/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetPersonnelExpenseRule {
    private static final String PERSONNEL_CATEGORY = "P";

    public boolean processCheckExistBudgetPersonnelDetailsBusinessRules(BudgetDocument budgetDocument) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        int i = 0;
        int j = 0;
        int k = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            j = 0;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                if (budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equals(PERSONNEL_CATEGORY)) {
                    k = 0;
                    for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                        if (StringUtils.isEmpty((String)budgetPersonnelDetails.getPeriodTypeCode())) {
                            errorMap.putError("document.budgetPeriod[" + i + "].budgetLineItem[" + j + "].budgetPersonnelDetailsList[" + k + "].periodTypeCode", "error.required", new String[0]);
                            valid = false;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }

    public boolean processCheckSummaryAddBusinessRules(BudgetLineItem budgetLineItem) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (budgetLineItem.getBudgetPersonnelDetailsList().size() > 0) {
            errorMap.putError("newBudgetPersonnelDetails.personSequenceNumber", "error.personnelExists", new String[0]);
            valid = false;
        }
        if (budgetLineItem.getBudgetPersonnelDetailsList().size() == 0) {
            errorMap.putError("newBudgetPersonnelDetails.personSequenceNumber", "error.summaryLineItemExists", new String[0]);
            valid = false;
        }
        return valid;
    }

    public boolean processCheckPersonAddBusinessRules(BudgetLineItem budgetLineItem) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (budgetLineItem.getBudgetPersonnelDetailsList().size() == 0) {
            errorMap.putError("newBudgetPersonnelDetails.personSequenceNumber", "error.summaryLineItemExists.addPerson", new String[0]);
            valid = false;
        }
        return valid;
    }

    public boolean processCheckDuplicateBudgetPersonnel(BudgetDocument budgetDocument, int budgetPeriodIndex, int budgetLineItemIndex) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int k = 0;
        int l = 0;
        HashMap<String, String> errorCombinations = new HashMap<String, String>();
        BudgetPeriod selectedBudgetPeriod = budgetDocument.getBudget().getBudgetPeriod(budgetPeriodIndex);
        BudgetLineItem selectedBudgetLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemIndex);
        for (BudgetPersonnelDetails personnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            l = 0;
            for (BudgetPersonnelDetails personnelDetailsForcomparison : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
                if (k != l && personnelDetails.getPersonSequenceNumber().intValue() == personnelDetailsForcomparison.getPersonSequenceNumber().intValue() && StringUtils.equals((String)personnelDetails.getJobCode(), (String)personnelDetailsForcomparison.getJobCode()) && personnelDetails.getStartDate().equals(personnelDetailsForcomparison.getStartDate())) {
                    if (errorCombinations.get(k + "" + l) == null) {
                        errorMap.putError("document.budgetPeriod[" + budgetPeriodIndex + "].budgetLineItem[" + budgetPeriodIndex + "].budgetPersonnelDetailsList[" + l + "].startDate", "error.duplicate.personnel", new String[]{personnelDetailsForcomparison.getBudgetPerson().getPersonName()});
                    }
                    errorCombinations.put(k + "" + l, l + "" + k);
                    errorCombinations.put(l + "" + k, k + "" + l);
                    valid = false;
                }
                ++l;
            }
            ++k;
        }
        return valid;
    }

    public boolean processSaveCheckDuplicateBudgetPersonnel(BudgetDocument budgetDocument) {
        boolean valid = true;
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        int i = 0;
        int j = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            j = 0;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                if (budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equals(PERSONNEL_CATEGORY)) {
                    valid &= this.processCheckDuplicateBudgetPersonnel(budgetDocument, i, j);
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }
}

