/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.ValidCeJobCode;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetPersonnelRule {
    private static final String BUDGET_PERSONS_FIELD_NAME_START = "budgetPersons[";
    private static final String BUDGET_PERSONS_FIELD_NAME_JOBCODE = "].jobCode";
    private static final String BUDGET_PERSONS_FIELD_NAME_PERSON_NUMBER = "].personNumber";
    private static final String BUDGET_PERSONS_FIELD_NAME_CALC_BASE = "].calculationBase";
    private final BusinessObjectService boService;
    private final ParameterService paramService;
    private final BudgetService budgetService;

    public BudgetPersonnelRule() {
        this(KraServiceLocator.getService(BusinessObjectService.class), KraServiceLocator.getService(ParameterService.class), KraServiceLocator.getService(BudgetService.class));
    }

    public BudgetPersonnelRule(BusinessObjectService boService, ParameterService paramService, BudgetService budgetService) {
        if (boService == null) {
            throw new NullPointerException("the boService is null");
        }
        if (paramService == null) {
            throw new NullPointerException("the paramService is null");
        }
        if (budgetService == null) {
            throw new NullPointerException("the budgetService is null");
        }
        this.boService = boService;
        this.paramService = paramService;
        this.budgetService = budgetService;
    }

    public boolean processCheckCompleteEntriesBusinessRules(BudgetDocument budgetDocument) {
        boolean valid = true;
        MessageMap messageMap = GlobalVariables.getMessageMap();
        List<BudgetPerson> budgetPersons = budgetDocument.getBudget().getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            if (!StringUtils.isBlank((String)budgetPerson.getJobCode()) && !StringUtils.isBlank((String)budgetPerson.getAppointmentTypeCode()) && !budgetPerson.getCalculationBase().isLessThan(BudgetDecimal.ZERO) && budgetPerson.getEffectiveDate() != null) continue;
            messageMap.putError("newBudgetPersonnelDetails.personSequenceNumber", "error.incomplete.person.entries", new String[0]);
            valid = false;
        }
        return valid;
    }

    public boolean processCheckExistBudgetPersonnelDetailsBusinessRules(BudgetDocument budgetDocument, BudgetPerson budgetPerson) {
        boolean valid = true;
        HashMap<String, Object> qMap = new HashMap<String, Object>();
        qMap.put("budgetId", budgetDocument.getBudget().getBudgetId());
        qMap.put("personId", budgetPerson.getPersonId());
        qMap.put("personSequenceNumber", budgetPerson.getPersonSequenceNumber());
        if (this.isPersonDetailsFound(budgetDocument.getBudget(), budgetPerson)) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            messageMap.putError("budgetPersons[0].personNumber", "error.delete.person.with.personnelDetails", new String[]{budgetPerson.getPersonName()});
            valid = false;
        }
        return valid;
    }

    private boolean isPersonDetailsFound(Budget budget, BudgetPerson budgetPerson) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetPersonnelDetails budgetPersonnelDetail : lineItem.getBudgetPersonnelDetailsList()) {
                    String personId = budgetPerson.getPersonId();
                    if (budgetPerson.getNonEmployeeFlag().booleanValue() && budgetPerson.getRolodexId() != null) {
                        personId = budgetPerson.getRolodexId().toString();
                    }
                    if (!budgetPersonnelDetail.getPersonId().equals(personId) || !budgetPersonnelDetail.getPersonSequenceNumber().equals(budgetPerson.getPersonSequenceNumber())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean processCheckBaseSalaryFormat(BudgetDocument budgetDocument) {
        boolean valid = true;
        MessageMap messageMap = GlobalVariables.getMessageMap();
        int i = 0;
        List<BudgetPerson> budgetPersons = budgetDocument.getBudget().getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            if (budgetPerson.getCalculationBase() == null) {
                messageMap.putError(BUDGET_PERSONS_FIELD_NAME_START + i + BUDGET_PERSONS_FIELD_NAME_CALC_BASE, "error.required", new String[]{"Base Salary"});
                valid = false;
            } else if (budgetPerson.getCalculationBase().isNegative()) {
                messageMap.putError(BUDGET_PERSONS_FIELD_NAME_START + i + BUDGET_PERSONS_FIELD_NAME_CALC_BASE, "error.negativeAmount", new String[]{"Base Salary"});
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    private Collection<ValidCeJobCode> getMappedCostElements(BudgetPerson person) {
        return this.budgetService.getApplicableCostElements(person.getBudgetId(), person.getPersonSequenceNumber().toString());
    }

    public boolean processBudgetPersonnelBusinessRules(BudgetDocument budgetDocument) {
        boolean valid = true;
        MessageMap messageMap = GlobalVariables.getMessageMap();
        List<BudgetPerson> budgetPersons = budgetDocument.getBudget().getBudgetPersons();
        for (int i = 0; i < budgetPersons.size(); ++i) {
            BudgetPerson budgetPerson = budgetPersons.get(i);
            for (int j = i + 1; j < budgetPersons.size(); ++j) {
                Object budgetParent;
                BudgetPerson budgetPersonCompare = budgetPersons.get(j);
                if (!budgetPerson.isDuplicatePerson(budgetPersonCompare) || (budgetParent = budgetDocument.getParentDocument().getBudgetParent()) instanceof DevelopmentProposal && ((DevelopmentProposal)budgetParent).isParent()) continue;
                messageMap.putError(BUDGET_PERSONS_FIELD_NAME_START + j + "].personName", "error.budgetPerson.duplicate", new String[]{budgetPerson.getPersonName()});
                valid = false;
            }
        }
        return valid;
    }

    public boolean processCheckForJobCodeChange(BudgetDocument budgetDocument, int viewBudgetPeriod) {
        BudgetPeriod selectedBudgetPeriod;
        Collection<Integer> budgetPersonSequences;
        if (budgetDocument == null) {
            throw new NullPointerException("the budgetDocument is null");
        }
        if (viewBudgetPeriod < 1) {
            throw new IllegalArgumentException("this viewBudgetPeriod: " + viewBudgetPeriod + " is invalid");
        }
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if ((valid &= this.processBudgetPersonnelBusinessRules(budgetDocument)) && CollectionUtils.isNotEmpty(budgetPersonSequences = this.getBudgetPersonSequencesFromPersonnelDetails((selectedBudgetPeriod = budgetDocument.getBudget().getBudgetPeriod(viewBudgetPeriod - 1)).getBudgetLineItems()))) {
            int i = 0;
            List<BudgetPerson> budgetPersons = budgetDocument.getBudget().getBudgetPersons();
            for (BudgetPerson person : budgetPersons) {
                if (budgetPersonSequences.contains(person.getPersonSequenceNumber())) {
                    if (CollectionUtils.isNotEmpty(this.getMappedCostElements(person))) {
                        valid &= this.validateJobCodeChange(i, person);
                    } else {
                        valid &= this.validateJobCodeValue(i, person);
                        this.updateJobCodeOnDetailsFromPerson(selectedBudgetPeriod.getBudgetLineItems(), person);
                    }
                }
                ++i;
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid;
    }

    private boolean validateJobCodeChange(int personNumber, BudgetPerson person) {
        assert (person != null) : "the person is null";
        assert (personNumber >= 0) : "the personNumber: " + personNumber + " is invalid";
        boolean valid = true;
        HashMap<String, Number> queryMap = new HashMap<String, Number>();
        queryMap.put("budgetId", person.getBudgetId());
        queryMap.put("personSequenceNumber", person.getPersonSequenceNumber());
        BudgetPerson personCopy = (BudgetPerson)this.boService.findByPrimaryKey(BudgetPerson.class, queryMap);
        if (!person.isDuplicatePerson(personCopy) && !StringUtils.equals((String)person.getJobCode(), (String)personCopy.getJobCode())) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            messageMap.putError(BUDGET_PERSONS_FIELD_NAME_START + personNumber + BUDGET_PERSONS_FIELD_NAME_JOBCODE, "error.person.jobcodeChange", new String[]{person.getPersonName()});
            valid = false;
        }
        return valid;
    }

    private boolean validateJobCodeValue(int personNumber, BudgetPerson person) {
        assert (person != null) : "the person is null";
        assert (personNumber >= 0) : "the personNumber: " + personNumber + " is invalid";
        boolean valid = true;
        if (person.getJobCode() == null) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            messageMap.putError(BUDGET_PERSONS_FIELD_NAME_START + personNumber + BUDGET_PERSONS_FIELD_NAME_JOBCODE, "error.person.jobcodeValue", new String[]{person.getPersonName()});
            valid = false;
        }
        return valid;
    }

    private Collection<Integer> getBudgetPersonSequencesFromPersonnelDetails(Collection<BudgetLineItem> budgetLineItems) {
        assert (budgetLineItems != null) : "the budgetLineItems is null";
        ArrayList<Integer> budgetPersonSequences = new ArrayList<Integer>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                budgetPersonSequences.add(budgetPersonnelDetails.getPersonSequenceNumber());
            }
        }
        return budgetPersonSequences;
    }

    private void updateJobCodeOnDetailsFromPerson(Collection<BudgetLineItem> budgetLineItems, BudgetPerson person) {
        assert (budgetLineItems != null) : "the budgetLineItems is null";
        assert (person != null) : "the person is null";
        if (person.getJobCode() == null) {
            return;
        }
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (!person.getPersonSequenceNumber().equals(budgetPersonnelDetails.getPersonSequenceNumber())) continue;
                budgetPersonnelDetails.setJobCode(person.getJobCode());
            }
        }
    }

    private List<ValidCeJobCode> getApplicableCostElements(BudgetDocument budgetDocument, BudgetPersonnelDetails newBudgetPersonnelDetails, boolean save) {
        List validCostElements = null;
        if (save) {
            String jobCodeValidationEnabledInd = this.paramService.getParameterValueAsString(BudgetDocument.class, "JOBCODE_VALIDATION_ENABLED");
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            BudgetPerson budgetPerson = null;
            if (StringUtils.isNotEmpty((String)jobCodeValidationEnabledInd) && jobCodeValidationEnabledInd.equals("Y")) {
                List<BudgetPerson> budgetPersons = budgetDocument.getBudget().getBudgetPersons();
                for (BudgetPerson tmpBudgetPerson : budgetPersons) {
                    if (tmpBudgetPerson.getPersonSequenceNumber().intValue() != newBudgetPersonnelDetails.getPersonSequenceNumber().intValue()) continue;
                    budgetPerson = tmpBudgetPerson;
                    break;
                }
                if (budgetPerson != null && StringUtils.isNotEmpty((String)budgetPerson.getJobCode())) {
                    fieldValues.put("jobCode", budgetPerson.getJobCode().toUpperCase());
                    validCostElements = (List)this.boService.findMatching(ValidCeJobCode.class, fieldValues);
                }
            }
        } else {
            validCostElements = this.budgetService.getApplicableCostElements(budgetDocument.getBudget().getBudgetId(), newBudgetPersonnelDetails.getPersonSequenceNumber().toString());
        }
        return validCostElements;
    }

    public boolean processCheckJobCodeObjectCodeCombo(BudgetDocument budgetDocument, BudgetPersonnelDetails newBudgetPersonnelDetails, boolean save) {
        List<ValidCeJobCode> validCostElements = null;
        boolean isValid = false;
        validCostElements = this.getApplicableCostElements(budgetDocument, newBudgetPersonnelDetails, save);
        if (CollectionUtils.isEmpty(validCostElements)) {
            isValid = true;
        } else {
            for (ValidCeJobCode validCeJobCode : validCostElements) {
                if (!validCeJobCode.getCostElement().equalsIgnoreCase(newBudgetPersonnelDetails.getCostElement())) continue;
                isValid = true;
                break;
            }
        }
        return isValid;
    }
}

