/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.printing.BudgetPrintType;
import org.kuali.kra.budget.printing.print.BudgetCostShareSummaryPrint;
import org.kuali.kra.budget.printing.print.BudgetCumulativePrint;
import org.kuali.kra.budget.printing.print.BudgetSalaryPrint;
import org.kuali.kra.budget.printing.print.BudgetSummaryPrint;
import org.kuali.kra.budget.printing.print.BudgetSummaryTotalPrint;
import org.kuali.kra.budget.printing.print.BudgetTotalPrint;
import org.kuali.kra.budget.printing.print.IndustrialBudgetPrint;
import org.kuali.kra.budget.printing.print.IndustrialCumulativeBudgetPrint;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetPrintForm;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetPrintService;

public class BudgetPrintingServiceImpl
implements BudgetPrintService {
    private BudgetSummaryPrint budgetSummaryPrint;
    private BudgetCostShareSummaryPrint budgetCostShareSummaryPrint;
    private BudgetSalaryPrint budgetSalaryPrint;
    private PrintingService printingService;
    private BudgetTotalPrint budgetTotalPrint;
    private BudgetSummaryTotalPrint budgetSummaryTotalPrint;
    private IndustrialCumulativeBudgetPrint industrialCumulativeBudgetPrint;
    private IndustrialBudgetPrint industrialBudgetPrint;
    private BudgetCumulativePrint budgetCumulativePrint;
    private static final Log LOG = LogFactory.getLog(BudgetPrintingServiceImpl.class);

    public AttachmentDataSource printBudgetReport(KraPersistableBusinessObjectBase budget, String reportName) throws PrintingException {
        AttachmentDataSource attachmentDataSource = null;
        AbstractPrint printable = null;
        String fileName = reportName + "-" + ((Budget)budget).getBudgetDocument().getParentDocumentKey() + ".pdf";
        if (reportName.equals(BudgetPrintType.BUDGET_SUMMARY_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetSummaryPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_COST_SHARE_SUMMARY_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetCostShareSummaryPrint();
        } else if (reportName.equals(BudgetPrintType.INDUSTRIAL_CUMULATIVE_BUDGET_REPORT.getBudgetPrintType())) {
            printable = this.getIndustrialCumulativeBudgetPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetSalaryPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_TOTAL_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetTotalPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_SUMMARY_TOTAL_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetSummaryTotalPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_CUMULATIVE_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetCumulativePrint();
        } else if (reportName.equals(BudgetPrintType.INDUSTRIAL_BUDGET_REPORT.getBudgetPrintType())) {
            printable = this.getIndustrialBudgetPrint();
        }
        printable.setPrintableBusinessObject(budget);
        attachmentDataSource = this.getPrintingService().print(printable);
        try {
            attachmentDataSource.setFileName(URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setFileName(fileName);
        }
        attachmentDataSource.setContentType("application/pdf");
        return attachmentDataSource;
    }

    @Override
    public void populateBudgetPrintForms(Budget budget) {
        BudgetPrintForm budgetCostShareForm = new BudgetPrintForm();
        budgetCostShareForm.setBudgetReportId(BudgetPrintType.BUDGET_COST_SHARE_SUMMARY_REPORT.getBudgetPrintType());
        budgetCostShareForm.setBudgetReportName(BudgetPrintType.BUDGET_COST_SHARE_SUMMARY_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetCumulativeForm = new BudgetPrintForm();
        budgetCumulativeForm.setBudgetReportId(BudgetPrintType.BUDGET_CUMULATIVE_REPORT.getBudgetPrintType());
        budgetCumulativeForm.setBudgetReportName(BudgetPrintType.BUDGET_CUMULATIVE_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetSalaryForm = new BudgetPrintForm();
        budgetSalaryForm.setBudgetReportId(BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType());
        budgetSalaryForm.setBudgetReportName(BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetSummaryForm = new BudgetPrintForm();
        budgetSummaryForm.setBudgetReportId(BudgetPrintType.BUDGET_SUMMARY_REPORT.getBudgetPrintType());
        budgetSummaryForm.setBudgetReportName(BudgetPrintType.BUDGET_SUMMARY_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetSummaryTotalForm = new BudgetPrintForm();
        budgetSummaryTotalForm.setBudgetReportId(BudgetPrintType.BUDGET_SUMMARY_TOTAL_REPORT.getBudgetPrintType());
        budgetSummaryTotalForm.setBudgetReportName(BudgetPrintType.BUDGET_SUMMARY_TOTAL_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetTotalForm = new BudgetPrintForm();
        budgetTotalForm.setBudgetReportId(BudgetPrintType.BUDGET_TOTAL_REPORT.getBudgetPrintType());
        budgetTotalForm.setBudgetReportName(BudgetPrintType.BUDGET_TOTAL_REPORT.getBudgetPrintType());
        BudgetPrintForm industrialBudgetForm = new BudgetPrintForm();
        industrialBudgetForm.setBudgetReportId(BudgetPrintType.INDUSTRIAL_BUDGET_REPORT.getBudgetPrintType());
        industrialBudgetForm.setBudgetReportName(BudgetPrintType.INDUSTRIAL_BUDGET_REPORT.getBudgetPrintType());
        BudgetPrintForm industrialBudgetCumulativeForm = new BudgetPrintForm();
        industrialBudgetCumulativeForm.setBudgetReportId(BudgetPrintType.INDUSTRIAL_CUMULATIVE_BUDGET_REPORT.getBudgetPrintType());
        industrialBudgetCumulativeForm.setBudgetReportName(BudgetPrintType.INDUSTRIAL_CUMULATIVE_BUDGET_REPORT.getBudgetPrintType());
        ArrayList<BudgetPrintForm> printForms = new ArrayList<BudgetPrintForm>();
        printForms.add(budgetCostShareForm);
        printForms.add(budgetCumulativeForm);
        printForms.add(budgetSalaryForm);
        printForms.add(budgetSummaryForm);
        printForms.add(budgetSummaryTotalForm);
        printForms.add(budgetTotalForm);
        printForms.add(industrialBudgetForm);
        printForms.add(industrialBudgetCumulativeForm);
        budget.setBudgetPrintForms(printForms);
    }

    @Override
    public boolean printBudgetForms(Budget budget, String[] selectedBudgetPrintFormId, HttpServletResponse response) {
        for (int i = 0; i < selectedBudgetPrintFormId.length; ++i) {
            AttachmentDataSource pdf = this.readBudgetPrintStream(budget, selectedBudgetPrintFormId[i]);
        }
        return false;
    }

    @Override
    public AttachmentDataSource readBudgetPrintStream(Budget budget, String selectedBudgetPrintFormId) {
        try {
            return this.printBudgetReport(budget, selectedBudgetPrintFormId);
        }
        catch (PrintingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public BudgetSummaryPrint getBudgetSummaryPrint() {
        return this.budgetSummaryPrint;
    }

    public void setBudgetSummaryPrint(BudgetSummaryPrint budgetSummaryPrint) {
        this.budgetSummaryPrint = budgetSummaryPrint;
    }

    public BudgetCostShareSummaryPrint getBudgetCostShareSummaryPrint() {
        return this.budgetCostShareSummaryPrint;
    }

    public void setBudgetCostShareSummaryPrint(BudgetCostShareSummaryPrint budgetCostShareSummaryPrint) {
        this.budgetCostShareSummaryPrint = budgetCostShareSummaryPrint;
    }

    public BudgetSalaryPrint getBudgetSalaryPrint() {
        return this.budgetSalaryPrint;
    }

    public void setBudgetSalaryPrint(BudgetSalaryPrint budgetSalaryPrint) {
        this.budgetSalaryPrint = budgetSalaryPrint;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public BudgetTotalPrint getBudgetTotalPrint() {
        return this.budgetTotalPrint;
    }

    public void setBudgetTotalPrint(BudgetTotalPrint budgetTotalPrint) {
        this.budgetTotalPrint = budgetTotalPrint;
    }

    public BudgetSummaryTotalPrint getBudgetSummaryTotalPrint() {
        return this.budgetSummaryTotalPrint;
    }

    public void setBudgetSummaryTotalPrint(BudgetSummaryTotalPrint budgetSummaryTotalPrint) {
        this.budgetSummaryTotalPrint = budgetSummaryTotalPrint;
    }

    public IndustrialCumulativeBudgetPrint getIndustrialCumulativeBudgetPrint() {
        return this.industrialCumulativeBudgetPrint;
    }

    public void setIndustrialCumulativeBudgetPrint(IndustrialCumulativeBudgetPrint industrialCumulativeBudgetPrint) {
        this.industrialCumulativeBudgetPrint = industrialCumulativeBudgetPrint;
    }

    public IndustrialBudgetPrint getIndustrialBudgetPrint() {
        return this.industrialBudgetPrint;
    }

    public void setIndustrialBudgetPrint(IndustrialBudgetPrint industrialBudgetPrint) {
        this.industrialBudgetPrint = industrialBudgetPrint;
    }

    public BudgetCumulativePrint getBudgetCumulativePrint() {
        return this.budgetCumulativePrint;
    }

    public void setBudgetCumulativePrint(BudgetCumulativePrint budgetCumulativePrint) {
        this.budgetCumulativePrint = budgetCumulativePrint;
    }
}

