/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.xmlstream;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.BudgetSummaryReportDocument;
import noNamespace.ReportHeaderType;
import noNamespace.ReportPageType;
import noNamespace.ReportType;
import noNamespace.SubReportType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.printing.util.ReportTypeVO;
import org.kuali.kra.budget.printing.xmlstream.BudgetBaseStream;

public class BudgetSummaryXmlStream
extends BudgetBaseStream {
    private static final Log LOG = LogFactory.getLog(BudgetSummaryXmlStream.class);

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectMap = new LinkedHashMap<String, XmlObject>();
        this.budget = (Budget)printableBusinessObject;
        if (this.budget != null) {
            for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) {
                    LOG.debug((Object)("Skipping printing of empty budget period, for Budget period - " + budgetPeriod.getBudgetPeriod()));
                    continue;
                }
                this.budgetPeriod = budgetPeriod;
                BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
                BudgetSummaryReportDocument budgetSummaryReportDocument = BudgetSummaryReportDocument.Factory.newInstance();
                budgetSummaryReport = this.getBudgetSummaryReport();
                budgetSummaryReportDocument.setBudgetSummaryReport(budgetSummaryReport);
                xmlObjectMap.put("Period" + budgetPeriod.getBudgetPeriod(), (XmlObject)budgetSummaryReportDocument);
            }
        }
        return xmlObjectMap;
    }

    private BudgetSummaryReportDocument.BudgetSummaryReport getBudgetSummaryReport() {
        BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
        ReportPageType cumilativePageType = ReportPageType.Factory.newInstance();
        BudgetParent budgetParent = this.budget.getBudgetParent();
        ReportHeaderType reportHeaderType = this.getReportHeaderTypeForCumulativeReport(budgetParent);
        budgetSummaryReport.setReportHeader(reportHeaderType);
        cumilativePageType = this.getBudgetSummaryReportPageType();
        budgetSummaryReport.setCumilativePage(cumilativePageType);
        ReportPageType[] reportPageTypeArray = this.getReportPageTypes();
        budgetSummaryReport.setReportPageArray(reportPageTypeArray);
        return budgetSummaryReport;
    }

    private ReportPageType[] getReportPageTypes() {
        ArrayList<ReportPageType> reportPageTypeList = new ArrayList<ReportPageType>();
        ReportPageType reportPageType = this.getBudgetSummaryReportPageType();
        reportPageTypeList.add(reportPageType);
        return reportPageTypeList.toArray(new ReportPageType[0]);
    }

    private ReportPageType getBudgetSummaryReportPageType() {
        ReportPageType reportPageType = ReportPageType.Factory.newInstance();
        ReportPageType.BudgetSummary budgetSummary = this.getBudgetSummary();
        reportPageType.setBudgetSummary(budgetSummary);
        ReportPageType.CalculationMethodology calculationMethodology = this.getCalculationMethodology();
        reportPageType.setCalculationMethodology(calculationMethodology);
        reportPageType.setPeriod(this.budgetPeriod.getBudgetPeriod().intValue());
        return reportPageType;
    }

    private ReportPageType.BudgetSummary getBudgetSummary() {
        ReportPageType.BudgetSummary budgetSummary = ReportPageType.BudgetSummary.Factory.newInstance();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        subReportType = this.getSalarySummary();
        budgetSummary.setSalarySummaryFromEDI(subReportType);
        subReportType = this.getBudgetSummaryNonPersonnel();
        budgetSummary.setBudgetSummaryNonPersonnel(subReportType);
        subReportType = this.getBudgetIndirectCostsForReport();
        budgetSummary.setBudgetIndirectCostsForReport(subReportType);
        budgetSummary.setTotalDirectCost(this.budgetPeriod.getTotalDirectCost().doubleValue());
        budgetSummary.setTotalCostToSponsor(this.budgetPeriod.getTotalCost().doubleValue());
        budgetSummary.setTotalUnderrecoveryAmount(this.budgetPeriod.getUnderrecoveryAmount().doubleValue());
        budgetSummary.setTotalCostSharingAmount(this.budgetPeriod.getCostSharingAmount().doubleValue());
        return budgetSummary;
    }

    private SubReportType getSalarySummary() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        this.setReportTypeForBudgetSalarySummary(reportTypeList);
        this.setBudgetLASalaryForBudgetRateAndBase(reportTypeList);
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForBudgetSalarySummary(List<ReportType> reportTypeList) {
        this.setReportTypeListFromReportTypeVOListForBudgetSalarySummary(reportTypeList, this.getReportTypeVOList(this.budgetPeriod));
    }

    private void setReportTypeListFromReportTypeVOListForBudgetSalarySummary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String budgetSalarySummaryKey = this.getKeyForBudgetSalarySummary(reportTypeVO);
            if (reportTypeMap.containsKey(budgetSalarySummaryKey)) continue;
            BudgetDecimal vacationRate = BudgetDecimal.ZERO;
            BudgetDecimal empBenefitRate = BudgetDecimal.ZERO;
            BudgetDecimal fringe = BudgetDecimal.ZERO;
            BudgetDecimal fringeCostSharing = BudgetDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String budgetSalarySummaryTempKey = this.getKeyForBudgetSalarySummary(tempReportTypeVO);
                if (!budgetSalarySummaryTempKey.equals(budgetSalarySummaryKey)) continue;
                if (vacationRate.isLessThan(tempReportTypeVO.getVacationRate())) {
                    vacationRate = tempReportTypeVO.getVacationRate();
                }
                if (empBenefitRate.isLessThan(tempReportTypeVO.getEmployeeBenefitRate())) {
                    empBenefitRate = tempReportTypeVO.getEmployeeBenefitRate();
                }
                fringe = (BudgetDecimal)fringe.add(tempReportTypeVO.getFringe());
                fringeCostSharing = (BudgetDecimal)fringeCostSharing.add(tempReportTypeVO.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForBudgetSalarySummary(vacationRate, empBenefitRate, fringe, fringeCostSharing, reportTypeVO);
            reportTypeMap.put(budgetSalarySummaryKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForBudgetSalarySummary(BudgetDecimal vacationRate, BudgetDecimal empBenefitRate, BudgetDecimal fringe, BudgetDecimal fringeCostSharing, ReportTypeVO reportTypeVO) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setStartDate(dateFormat.format(reportTypeVO.getStartDate()));
        reportType.setEndDate(dateFormat.format(reportTypeVO.getEndDate()));
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setPersonName(reportTypeVO.getPersonName());
        reportType.setPercentEffort(reportTypeVO.getPercentEffort() != null ? reportTypeVO.getPercentEffort().doubleValue() : 0.0);
        reportType.setPercentCharged(reportTypeVO.getPercentCharged() != null ? reportTypeVO.getPercentCharged().doubleValue() : 0.0);
        reportType.setVacationRate(vacationRate.toString().concat("%"));
        reportType.setEmployeeBenefitRate(empBenefitRate.toString().concat("%"));
        reportType.setCostSharingAmount(reportTypeVO.getCostSharingAmount().doubleValue());
        reportType.setCalculatedCost(fringeCostSharing.doubleValue());
        reportType.setFringe(fringe.doubleValue());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setInvestigatorFlag(reportTypeVO.getInvestigatorFlag().intValue());
        if (reportTypeVO.getBudgetCategoryCode() != null) {
            reportType.setBudgetCategoryCode(Integer.parseInt(reportTypeVO.getBudgetCategoryCode()));
        }
        reportType.setSalaryRequested(reportTypeVO.getSalaryRequested().doubleValue());
        return reportType;
    }

    private SubReportType getBudgetSummaryNonPersonnel() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        if (this.getUnitNumber() > 0) {
            String categoryDesc = "Other Direct Costs";
            String costElementDesc = "Allocated Lab Expense";
            for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
                calculatedCost = (BudgetDecimal)calculatedCost.add(this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.LAB_ALLOCATION.getRateClassType(), budgetLineItem));
                costSharingAmount = (BudgetDecimal)costSharingAmount.add(this.getTotalCostSharingAmountByRateClassTypeFromLineItem(budgetLineItem, RateClassType.LAB_ALLOCATION.getRateClassType()));
            }
            ReportType reportType = this.getReportTypeForNonPersonnel(categoryDesc, costElementDesc, calculatedCost, costSharingAmount);
            reportTypeList.add(reportType);
        }
        this.setReportTypeForBudgetSummaryNonPersonnel(reportTypeList);
        Collections.sort(reportTypeList, new Comparator<ReportType>(){

            @Override
            public int compare(ReportType reportType1, ReportType reportType2) {
                return reportType1.getBudgetCategoryDescription().compareTo(reportType2.getBudgetCategoryDescription());
            }
        });
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForBudgetSummaryNonPersonnel(List<ReportType> reportTypeList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
            ReportTypeVO tempReportTypeVO = this.getReportTypeVOForBudgetSummaryNonPersonnel(budgetLineItem);
            tempReportTypeVOList.add(tempReportTypeVO);
        }
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetSummaryNonPersKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(budgetSummaryNonPersKey)) continue;
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String budgetSummaryNonPersTempKey = reportTypeVO1.getCostElementDesc();
                if (!budgetSummaryNonPersTempKey.equals(budgetSummaryNonPersKey)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add(reportTypeVO1.getCalculatedCost());
                costSharingAmount = (BudgetDecimal)costSharingAmount.add(reportTypeVO1.getCostSharingAmount());
            }
            ReportType reportType = this.getReportTypeForBudgetSummaryNonPersonnel(calculatedCost, costSharingAmount, reportTypeVO);
            reportTypeMap.put(budgetSummaryNonPersKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForBudgetSummaryNonPersonnel(BudgetDecimal calculatedCost, BudgetDecimal costSharingAmount, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setCostSharingAmount(costSharingAmount.doubleValue());
        return reportType;
    }

    private ReportTypeVO getReportTypeVOForBudgetSummaryNonPersonnel(BudgetLineItem budgetLineItem) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setBudgetCategoryDesc(budgetLineItem.getBudgetCategory().getDescription());
        reportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
        reportTypeVO.setCostSharingAmount(budgetLineItem.getCostSharingAmount());
        reportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
        return reportTypeVO;
    }
}

