/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.xmlstream;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.BudgetSummaryReportDocument;
import noNamespace.ReportHeaderType;
import noNamespace.ReportPageType;
import noNamespace.ReportType;
import noNamespace.SubReportType;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.printing.util.ReportTypeVO;
import org.kuali.kra.budget.printing.xmlstream.BudgetBaseStream;

public class IndustrialBudgetXmlStream
extends BudgetBaseStream {
    private static final Log LOG = LogFactory.getLog(IndustrialBudgetXmlStream.class);

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        this.budget = (Budget)printableBusinessObject;
        if (this.budget != null) {
            for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) {
                    LOG.debug((Object)("Skipping printing of empty budget period, for Budget period - " + budgetPeriod.getBudgetPeriod()));
                    continue;
                }
                this.budgetPeriod = budgetPeriod;
                BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
                BudgetSummaryReportDocument budgetSummaryReportDocument = BudgetSummaryReportDocument.Factory.newInstance();
                budgetSummaryReport = this.getIndustrialBudgetReport();
                budgetSummaryReportDocument.setBudgetSummaryReport(budgetSummaryReport);
                xmlObjectList.put("Period" + budgetPeriod.getBudgetPeriod(), (XmlObject)budgetSummaryReportDocument);
            }
        }
        return xmlObjectList;
    }

    private BudgetSummaryReportDocument.BudgetSummaryReport getIndustrialBudgetReport() {
        BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
        ReportPageType cumilativePageType = ReportPageType.Factory.newInstance();
        BudgetParent budgetParent = this.budget.getBudgetParent();
        ReportHeaderType reportHeaderType = this.getReportHeaderTypeForCumulativeReport(budgetParent);
        budgetSummaryReport.setReportHeader(reportHeaderType);
        cumilativePageType = this.getIndustrialBudgetReportPageType();
        budgetSummaryReport.setCumilativePage(cumilativePageType);
        ReportPageType[] reportPageTypeArray = this.getReportPageTypes();
        budgetSummaryReport.setReportPageArray(reportPageTypeArray);
        return budgetSummaryReport;
    }

    private ReportPageType[] getReportPageTypes() {
        ArrayList<ReportPageType> reportPageTypeList = new ArrayList<ReportPageType>();
        ReportPageType reportPageType = this.getIndustrialBudgetReportPageType();
        reportPageTypeList.add(reportPageType);
        return reportPageTypeList.toArray(new ReportPageType[0]);
    }

    private ReportPageType getIndustrialBudgetReportPageType() {
        ReportPageType reportPageType = ReportPageType.Factory.newInstance();
        ReportPageType.BudgetSummary budgetSummary = this.getIndustrialBudget();
        ReportPageType.CalculationMethodology calculationMethodology = this.getCalculationMethodology();
        reportPageType.setBudgetSummary(budgetSummary);
        reportPageType.setCalculationMethodology(calculationMethodology);
        reportPageType.setPeriod(this.budgetPeriod.getBudgetPeriod().intValue());
        return reportPageType;
    }

    private ReportPageType.BudgetSummary getIndustrialBudget() {
        ReportPageType.BudgetSummary budgetSummary = ReportPageType.BudgetSummary.Factory.newInstance();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        subReportType = this.getIndustrialSalarySummary();
        budgetSummary.setSalarySummaryFromEDI(subReportType);
        subReportType = this.getIndustrialBudgetSummaryNonPersonnel();
        budgetSummary.setBudgetSummaryNonPersonnel(subReportType);
        subReportType = this.getBudgetIndirectCostsForReport();
        budgetSummary.setBudgetIndirectCostsForReport(subReportType);
        budgetSummary.setTotalDirectCost(this.budgetPeriod.getTotalDirectCost().doubleValue());
        budgetSummary.setTotalCostToSponsor(this.budgetPeriod.getTotalCost().doubleValue());
        budgetSummary.setTotalUnderrecoveryAmount(this.budgetPeriod.getUnderrecoveryAmount().doubleValue());
        budgetSummary.setTotalCostSharingAmount(this.budgetPeriod.getCostSharingAmount().doubleValue());
        return budgetSummary;
    }

    private SubReportType getIndustrialSalarySummary() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        this.setReportTypeForIndustrialBudgetSalary(reportTypeList);
        this.setIndustrialBudgetLASalaryForBudgetRateAndBase(reportTypeList);
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForIndustrialBudgetSalary(List<ReportType> reportTypeList) {
        this.setReportTypeListFromReportTypeVOListForIndustrialBudgetSalary(reportTypeList, this.getReportTypeVOList(this.budgetPeriod));
    }

    @Override
    protected List<AbstractBudgetRateAndBase> getRatesApplicableToVOList(List<? extends AbstractBudgetRateAndBase> rates) {
        ArrayList<AbstractBudgetRateAndBase> result = new ArrayList<AbstractBudgetRateAndBase>();
        for (AbstractBudgetRateAndBase abstractBudgetRateAndBase : rates) {
            if (this.isRateAndBaseOfRateClassTypeEB(abstractBudgetRateAndBase) || this.isRateAndBaseOfRateClassTypeVacation(abstractBudgetRateAndBase) || this.isRateAndBaseOfRateClassTypeLAwithEBVA(abstractBudgetRateAndBase)) continue;
            result.add(abstractBudgetRateAndBase);
        }
        return result;
    }

    private void setIndustrialBudgetLASalaryForBudgetRateAndBase(List<ReportType> reportTypeList) {
        ArrayList<ReportTypeVO> reportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (!this.isRateAndBaseOfRateClassTypeLAwithEBVA(budgetRateAndBase)) continue;
                Date startDate = budgetRateAndBase.getStartDate();
                Date endDate = budgetRateAndBase.getEndDate();
                String key = startDate.toString() + endDate.toString();
                if (laRateBaseMap.containsKey(key)) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForIndustrialBudgetLASalaryForRateBase(budgetLineItem, budgetRateAndBase);
                reportTypeVOList.add(reportTypeVO);
                laRateBaseMap.put(key, budgetRateAndBase);
            }
        }
        this.setReportTypeBudgetLASalary(reportTypeList, reportTypeVOList);
    }

    private ReportTypeVO getReportTypeVOForIndustrialBudgetLASalaryForRateBase(BudgetLineItem budgetLineItem, BudgetRateAndBase budgetRateAndBase) {
        ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetLASalaryForRateBase(budgetLineItem, budgetRateAndBase);
        reportTypeVO.setSalaryRequested((BudgetDecimal)reportTypeVO.getSalaryRequested().add(reportTypeVO.getFringe()));
        return reportTypeVO;
    }

    private void setReportTypeListFromReportTypeVOListForIndustrialBudgetSalary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String reportTypeKey = this.getKeyForIndustrialBudget(reportTypeVO);
            if (reportTypeMap.containsKey(reportTypeKey)) continue;
            BudgetDecimal salary = BudgetDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String reportTypeTempKey = this.getKeyForIndustrialBudget(tempReportTypeVO);
                if (!reportTypeTempKey.equals(reportTypeKey)) continue;
                salary = (BudgetDecimal)salary.add(tempReportTypeVO.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForIndustrialBudgetSalary(salary, reportTypeVO);
            reportTypeMap.put(reportTypeKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForIndustrialBudgetSalary(BudgetDecimal salary, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)reportTypeVO.getStartDate(), (String)"MM/dd/yy"));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)reportTypeVO.getEndDate(), (String)"MM/dd/yy"));
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setPersonName(reportTypeVO.getPersonName());
        reportType.setPercentEffort(reportTypeVO.getPercentEffort() != null ? reportTypeVO.getPercentEffort().doubleValue() : 0.0);
        reportType.setPercentCharged(reportTypeVO.getPercentCharged() != null ? reportTypeVO.getPercentCharged().doubleValue() : 0.0);
        if (reportTypeVO.getBudgetCategoryCode() != null) {
            reportType.setBudgetCategoryCode(Integer.parseInt(reportTypeVO.getBudgetCategoryCode()));
        }
        salary = (BudgetDecimal)salary.add(reportTypeVO.getSalaryRequested());
        reportType.setSalaryRequested(salary.doubleValue());
        reportType.setInvestigatorFlag(reportTypeVO.getInvestigatorFlag().intValue());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        return reportType;
    }

    private String getKeyForIndustrialBudget(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getStartDate().toString()).append(reportTypeVO.getEndDate().toString()).append(reportTypeVO.getPersonName()).append(reportTypeVO.getInvestigatorFlag().toString()).append(reportTypeVO.getBudgetCategoryCode()).append(reportTypeVO.getBudgetCategoryDesc());
        return key.toString();
    }

    private SubReportType getIndustrialBudgetSummaryNonPersonnel() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        if (this.getUnitNumber() > 0) {
            String categoryDesc = "Other Direct Costs";
            String costElementDesc = "Allocated Lab Expense";
            for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
                calculatedCost = (BudgetDecimal)calculatedCost.add(this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.LAB_ALLOCATION.getRateClassType(), budgetLineItem));
            }
            ReportType reportType = this.getReportTypeForNonPersonnel(categoryDesc, costElementDesc, calculatedCost, null);
            reportTypeList.add(reportType);
        }
        this.setReportTypeForIndustrialBudgetNonPersonnel(reportTypeList);
        Collections.sort(reportTypeList, new Comparator<ReportType>(){

            @Override
            public int compare(ReportType reportType1, ReportType reportType2) {
                return reportType1.getBudgetCategoryDescription().compareTo(reportType2.getBudgetCategoryDescription());
            }
        });
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForIndustrialBudgetNonPersonnel(List<ReportType> reportTypeList) {
        ReportTypeVO tempReportTypeVO;
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel(budgetLineItem) || this.checkLineItemNumberAvailableForIndustrialNonPersonnel(budgetLineItem)) continue;
            tempReportTypeVO = this.getReportTypeVOForIndustrialNonPersonnel(budgetLineItem);
            tempReportTypeVOList.add(tempReportTypeVO);
        }
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel(budgetLineItem) || !this.isOverhead(budgetLineItem)) continue;
            tempReportTypeVO = this.getReportTypeVOForIndustrialNonPersonnel(budgetLineItem);
            tempReportTypeVOList.add(tempReportTypeVO);
        }
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String industrialBudgetNonPersKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(industrialBudgetNonPersKey)) continue;
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String industrialBudgetNonPersTempKey = reportTypeVO1.getCostElementDesc();
                if (!industrialBudgetNonPersTempKey.equals(industrialBudgetNonPersKey)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add(reportTypeVO1.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForIndustrialNonPersonnel(calculatedCost, reportTypeVO);
            reportTypeMap.put(industrialBudgetNonPersKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForIndustrialNonPersonnel(BudgetDecimal calculatedCost, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        return reportType;
    }

    private ReportTypeVO getReportTypeVOForIndustrialNonPersonnel(BudgetLineItem budgetLineItem) {
        ReportTypeVO tempReportTypeVO = new ReportTypeVO();
        tempReportTypeVO.setBudgetCategoryDesc(budgetLineItem.getBudgetCategory().getDescription());
        tempReportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
        tempReportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
        return tempReportTypeVO;
    }

    private boolean isOverhead(BudgetLineItem budgetLineItem) {
        boolean availabe = false;
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            if (!budgetLineItemCalcAmount.getApplyRateFlag().booleanValue() || !this.isLineItemCalAmountOfRateClassTypeOverhead(budgetLineItemCalcAmount)) continue;
            availabe = true;
            break;
        }
        return availabe;
    }

    private boolean checkLineItemNumberAvailableForIndustrialNonPersonnel(BudgetLineItem budgetLineItem) {
        boolean availabe = false;
        Integer lineItemNumber = budgetLineItem.getLineItemNumber();
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            if (!this.isLineItemCalAmountOfRateClassTypeOverhead(budgetLineItemCalcAmount) || !budgetLineItemCalcAmount.getLineItemNumber().equals(lineItemNumber)) continue;
            availabe = true;
        }
        return availabe;
    }
}

