/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rates;

import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.bo.AbstractInstituteRate;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetAssociateInterface;

public abstract class AbstractBudgetRate
extends AbstractInstituteRate
implements BudgetAssociateInterface {
    private static final long serialVersionUID = -7152006670699620080L;
    private Long budgetId;
    private Budget budget;
    private BudgetDecimal applicableRate;
    private BudgetDecimal oldApplicableRate;
    private boolean rateChanged;
    private String viewLocation;
    private boolean displayLocation = true;
    private String budgetPeriod;
    private String affectedBudgetPeriod;
    private String trackAffectedPeriod;

    public AbstractBudgetRate() {
    }

    public AbstractBudgetRate(String unitNumber, AbstractInstituteRate abstractInstituteRate) {
        this();
        this.copyValues(unitNumber, abstractInstituteRate);
    }

    private void copyValues(String unitNumber, AbstractInstituteRate abstractInstituteRate) {
        this.setApplicableRate(abstractInstituteRate.getExternalApplicableRate());
        this.setFiscalYear(abstractInstituteRate.getFiscalYear());
        this.setInstituteRate(abstractInstituteRate.getInstituteRate());
        this.setOnOffCampusFlag(abstractInstituteRate.getOnOffCampusFlag());
        this.setRateClass(abstractInstituteRate.getRateClass());
        this.setRateClassCode(abstractInstituteRate.getRateClassCode());
        this.setRateType(abstractInstituteRate.getRateType());
        this.setRateTypeCode(abstractInstituteRate.getRateTypeCode());
        this.setStartDate(abstractInstituteRate.getStartDate());
        this.setUnitNumber(unitNumber);
        this.setOldApplicableRate(abstractInstituteRate.getInstituteRate());
        this.setNonEditableRateFlag(abstractInstituteRate.getNonEditableRateFlag());
    }

    @Override
    public boolean getNonEditableRateFlag() {
        boolean nonEditableRate = false;
        if (this.getBudget() != null) {
            if (RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(this.getRateClassType())) {
                nonEditableRate = this.getBudget().getEbRatesNonEditable();
            } else if (RateClassType.OVERHEAD.getRateClassType().equals(this.getRateClassType())) {
                nonEditableRate = this.getBudget().getOhRatesNonEditable();
            }
        }
        return nonEditableRate;
    }

    public BudgetDecimal getApplicableRate() {
        return BudgetDecimal.returnZeroIfNull(this.applicableRate);
    }

    public BudgetDecimal getExactApplicableRate() {
        return this.applicableRate;
    }

    public boolean isApplicableRateNull() {
        return this.applicableRate == null;
    }

    public void setExactApplicableRate(BudgetDecimal applicableRate) {
        this.setApplicableRate(applicableRate);
    }

    public void setApplicableRate(BudgetDecimal applicableRate) {
        this.setOldApplicableRate(this.applicableRate);
        if (!ObjectUtils.equals((Object)((Object)this.applicableRate), (Object)((Object)applicableRate))) {
            this.setRateChanged(true);
        }
        this.applicableRate = applicableRate;
    }

    public BudgetDecimal getOldApplicableRate() {
        return BudgetDecimal.returnZeroIfNull(this.oldApplicableRate);
    }

    public void setOldApplicableRate(BudgetDecimal oldApplicableRate) {
        this.oldApplicableRate = oldApplicableRate;
    }

    public String getViewLocation() {
        return this.viewLocation;
    }

    public void setViewLocation(String viewLocation) {
        this.viewLocation = viewLocation;
    }

    public boolean isDisplayLocation() {
        return this.displayLocation;
    }

    public void setDisplayLocation(boolean displayLocation) {
        this.displayLocation = displayLocation;
    }

    public String getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(String budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public final String getAffectedBudgetPeriod() {
        return this.affectedBudgetPeriod;
    }

    public final void setAffectedBudgetPeriod(String affectedBudgetPeriod) {
        this.affectedBudgetPeriod = affectedBudgetPeriod;
    }

    public final String getTrackAffectedPeriod() {
        return this.trackAffectedPeriod;
    }

    public final void setTrackAffectedPeriod(String trackAffectedPeriod) {
        this.trackAffectedPeriod = trackAffectedPeriod;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    @Override
    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.affectedBudgetPeriod == null ? 0 : this.affectedBudgetPeriod.hashCode());
        result = 31 * result + (this.applicableRate == null ? 0 : this.applicableRate.hashCode());
        result = 31 * result + (this.budgetId == null ? 0 : this.budgetId.hashCode());
        result = 31 * result + (this.budgetPeriod == null ? 0 : this.budgetPeriod.hashCode());
        result = 31 * result + (this.displayLocation ? 1231 : 1237);
        result = 31 * result + (this.oldApplicableRate == null ? 0 : this.oldApplicableRate.hashCode());
        result = 31 * result + (this.trackAffectedPeriod == null ? 0 : this.trackAffectedPeriod.hashCode());
        result = 31 * result + (this.viewLocation == null ? 0 : this.viewLocation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBudgetRate other = (AbstractBudgetRate)obj;
        if (this.affectedBudgetPeriod == null ? other.affectedBudgetPeriod != null : !this.affectedBudgetPeriod.equals(other.affectedBudgetPeriod)) {
            return false;
        }
        if (this.applicableRate == null ? other.applicableRate != null : !this.applicableRate.equals((Object)other.applicableRate)) {
            return false;
        }
        if (this.budget == null ? other.budget != null : !this.budget.equals(other.budget)) {
            return false;
        }
        if (this.budgetId == null ? other.budgetId != null : !this.budgetId.equals(other.budgetId)) {
            return false;
        }
        if (this.budgetPeriod == null ? other.budgetPeriod != null : !this.budgetPeriod.equals(other.budgetPeriod)) {
            return false;
        }
        if (this.displayLocation != other.displayLocation) {
            return false;
        }
        if (this.oldApplicableRate == null ? other.oldApplicableRate != null : !this.oldApplicableRate.equals((Object)other.oldApplicableRate)) {
            return false;
        }
        if (this.trackAffectedPeriod == null ? other.trackAffectedPeriod != null : !this.trackAffectedPeriod.equals(other.trackAffectedPeriod)) {
            return false;
        }
        return !(this.viewLocation == null ? other.viewLocation != null : !this.viewLocation.equals(other.viewLocation));
    }

    public boolean isRateChanged() {
        return this.rateChanged;
    }

    public void setRateChanged(boolean rateChanged) {
        this.rateChanged = rateChanged;
    }
}

