/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rates;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.LesserThan;
import org.kuali.kra.budget.calculator.query.Or;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRatesServiceImpl;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class BudgetRateServiceDecorator<T extends BudgetParent>
extends BudgetRatesServiceImpl<T> {
    private static final String AWARD_EB_RATE_CLASS_CODE = "awardBudgetEbRateClassCode";
    private static final String AWARD_EB_RATE_TYPE_CODE = "awardBudgetEbRateTypeCode";
    private static final String DEFAULT_FNA_RATE_CLASS_CODE = "defaultFnARateClassCode";
    private ParameterService parameterService;
    private BudgetCalculationService budgetCalculationService;

    @Override
    protected Collection<InstituteRate> getInstituteRates(BudgetDocument<T> budgetDocument) {
        Collection<InstituteRate> institueRates = super.getInstituteRates(budgetDocument);
        if (this.isAwardBudget(budgetDocument)) {
            return this.syncRatesIfAward(budgetDocument, institueRates);
        }
        return institueRates;
    }

    private boolean isAwardBudget(BudgetDocument<T> budgetDocument) {
        return budgetDocument.getParentDocument().getClass().equals(AwardDocument.class);
    }

    private Collection<InstituteRate> syncRatesIfAward(BudgetDocument<T> budgetDocument, Collection<InstituteRate> institueRates) {
        Award award = (Award)budgetDocument.getParentDocument().getBudgetParent();
        return this.filterInstituteRatesForAward(budgetDocument, award, institueRates);
    }

    private Collection<InstituteRate> filterInstituteRatesForAward(BudgetDocument<T> budgetDocument, Award award, Collection<InstituteRate> instituteRates) {
        List<AwardFandaRate> awardFnARates = award.getAwardFandaRate();
        ArrayList<InstituteRate> instituteRatesForAward = new ArrayList<InstituteRate>();
        List<InstituteRate> awardEbRates = this.createAwardEBInstituteRates(award);
        if (awardFnARates.isEmpty() && awardEbRates.isEmpty()) {
            return instituteRates;
        }
        for (AwardFandaRate awardFnARate : awardFnARates) {
            InstituteRate awardRate = this.createAwardFnAInstitueRate(awardFnARate, award, instituteRates);
            instituteRatesForAward.add(awardRate);
        }
        if (!instituteRatesForAward.isEmpty()) {
            QueryList qlInstituteRates = new QueryList(instituteRatesForAward);
            qlInstituteRates.sort("startDate");
            InstituteRate firstRate = (InstituteRate)qlInstituteRates.get(0);
            if (firstRate.getStartDate().after(award.getRequestedStartDateInitial())) {
                firstRate.setStartDate(award.getRequestedStartDateInitial());
            }
        }
        for (InstituteRate awardEBRate : awardEbRates) {
            instituteRatesForAward.add(awardEBRate);
        }
        for (InstituteRate instituteRate : instituteRates) {
            if (!awardFnARates.isEmpty() && instituteRate.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType()) || !awardEbRates.isEmpty() & instituteRate.getRateClassType().equals(RateClassType.EMPLOYEE_BENEFITS.getRateClassType())) continue;
            instituteRatesForAward.add(instituteRate);
        }
        return instituteRatesForAward;
    }

    private List<InstituteRate> createAwardEBInstituteRates(Award award) {
        KualiDecimal specialEbRateOffCampus;
        ArrayList<InstituteRate> awardEBInstituteRates = new ArrayList<InstituteRate>();
        KualiDecimal specialEbRateOnCampus = award.getSpecialEbRateOnCampus();
        if (specialEbRateOnCampus != null) {
            awardEBInstituteRates.add(this.createEBInstituteRate(award, specialEbRateOnCampus, Boolean.TRUE));
        }
        if ((specialEbRateOffCampus = award.getSpecialEbRateOffCampus()) != null) {
            awardEBInstituteRates.add(this.createEBInstituteRate(award, specialEbRateOffCampus, Boolean.FALSE));
        }
        return awardEBInstituteRates;
    }

    private InstituteRate createEBInstituteRate(Award award, KualiDecimal specialEbRate, Boolean onCampusFlag) {
        InstituteRate awardInstituteRate = new InstituteRate();
        BudgetDecimal applicableRate = new BudgetDecimal(specialEbRate.bigDecimalValue());
        awardInstituteRate.setActivityTypeCode(award.getActivityTypeCode());
        awardInstituteRate.setStartDate(award.getRequestedStartDateInitial());
        Calendar cal = Calendar.getInstance();
        cal.setTime(award.getRequestedStartDateInitial());
        int year = cal.get(1);
        awardInstituteRate.setFiscalYear("" + year);
        awardInstituteRate.setInstituteRate(applicableRate);
        awardInstituteRate.setUnitNumber(award.getUnitNumber());
        String awardEBRateTypeCode = this.getDefaultEBRateTypeCode();
        String awardEBRateClassCode = this.getDefaultEBRateClassCode();
        awardInstituteRate.setRateTypeCode(awardEBRateTypeCode);
        awardInstituteRate.setRateType(this.createRateType(awardEBRateClassCode, awardEBRateTypeCode, "Special EB Rate"));
        awardInstituteRate.setRateClassCode(awardEBRateClassCode);
        awardInstituteRate.setOnOffCampusFlag(onCampusFlag);
        awardInstituteRate.setNonEditableRateFlag(true);
        awardInstituteRate.refreshReferenceObject("rateType");
        awardInstituteRate.refreshReferenceObject("rateClass");
        return awardInstituteRate;
    }

    private String getDefaultEBRateClassCode() {
        return this.getParameterService().getParameterValueAsString(BudgetDocument.class, AWARD_EB_RATE_CLASS_CODE);
    }

    private String getDefaultEBRateTypeCode() {
        return this.getParameterService().getParameterValueAsString(BudgetDocument.class, AWARD_EB_RATE_TYPE_CODE);
    }

    private InstituteRate createAwardFnAInstitueRate(AwardFandaRate awardFnARate, Award award, Collection<InstituteRate> instituteRates) {
        InstituteRate awardInstituteRate = this.filterInstituteRate(awardFnARate, award, instituteRates);
        BudgetDecimal applicableRate = new BudgetDecimal(awardFnARate.getApplicableFandaRate().bigDecimalValue());
        awardInstituteRate.setActivityTypeCode(award.getActivityTypeCode());
        awardInstituteRate.setStartDate(awardFnARate.getStartDate());
        awardInstituteRate.setFiscalYear(awardFnARate.getFiscalYear());
        awardInstituteRate.setExternalApplicableRate(applicableRate);
        if (awardInstituteRate.getInstituteRate() == null) {
            awardInstituteRate.setInstituteRate(applicableRate);
        }
        String awardFnArateTypeCode = awardFnARate.getFandaRateTypeCode().toString();
        awardInstituteRate.setRateTypeCode(awardFnArateTypeCode);
        awardInstituteRate.setRateType(awardFnARate.getFandaRateType());
        awardInstituteRate.setRateClassCode(awardFnARate.getFandaRateType().getRateClassCode());
        Boolean onCampusFlag = new Boolean(awardFnARate.getOnCampusFlag().equals("N"));
        awardInstituteRate.setOnOffCampusFlag(onCampusFlag);
        awardInstituteRate.setNonEditableRateFlag(true);
        awardInstituteRate.refreshReferenceObject("rateClass");
        return awardInstituteRate;
    }

    private InstituteRate filterInstituteRate(AwardFandaRate awardFnARate, Award award, Collection<InstituteRate> instituteRates) {
        QueryList<InstituteRate> qlInstituteRates = new QueryList<InstituteRate>(instituteRates);
        Equals eqActivityType = new Equals("activityTypeCode", (Comparable)((Object)award.getActivityTypeCode()));
        Equals eqCampusFlag = new Equals("onOffCampusFlag", new Boolean(awardFnARate.getOnCampusFlag().equals("N")));
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)awardFnARate.getFandaRateType().getRateClassCode()));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)awardFnARate.getFandaRateTypeCode()));
        And campFlagAndActTypeAndUnitNum = new And(eqActivityType, eqCampusFlag);
        And rateClassAndRateType = new And(eqRateClassCode, eqRateTypeCode);
        And filterCondition = new And(campFlagAndActTypeAndUnitNum, rateClassAndRateType);
        QueryList<InstituteRate> qlfilteredList = qlInstituteRates.filter(filterCondition);
        Equals eqStartDate = new Equals("startDate", awardFnARate.getStartDate());
        LesserThan ltStartDate = new LesserThan("startDate", awardFnARate.getStartDate());
        Or ltOrEqStartDate = new Or(eqStartDate, ltStartDate);
        qlfilteredList = qlfilteredList.filter(ltOrEqStartDate);
        qlfilteredList.sort("startDate", false);
        return qlfilteredList.isEmpty() ? new InstituteRate() : qlfilteredList.get(0);
    }

    private String getDefaultFnARateClassCode() {
        return this.getParameterService().getParameterValueAsString(BudgetDocument.class, DEFAULT_FNA_RATE_CLASS_CODE);
    }

    private RateType createRateType(String rateClassCode, String awardFnArateTypeCode, String rateTypeDesc) {
        RateType rateType = new RateType();
        rateType.setRateTypeCode(awardFnArateTypeCode);
        rateType.setRateClassCode(rateClassCode);
        rateType.setDescription(rateTypeDesc);
        return rateType;
    }

    @Override
    public void syncAllBudgetRates(BudgetDocument<T> budgetDocument) {
        if (this.isAwardBudget(budgetDocument)) {
            if (this.isOutOfSyncAwardRates(budgetDocument.getBudget())) {
                super.syncAllBudgetRates(budgetDocument);
                this.repopulateAllCalcAmounts(budgetDocument);
            }
        } else {
            super.syncAllBudgetRates(budgetDocument);
        }
    }

    @Override
    public void syncParentDocumentRates(BudgetDocument<T> budgetDocument) {
        if (this.isAwardBudget(budgetDocument) && !this.hasNoRatesFromParent(budgetDocument.getBudget()) && this.isOutOfSyncAwardRates((Award)budgetDocument.getParentDocument().getBudgetParent(), budgetDocument.getBudget())) {
            this.syncBudgetRatesForRateClassType(RateClassType.OVERHEAD.getRateClassType(), budgetDocument);
            this.syncBudgetRatesForRateClassType(RateClassType.EMPLOYEE_BENEFITS.getRateClassType(), budgetDocument);
            this.repopulateAllCalcAmounts(budgetDocument);
        }
    }

    private void repopulateAllCalcAmounts(BudgetDocument budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                this.getBudgetCalculationService().rePopulateCalculatedAmount(budget, budgetLineItem);
                List<BudgetPersonnelDetails> personnelDetailList = budgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetails : personnelDetailList) {
                    budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
                    this.getBudgetCalculationService().rePopulateCalculatedAmount(budget, budgetPersonnelDetails);
                }
            }
        }
    }

    private boolean hasNoRatesFromParent(Budget budget) {
        Award award = (Award)budget.getBudgetDocument().getParentDocument().getBudgetParent();
        return award.getAwardFandaRate().isEmpty() && award.getSpecialEbRateOffCampus() == null && award.getSpecialEbRateOnCampus() == null;
    }

    private boolean isOutOfSyncAwardRates(Budget budget) {
        Award award = (Award)budget.getBudgetDocument().getParentDocument().getBudgetParent();
        if (budget.getInstituteRates().isEmpty()) {
            this.populateInstituteRates(budget.getBudgetDocument());
        }
        if (this.hasNoRatesFromParent(budget)) {
            return this.isOutOfSync(budget);
        }
        return this.isOutOfSyncAwardRates(award, budget);
    }

    private boolean isOutOfSyncAwardRates(Award award, Budget budget) {
        List<AwardFandaRate> fnaRates = award.getAwardFandaRate();
        QueryList<BudgetRate> budgetRates = new QueryList<BudgetRate>(budget.getBudgetRates());
        boolean ratesOutOfSync = false;
        if (!fnaRates.isEmpty()) {
            Equals eqOhRateClassType = new Equals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            QueryList<BudgetRate> filteredOhRates = budgetRates.filter(eqOhRateClassType);
            boolean bl = ratesOutOfSync = fnaRates.size() != filteredOhRates.size();
            if (!ratesOutOfSync) {
                for (BudgetRate budgetRate : filteredOhRates) {
                    ratesOutOfSync = !this.fnaRatesContains(fnaRates, budgetRate);
                    if (!ratesOutOfSync) continue;
                    return ratesOutOfSync;
                }
            }
        }
        Equals eqEbRateClassType = new Equals("rateClassType", (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
        KualiDecimal specialEbRateOnCampus = award.getSpecialEbRateOnCampus();
        if (specialEbRateOnCampus != null) {
            Equals eqOnCampus = new Equals("onOffCampusFlag", Boolean.TRUE);
            And onCampusEbRateClassType = new And(eqEbRateClassType, eqOnCampus);
            QueryList<BudgetRate> filteredEbRates = budgetRates.filter(onCampusEbRateClassType);
            boolean bl = ratesOutOfSync = filteredEbRates.size() != 1;
            if (!ratesOutOfSync) {
                BudgetRate budgetEbOnCampusRate = (BudgetRate)filteredEbRates.get(0);
                ratesOutOfSync = !budgetEbOnCampusRate.getApplicableRate().bigDecimalValue().equals(specialEbRateOnCampus.bigDecimalValue());
            }
        }
        KualiDecimal specialEbRateOffCampus = award.getSpecialEbRateOffCampus();
        if (!ratesOutOfSync && specialEbRateOffCampus != null) {
            Equals eqOffCampus = new Equals("onOffCampusFlag", Boolean.FALSE);
            And offCampusEbRateClassType = new And(eqEbRateClassType, eqOffCampus);
            QueryList<BudgetRate> filteredOffCampusEbRates = budgetRates.filter(offCampusEbRateClassType);
            boolean bl = ratesOutOfSync = filteredOffCampusEbRates.size() != 1;
            if (!ratesOutOfSync) {
                BudgetRate budgetEbOnCampusRate = (BudgetRate)filteredOffCampusEbRates.get(0);
                ratesOutOfSync = !budgetEbOnCampusRate.getApplicableRate().bigDecimalValue().equals(specialEbRateOffCampus.bigDecimalValue());
            }
        }
        return ratesOutOfSync;
    }

    private boolean fnaRatesContains(List<AwardFandaRate> fnaRates, BudgetRate budgetRate) {
        for (AwardFandaRate awardFandaRate : fnaRates) {
            if (!awardFandaRate.equals(budgetRate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean performSyncFlag(BudgetDocument<T> budgetDocument) {
        return this.isAwardBudget(budgetDocument) && this.isOutOfSyncAwardRates(budgetDocument.getBudget());
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }
}

