/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rates;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.AbstractInstituteRate;
import org.kuali.kra.bo.InstituteLaRate;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.GreaterThan;
import org.kuali.kra.budget.calculator.query.LesserThan;
import org.kuali.kra.budget.calculator.query.Or;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.rates.AbstractBudgetRate;
import org.kuali.kra.budget.rates.BudgetLaRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.budget.rates.RateClassType;
import org.kuali.kra.budget.rates.UnitFormulatedCost;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.BusinessObjectService;

public class BudgetRatesServiceImpl<T extends BudgetParent>
implements BudgetRatesService<T> {
    private static final String SPACE = " ";
    public static final String UNIT_NUMBER_KEY = "unitNumber";
    public static final String ACTIVITY_TYPE_CODE_KEY = "activityTypeCode";
    public static final String BUDGET_ID_KEY = "budgetId";
    private BusinessObjectService businessObjectService;
    private UnitService unitService;
    private static final String PERIOD_SEARCH_SEPARATOR = "|";
    private static final String PERIOD_DISPLAY_SEPARATOR = ",";
    private static final Log LOG = LogFactory.getLog(BudgetRatesServiceImpl.class);
    private static final String BUDGET_RATE_AUDIT_WARNING_KEY = "budgetRateAuditWarnings";

    @Override
    public void resetAllBudgetRates(Budget budget) {
        this.resetAbstractBudgetApplicableRatesToInstituteRates(budget.getBudgetRates());
        this.resetAbstractBudgetApplicableRatesToInstituteRates(budget.getBudgetLaRates());
    }

    @Override
    public void resetBudgetRatesForRateClassType(String rateClassType, Budget budget) {
        List<RateClass> rateClasses = budget.getRateClasses();
        this.resetBudgetRatesForRateClassType(rateClasses, rateClassType, budget.getBudgetRates());
        this.resetBudgetRatesForRateClassType(rateClasses, rateClassType, budget.getBudgetLaRates());
    }

    @Override
    public void syncAllBudgetRates(BudgetDocument<T> budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        ArrayList<InstituteRate> allInstituteRates = new ArrayList<InstituteRate>(this.getInstituteRates(budgetDocument));
        ArrayList<InstituteLaRate> allInstituteLaRates = new ArrayList<InstituteLaRate>(this.getInstituteLaRates(budgetDocument));
        if (this.isOutOfSync(budget)) {
            Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalRates = this.mapRatesToKeys(budget.getBudgetRates());
            Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalLaRates = this.mapRatesToKeys(budget.getBudgetLaRates());
            budget.getBudgetRates().clear();
            budget.getBudgetLaRates().clear();
            budget.getRateClasses().clear();
            budget.getBudgetUnrecoveredFandAs().clear();
            this.getBudgetRates(budgetDocument, allInstituteRates);
            this.getBudgetLaRates(budgetDocument, allInstituteLaRates);
            this.syncVersionNumber(mapOfExistingBudgetProposalRates, budget.getBudgetRates());
            this.syncVersionNumber(mapOfExistingBudgetProposalLaRates, budget.getBudgetLaRates());
        } else {
            this.syncBudgetRates(budget.getBudgetRates(), allInstituteRates);
            this.syncBudgetRates(budget.getBudgetLaRates(), allInstituteLaRates);
        }
    }

    protected void syncVersionNumber(Map<String, AbstractInstituteRate> oldRateMap, List rates) {
        List abstractBudgetRates = rates;
        for (AbstractBudgetRate budgetRate : abstractBudgetRates) {
            AbstractInstituteRate oldRate = oldRateMap.get(budgetRate.getRateKeyAsString());
            if (oldRate == null) continue;
            budgetRate.setVersionNumber(oldRate.getVersionNumber());
        }
    }

    @Override
    public void viewLocation(String viewLocation, Integer budgetPeriod, Budget budget) {
        this.viewLocation(viewLocation, budgetPeriod, budget.getBudgetRates());
        this.viewLocation(viewLocation, budgetPeriod, budget.getBudgetLaRates());
    }

    @Override
    public void syncParentDocumentRates(BudgetDocument<T> budgetDocument) {
    }

    @Override
    public void syncBudgetRatesForRateClassType(String rateClassType, BudgetDocument<T> budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        this.populateInstituteRates(budgetDocument);
        Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalRates = this.mapRatesToKeys(budget.getBudgetRates());
        Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalLaRates = this.mapRatesToKeys(budget.getBudgetLaRates());
        this.replaceRateClassesForRateClassType(rateClassType, budget, budget.getInstituteRates());
        this.replaceRateClassesForRateClassType(rateClassType, budget, budget.getInstituteLaRates());
        this.replaceBudgetRatesForRateClassType(rateClassType, budgetDocument, budget.getBudgetRates(), budget.getInstituteRates());
        this.replaceBudgetRatesForRateClassType(rateClassType, budgetDocument, budget.getBudgetLaRates(), budget.getInstituteLaRates());
        this.syncVersionNumber(mapOfExistingBudgetProposalRates, budget.getBudgetRates());
        this.syncVersionNumber(mapOfExistingBudgetProposalLaRates, budget.getBudgetLaRates());
    }

    @Override
    public void getBudgetRates(List<RateClassType> rateClassTypes, BudgetDocument<T> budgetDocument) {
        this.getBudgetRates(rateClassTypes, budgetDocument, this.getInstituteRates(budgetDocument));
    }

    protected void checkActivityPrefixForRateClassTypes(List<RateClassType> rateClassTypes, BudgetDocument<T> budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        String activityTypeDescription = this.getActivityTypeDescription(budgetDocument);
        List<BudgetRate> budgetRates = budget.getBudgetRates();
        List<BudgetLaRate> budgetLaRates = budget.getBudgetLaRates();
        for (RateClassType rateClassType : rateClassTypes) {
            if (!rateClassType.getPrefixActivityType().booleanValue()) continue;
            String newRateClassTypeDescription = activityTypeDescription.concat(rateClassType.getDescription());
            rateClassType.setDescription(newRateClassTypeDescription);
            rateClassType.setPrefixActivityType(false);
            for (BudgetRate budgetRate : budgetRates) {
                RateClassType BPRateClassType = budgetRate.getRateClass().getRateClassTypeT();
                if (!rateClassType.getRateClassType().equalsIgnoreCase(BPRateClassType.getRateClassType())) continue;
                BPRateClassType.setDescription(newRateClassTypeDescription);
            }
            for (BudgetLaRate budgetLaRate : budgetLaRates) {
                RateClassType BPLRateClassType = budgetLaRate.getRateClass().getRateClassTypeT();
                if (!rateClassType.getRateClassType().equalsIgnoreCase(BPLRateClassType.getRateClassType())) continue;
                BPLRateClassType.setDescription(newRateClassTypeDescription);
            }
        }
    }

    protected String getActivityTypeDescription(BudgetDocument<T> budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        T budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        if (budget.isRateSynced() || !KraServiceLocator.getService(BudgetService.class).checkActivityTypeChange(this.getBudgetParentDocument(budget), budget)) {
            if (budgetParent.getActivityType() != null) {
                return budgetParent.getActivityType().getDescription().concat(SPACE);
            }
            return "";
        }
        String activityTypeCode = null;
        if (CollectionUtils.isNotEmpty(budget.getBudgetRates())) {
            activityTypeCode = budget.getBudgetRates().get(0).getActivityTypeCode();
        }
        if (activityTypeCode != null) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put(ACTIVITY_TYPE_CODE_KEY, activityTypeCode);
            ActivityType activityType = (ActivityType)KraServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(ActivityType.class, pkMap);
            if (activityType == null) {
                return "";
            }
            return activityType.getDescription().concat(SPACE);
        }
        return "";
    }

    @Override
    public List<BudgetPeriod> getBudgetPeriods() {
        BudgetForm budgetForm = (BudgetForm)KNSGlobalVariables.getKualiForm();
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        return budgetPeriods;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected void updateRatesForEachPeriod(Budget budget) {
        List<BudgetRate> budgetRates = budget.getBudgetRates();
        List<BudgetLaRate> budgetLaRates = budget.getBudgetLaRates();
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            String currBudgetPeriod;
            String formattedPeriod;
            String dispBudgetPeriod;
            for (BudgetRate budgetRate : budgetRates) {
                if (budgetRate.getStartDate().compareTo(budgetPeriod.getEndDate()) > 0) continue;
                dispBudgetPeriod = budgetPeriod.getBudgetPeriod().toString();
                formattedPeriod = dispBudgetPeriod.concat(PERIOD_SEARCH_SEPARATOR);
                currBudgetPeriod = budgetRate.getTrackAffectedPeriod();
                if (currBudgetPeriod == null) {
                    currBudgetPeriod = PERIOD_SEARCH_SEPARATOR.concat(formattedPeriod);
                    budgetRate.setTrackAffectedPeriod(currBudgetPeriod);
                } else if (currBudgetPeriod.indexOf(formattedPeriod) < 0) {
                    currBudgetPeriod = currBudgetPeriod.concat(formattedPeriod);
                    budgetRate.setTrackAffectedPeriod(currBudgetPeriod);
                }
                budgetRate.setAffectedBudgetPeriod(this.getFormattedAffectedBudgetPeriod(currBudgetPeriod));
            }
            for (BudgetLaRate budgetLaRate : budgetLaRates) {
                if (budgetLaRate.getStartDate().compareTo(budgetPeriod.getEndDate()) > 0) continue;
                dispBudgetPeriod = budgetPeriod.getBudgetPeriod().toString();
                formattedPeriod = dispBudgetPeriod.concat(PERIOD_SEARCH_SEPARATOR);
                currBudgetPeriod = budgetLaRate.getTrackAffectedPeriod();
                if (currBudgetPeriod == null) {
                    currBudgetPeriod = PERIOD_SEARCH_SEPARATOR.concat(formattedPeriod);
                    budgetLaRate.setTrackAffectedPeriod(currBudgetPeriod);
                } else if (currBudgetPeriod.indexOf(formattedPeriod) < 0) {
                    currBudgetPeriod = currBudgetPeriod.concat(formattedPeriod);
                    budgetLaRate.setTrackAffectedPeriod(currBudgetPeriod);
                }
                budgetLaRate.setAffectedBudgetPeriod(this.getFormattedAffectedBudgetPeriod(currBudgetPeriod));
            }
        }
    }

    protected Map<String, AbstractInstituteRate> mapRatesToKeys(Collection rates) {
        Collection abstractInstituteRates = rates;
        HashMap<String, AbstractInstituteRate> rateMap = new HashMap<String, AbstractInstituteRate>();
        for (AbstractInstituteRate abstractInstituteRate : abstractInstituteRates) {
            rateMap.put(abstractInstituteRate.getRateKeyAsString(), abstractInstituteRate);
        }
        return rateMap;
    }

    protected Collection<InstituteRate> getInstituteRates(BudgetDocument<T> budgetDocument) {
        Unit firstUnit = this.findFirstUnitWithRates(budgetDocument.getParentDocument().getBudgetParent().getUnit(), InstituteRate.class);
        if (firstUnit == null) {
            return new ArrayList<InstituteRate>();
        }
        Collection<AbstractInstituteRate> abstractRates = this.getActiveInstituteRates(InstituteRate.class, firstUnit, budgetDocument.getParentDocument().getBudgetParent().getActivityTypeCode());
        return abstractRates;
    }

    protected Unit findFirstUnitWithRates(Unit leadUnit, Class rateType) {
        Unit currentUnit;
        HashMap<String, String> currentSearchMap = new HashMap<String, String>();
        Collection currentRates = null;
        for (currentUnit = leadUnit; currentUnit != null; currentUnit = currentUnit.getParentUnit()) {
            currentSearchMap.put(UNIT_NUMBER_KEY, currentUnit.getUnitNumber());
            currentRates = this.filterForActiveRatesOnly(this.getBusinessObjectService().findMatching(rateType, currentSearchMap));
            if (currentRates != null && !currentRates.isEmpty()) break;
        }
        return currentUnit;
    }

    protected Collection<AbstractInstituteRate> getActiveInstituteRates(Class rateType, Unit unit, String activityTypeCode) {
        HashMap<String, String> searchMap = new HashMap<String, String>();
        searchMap.put(UNIT_NUMBER_KEY, unit.getUnitNumber());
        searchMap.put(ACTIVITY_TYPE_CODE_KEY, activityTypeCode);
        return this.filterForActiveRatesOnly(this.getBusinessObjectService().findMatching(rateType, searchMap));
    }

    protected Collection<InstituteLaRate> getInstituteLaRates(BudgetDocument<T> budgetDocument) {
        T budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        String unitNumber = budgetParent.getUnitNumber();
        Collection abstractInstituteRates = this.getFilteredInstituteLaRates(InstituteLaRate.class, unitNumber, budgetParent.getUnit(), this.getRateFilterMap(budgetDocument));
        abstractInstituteRates = abstractInstituteRates.size() > 0 ? abstractInstituteRates : new ArrayList();
        return abstractInstituteRates;
    }

    protected BudgetParentDocument<T> getBudgetParentDocument(Budget budget) {
        BudgetDocument budgetDocument = budget.getBudgetDocument();
        if (budgetDocument == null) {
            budget.refreshReferenceObject("budgetDocument");
            budgetDocument = budget.getBudgetDocument();
        }
        return budgetDocument.getParentDocument();
    }

    protected Map<String, String> getRateFilterMap(BudgetDocument<T> budgetDocument) {
        T budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        HashMap<String, String> rateFilterMap = new HashMap<String, String>();
        rateFilterMap.put(UNIT_NUMBER_KEY, budgetParent.getUnitNumber());
        return rateFilterMap;
    }

    protected Collection getFilteredInstituteLaRates(Class rateType, String unitNumber, Unit currentUnit, Map<String, String> rateFilterMap) {
        Collection abstractInstituteRates = this.filterForActiveRatesOnly(this.getBusinessObjectService().findMatching(rateType, rateFilterMap));
        return abstractInstituteRates;
    }

    protected Collection getFilteredInstituteRates(Class rateType, String unitNumber, Unit currentUnit, Map<String, String> rateFilterMap) {
        Collection abstractInstituteRates;
        do {
            abstractInstituteRates = this.filterForActiveRatesOnly(this.getBusinessObjectService().findMatching(rateType, rateFilterMap));
            currentUnit = this.makeParentUnitAsCurrentUnit(currentUnit, rateFilterMap);
        } while (abstractInstituteRates.size() == 0 && currentUnit != null);
        return abstractInstituteRates;
    }

    protected Collection filterForActiveRatesOnly(Collection abstractInstituteRates) {
        ArrayList<AbstractInstituteRate> filteredList = new ArrayList<AbstractInstituteRate>();
        for (AbstractInstituteRate rate : abstractInstituteRates) {
            if (rate.isActive()) {
                filteredList.add(rate);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Filtering inactive rate: " + rate.getObjectId()));
        }
        return filteredList;
    }

    protected Unit makeParentUnitAsCurrentUnit(Unit currentUnit, Map<String, String> rateFilterMap) {
        Unit parentUnit;
        Unit unit = parentUnit = currentUnit == null ? null : currentUnit.getParentUnit();
        if (parentUnit != null) {
            rateFilterMap.put(UNIT_NUMBER_KEY, parentUnit.getUnitNumber());
        }
        return parentUnit;
    }

    protected Date getRateEffectiveStartDate(Budget budget, AbstractInstituteRate rate, Date personEffectiveDate) {
        Date effectiveDate = budget.getStartDate();
        if (rate.getRateClass().getRateClassType().equalsIgnoreCase("I") && personEffectiveDate != null && personEffectiveDate.compareTo(effectiveDate) < 0) {
            effectiveDate = personEffectiveDate;
        }
        return effectiveDate;
    }

    protected Date getBudgetPersonSalaryEffectiveDate(Budget budget) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put(BUDGET_ID_KEY, budget.getBudgetId());
        Collection budgetPersons = this.getBusinessObjectService().findMatching(BudgetPerson.class, queryMap);
        Date effectiveDate = null;
        for (BudgetPerson budgetPerson : budgetPersons) {
            if (effectiveDate != null && budgetPerson.getEffectiveDate().compareTo(effectiveDate) >= 0) continue;
            effectiveDate = budgetPerson.getEffectiveDate();
        }
        return effectiveDate;
    }

    protected void getRatesForProjectDates(Budget budget, Collection allRates, Collection filteredRates, Date personSalaryEffectiveDate) {
        List dateFilteredRates = (List)filteredRates;
        List allAbstractInstituteRates = (List)allRates;
        for (AbstractInstituteRate rate : allAbstractInstituteRates) {
            Date rateEffectiveDate;
            Date rateStartDate = rate.getStartDate();
            if (rateStartDate.compareTo(rateEffectiveDate = this.getRateEffectiveStartDate(budget, rate, personSalaryEffectiveDate)) < 0 || rateStartDate.compareTo(budget.getEndDate()) > 0) continue;
            dateFilteredRates.add(rate);
        }
    }

    protected void filterInstituteRates(Budget budget, Collection<AbstractInstituteRate> allRates, Collection<AbstractInstituteRate> filteredRates, Date personSalaryEffectiveDate) {
        ArrayList<String> addedList = new ArrayList<String>();
        QueryList<AbstractInstituteRate> instituteRates = new QueryList<AbstractInstituteRate>(allRates);
        for (AbstractInstituteRate instituteRate : allRates) {
            String hKey = this.generateThreePartKey(instituteRate);
            if (addedList.contains(hKey)) continue;
            addedList.add(hKey);
            Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)instituteRate.getRateClassCode()));
            Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)instituteRate.getRateTypeCode()));
            Equals eqCampusFlag = new Equals("onOffCampusFlag", instituteRate.getOnOffCampusFlag());
            And rateClassAndRateType = new And(eqRateClassCode, eqRateTypeCode);
            And rcRtCampus = new And(rateClassAndRateType, eqCampusFlag);
            QueryList<AbstractInstituteRate> tempFilteredRates = instituteRates.filter(rcRtCampus);
            Date effectiveStartDate = this.getRateEffectiveStartDate(budget, instituteRate, personSalaryEffectiveDate);
            Equals eqEndDate = new Equals("startDate", budget.getEndDate());
            LesserThan ltEndDate = new LesserThan("startDate", budget.getEndDate());
            Or ltEqEndDate = new Or(eqEndDate, ltEndDate);
            tempFilteredRates = tempFilteredRates.filter(ltEqEndDate);
            GreaterThan gtStartDate = new GreaterThan("startDate", effectiveStartDate);
            QueryList<AbstractInstituteRate> rateWithinProjectPeriod = tempFilteredRates.filter(gtStartDate);
            filteredRates.addAll(rateWithinProjectPeriod);
            tempFilteredRates.removeAll(rateWithinProjectPeriod);
            if (tempFilteredRates.isEmpty()) continue;
            tempFilteredRates.sort("startDate", false);
            filteredRates.add(tempFilteredRates.get(0));
        }
    }

    protected String generateThreePartKey(AbstractInstituteRate instituteRate) {
        return instituteRate.getRateClassCode() + instituteRate.getRateTypeCode() + this.getLocationFlagAsString(instituteRate.getOnOffCampusFlag());
    }

    protected void filterRates(Budget budget, Collection allAbstractInstituteRates, Collection filteredAbstractInstituteRates) {
        filteredAbstractInstituteRates.clear();
        Date personSalaryEffectiveDate = this.getBudgetPersonSalaryEffectiveDate(budget);
        this.filterInstituteRates(budget, allAbstractInstituteRates, filteredAbstractInstituteRates, personSalaryEffectiveDate);
    }

    protected boolean isOutOfSync(Budget budget) {
        return this.isOutOfSync(budget.getInstituteRates(), budget.getBudgetRates()) || this.isOutOfSync(budget.getInstituteLaRates(), budget.getBudgetLaRates());
    }

    protected boolean isOutOfSync(List instituteRates, List budgetRates) {
        boolean outOfSync = this.areNumbersOfBudgetRatesOutOfSyncWithInstituteRates(instituteRates, budgetRates);
        if (!outOfSync) {
            outOfSync = this.areBudgetRatesOutOfSyncWithInsttituteRates(instituteRates, budgetRates);
        }
        return outOfSync;
    }

    protected boolean areNumbersOfBudgetRatesOutOfSyncWithInstituteRates(List instituteRates, List budgetRates) {
        return instituteRates.size() != budgetRates.size();
    }

    protected boolean areBudgetRatesOutOfSyncWithInsttituteRates(List instituteRates, List budgetRates) {
        Set<String> budgetRateKeys;
        Set<String> instituteRateKeys = this.storeAllKeys(instituteRates);
        return !instituteRateKeys.containsAll(budgetRateKeys = this.storeAllKeys(budgetRates));
    }

    protected Set<String> storeAllKeys(List<AbstractInstituteRate> rates) {
        HashSet<String> keys = new HashSet<String>(rates.size(), 1.0f);
        for (AbstractInstituteRate rate : rates) {
            keys.add(rate.getRateKeyAsString());
        }
        return keys;
    }

    protected void resetAbstractBudgetApplicableRatesToInstituteRates(List budgetRates) {
        List abstractBudgetRates = budgetRates;
        for (AbstractBudgetRate abstractBudgetRate : abstractBudgetRates) {
            abstractBudgetRate.setApplicableRate(abstractBudgetRate.getExternalApplicableRate());
        }
    }

    protected void resetBudgetRatesForRateClassType(List<RateClass> rateClasses, String rateClassType, List budgetRates) {
        List abstractBudgetRates = budgetRates;
        for (RateClass rateClass : rateClasses) {
            if (!rateClass.getRateClassType().equalsIgnoreCase(rateClassType)) continue;
            for (AbstractBudgetRate abstractBudgetRate : abstractBudgetRates) {
                if (!abstractBudgetRate.getRateClassCode().equalsIgnoreCase(rateClass.getRateClassCode())) continue;
                abstractBudgetRate.setApplicableRate(abstractBudgetRate.getExternalApplicableRate());
            }
        }
    }

    protected void syncBudgetRates(List budgetRates, Collection abstractIntituteRates) {
        List abstractBudgetRates = budgetRates;
        Map<String, AbstractInstituteRate> instRateMap = this.mapRatesToKeys(abstractIntituteRates);
        for (AbstractBudgetRate abstractBudgetRate : abstractBudgetRates) {
            String hKey = abstractBudgetRate.getRateKeyAsString();
            AbstractInstituteRate abstractInstituteRate = instRateMap.get(hKey);
            abstractBudgetRate.setInstituteRate(abstractInstituteRate.getInstituteRate());
            abstractBudgetRate.setApplicableRate(abstractInstituteRate.getExternalApplicableRate());
        }
    }

    protected String getFormattedAffectedBudgetPeriod(String periodAffected) {
        String budgetPeriodAffected = periodAffected;
        if (budgetPeriodAffected != null) {
            budgetPeriodAffected = budgetPeriodAffected.trim();
            budgetPeriodAffected = budgetPeriodAffected.replace(PERIOD_SEARCH_SEPARATOR, PERIOD_DISPLAY_SEPARATOR);
            budgetPeriodAffected = budgetPeriodAffected.substring(1, budgetPeriodAffected.length() - 1);
        }
        return budgetPeriodAffected;
    }

    protected void viewLocation(String viewLocation, Integer budgetPeriod, List rates) {
        List budgetRates = rates;
        for (AbstractBudgetRate budgetRate : budgetRates) {
            boolean displayRate;
            String onOffCampusFlag = this.getLocationFlagAsString(budgetRate.getOnOffCampusFlag());
            boolean bl = displayRate = viewLocation == null || viewLocation.equalsIgnoreCase(onOffCampusFlag);
            if (displayRate && budgetPeriod != null) {
                String trackAffectedPeriod = budgetRate.getTrackAffectedPeriod();
                String formattedBudgetPeriod = this.getSeparatedBudgetPeriod(budgetPeriod);
                if (trackAffectedPeriod == null || trackAffectedPeriod.indexOf(formattedBudgetPeriod) < 0) {
                    displayRate = false;
                }
            }
            budgetRate.setDisplayLocation(displayRate);
        }
    }

    protected String getLocationFlagAsString(boolean onOffCampusFlag) {
        return onOffCampusFlag ? "N" : "F";
    }

    protected String getSeparatedBudgetPeriod(Integer budgetPeriod) {
        return PERIOD_SEARCH_SEPARATOR + budgetPeriod + PERIOD_SEARCH_SEPARATOR;
    }

    protected void syncBudgetRatesForRateClassType(List<RateClass> rateClasses, String rateClassType, Collection abstractInstituteRates, List budgetRates) {
        List abstractBudgetRates = budgetRates;
        Map<String, AbstractInstituteRate> instRateMap = this.mapRatesToKeys(abstractInstituteRates);
        for (RateClass rateClass : rateClasses) {
            if (!rateClass.getRateClassType().equalsIgnoreCase(rateClassType)) continue;
            for (AbstractBudgetRate budgetRate : abstractBudgetRates) {
                if (!budgetRate.getRateClassCode().equalsIgnoreCase(rateClass.getRateClassCode())) continue;
                String hKey = budgetRate.getRateKeyAsString();
                InstituteRate instituteRate = (InstituteRate)instRateMap.get(hKey);
                budgetRate.setInstituteRate(instituteRate.getInstituteRate());
                budgetRate.setApplicableRate(instituteRate.getExternalApplicableRate());
            }
        }
    }

    protected Map<String, RateClassType> populateExistingRateClassTypeMap(List<RateClassType> rateClassTypes) {
        HashMap<String, RateClassType> existingRateClassTypeMap = new HashMap<String, RateClassType>();
        for (RateClassType rateClassType : rateClassTypes) {
            existingRateClassTypeMap.put(rateClassType.getRateClassType(), rateClassType);
        }
        return existingRateClassTypeMap;
    }

    protected void getBudgetRates(BudgetDocument<T> budgetDocument, Collection<InstituteRate> allInstituteRates) {
        Budget budget = budgetDocument.getBudget();
        this.getBudgetRates(budget.getRateClassTypes(), budgetDocument, allInstituteRates);
    }

    protected void getBudgetRates(List<RateClassType> rateClassTypes, BudgetDocument<T> budgetDocument, Collection<InstituteRate> allInstituteRates) {
        Budget budget = budgetDocument.getBudget();
        List<InstituteRate> instituteRates = budget.getInstituteRates();
        this.filterRates(budget, allInstituteRates, instituteRates);
        List<BudgetRate> budgetRates = budget.getBudgetRates();
        this.syncBudgetRateCollections(rateClassTypes, budgetDocument, instituteRates, budgetRates);
        this.getBudgetLaRates(rateClassTypes, budgetDocument);
        this.checkActivityPrefixForRateClassTypes(rateClassTypes, budgetDocument);
    }

    protected void getBudgetLaRates(BudgetDocument<T> budgetDocument, List<InstituteLaRate> allInstituteLaRates) {
        Budget budget = budgetDocument.getBudget();
        this.getBudgetLaRates(budget.getRateClassTypes(), budgetDocument, allInstituteLaRates);
    }

    protected void getBudgetLaRates(List<RateClassType> rateClassTypes, BudgetDocument<T> budgetDocument) {
        this.getBudgetLaRates(rateClassTypes, budgetDocument, new ArrayList<InstituteLaRate>(this.getInstituteLaRates(budgetDocument)));
    }

    protected void getBudgetLaRates(List<RateClassType> rateClassTypes, BudgetDocument<T> budgetDocument, List<InstituteLaRate> allInstituteLaRates) {
        Budget budget = budgetDocument.getBudget();
        List<InstituteLaRate> instituteLaRates = budget.getInstituteLaRates();
        this.filterRates(budget, allInstituteLaRates, instituteLaRates);
        List<BudgetLaRate> budgetRates = budget.getBudgetLaRates();
        this.syncBudgetRateCollections(rateClassTypes, budgetDocument, instituteLaRates, budgetRates);
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected void syncBudgetRateCollections(List<RateClassType> rateClassTypes, BudgetDocument<T> budgetDocument, List abstractInstituteRates, List budgetRates) {
        Budget budget = budgetDocument.getBudget();
        List abstractBudgetRates = budgetRates;
        List instituteRates = abstractInstituteRates;
        this.syncAllRateClasses(budget, instituteRates);
        this.syncAllRateClassTypes(budget, rateClassTypes, instituteRates);
        if (budgetRates.size() == 0) {
            this.syncAllBudgetRatesForInstituteRateType(budgetDocument, abstractBudgetRates, instituteRates);
        }
    }

    @Override
    public void syncBudgetRateCollectionsToExistingRates(List<RateClassType> rateClassTypes, BudgetDocument<T> budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        this.syncAllRateClasses(budget, budget.getBudgetRates());
        this.syncAllRateClassTypes(budget, rateClassTypes, budget.getBudgetRates());
        this.syncAllRateClasses(budget, budget.getBudgetLaRates());
        this.syncAllRateClassTypes(budget, rateClassTypes, budget.getBudgetLaRates());
        this.checkActivityPrefixForRateClassTypes(rateClassTypes, budgetDocument);
    }

    protected void syncAllBudgetRatesForInstituteRateType(BudgetDocument<T> budgetDocument, List<AbstractBudgetRate> budgetRates, List<AbstractInstituteRate> instituteRates) {
        for (AbstractInstituteRate abstractInstituteRate : instituteRates) {
            if (abstractInstituteRate.getRateClass() == null) continue;
            budgetRates.add(this.generateBudgetRate(budgetDocument, abstractInstituteRate));
        }
        this.updateRatesForEachPeriod(budgetDocument.getBudget());
        Collections.sort(budgetRates);
    }

    protected void replaceRateClassesForRateClassType(String rateClassType, Budget budget, List rates) {
        List instituteRates = rates;
        List<RateClass> budgetRateClasses = budget.getRateClasses();
        this.removeAllPreviouslyRegisteredRateClassesForRateClassType(rateClassType, budgetRateClasses);
        this.addRateClassesForRateClassType(rateClassType, instituteRates);
    }

    protected void removeAllPreviouslyRegisteredRateClassesForRateClassType(String rateClassType, List<RateClass> budgetRateClasses) {
        Iterator<RateClass> iter = budgetRateClasses.iterator();
        while (iter.hasNext()) {
            RateClass rateClass = iter.next();
            if (!rateClassType.equals(rateClass.getRateClassType())) continue;
            iter.remove();
        }
    }

    protected void addRateClassesForRateClassType(String rateClassType, List<AbstractInstituteRate> instituteRates) {
        HashMap<String, RateClass> mapOfMatchingRateClasses = new HashMap<String, RateClass>();
        for (AbstractInstituteRate abstractInstituteRate : instituteRates) {
            if (abstractInstituteRate.getRateType() == null) continue;
            RateClass rateClass = abstractInstituteRate.getRateType().getRateClass();
            if (rateClass == null) {
                abstractInstituteRate.getRateType().refreshNonUpdateableReferences();
            }
            if (!(rateClass = abstractInstituteRate.getRateType().getRateClass()).getRateClassType().equals(rateClassType) || mapOfMatchingRateClasses.get(rateClass.getRateClassCode()) != null) continue;
            mapOfMatchingRateClasses.put(rateClass.getRateClassCode(), rateClass);
        }
    }

    protected void replaceBudgetRatesForRateClassType(String rateClassType, BudgetDocument<T> budgetDocument, List existingBudgetRates, List rates) {
        List instituteRates = rates;
        List abstractBudgetRates = existingBudgetRates;
        Map<String, AbstractBudgetRate> existingBudgetRateMap = this.preservePersistedBudgetRatesForRateClassType(rateClassType, abstractBudgetRates);
        this.removeRegisteredBudgetRatesForRateClassType(rateClassType, abstractBudgetRates);
        Map<String, AbstractBudgetRate> newBudgetRateMap = this.generateNewAndUpdatedBudgetRates(rateClassType, budgetDocument, instituteRates, existingBudgetRateMap);
        this.registerNewAndUpdatedBudgetRates(abstractBudgetRates, newBudgetRateMap);
        this.updateRatesForEachPeriod(budgetDocument.getBudget());
        Collections.sort(abstractBudgetRates);
    }

    protected void registerNewAndUpdatedBudgetRates(List<AbstractBudgetRate> abstractBudgetRates, Map<String, AbstractBudgetRate> newBudgetRateMap) {
        abstractBudgetRates.addAll(newBudgetRateMap.values());
    }

    protected Map<String, AbstractBudgetRate> generateNewAndUpdatedBudgetRates(String rateClassType, BudgetDocument<T> budgetDocument, List<AbstractInstituteRate> instituteRates, Map<String, AbstractBudgetRate> existingBudgetRateMap) {
        HashMap<String, AbstractBudgetRate> newBudgetRateMap = new HashMap<String, AbstractBudgetRate>();
        for (AbstractInstituteRate abstractInstituteRate : instituteRates) {
            RateClass rateClass;
            if (abstractInstituteRate.getRateType() == null || !rateClassType.equals((rateClass = abstractInstituteRate.getRateType().getRateClass()).getRateClassType())) continue;
            AbstractBudgetRate newBudgetRate = this.generateBudgetRate(budgetDocument, abstractInstituteRate);
            String hKey = abstractInstituteRate.getRateKeyAsString();
            AbstractBudgetRate existingBudgetRate = existingBudgetRateMap.get(hKey);
            if (existingBudgetRate != null) {
                newBudgetRate.setVersionNumber(existingBudgetRate.getVersionNumber());
            }
            newBudgetRateMap.put(hKey, newBudgetRate);
        }
        return newBudgetRateMap;
    }

    protected void removeRegisteredBudgetRatesForRateClassType(String rateClassType, List<AbstractBudgetRate> abstractBudgetRates) {
        Iterator<AbstractBudgetRate> iter = abstractBudgetRates.iterator();
        while (iter.hasNext()) {
            AbstractBudgetRate budgetRate = iter.next();
            if (!rateClassType.equals(budgetRate.getRateClass().getRateClassType())) continue;
            iter.remove();
        }
    }

    protected Map<String, AbstractBudgetRate> preservePersistedBudgetRatesForRateClassType(String rateClassType, List<AbstractBudgetRate> abstractBudgetRates) {
        HashMap<String, AbstractBudgetRate> existingBudgetRateMap = new HashMap<String, AbstractBudgetRate>();
        for (AbstractBudgetRate abstractBudgetRate : abstractBudgetRates) {
            if (!rateClassType.equals(abstractBudgetRate.getRateClass().getRateClassType())) continue;
            existingBudgetRateMap.put(abstractBudgetRate.getRateKeyAsString(), abstractBudgetRate);
        }
        return existingBudgetRateMap;
    }

    protected void syncAllRateClasses(Budget budget, List<AbstractInstituteRate> instituteRates) {
        HashMap<String, RateClass> rateClassMap = new HashMap<String, RateClass>();
        for (AbstractInstituteRate abstractInstituteRate : instituteRates) {
            String rateClassCode;
            if (abstractInstituteRate.getRateClass() == null || rateClassMap.get(rateClassCode = abstractInstituteRate.getRateClassCode()) != null) continue;
            rateClassMap.put(rateClassCode, abstractInstituteRate.getRateClass());
        }
        budget.getRateClasses().addAll(rateClassMap.values());
    }

    protected void syncAllRateClassTypes(Budget budget, List<RateClassType> rateClassTypes, List<AbstractInstituteRate> instituteRates) {
        Map<String, RateClassType> existingRateClassTypeMap = this.populateExistingRateClassTypeMap(rateClassTypes);
        HashMap<String, RateClassType> rateClassTypeMap = new HashMap<String, RateClassType>();
        for (AbstractInstituteRate abstractInstituteRate : instituteRates) {
            String rateClassType;
            if (abstractInstituteRate.getRateClass() == null || existingRateClassTypeMap.get(rateClassType = abstractInstituteRate.getRateClass().getRateClassType()) != null) continue;
            rateClassTypeMap.put(rateClassType, abstractInstituteRate.getRateClass().getRateClassTypeT());
        }
        rateClassTypes.addAll(rateClassTypeMap.values());
    }

    protected AbstractBudgetRate generateBudgetProposalRate(BudgetDocument<T> budgetDocument, InstituteRate instituteRate) {
        T budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        return new BudgetRate(budgetParent.getUnitNumber(), instituteRate);
    }

    protected AbstractBudgetRate generateBudgetProposalLaRate(BudgetDocument<T> budgetDocument, InstituteLaRate instituteLaRate) {
        T budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        return new BudgetLaRate(budgetParent.getUnitNumber(), instituteLaRate);
    }

    protected AbstractBudgetRate generateBudgetRate(BudgetDocument<T> budgetDocument, AbstractInstituteRate abstractInstituteRate) {
        Budget budget = budgetDocument.getBudget();
        AbstractBudgetRate abstractBudgetRate = abstractInstituteRate instanceof InstituteRate ? this.generateBudgetProposalRate(budgetDocument, (InstituteRate)abstractInstituteRate) : this.generateBudgetProposalLaRate(budgetDocument, (InstituteLaRate)abstractInstituteRate);
        abstractBudgetRate.setBudgetId(budget.getBudgetId());
        abstractBudgetRate.setBudget(budget);
        return abstractBudgetRate;
    }

    @Override
    public Collection<RateClass> getBudgetRateClasses(String rateClassType) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("rateClassType", rateClassType);
        return this.getBusinessObjectService().findMatching(RateClass.class, queryMap);
    }

    @Override
    public Map<String, RateClass> getBudgetRateClassMap(String rateClassType) {
        HashMap<String, RateClass> retval = new HashMap<String, RateClass>();
        for (RateClass rateClass : this.getBudgetRateClasses(rateClassType)) {
            retval.put(rateClass.getRateClassCode(), rateClass);
        }
        return retval;
    }

    protected void populateInstituteRates(BudgetDocument<T> budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        List instituteRates = (List)this.getInstituteRates(budgetDocument);
        this.filterRates(budget, instituteRates, budget.getInstituteRates());
        List instituteLaRates = (List)this.getInstituteLaRates(budgetDocument);
        this.filterRates(budget, instituteLaRates, budget.getInstituteLaRates());
    }

    @Override
    public boolean isOutOfSyncForRateAudit(BudgetDocument<T> budgetDocument) {
        this.populateInstituteRates(budgetDocument);
        Budget budget = budgetDocument.getBudget();
        return this.isOutOfSyncForRateAudit(budget.getInstituteRates(), budget.getBudgetRates()) || this.isOutOfSyncForRateAudit(budget.getInstituteLaRates(), budget.getBudgetLaRates());
    }

    protected boolean isOutOfSyncForRateAudit(List instituteRates, List budgetRates) {
        boolean outOfSync = false;
        outOfSync = !this.isRatesMatched(instituteRates, budgetRates) || outOfSync;
        outOfSync = !this.isRatesMatched(budgetRates, instituteRates) || outOfSync;
        return outOfSync;
    }

    protected boolean isRatesMatched(List<AbstractInstituteRate> fromRates, List<AbstractInstituteRate> toRates) {
        boolean matched = true;
        Iterator<AbstractInstituteRate> i$ = fromRates.iterator();
        while (i$.hasNext()) {
            AbstractInstituteRate rate;
            AbstractInstituteRate budgetRate = rate = i$.next();
            boolean isRateMatched = false;
            for (AbstractInstituteRate rate1 : toRates) {
                AbstractInstituteRate instituteRate = rate1;
                if (!(instituteRate.getRateKeyAsString() + (Object)((Object)instituteRate.getInstituteRate())).equals(budgetRate.getRateKeyAsString() + (Object)((Object)budgetRate.getInstituteRate()))) continue;
                if (instituteRate instanceof InstituteRate) {
                    if (!((InstituteRate)instituteRate).getActivityTypeCode().equals(((BudgetRate)budgetRate).getActivityTypeCode())) continue;
                    isRateMatched = true;
                    break;
                }
                isRateMatched = true;
                break;
            }
            if (isRateMatched) continue;
            matched = false;
            String rateClassType = budgetRate.getRateClass().getRateClassTypeT().getDescription();
            String errorPath = "document.budgetProposalRate[" + rateClassType + "]";
            boolean isNewError = true;
            for (AuditError auditError : this.getAuditErrors()) {
                if (!auditError.getErrorKey().equals(errorPath) || !auditError.getMessageKey().equals("warning.rate.outofsync") || !auditError.getLink().equals("budgetRate." + rateClassType)) continue;
                isNewError = false;
                break;
            }
            if (!isNewError) continue;
            this.getAuditErrors().add(new AuditError(errorPath, "warning.rate.outofsync", "budgetRate." + rateClassType));
        }
        return matched;
    }

    protected List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(BUDGET_RATE_AUDIT_WARNING_KEY)) {
            KNSGlobalVariables.getAuditErrorMap().put(BUDGET_RATE_AUDIT_WARNING_KEY, new AuditCluster("Budget Rate", auditErrors, "Warnings"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(BUDGET_RATE_AUDIT_WARNING_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected boolean isOutOfSyncForRateAudit_org(List instituteRates, List budgetRates) {
        boolean outOfSync = this.areNumbersOfBudgetRatesOutOfSyncWithInstituteRates(instituteRates, budgetRates);
        if (!outOfSync) {
            outOfSync = this.areBudgetRatesOutOfSyncWithInsttituteRatesForRateAudit(instituteRates, budgetRates);
        }
        return outOfSync;
    }

    protected boolean areBudgetRatesOutOfSyncWithInsttituteRatesForRateAudit(List instituteRates, List budgetRates) {
        Set<String> budgetRateKeys;
        Set<String> instituteRateKeys = this.storeAllKeysWithRate(instituteRates);
        return !instituteRateKeys.containsAll(budgetRateKeys = this.storeAllKeysWithRate(budgetRates));
    }

    protected Set<String> storeAllKeysWithRate(List<AbstractInstituteRate> rates) {
        HashSet<String> keys = new HashSet<String>(rates.size(), 1.0f);
        for (AbstractInstituteRate rate : rates) {
            keys.add(rate.getRateKeyAsString() + (Object)((Object)rate.getInstituteRate()));
        }
        return keys;
    }

    @Override
    public void populateBudgetRatesForNewVersion(BudgetDocument<T> budgetDocument) {
        this.getBudgetRates(new ArrayList<RateClassType>(), budgetDocument);
    }

    @Override
    public boolean performSyncFlag(BudgetDocument<T> budgetDocument) {
        return false;
    }

    @Override
    public double getUnitFormulatedCost(String unitNumber, String formulatedTypeCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formulatedTypeCode", formulatedTypeCode);
        List unitFormulatedCosts = (List)this.getBusinessObjectService().findMatchingOrderBy(UnitFormulatedCost.class, param, UNIT_NUMBER_KEY, true);
        List<Unit> unitHierarchy = this.unitService.getUnitHierarchyForUnit(unitNumber);
        for (Unit unit : unitHierarchy) {
            for (UnitFormulatedCost unitFormulatedCost : unitFormulatedCosts) {
                if (!unit.getUnitNumber().equals(unitFormulatedCost.getUnitNumber())) continue;
                return unitFormulatedCost.getUnitCost().doubleValue();
            }
        }
        return 0.0;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }
}

