/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rates;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.AbstractInstituteRate;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.rates.InstituteRateRateTypeRateClassRule;
import org.kuali.kra.budget.rates.InstituteRateRateTypeRateClassRuleImpl;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstituteRateMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private final InstituteRateRateTypeRateClassRule rule;

    public InstituteRateMaintenanceDocumentRule() {
        this(new InstituteRateRateTypeRateClassRuleImpl());
    }

    InstituteRateMaintenanceDocumentRule(InstituteRateRateTypeRateClassRule rule) {
        if (rule == null) {
            throw new NullPointerException("the rule is null");
        }
        this.rule = rule;
    }

    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        this.logDocInfo(document);
        boolean valid = this.rule.validateRateTypeAndRateClass((AbstractInstituteRate)document.getDocumentDataObject());
        return valid &= this.checkExistence((AbstractInstituteRate)document.getNewMaintainableObject().getDataObject());
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        this.logDocInfo(document);
        boolean valid = this.rule.validateRateTypeAndRateClass((AbstractInstituteRate)document.getDocumentDataObject());
        return valid &= this.checkExistence((AbstractInstituteRate)document.getNewMaintainableObject().getDataObject());
    }

    private boolean checkExistence(AbstractInstituteRate newInstituteRate) {
        HashMap<String, String> pkMap;
        boolean valid = true;
        if (StringUtils.isNotBlank((String)newInstituteRate.getRateClassCode()) && StringUtils.isNotBlank((String)newInstituteRate.getRateTypeCode())) {
            pkMap = new HashMap();
            pkMap.put("rateClassCode", newInstituteRate.getRateClassCode());
            pkMap.put("rateTypeCode", newInstituteRate.getRateTypeCode());
            RateType rateType = (RateType)KraServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{newInstituteRate.getRateClassCode(), newInstituteRate.getRateTypeCode()});
                valid = false;
            }
        }
        pkMap = new HashMap<String, String>();
        pkMap.put("unitNumber", newInstituteRate.getUnitNumber());
        valid &= this.checkExistenceFromTable(Unit.class, pkMap, "unitNumber", "Unit Number");
        if (newInstituteRate instanceof InstituteRate) {
            HashMap<String, String> pkMap1 = new HashMap<String, String>();
            pkMap1.put("activityTypeCode", ((InstituteRate)newInstituteRate).getActivityTypeCode());
            valid &= this.checkExistenceFromTable(ActivityType.class, pkMap1, "activityTypeCode", "Activity Type");
        }
        return valid;
    }

    private void logDocInfo(MaintenanceDocument maintenanceDocument) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
    }
}

