/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.service.impl;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.service.BudgetLockService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.impl.PessimisticLockServiceImpl;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetLockServiceImpl
extends PessimisticLockServiceImpl
implements BudgetLockService {
    private static final String FALSE = "FALSE";
    private static final String ADD_BUDGET = "addBudget";

    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry) || !StringUtils.isNotEmpty((String)activeLockRegion)) continue;
            return true;
        }
        return false;
    }

    public Map establishLocks(Document document, Map editMode, Person user) {
        BudgetDocument budgetDoc;
        if (document instanceof BudgetDocument && (budgetDoc = (BudgetDocument)document).getParentDocument() instanceof ProposalDevelopmentDocument) {
            for (PessimisticLock lock : budgetDoc.getParentDocument().getPessimisticLocks()) {
                if (lock.isOwnedByUser(user) || !StringUtils.equals((String)budgetDoc.getCustomLockDescriptor(user), (String)lock.getLockDescriptor())) continue;
                return this.getEditModeWithEditableModesRemoved(editMode);
            }
        }
        return super.establishLocks(document, editMode, user);
    }

    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey()) || "modifyBudgets".equals(entry.getKey()) || ADD_BUDGET.equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return StringUtils.equalsIgnoreCase((String)"true", (String)fullEntryEditModeValue);
        }
        return false;
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document instanceof BudgetDocument) {
            BudgetDocument budgetDocument = (BudgetDocument)document;
            if (document.useCustomLockDescriptors()) {
                String lockDescriptor = document.getCustomLockDescriptor(user);
                this.establishLocks((Document)budgetDocument.getParentDocument(), editMode, user);
                return this.generateNewLock(document.getDocumentNumber(), lockDescriptor, user);
            }
            return this.generateNewLock(document.getDocumentNumber(), user);
        }
        return super.createNewPessimisticLock(document, editMode, user);
    }

    public boolean hasPreRouteEditAuthorization(Document document, Person user) {
        BudgetDocument budgetDocument = (BudgetDocument)document;
        for (PessimisticLock lock : budgetDocument.getParentDocument().getPessimisticLocks()) {
            if (!lock.getLockDescriptor().endsWith("BUDGET") || !lock.isOwnedByUser(user)) continue;
            return true;
        }
        return false;
    }
}

