/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.versions;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.service.DocumentService;

public class BudgetDocumentVersion
extends KraPersistableBusinessObjectBase
implements Comparable<BudgetDocumentVersion> {
    private static final String BUDGET_COMPLETE = "1";
    private static final long serialVersionUID = -2143813153034264031L;
    private String parentDocumentKey;
    private String parentDocumentTypeCode;
    private List<BudgetVersionOverview> budgetVersionOverviews = new ArrayList<BudgetVersionOverview>();
    private String documentNumber;
    private DocumentHeader documentHeader;

    public List<BudgetVersionOverview> getBudgetVersionOverviews() {
        return this.budgetVersionOverviews;
    }

    public void setBudgetVersionOverviews(List<BudgetVersionOverview> budgets) {
        this.budgetVersionOverviews = budgets;
    }

    public BudgetVersionOverview getBudgetVersionOverview() {
        if (this.budgetVersionOverviews.isEmpty()) {
            this.budgetVersionOverviews.add(new BudgetVersionOverview());
        }
        return this.budgetVersionOverviews.get(0);
    }

    public String getParentDocumentKey() {
        return this.parentDocumentKey;
    }

    public void setParentDocumentKey(String parentDocumentNumber) {
        this.parentDocumentKey = parentDocumentNumber;
    }

    public Budget getFinalBudget() {
        for (BudgetVersionOverview budgetVersionOverview : this.getBudgetVersionOverviews()) {
            Budget result;
            if (budgetVersionOverview == null || budgetVersionOverview.getBudgetStatus() == null || !budgetVersionOverview.getBudgetStatus().equals(BUDGET_COMPLETE) || !budgetVersionOverview.isFinalVersionFlag() || (result = this.findBudget()) == null) continue;
            return result;
        }
        return null;
    }

    public boolean isBudgetComplete() {
        if (!this.getBudgetVersionOverviews().isEmpty()) {
            return BUDGET_COMPLETE.equals(this.getBudgetVersionOverview().getBudgetStatus());
        }
        return false;
    }

    public Budget findBudget() {
        DocumentService docService = KraServiceLocator.getService(DocumentService.class);
        try {
            BudgetDocument budgetDoc = (BudgetDocument)docService.getByDocumentHeaderId(this.getDocumentNumber());
            return budgetDoc.getBudget();
        }
        catch (WorkflowException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int compareTo(BudgetDocumentVersion otherVersion) {
        return this.getBudgetVersionOverview().getBudgetVersionNumber().compareTo(otherVersion.getBudgetVersionOverview().getBudgetVersionNumber());
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public DocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public String getParentDocumentTypeCode() {
        return this.parentDocumentTypeCode;
    }

    public void setParentDocumentTypeCode(String parentDocumentTypeCode) {
        this.parentDocumentTypeCode = parentDocumentTypeCode;
    }
}

