/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.budget.AwardBudgetForm;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.AddBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.parameters.GenerateBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.SaveBudgetPeriodEvent;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.action.BudgetTDCValidator;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class BudgetParametersAction
extends BudgetAction {
    private static final Log LOG = LogFactory.getLog(BudgetParametersAction.class);
    private static final String CONFIRM_RECALCULATE_BUDGET_KEY = "calculateAllPeriods";
    private static final String CONFIRM_SAVE_BUDGET_KEY = "saveAfterQuestion";
    private static final String CONFIRM_GENERATE_ALL_PERIODS = "confirmGenerateAllPeriods";
    private static final String CONFIRM_HEADER_TAB_KEY = "headerTabAfterQuestion";
    private static final String DO_NOTHING = "doNothing";
    private static final String CONFIRM_SAVE_SUMMARY = "confirmSaveSummary";
    private static final String CONFIRM_DELETE_BUDGET_PERIOD = "confirmDeleteBudgetPeriod";
    private static final String CONFIRM_DEFAULT_BUDGET_PERIODS = "confirmDefaultBudgetPeriods";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        this.updateTotalCost(budget);
        this.getBudgetSummaryService().setupOldStartEndDate(budget, false);
        if (StringUtils.isNotBlank((String)budgetForm.getSyncBudgetRate()) && budgetForm.getSyncBudgetRate().equals("Y")) {
            budget.setRateClassTypesReloaded(true);
            this.getBudgetRatesService().syncAllBudgetRates(budgetDocument);
            budget.setRateSynced(true);
            budgetForm.setSyncBudgetRate("");
            this.getBudgetSummaryService().calculateBudget(budget);
        }
        return forward;
    }

    private BudgetRatesService getBudgetRatesService() {
        return KraServiceLocator.getService(BudgetRatesService.class);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new SaveBudgetPeriodEvent("", budgetForm.getBudgetDocument()));
        if (this.isRateTypeChanged(budgetForm)) {
            if (this.isBudgetPeriodDateChanged(budget) && this.isLineItemErrorOnly()) {
                GlobalVariables.setMessageMap((MessageMap)new MessageMap());
                return this.confirm(this.buildSaveBudgetSummaryConfirmationQuestion(mapping, form, request, response, "document.question.saveBudgetSummary.forRateAndDateChange.text"), CONFIRM_SAVE_SUMMARY, DO_NOTHING);
            }
            return this.confirm(this.buildRecalculateBudgetConfirmationQuestion(mapping, form, request, response), CONFIRM_SAVE_BUDGET_KEY, DO_NOTHING);
        }
        this.updateThisBudgetVersion(budgetDocument);
        if (budgetForm.isUpdateFinalVersion()) {
            this.reconcileFinalBudgetFlags(budgetForm);
            this.setBudgetStatuses(budgetDocument.getParentDocument());
        }
        if (this.isBudgetPeriodDateChanged(budget) && this.isLineItemErrorOnly()) {
            GlobalVariables.setMessageMap((MessageMap)new MessageMap());
            return this.confirm(this.buildSaveBudgetSummaryConfirmationQuestion(mapping, form, request, response, "document.question.saveBudgetSummary.text"), CONFIRM_SAVE_SUMMARY, "");
        }
        if (rulePassed) {
            if (StringUtils.isBlank((String)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KraServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            boolean valid = true;
            if (Boolean.valueOf(budgetDocument.getProposalBudgetFlag()).booleanValue()) {
                valid = this.isValidToComplete(budgetDocument.getParentDocument());
                int errorSize = GlobalVariables.getMessageMap().getErrorMessages().size();
                BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
                tdcValidator.validateGeneratingErrorsAndWarnings(budgetDocument.getParentDocument());
                if (GlobalVariables.getMessageMap().getErrorMessages().size() > errorSize) {
                    valid = false;
                }
            }
            if (budget.getFinalVersionFlag().booleanValue() && valid) {
                budgetDocument.getParentDocument().getBudgetParent().setBudgetStatus(budget.getBudgetStatus());
            }
            if (valid) {
                this.updateBudgetPeriodDbVersion(budget);
                return super.save(mapping, form, request, response);
            }
            String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
            budget.setBudgetStatus(budgetStatusIncompleteCode);
            if (form instanceof AwardBudgetForm) {
                new AuditActionHelper().setAuditMode(mapping, (AwardBudgetForm)form, true);
            } else {
                new AuditActionHelper().setAuditMode(mapping, (BudgetForm)form, true);
            }
            return mapping.findForward("budgetActions");
        }
        return mapping.findForward("basic");
    }

    private boolean isValidToComplete(BudgetParentDocument document) throws Exception {
        boolean valid = KraServiceLocator.getService(BudgetService.class).validateBudgetAuditRuleBeforeSaveBudgetVersion(document);
        if (!valid) {
            GlobalVariables.getMessageMap().putError("document.budgetDocumentVersion[0].budgetVersionOverview.budgetStatus", "clear.audit.error.before.change.status.to.complete", new String[0]);
        }
        return valid;
    }

    private boolean isRateTypeChanged(BudgetForm budgetForm) {
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetDocument originalBudgetDocument = (BudgetDocument)KraServiceLocator.getService(BusinessObjectService.class).retrieve((PersistableBusinessObject)budgetDocument);
        Budget originalBudget = originalBudgetDocument.getBudget();
        return !StringUtils.equalsIgnoreCase((String)originalBudget.getOhRateClassCode(), (String)budget.getOhRateClassCode()) || !StringUtils.equalsIgnoreCase((String)originalBudget.getUrRateClassCode(), (String)budget.getUrRateClassCode());
    }

    public ActionForward saveAfterQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean rulePassed;
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetDocument originalBudgetDocument = (BudgetDocument)KraServiceLocator.getService(BusinessObjectService.class).retrieve((PersistableBusinessObject)budgetDocument);
        budgetForm.setOhRateClassCodePrevValue(originalBudgetDocument.getBudget().getOhRateClassCode());
        budgetForm.setUrRateClassCodePrevValue(originalBudgetDocument.getBudget().getUrRateClassCode());
        this.updateThisBudgetVersion(budgetDocument);
        if (budgetForm.isUpdateFinalVersion()) {
            this.reconcileFinalBudgetFlags(budgetForm);
            this.setBudgetStatuses(budgetDocument.getParentDocument());
        }
        if (rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new SaveBudgetPeriodEvent("", budgetDocument))) {
            if (StringUtils.isBlank((String)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KraServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            if (budget.getFinalVersionFlag().booleanValue()) {
                budgetDocument.getParentDocument().getBudgetParent().setBudgetStatus(budget.getBudgetStatus());
            }
            this.updateBudgetPeriodDbVersion(budget);
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmSaveSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        if (this.isRateTypeChanged(budgetForm)) {
            BudgetDocument originalBudgetDocument = (BudgetDocument)KraServiceLocator.getService(BusinessObjectService.class).retrieve((PersistableBusinessObject)budgetDocument);
            budgetForm.setOhRateClassCodePrevValue(originalBudgetDocument.getBudget().getOhRateClassCode());
            budgetForm.setUrRateClassCodePrevValue(originalBudgetDocument.getBudget().getUrRateClassCode());
        }
        this.updateThisBudgetVersion(budgetDocument);
        if (budgetForm.isUpdateFinalVersion()) {
            this.reconcileFinalBudgetFlags(budgetForm);
            this.setBudgetStatuses(budgetDocument.getParentDocument());
        }
        this.getBudgetSummaryService().adjustStartEndDatesForLineItems(budget);
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new SaveBudgetPeriodEvent("", budgetForm.getBudgetDocument()));
        if (rulePassed) {
            if (StringUtils.isBlank((String)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KraServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            if (budget.getFinalVersionFlag().booleanValue()) {
                budgetDocument.getParentDocument().getBudgetParent().setBudgetStatus(budget.getBudgetStatus());
            }
            this.updateBudgetPeriodDbVersion(budget);
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetPeriod newBudgetPeriod = budgetForm.getNewBudgetPeriod();
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddBudgetPeriodEvent("", budgetForm.getBudgetDocument(), newBudgetPeriod))) {
            this.getBudgetSummaryService().addBudgetPeriod(budget, newBudgetPeriod);
            budgetForm.setNewBudgetPeriod(budget.getNewBudgetPeriod());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int delPeriod = this.getLineToDelete(request);
        int viewPeriod = 0;
        if (budgetForm.getViewBudgetPeriod() != null) {
            viewPeriod = budgetForm.getViewBudgetPeriod();
        }
        List<BudgetLineItem> budgetLineItems = budget.getBudgetPeriods().get(delPeriod).getBudgetLineItems();
        if (viewPeriod > 0 && (delPeriod + 1 == viewPeriod || budget.getBudgetPeriods().size() == viewPeriod)) {
            budgetForm.setViewBudgetPeriod(1);
        }
        if (budgetLineItems != null && budgetLineItems.size() > 0) {
            return this.confirm(this.buildDeleteBudgetPeriodConfirmationQuestion(mapping, form, request, response, delPeriod + 1), CONFIRM_DELETE_BUDGET_PERIOD, "");
        }
        this.getBudgetSummaryService().deleteBudgetPeriod(budget, delPeriod);
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int delPeriod = this.getLineToDelete(request);
        this.getBudgetSummaryService().deleteBudgetPeriod(budget, delPeriod);
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward recalculateBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward generateAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        BudgetForm budgetForm = (BudgetForm)form;
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new GenerateBudgetPeriodEvent("", budgetForm.getBudgetDocument()));
        if (rulePassed) {
            if (this.isRateTypeChanged(budgetForm)) {
                return this.confirm(this.buildRecalculateBudgetConfirmationQuestion(mapping, form, request, response), CONFIRM_GENERATE_ALL_PERIODS, DO_NOTHING);
            }
            return this.confirmGenerateAllPeriods(mapping, form, request, response);
        }
        return forward;
    }

    public ActionForward confirmGenerateAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        if (StringUtils.isBlank((String)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
            KraServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
        }
        this.getBudgetSummaryService().calculateBudget(budget);
        this.getBudgetSummaryService().generateAllPeriods(budget);
        this.getBudgetSummaryService().calculateBudget(budget);
        this.getBudgetSummaryService().setupOldStartEndDate(budget, true);
        return mapping.findForward("basic");
    }

    public ActionForward questionCalculateAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        if (!StringUtils.equalsIgnoreCase((String)budget.getOhRateClassCode(), (String)budgetForm.getOhRateClassCodePrevValue()) || !StringUtils.equalsIgnoreCase((String)budget.getUrRateClassCode(), (String)budgetForm.getUrRateClassCodePrevValue())) {
            return this.confirm(this.buildRecalculateBudgetConfirmationQuestion(mapping, form, request, response), CONFIRM_RECALCULATE_BUDGET_KEY, DO_NOTHING);
        }
        if (StringUtils.isBlank((String)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
            KraServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
        }
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward calculateAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        String question = request.getParameter("questionIndex");
        if (CONFIRM_RECALCULATE_BUDGET_KEY.equals(question)) {
            if (StringUtils.isBlank((String)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KraServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            this.getBudgetSummaryService().calculateBudget(budget);
        }
        return mapping.findForward("basic");
    }

    public ActionForward doNothing(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        budget.setOhRateClassCode(budgetForm.getOhRateClassCodePrevValue());
        budget.setUrRateClassCode(budgetForm.getUrRateClassCodePrevValue());
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildRecalculateBudgetConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RECALCULATE_BUDGET_KEY, "document.question.recalculateBudget.text", new String[0]);
    }

    protected KualiRuleService getKualiRuleService() {
        return KraServiceLocator.getService(KualiRuleService.class);
    }

    private void reconcileFinalBudgetFlags(BudgetForm budgetForm) {
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        if (budget.getFinalVersionFlag().booleanValue()) {
            for (BudgetDocumentVersion documentVersion : parentDocument.getBudgetDocumentVersions()) {
                BudgetVersionOverview version = documentVersion.getBudgetVersionOverview();
                if (budget.getBudgetVersionNumber().equals(version.getBudgetVersionNumber())) continue;
                version.setFinalVersionFlag(false);
            }
        } else {
            budgetForm.setFinalBudgetVersion(null);
        }
    }

    private void updateBudgetPeriodDbVersion(Budget budget) {
        HashMap<String, Long> budgetPeriodMap = new HashMap<String, Long>();
        budgetPeriodMap.put("budgetId", budget.getBudgetId());
        Collection existBudgetPeriods = KraServiceLocator.getService(BusinessObjectService.class).findMatching(BudgetPeriod.class, budgetPeriodMap);
        for (BudgetPeriod budgetPeriod : existBudgetPeriods) {
            for (BudgetPeriod newBudgetPeriod : budget.getBudgetPeriods()) {
                if (!budgetPeriod.getBudgetPeriodId().equals(newBudgetPeriod.getBudgetPeriodId())) continue;
                newBudgetPeriod.setVersionNumber(budgetPeriod.getVersionNumber());
            }
        }
    }

    private void updateTotalCost(Budget budget) {
        BudgetDecimal totalDirectCost = BudgetDecimal.ZERO;
        BudgetDecimal totalIndirectCost = BudgetDecimal.ZERO;
        BudgetDecimal totalCost = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getTotalDirectCost().isGreaterThan(BudgetDecimal.ZERO) || budgetPeriod.getTotalIndirectCost().isGreaterThan(BudgetDecimal.ZERO)) {
                budgetPeriod.setTotalCost((BudgetDecimal)budgetPeriod.getTotalDirectCost().add(budgetPeriod.getTotalIndirectCost()));
            }
            totalDirectCost = (BudgetDecimal)totalDirectCost.add(budgetPeriod.getTotalDirectCost());
            totalIndirectCost = (BudgetDecimal)totalIndirectCost.add(budgetPeriod.getTotalIndirectCost());
            totalCost = (BudgetDecimal)totalCost.add(budgetPeriod.getTotalCost());
        }
        budget.setTotalDirectCost(totalDirectCost);
        budget.setTotalIndirectCost(totalIndirectCost);
        budget.setTotalCost(totalCost);
    }

    private void updateThisBudgetVersion(BudgetDocument budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        BudgetParentDocument proposal = budgetDocument.getParentDocument();
        for (BudgetDocumentVersion documentVersion : proposal.getBudgetDocumentVersions()) {
            BudgetVersionOverview version = documentVersion.getBudgetVersionOverview();
            if (!budget.getBudgetVersionNumber().equals(version.getBudgetVersionNumber())) continue;
            version.setFinalVersionFlag(budget.getFinalVersionFlag());
            version.setBudgetStatus(budget.getBudgetStatus());
            version.setModularBudgetFlag(budget.getModularBudgetFlag());
        }
    }

    @Override
    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        if (!StringUtils.equalsIgnoreCase((String)budget.getOhRateClassCode(), (String)budgetForm.getOhRateClassCodePrevValue()) || !StringUtils.equalsIgnoreCase((String)budget.getUrRateClassCode(), (String)budgetForm.getUrRateClassCodePrevValue())) {
            return this.confirm(this.buildRecalculateBudgetConfirmationQuestion(mapping, form, request, response), CONFIRM_HEADER_TAB_KEY, DO_NOTHING);
        }
        return super.headerTab(mapping, form, request, response);
    }

    public ActionForward headerTabAfterQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.headerTab(mapping, form, request, response);
    }

    private boolean isBudgetPeriodDateChanged(Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getStartDate() == null || budgetPeriod.getOldStartDate() == null || budgetPeriod.getEndDate() == null || budgetPeriod.getOldEndDate() == null || budgetPeriod.getStartDate().compareTo(budgetPeriod.getOldStartDate()) == 0 && budgetPeriod.getEndDate().compareTo(budgetPeriod.getOldEndDate()) == 0) continue;
            return true;
        }
        return false;
    }

    private StrutsConfirmation buildSaveBudgetSummaryConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SAVE_SUMMARY, message, "");
    }

    private StrutsConfirmation buildDeleteBudgetPeriodConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int deletePeriod) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_HEADER_TAB_KEY, "document.question.deleteBudgetPeriod.text", Integer.toString(deletePeriod));
    }

    private boolean isLineItemErrorOnly() {
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            Map errors = GlobalVariables.getMessageMap().getErrorMessages();
            for (Map.Entry entry : errors.entrySet()) {
                for (ErrorMessage em : (AutoPopulatingList)entry.getValue()) {
                    if (em.getErrorKey().equals("error.lineItem.dateDoesNotmatch")) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public ActionForward defaultPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        String warningMessage = this.getBudgetSummaryService().defaultWarningMessage(budget);
        if (StringUtils.isNotBlank((String)warningMessage)) {
            return this.confirm(this.buildDefaultBudgetPeriodsConfirmationQuestion(mapping, form, request, response, warningMessage), CONFIRM_DEFAULT_BUDGET_PERIODS, "");
        }
        this.getBudgetSummaryService().defaultBudgetPeriods(budget);
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDefaultBudgetPeriodsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_HEADER_TAB_KEY, "document.question.defaultBudgetPeriods.text", message);
    }

    public ActionForward confirmDefaultBudgetPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        this.getBudgetSummaryService().defaultBudgetPeriods(budget);
        this.getBudgetSummaryService().adjustStartEndDatesForLineItems(budget);
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        if (budgetForm.getLookupResultsBOClassName() != null && budgetForm.getLookupResultsSequenceNumber() != null) {
            String lookupResultsSequenceNumber = budgetForm.getLookupResultsSequenceNumber();
            Class<BudgetPeriod> lookupResultsBOClass = Class.forName(budgetForm.getLookupResultsBOClassName());
            Collection rawValues = KraServiceLocator.getService(LookupResultsService.class).retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPerson().getPrincipalId());
            if (lookupResultsBOClass.isAssignableFrom(BudgetPeriod.class)) {
                String budgetPeriod = budgetForm.getLookedUpCollectionName();
                this.getAwardBudgetService().copyLineItemsFromProposalPeriods(rawValues, budgetForm.getBudgetDocument().getBudget().getBudgetPeriod(Integer.parseInt(budgetPeriod)));
            }
        }
        return super.refresh(mapping, form, request, response);
    }

    private AwardBudgetService getAwardBudgetService() {
        return KraServiceLocator.getService(AwardBudgetService.class);
    }
}

