/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategory;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetExpenseRule;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonSalaryDetails;
import org.kuali.kra.budget.personnel.BudgetPersonService;
import org.kuali.kra.budget.personnel.BudgetPersonnelBudgetService;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelExpenseRule;
import org.kuali.kra.budget.personnel.BudgetPersonnelRule;
import org.kuali.kra.budget.personnel.TbnPerson;
import org.kuali.kra.budget.web.struts.action.BudgetExpensesAction;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetPersonnelAction
extends BudgetExpensesAction {
    private static final Log LOG = LogFactory.getLog(BudgetPersonnelAction.class);
    private static final String CONFIRM_DELETE_BUDGET_PERSON = "confirmDeleteBudgetPerson";
    private static final String EMPTY_GROUP_NAME = "";
    private static final String DEFAULT_GROUP_NAME = "(new group)";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        if (budget.getBudgetCategoryTypeCodes() == null || budget.getBudgetCategoryTypeCodes().size() == 0) {
            this.populatePersonnelCategoryTypeCodes(budgetForm);
        }
        ActionForward forward = super.execute(mapping, form, request, response);
        return forward;
    }

    public ActionForward closePopUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        budgetForm.setViewDivFlag(false);
        return mapping.findForward("personnel");
    }

    private BudgetPeriod getSelectedBudgetPeriod(BudgetForm budgetForm) {
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        primaryKeys.put("budgetId", budget.getBudgetId());
        primaryKeys.put("budgetPeriod", budgetForm.getViewBudgetPeriod().toString());
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        List budgetPeriods = (List)businessObjectService.findMatching(BudgetPeriod.class, primaryKeys);
        BudgetPeriod budgetPeriod = null;
        if (CollectionUtils.isNotEmpty((Collection)budgetPeriods)) {
            budgetPeriod = (BudgetPeriod)budgetPeriods.get(0);
        }
        return budgetPeriod;
    }

    public ActionForward addPersonnelLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        DictionaryValidationService dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        BudgetPersonnelRule budgetPersonnelRule = new BudgetPersonnelRule();
        Integer budgetCategoryTypeIndex = Integer.parseInt(this.getBudgetCategoryTypeIndex(request));
        BudgetLineItem newBudgetLineItem = budgetForm.getNewBudgetLineItems().get(budgetCategoryTypeIndex);
        BudgetPersonnelDetails budgetPersonDetails = budgetForm.getNewBudgetPersonnelDetails();
        budgetPersonDetails.setBudgetId(budget.getBudgetId());
        budgetPersonDetails.setPeriodTypeCode(this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetPersonDetailsDefaultPeriodType"));
        budgetPersonDetails.setCostElement(newBudgetLineItem.getCostElement());
        String groupErrorKey = EMPTY_GROUP_NAME;
        if (StringUtils.isNotEmpty((String)newBudgetLineItem.getGroupName())) {
            groupErrorKey = "newBudgetLineItems[" + budgetCategoryTypeIndex + "].costElement";
        }
        if (StringUtils.isEmpty((String)newBudgetLineItem.getGroupName())) {
            newBudgetLineItem.setGroupName(budgetForm.getNewGroupName());
            groupErrorKey = "newGroupName";
        }
        if (StringUtils.isEmpty((String)newBudgetLineItem.getGroupName()) || StringUtils.equals((String)newBudgetLineItem.getGroupName(), (String)DEFAULT_GROUP_NAME)) {
            newBudgetLineItem.setGroupName(EMPTY_GROUP_NAME);
        }
        dictionaryValidationService.validateAttributeFormat(BudgetLineItem.class.getSimpleName(), "groupName", newBudgetLineItem.getGroupName(), groupErrorKey);
        if (budgetForm.getViewBudgetPeriod() == null || StringUtils.equalsIgnoreCase((String)budgetForm.getViewBudgetPeriod().toString(), (String)"0")) {
            GlobalVariables.getMessageMap().putError("viewBudgetPeriod", "error.viewBudgetPeriod.notSelected", new String[0]);
        } else if (newBudgetLineItem.getCostElement() == null || StringUtils.equalsIgnoreCase((String)newBudgetLineItem.getCostElement(), (String)EMPTY_GROUP_NAME)) {
            GlobalVariables.getMessageMap().putError("newBudgetLineItems[" + budgetCategoryTypeIndex + "].costElement", "error.costElement.notSelected", new String[0]);
        } else if (budgetPersonDetails.getPersonSequenceNumber() == null) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.personSequenceNumber", "error.budgetPersonnel.notSelected", new String[0]);
        } else if (!budgetPersonnelRule.processCheckJobCodeObjectCodeCombo(budgetDocument, budgetPersonDetails, false)) {
            GlobalVariables.getMessageMap().putError("newBudgetLineItems[" + budgetCategoryTypeIndex + "].costElement", "error.jobCode.costElement.invalid", new String[0]);
        } else {
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("budgetId", budget.getBudgetId());
            primaryKeys.put("budgetPeriod", budgetForm.getViewBudgetPeriod().toString());
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            List budgetPeriods = (List)businessObjectService.findMatching(BudgetPeriod.class, primaryKeys);
            BudgetPeriod budgetPeriod = null;
            if (CollectionUtils.isNotEmpty((Collection)budgetPeriods)) {
                budgetPeriod = (BudgetPeriod)budgetPeriods.get(0);
            }
            BudgetCategory newBudgetCategory = new BudgetCategory();
            newBudgetCategory.setBudgetCategoryTypeCode(this.getSelectedBudgetCategoryType(request));
            newBudgetCategory.refreshNonUpdateableReferences();
            boolean existingCeGroupCombo = false;
            int openTabLineItemIndex = -1;
            ArrayList<BudgetLineItem> existingPersonnelLineItems = new ArrayList<BudgetLineItem>();
            List<BudgetLineItem> existingLineItems = budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getBudgetLineItems();
            if (GlobalVariables.getMessageMap().hasNoErrors()) {
                for (BudgetLineItem budgetLineItem : existingLineItems) {
                    budgetLineItem.refreshNonUpdateableReferences();
                    if (!budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(newBudgetCategory.getBudgetCategoryTypeCode())) continue;
                    existingPersonnelLineItems.add(budgetLineItem);
                    if (!newBudgetLineItem.getCostElement().equalsIgnoreCase(budgetLineItem.getCostElement()) || !StringUtils.equals((String)newBudgetLineItem.getGroupName(), (String)budgetLineItem.getGroupName()) && (!StringUtils.isEmpty((String)newBudgetLineItem.getGroupName()) || !StringUtils.isEmpty((String)budgetLineItem.getGroupName()))) continue;
                    if (budgetPersonDetails.getPersonSequenceNumber() != -1) {
                        BudgetPersonnelExpenseRule budgetPersonnelExpenseRule = new BudgetPersonnelExpenseRule();
                        if (budgetPersonnelExpenseRule.processCheckPersonAddBusinessRules(budgetLineItem)) {
                            this.addBudgetPersonnelDetails(budgetForm, budgetPeriod, budgetLineItem, budgetPersonDetails);
                        }
                    } else if (!new BudgetPersonnelExpenseRule().processCheckSummaryAddBusinessRules(budgetLineItem)) {
                        existingCeGroupCombo = true;
                        break;
                    }
                    openTabLineItemIndex = budgetLineItem.getLineItemNumber();
                    this.setLineItemQuantity(budgetLineItem);
                    existingCeGroupCombo = true;
                    break;
                }
                if (!existingCeGroupCombo) {
                    newBudgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                    newBudgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
                    newBudgetLineItem.setBudgetCategory(newBudgetCategory);
                    newBudgetLineItem.setStartDate(budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getStartDate());
                    newBudgetLineItem.setEndDate(budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getEndDate());
                    newBudgetLineItem.setStartDate(newBudgetLineItem.getStartDate());
                    newBudgetLineItem.setEndDate(newBudgetLineItem.getEndDate());
                    newBudgetLineItem.setBudgetId(budget.getBudgetId());
                    newBudgetLineItem.setLineItemNumber(budgetForm.getBudgetDocument().getHackedDocumentNextValue("budget.budgetLineItem.lineItemNumber"));
                    newBudgetLineItem.setApplyInRateFlag(true);
                    newBudgetLineItem.refreshReferenceObject("costElementBO");
                    String onOffCampusFlag = budget.getOnOffCampusFlag();
                    if (onOffCampusFlag.equalsIgnoreCase("D")) {
                        newBudgetLineItem.setOnOffCampusFlag(newBudgetLineItem.getCostElementBO().getOnOffCampusFlag());
                    } else {
                        newBudgetLineItem.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
                    }
                    newBudgetLineItem.setBudgetCategoryCode(newBudgetLineItem.getCostElementBO().getBudgetCategoryCode());
                    newBudgetLineItem.setLineItemSequence(newBudgetLineItem.getLineItemNumber());
                    if (budgetPersonDetails.getPersonSequenceNumber() != -1) {
                        this.addBudgetPersonnelDetails(budgetForm, budgetPeriod, newBudgetLineItem, budgetPersonDetails);
                    }
                    this.setLineItemQuantity(newBudgetLineItem);
                    budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getBudgetLineItems().add(newBudgetLineItem);
                    this.recalculateBudgetPeriod(budgetForm, budget, budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1));
                    this.getCalculationService().populateCalculatedAmount(budget, newBudgetLineItem);
                    openTabLineItemIndex = newBudgetLineItem.getLineItemNumber();
                }
                BudgetLineItem newLineItemToAdd = budget.getNewBudgetLineItem();
                budgetForm.getNewBudgetLineItems().set(budgetCategoryTypeIndex, newLineItemToAdd);
                request.setAttribute("openTabLineItemIndex", (Object)openTabLineItemIndex);
                budgetForm.setNewBudgetPersonnelDetails(newLineItemToAdd.getNewBudgetPersonnelLineItem());
            }
        }
        return mapping.findForward("basic");
    }

    private void setLineItemQuantity(BudgetLineItem personnelLineItem) {
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : personnelLineItem.getBudgetPersonnelDetailsList()) {
            if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
            uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
            ++qty;
        }
        personnelLineItem.setQuantity(new Integer(qty));
    }

    private void addBudgetPersonnelDetails(BudgetForm budgetForm, BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetails) throws Exception {
        boolean errorFound = false;
        if (budgetForm.getNewBudgetPersonnelDetails().getPersonSequenceNumber() == null) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.personSequenceNumber", "error.required", new String[]{"Person (Person)"});
            errorFound = true;
        }
        if (!errorFound) {
            BudgetPersonnelBudgetService budgetPersonnelBudgetService = KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
            budgetPersonnelBudgetService.addBudgetPersonnelDetails(budgetForm.getBudgetDocument(), budgetPeriod, newBudgetLineItem, newBudgetPersonnelDetails);
            this.updatePersonnelBudgetRate(newBudgetLineItem);
            budgetForm.setNewBudgetPersonnelDetails(newBudgetLineItem.getNewBudgetPersonnelLineItem());
        }
    }

    public ActionForward deleteBudgetPersonnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = this.getSelectedLine(request);
        BudgetPersonnelBudgetService budgetPersonnelBudgetService = KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
        budgetPersonnelBudgetService.deleteBudgetPersonnelDetails(budget, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, this.getSelectedPersonnel(request));
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).getBudgetPersonnelDetailsList()) {
            if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
            uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
            ++qty;
        }
        budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).setQuantity(new Integer(qty));
        if (qty == 0) {
            budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItems().remove(selectedBudgetLineItemIndex);
        }
        this.recalculateBudgetPeriod(budgetForm, budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
        return mapping.findForward("basic");
    }

    protected int getSelectedPersonnel(HttpServletRequest request) {
        int selectedPersonnel = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String personnelIndex = StringUtils.substringBetween((String)parameterName, (String)".personnel", (String)".");
            selectedPersonnel = Integer.parseInt(personnelIndex);
        }
        return selectedPersonnel;
    }

    public ActionForward calculateSalary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = this.getSelectedLine(request);
        int selectedPersonnelIndex = this.getSelectedPersonnel(request);
        boolean errorFound = false;
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        BudgetPersonnelDetails budgetPersonnelDetails = selectedBudgetLineItem.getBudgetPersonnelDetailsList().get(selectedPersonnelIndex);
        errorFound = this.personnelDetailsCheck(budgetDocument, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, selectedPersonnelIndex);
        if (!errorFound) {
            this.updatePersonnelBudgetRate(selectedBudgetLineItem);
            BudgetPersonnelBudgetService budgetPersonnelBudgetService = KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
            budgetPersonnelBudgetService.calculateBudgetPersonnelBudget(budget, selectedBudgetLineItem, budgetPersonnelDetails, selectedPersonnelIndex);
            this.recalculateBudgetPeriod(budgetForm, budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
            this.getCalculationService().populateCalculatedAmount(budget, selectedBudgetLineItem);
        }
        return mapping.findForward("basic");
    }

    private boolean personnelDetailsCheck(BudgetDocument budgetDocument, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int selectedPersonnelIndex) {
        Budget budget = budgetDocument.getBudget();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        BudgetPersonnelDetails budgetPersonnelDetails = selectedBudgetLineItem.getBudgetPersonnelDetailsList().get(selectedPersonnelIndex);
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (StringUtils.isEmpty((String)budgetPersonnelDetails.getPeriodTypeCode())) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].periodTypeCode", "error.required.periodTypeCode", new String[0]);
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentEffort().isGreaterThan(new BudgetDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].percentEffort", "error.percentage", new String[]{"Percent Effort"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan(new BudgetDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].percentCharged", "error.percentage", new String[]{"Percent Charged"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan(budgetPersonnelDetails.getPercentEffort())) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
            errorFound = true;
        }
        errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, selectedPersonnelIndex);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return errorFound;
    }

    private boolean personnelDatesCheck(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int detailIndex) {
        boolean errorFound = false;
        if (budgetPersonnelDetails.getStartDate() == null) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.required", new String[]{"Start Date (Start Date)"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getEndDate() == null) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.required", new String[]{"End Date (End Date)"});
            errorFound = true;
        }
        if (!errorFound) {
            if (budgetPersonnelDetails.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.dates", new String[0]);
                errorFound = true;
            }
            if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getEndDate()) < 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be after", "end date"});
                errorFound = true;
            }
            if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getEndDate()) > 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be before", "start date"});
                errorFound = true;
            }
            if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getStartDate()) > 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be before", "start date"});
                errorFound = true;
            }
            if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be after", "end date"});
                errorFound = true;
            }
        }
        return errorFound;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block3: {
            BudgetPersonService budgetPersonService;
            Collection rawValues;
            Class<Object> lookupResultsBOClass;
            BudgetForm budgetForm;
            block5: {
                block4: {
                    super.refresh(mapping, form, request, response);
                    budgetForm = (BudgetForm)form;
                    if (budgetForm.getLookupResultsBOClassName() == null || budgetForm.getLookupResultsSequenceNumber() == null) break block3;
                    String lookupResultsSequenceNumber = budgetForm.getLookupResultsSequenceNumber();
                    lookupResultsBOClass = Class.forName(budgetForm.getLookupResultsBOClassName());
                    rawValues = KraServiceLocator.getService(LookupResultsService.class).retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPerson().getPrincipalId());
                    budgetPersonService = KraServiceLocator.getService(BudgetPersonService.class);
                    if (!lookupResultsBOClass.isAssignableFrom(KcPerson.class)) break block4;
                    for (KcPerson person : rawValues) {
                        BudgetPerson budgetPerson = new BudgetPerson(person);
                        this.populateAndAddBudgetPerson(budgetPerson, budgetForm.getBudgetDocument(), budgetPersonService);
                    }
                    break block3;
                }
                if (!lookupResultsBOClass.isAssignableFrom(NonOrganizationalRolodex.class)) break block5;
                for (Rolodex rolodex : rawValues) {
                    BudgetPerson budgetPerson = new BudgetPerson(rolodex);
                    this.populateAndAddBudgetPerson(budgetPerson, budgetForm.getBudgetDocument(), budgetPersonService);
                }
                break block3;
            }
            if (!lookupResultsBOClass.isAssignableFrom(TbnPerson.class)) break block3;
            for (TbnPerson tbn : rawValues) {
                BudgetPerson budgetPerson = new BudgetPerson(tbn);
                this.populateAndAddBudgetPerson(budgetPerson, budgetForm.getBudgetDocument(), budgetPersonService);
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        ActionForward forward = mapping.findForward("basic");
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            int i = 0;
            ArrayList<Integer> toBeDeletedLineItems = new ArrayList<Integer>();
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (StringUtils.equalsIgnoreCase((String)budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (String)"P")) {
                    if (!StringUtils.equalsIgnoreCase((String)budgetLineItem.getCostElement(), (String)budgetLineItem.getCostElementBO().getCostElement())) {
                        budgetLineItem.refreshReferenceObject("costElementBO");
                        budgetLineItem.setBudgetCategoryCode(budgetLineItem.getCostElementBO().getBudgetCategoryCode());
                    }
                    this.updatePersonnelBudgetRate(budgetLineItem);
                    if (this.checkToRetainBudgetLineItem(budgetLineItem, budgetDocument)) {
                        toBeDeletedLineItems.add(i);
                    }
                }
                ++i;
            }
            for (Integer lineItemIndex : toBeDeletedLineItems) {
                budgetPeriod.getBudgetLineItems().remove(lineItemIndex);
            }
        }
        BudgetPersonnelRule personnelRule = new BudgetPersonnelRule();
        if (personnelRule.processCheckBaseSalaryFormat(budgetDocument) && personnelRule.processCheckForJobCodeChange(budgetDocument, budgetForm.getViewBudgetPeriod())) {
            BudgetPersonService budgetPersonService = KraServiceLocator.getService(BudgetPersonService.class);
            budgetPersonService.populateBudgetPersonDefaultDataIfEmpty(budget);
            if (this.budgetPersonnelDetailsCheck(budgetDocument) && new BudgetPersonnelExpenseRule().processSaveCheckDuplicateBudgetPersonnel(budgetDocument)) {
                if (budgetForm.isAuditActivated()) {
                    forward = super.save(mapping, form, request, response);
                } else {
                    super.save(mapping, form, request, response);
                }
            }
        }
        return forward;
    }

    private boolean budgetPersonnelDetailsCheck(BudgetDocument budgetDocument, int budgetPeriodIndex, int budgetLineItemIndex) {
        Budget budget = budgetDocument.getBudget();
        boolean valid = true;
        boolean validJobCodeCECombo = false;
        BudgetPersonnelRule budgetPersonnelRule = new BudgetPersonnelRule();
        BudgetPeriod selectedBudgetPeriod = budget.getBudgetPeriod(budgetPeriodIndex);
        BudgetLineItem selectedBudgetLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemIndex);
        int k = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            valid &= !this.personnelDetailsCheck(budgetDocument, budgetPeriodIndex, budgetLineItemIndex, k);
            validJobCodeCECombo = budgetPersonnelRule.processCheckJobCodeObjectCodeCombo(budgetDocument, budgetPersonnelDetails, true);
            if (!validJobCodeCECombo) {
                GlobalVariables.getMessageMap().putError("document.budgetPeriod[" + budgetPeriodIndex + "].budgetLineItem[" + budgetLineItemIndex + "].budgetPersonnelDetailsList[" + k + "].personSequenceNumber", "error.save.jobCode.costElement.invalid", new String[0]);
            }
            valid &= validJobCodeCECombo;
            ++k;
        }
        return valid;
    }

    private boolean budgetPersonnelDetailsCheck(BudgetDocument budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        boolean valid = true;
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        int i = 0;
        int j = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            j = 0;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                if (budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equals("P")) {
                    valid &= this.budgetPersonnelDetailsCheck(budgetDocument, i, j);
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }

    public ActionForward deleteBudgetPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Budget budget;
        BudgetDocument budgetDocument = ((BudgetForm)form).getBudgetDocument();
        if (!new BudgetPersonnelRule().processCheckExistBudgetPersonnelDetailsBusinessRules(budgetDocument, (budget = budgetDocument.getBudget()).getBudgetPerson(this.getLineToDelete(request)))) {
            return mapping.findForward("basic");
        }
        return this.confirm(this.buildDeleteBudgetPersonConfirmationQuestion(mapping, form, request, response), CONFIRM_DELETE_BUDGET_PERSON, EMPTY_GROUP_NAME);
    }

    public ActionForward confirmDeleteBudgetPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_BUDGET_PERSON.equals(question)) {
            BudgetDocument budgetDocument = ((BudgetForm)form).getBudgetDocument();
            Budget budget = budgetDocument.getBudget();
            this.getBudgetPersonnelBudgetService().deleteBudgetPersonnelDetailsForPerson(budget, budget.getBudgetPerson(this.getLineToDelete(request)));
            budget.getBudgetPersons().remove(this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument document = budgetForm.getBudgetDocument();
        budgetForm.setDocId(document.getDocumentNumber());
        budgetForm.setCommand("displayDocSearchView");
        ActionForward actionForward = this.docHandler(mapping, form, request, response);
        KNSGlobalVariables.getMessageList().add("message.document.reloaded", new String[0]);
        this.reconcilePersonnelRoles(budgetForm.getBudgetDocument());
        this.populatePersonnelCategoryTypeCodes(budgetForm);
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!StringUtils.equalsIgnoreCase((String)budgetLineItem.getCostElement(), (String)budgetLineItem.getCostElementBO().getCostElement())) {
                    budgetLineItem.refreshReferenceObject("costElementBO");
                    budgetLineItem.setBudgetCategoryCode(budgetLineItem.getCostElementBO().getBudgetCategoryCode());
                }
                this.updatePersonnelBudgetRate(budgetLineItem);
            }
        }
        return actionForward;
    }

    public ActionForward synchToProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        KraServiceLocator.getService(BudgetPersonService.class).synchBudgetPersonsToProposal(budget);
        this.reconcilePersonnelRoles(budgetDocument);
        return mapping.findForward("basic");
    }

    private void populateAndAddBudgetPerson(BudgetPerson budgetPerson, BudgetDocument budgetDocument, BudgetPersonService budgetPersonService) {
        Budget budget = budgetDocument.getBudget();
        budgetPersonService.addBudgetPerson(budget, budgetPerson);
    }

    private StrutsConfirmation buildDeleteBudgetPersonConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetDocument budgetDocument = ((BudgetForm)form).getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        String personName = budget.getBudgetPerson(this.getLineToDelete(request)).getPersonName();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_BUDGET_PERSON, "document.question.deletePerson.text", personName);
    }

    private BudgetPersonnelBudgetService getBudgetPersonnelBudgetService() {
        return KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
    }

    public ActionForward personnelRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int budgetPeriodNumber = Integer.parseInt(request.getParameter("budgetPeriod"));
        int budgetLineItemNumber = Integer.parseInt(request.getParameter("line"));
        String rateClassCode = request.getParameter("rateClassCode");
        String rateTypeCode = request.getParameter("rateTypeCode");
        String fieldName = request.getParameter("fieldName");
        BudgetPeriod selectedBudgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber - 1);
        BudgetLineItem selectedLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemNumber);
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedLineItem.getBudgetPersonnelDetailsList()) {
            budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
        }
        this.updatePersonnelBudgetRate(selectedLineItem);
        request.setAttribute("budgetPeriod", (Object)budgetPeriodNumber);
        request.setAttribute("lineNumber", (Object)budgetLineItemNumber);
        request.setAttribute("rateClassCode", (Object)rateClassCode);
        request.setAttribute("rateTypeCode", (Object)rateTypeCode);
        request.setAttribute("fieldName", (Object)fieldName);
        return mapping.findForward("personnelRates");
    }

    private boolean checkForDeletedPerson(BudgetDocument budgetDocument, BudgetPersonnelDetails budgetPersonnelDetails) {
        Budget budget = budgetDocument.getBudget();
        for (BudgetPerson person : budget.getBudgetPersons()) {
            if (person.getPersonSequenceNumber().intValue() != budgetPersonnelDetails.getPersonSequenceNumber().intValue()) continue;
            return false;
        }
        return true;
    }

    private boolean checkToRetainBudgetLineItem(BudgetLineItem budgetLineItem, BudgetDocument budgetDocument) {
        ArrayList<Integer> deletedPersons = new ArrayList<Integer>();
        int originalPersonListSize = budgetLineItem.getBudgetPersonnelDetailsList().size();
        int i = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            if (budgetPersonnelDetails.getBudgetPerson() == null) {
                budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
            }
            if (budgetPersonnelDetails.getBudgetPerson() != null && this.checkForDeletedPerson(budgetDocument, budgetPersonnelDetails)) {
                deletedPersons.add(i);
            }
            ++i;
        }
        for (Integer deletedPersonIndex : deletedPersons) {
            budgetLineItem.getBudgetPersonnelDetailsList().remove(deletedPersonIndex);
        }
        return originalPersonListSize > 0 && deletedPersons.size() == originalPersonListSize;
    }

    public void updatePersonnelBudgetRate(BudgetLineItem budgetLineItem) {
        int j = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            budgetPersonnelDetails.setApplyInRateFlag(budgetLineItem.getApplyInRateFlag());
            budgetPersonnelDetails.setOnOffCampusFlag(budgetLineItem.getOnOffCampusFlag());
            if (budgetPersonnelDetails.getBudgetPerson() == null) {
                budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
            }
            j = 0;
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                Boolean updatedApplyRateFlag = null;
                if (budgetPersonnelCalculatedAmount.getRateClass() == null) {
                    budgetPersonnelCalculatedAmount.refreshReferenceObject("rateClass");
                }
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmout : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (!budgetLineItemCalculatedAmout.getRateClassCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateClassCode()) || !budgetLineItemCalculatedAmout.getRateTypeCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateTypeCode())) continue;
                    updatedApplyRateFlag = budgetLineItemCalculatedAmout.getApplyRateFlag();
                }
                budgetPersonnelCalculatedAmount.setApplyRateFlag(updatedApplyRateFlag);
                ++j;
            }
        }
        for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            if (lineItemCalculatedAmount.getRateClass() != null) continue;
            lineItemCalculatedAmount.refreshReferenceObject("rateClass");
        }
    }

    public ActionForward personnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int budgetPeriodNumber = Integer.parseInt(request.getParameter("budgetPeriod"));
        int budgetLineItemNumber = Integer.parseInt(request.getParameter("line"));
        int personNumber = Integer.parseInt(request.getParameter("personNumber"));
        BudgetPeriod selectedBudgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber - 1);
        BudgetLineItem selectedLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemNumber);
        BudgetPersonnelDetails selectedBudgetPersonnelDetails = selectedLineItem.getBudgetPersonnelDetails(personNumber);
        selectedBudgetPersonnelDetails.refreshReferenceObject("budgetPerson");
        request.setAttribute("budgetPeriod", (Object)budgetPeriodNumber);
        request.setAttribute("lineNumber", (Object)budgetLineItemNumber);
        request.setAttribute("personNumber", (Object)personNumber);
        return mapping.findForward("personnelDetails");
    }

    public ActionForward savePersonnelDescription(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int budgetPeriodNumber = Integer.parseInt(request.getParameter("budgetPeriod"));
        int budgetLineItemNumber = Integer.parseInt(request.getParameter("line"));
        int personNumber = Integer.parseInt(request.getParameter("personnelIndex"));
        BudgetPeriod selectedBudgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber - 1);
        BudgetLineItem selectedLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemNumber);
        return mapping.findForward("closePage");
    }

    public ActionForward calculateLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = this.getSelectedLine(request);
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        if (new BudgetExpenseRule().processCheckLineItemDates(budgetDocument)) {
            this.updatePersonnelBudgetRate(selectedBudgetLineItem);
            this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
            this.recalculateBudgetPeriod(budgetForm, budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
            this.getCalculationService().populateCalculatedAmount(budget, selectedBudgetLineItem);
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward applyToLaterPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int sltdLineItem = this.getSelectedLine(request);
        BudgetExpenseRule budgetExpenseRule = new BudgetExpenseRule();
        int sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1;
        if (budgetExpenseRule.processApplyToLaterPeriodsWithPersonnelDetails(budgetDocument, budget.getBudgetPeriod(sltdBudgetPeriod), budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem), sltdLineItem) && budgetExpenseRule.processCheckLineItemDates(budget.getBudgetPeriod(sltdBudgetPeriod), sltdLineItem) && this.budgetPersonnelDetailsCheck(budgetDocument, sltdBudgetPeriod, sltdLineItem) && new BudgetPersonnelExpenseRule().processCheckDuplicateBudgetPersonnel(budgetDocument, sltdBudgetPeriod, sltdLineItem)) {
            this.getCalculationService().applyToLaterPeriods(budget, budget.getBudgetPeriod(sltdBudgetPeriod), budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem));
        }
        return mapping.findForward("basic");
    }

    public ActionForward calculatePersonSalaryDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        ArrayList<BudgetPersonSalaryDetails> budgetPersonSalaryDetails = new ArrayList();
        BudgetPersonnelBudgetService budgetPersonnelBudgetService = KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
        budgetPersonSalaryDetails = budgetPersonnelBudgetService.calculatePersonSalary(budget, this.getSelectedLine(request));
        budgetForm.getBudgetDocument().getBudget().getBudgetPerson(this.getSelectedLine(request)).setBudgetPersonSalaryDetails(budgetPersonSalaryDetails);
        budgetForm.setViewDivFlag(true);
        budgetForm.setPersonIndex(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward saveBudgetPersonSalaryInDiffPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean zero = false;
        int listIndex = 0;
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails = budget.getBudgetPerson(this.getSelectedLine(request)).getBudgetPersonSalaryDetails();
        HashMap<String, Object> budgetPersonInPeriodsSalaryMap = new HashMap<String, Object>();
        budgetPersonInPeriodsSalaryMap.put("personSequenceNumber", budget.getBudgetPerson(this.getSelectedLine(request)).getPersonSequenceNumber());
        budgetPersonInPeriodsSalaryMap.put("budgetId", budget.getBudgetId());
        if (budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId() != null) {
            budgetPersonInPeriodsSalaryMap.put("personId", budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId());
        } else if (budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId() != null) {
            budgetPersonInPeriodsSalaryMap.put("personId", budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId());
        } else {
            budgetPersonInPeriodsSalaryMap.put("personId", budget.getBudgetPerson(this.getSelectedLine(request)).getTbnId());
        }
        Collection salaryDetails = boService.findMatching(BudgetPersonSalaryDetails.class, budgetPersonInPeriodsSalaryMap);
        List personSalaryDetails = (List)salaryDetails;
        for (BudgetPersonSalaryDetails budgetPerSalaryDetails : budgetPersonSalaryDetails) {
            budgetPerSalaryDetails.setBudgetId(budget.getBudgetId());
            budgetPerSalaryDetails.setPersonSequenceNumber(budget.getBudgetPerson(this.getSelectedLine(request)).getPersonSequenceNumber());
            if (budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId() != null) {
                budgetPerSalaryDetails.setPersonId(budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId());
            } else if (budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId() != null) {
                budgetPerSalaryDetails.setPersonId(budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId().toString());
            } else {
                budgetPerSalaryDetails.setPersonId(budget.getBudgetPerson(this.getSelectedLine(request)).getTbnId());
            }
            if (personSalaryDetails != null && personSalaryDetails.size() > 0) {
                budgetPerSalaryDetails.setBudgetPeriod(((BudgetPersonSalaryDetails)((Object)personSalaryDetails.get(listIndex))).getBudgetPeriod());
                budgetPerSalaryDetails.setBudgetPersonSalaryDetailId(((BudgetPersonSalaryDetails)((Object)personSalaryDetails.get(listIndex))).getBudgetPersonSalaryDetailId());
            } else {
                budgetPerSalaryDetails.setBudgetPeriod(listIndex + 1);
            }
            ++listIndex;
        }
        if (budgetPersonSalaryDetails != null && budgetPersonSalaryDetails.size() > 0) {
            boService.save(budgetPersonSalaryDetails);
        }
        budgetForm.setViewDivFlag(true);
        budgetForm.setPersonIndex(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }
}

