/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodExt;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;

public class BudgetSummaryTotalsAction
extends BudgetAction {
    private static final Log LOG = LogFactory.getLog(BudgetSummaryTotalsAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.execute(mapping, form, request, response);
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.reload(mapping, form, request, response);
        Budget budget = this.getBudget(form);
        this.getBudgetCommonService(budget.getBudgetDocument().getParentDocument()).recalculateBudget(budget);
        return actionForward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Budget budget = this.getBudget(form);
        if (budget instanceof AwardBudgetExt) {
            List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
            for (int i = 0; i < budgetPeriods.size(); ++i) {
                AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriods.get(i);
                String val = request.getParameter("document.budget.budgetPeriods[" + i + "].rateOverrideFlag");
                if (!StringUtils.isNotBlank((String)val)) continue;
                awardBudgetPeriod.setRateOverrideFlag(Boolean.valueOf(val));
            }
        }
        if (budget != null && budget instanceof ProposalDevelopmentBudgetExt) {
            this.getBusinessObjectService().findBySinglePrimaryKey(ProposalDevelopmentBudgetExt.class, (Object)budget.getBudgetId());
        }
        return super.save(mapping, form, request, response);
    }

    private AwardBudgetService getAwardBudgetService() {
        return KraServiceLocator.getService(AwardBudgetService.class);
    }

    private BudgetCalculationService getBudgetCalaculationService() {
        return KraServiceLocator.getService(BudgetCalculationService.class);
    }

    public ActionForward previousPeriodSet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotEmpty((String)request.getParameter("periodStartIndex")) && StringUtils.isNotEmpty((String)request.getParameter("periodEndIndex"))) {
            int oldPeriodStartIndex = Integer.parseInt(request.getParameter("periodStartIndex"));
            int oldPeriodEndIndex = Integer.parseInt(request.getParameter("periodEndIndex"));
            int newPeriodStartIndex = oldPeriodStartIndex - 5;
            int newPeriodEndIndex = oldPeriodEndIndex - 5;
            if (newPeriodStartIndex < 0) {
                newPeriodStartIndex = 0;
                newPeriodEndIndex = newPeriodStartIndex + 4;
            }
            request.setAttribute("startIndex", (Object)newPeriodStartIndex);
            request.setAttribute("endIndex", (Object)newPeriodEndIndex);
        }
        return mapping.findForward("basic");
    }

    public ActionForward nextPeriodSet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Budget budget = this.getBudget(form);
        if (StringUtils.isNotEmpty((String)request.getParameter("periodStartIndex")) && StringUtils.isNotEmpty((String)request.getParameter("periodEndIndex"))) {
            int oldPeriodStartIndex = Integer.parseInt(request.getParameter("periodStartIndex"));
            int oldPeriodEndIndex = Integer.parseInt(request.getParameter("periodEndIndex"));
            int newPeriodStartIndex = -1;
            int newPeriodEndIndex = -1;
            if (budget.getBudgetPeriods().size() > oldPeriodEndIndex + 5) {
                newPeriodEndIndex = oldPeriodEndIndex + 5;
                newPeriodStartIndex = oldPeriodStartIndex + 5;
            } else if (budget.getBudgetPeriods().size() > oldPeriodEndIndex + 1) {
                newPeriodEndIndex = budget.getBudgetPeriods().size() - 1;
                newPeriodStartIndex = newPeriodEndIndex - 4;
            }
            request.setAttribute("startIndex", (Object)newPeriodStartIndex);
            request.setAttribute("endIndex", (Object)newPeriodEndIndex);
        }
        return mapping.findForward("basic");
    }

    private Budget getBudget(ActionForm form) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        return budget;
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        super.populateAuthorizationFields(formBase);
        BudgetForm budgetForm = (BudgetForm)formBase;
        String navigateTo = budgetForm.getNavigateTo();
        Map documentActions = formBase.getDocumentActions();
        if ("summaryTotals".equalsIgnoreCase(navigateTo) && documentActions.containsKey("canReload")) {
            documentActions.remove("canReload");
        }
    }
}

