/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class CoiDiscDetail
extends KraPersistableBusinessObjectBase
implements Comparable<CoiDiscDetail> {
    private static final long serialVersionUID = 779054686380799255L;
    private Long coiDiscDetailId;
    private Long coiDisclosureId;
    private Long coiDisclProjectId;
    private String coiDisclosureNumber;
    private Integer sequenceNumber;
    private Integer coiDiscDetailNumber;
    private String moduleCode;
    private String moduleItemKey;
    private String entityNumber;
    private Integer entitySequenceNumber;
    private Integer entityDispositionCode;
    private Integer oldEntityDispositionCode;
    private String description;
    private String comments;
    private Long personFinIntDisclosureId;
    private Long copiedCoiDiscDetailId;
    private PersonFinIntDisclosure personFinIntDisclosure;
    private CoiDispositionStatus coiEntityDispositionStatus;
    private CoiDisclosure coiDisclosure;
    private Long originalCoiDisclosureId;
    @SkipVersioning
    private CoiDisclosure originalCoiDisclosure;
    private CoiDisclProject coiDisclProject;
    private String projectType;
    private String projectIdFk;

    public CoiDiscDetail() {
    }

    public CoiDiscDetail(PersonFinIntDisclosure personFinIntDisclosure) {
        this.setPersonFinIntDisclosureId(personFinIntDisclosure.getPersonFinIntDisclosureId());
        this.setPersonFinIntDisclosure(personFinIntDisclosure);
        this.setEntityNumber(personFinIntDisclosure.getEntityNumber());
        this.setEntitySequenceNumber(personFinIntDisclosure.getSequenceNumber());
        Long nextNumber = KraServiceLocator.getService(SequenceAccessorService.class).getNextAvailableSequenceNumber("SEQ_COI_DISC_DETAILS_ID");
        this.setCoiDiscDetailNumber(nextNumber.intValue());
    }

    public Long getCoiDiscDetailId() {
        return this.coiDiscDetailId;
    }

    public void setCoiDiscDetailId(Long coiDiscDetailId) {
        this.coiDiscDetailId = coiDiscDetailId;
    }

    public Long getCoiDisclosureId() {
        return this.coiDisclosureId;
    }

    public void setCoiDisclosureId(Long coiDisclosureId) {
        this.coiDisclosureId = coiDisclosureId;
    }

    public Long getCoiDisclProjectId() {
        return this.coiDisclProjectId;
    }

    public void setCoiDisclProjectId(Long coiDisclProjectId) {
        this.coiDisclProjectId = coiDisclProjectId;
    }

    public String getCoiDisclosureNumber() {
        return this.coiDisclosureNumber;
    }

    public void setCoiDisclosureNumber(String coiDisclosureNumber) {
        this.coiDisclosureNumber = coiDisclosureNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Integer getCoiDiscDetailNumber() {
        return this.coiDiscDetailNumber;
    }

    public void setCoiDiscDetailNumber(Integer coiDiscDetailNumber) {
        this.coiDiscDetailNumber = coiDiscDetailNumber;
    }

    public String getModuleCode() {
        return this.moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }

    public String getModuleItemKey() {
        return this.moduleItemKey;
    }

    public void setModuleItemKey(String moduleItemKey) {
        this.moduleItemKey = moduleItemKey;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public Integer getEntitySequenceNumber() {
        return this.entitySequenceNumber;
    }

    public void setEntitySequenceNumber(Integer entitySequenceNumber) {
        this.entitySequenceNumber = entitySequenceNumber;
    }

    public Integer getEntityDispositionCode() {
        return this.entityDispositionCode;
    }

    public void setEntityDispositionCode(Integer entityDispositionCode) {
        this.entityDispositionCode = entityDispositionCode;
    }

    public Integer getOldEntityDispositionCode() {
        return this.oldEntityDispositionCode;
    }

    public void setOldEntityDispositionCode() {
        this.oldEntityDispositionCode = this.entityDispositionCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public CoiDispositionStatus getCoiEntityDispositionStatus() {
        return this.coiEntityDispositionStatus;
    }

    public void setCoiEntityDispositionStatus(CoiDispositionStatus coiEntityDispositionStatus) {
        this.coiEntityDispositionStatus = coiEntityDispositionStatus;
    }

    public CoiDisclosure getCoiDisclosure() {
        return this.coiDisclosure;
    }

    public void setCoiDisclosure(CoiDisclosure coiDisclosure) {
        this.coiDisclosure = coiDisclosure;
    }

    public Long getPersonFinIntDisclosureId() {
        return this.personFinIntDisclosureId;
    }

    public void setPersonFinIntDisclosureId(Long personFinIntDisclosureId) {
        this.personFinIntDisclosureId = personFinIntDisclosureId;
    }

    public PersonFinIntDisclosure getPersonFinIntDisclosure() {
        return this.personFinIntDisclosure;
    }

    public void setPersonFinIntDisclosure(PersonFinIntDisclosure personFinIntDisclosure) {
        this.personFinIntDisclosure = personFinIntDisclosure;
    }

    @Override
    public int compareTo(CoiDiscDetail other) {
        int result = 0;
        if (other != null) {
            result = StringUtils.equals((String)this.projectType, (String)other.getProjectType()) ? (StringUtils.equals((String)this.moduleItemKey, (String)other.getModuleItemKey()) ? this.personFinIntDisclosureId.compareTo(other.getPersonFinIntDisclosureId()) : this.moduleItemKey.compareTo(other.getModuleItemKey())) : this.projectType.compareTo(other.getProjectType());
        }
        return result;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public boolean isProposalEvent() {
        return StringUtils.equals((String)"2", (String)this.projectType);
    }

    public boolean isInstitutionalProposalEvent() {
        return StringUtils.equals((String)"10", (String)this.projectType);
    }

    public boolean isAwardEvent() {
        return StringUtils.equals((String)"1", (String)this.projectType);
    }

    public boolean isProtocolEvent() {
        return StringUtils.equals((String)"3", (String)this.projectType);
    }

    public boolean isIacucProtocolEvent() {
        return StringUtils.equals((String)"4", (String)this.projectType);
    }

    public boolean isManualAwardEvent() {
        return StringUtils.equals((String)"11", (String)this.projectType);
    }

    public boolean isManualProposalEvent() {
        return StringUtils.equals((String)"12", (String)this.projectType);
    }

    public boolean isManualProtocolEvent() {
        return StringUtils.equals((String)"13", (String)this.projectType);
    }

    public boolean isManualIacucProtocolEvent() {
        return StringUtils.equals((String)"16", (String)this.projectType);
    }

    public boolean isManualEvent() {
        return this.isManualAwardEvent() || this.isManualProposalEvent() || this.isManualProtocolEvent();
    }

    public String getProjectIdFk() {
        return this.projectIdFk;
    }

    public void setProjectIdFk(String projectIdFk) {
        this.projectIdFk = projectIdFk;
    }

    public Long getCopiedCoiDiscDetailId() {
        return this.copiedCoiDiscDetailId;
    }

    public void setCopiedCoiDiscDetailId(Long copiedCoiDiscDetailId) {
        this.copiedCoiDiscDetailId = copiedCoiDiscDetailId;
    }

    public Long getOriginalCoiDisclosureId() {
        return this.originalCoiDisclosureId;
    }

    public void setOriginalCoiDisclosureId(Long originalCoiDisclosureId) {
        this.originalCoiDisclosureId = originalCoiDisclosureId;
    }

    public CoiDisclosure getOriginalCoiDisclosure() {
        if (this.originalCoiDisclosureId != null && this.originalCoiDisclosure == null) {
            this.refreshReferenceObject("originalCoiDisclosure");
        }
        return this.originalCoiDisclosure;
    }

    public void setOriginalCoiDisclosure(CoiDisclosure originalCoiDisclosure) {
        this.originalCoiDisclosure = originalCoiDisclosure;
    }

    public CoiDisclProject getCoiDisclProject() {
        return this.coiDisclProject;
    }

    public void setCoiDisclProject(CoiDisclProject coiDisclProject) {
        this.coiDisclProject = coiDisclProject;
    }
}

