/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.krms.service.impl.KcKrmsFactBuilderServiceHelper;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;
import org.w3c.dom.Document;

public class CoiDisclosureFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            CoiDisclosureDocument disclosureDocument = (CoiDisclosureDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, disclosureDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, ResearchDocumentBase document) {
        CoiDisclosureDocument disclosureDocument = (CoiDisclosureDocument)document;
        CoiDisclosure coiDisclosure = disclosureDocument.getCoiDisclosure();
        this.addObjectMembersAsFacts(factsBuilder, coiDisclosure, "KC-COIDISCLOSURE-CONTEXT", "KC-COIDISCLOSURE");
        factsBuilder.addFact("CoiDisclosure", (Object)coiDisclosure);
        factsBuilder.addFact("moduleCode", (Object)"8");
        factsBuilder.addFact("moduleItemKey", (Object)coiDisclosure.getCoiDisclosureNumber());
    }

    @Override
    protected String getElementValue(String docContent, String xpathExpression) {
        try {
            Document document = XmlHelper.trimXml((InputStream)new ByteArrayInputStream(docContent.getBytes()));
            XPath xpath = XPathHelper.newXPath();
            String value = (String)xpath.evaluate(xpathExpression, document, XPathConstants.STRING);
            return value;
        }
        catch (Exception e) {
            throw new RiceRuntimeException();
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

