/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureStatus;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.coi.actions.DisclosureActionHelper;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.disclosure.DisclosureHelper;
import org.kuali.kra.coi.notesandattachments.CoiNotesAndAttachmentsHelper;
import org.kuali.kra.coi.notification.CoiNotificationContext;
import org.kuali.kra.coi.questionnaire.DisclosureQuestionnaireHelper;
import org.kuali.kra.coi.questionnaire.ScreeningQuestionnaireHelper;
import org.kuali.kra.common.notification.web.struts.form.NotificationHelper;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.QuestionableFormInterface;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.web.struts.form.Auditable;
import org.kuali.kra.web.struts.form.KraTransactionalDocumentFormBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiDisclosureForm
extends KraTransactionalDocumentFormBase
implements Auditable,
QuestionableFormInterface {
    private static final long serialVersionUID = -5620344612882618024L;
    private transient DisclosureHelper disclosureHelper;
    private transient DisclosureActionHelper disclosureActionHelper;
    private boolean auditActivated;
    private transient CoiNotesAndAttachmentsHelper coiNotesAndAttachmentsHelper;
    private transient NotificationHelper<CoiNotificationContext> notificationHelper;
    private transient DisclosureQuestionnaireHelper disclosureQuestionnaireHelper;
    private transient ScreeningQuestionnaireHelper screeningQuestionnaireHelper;
    private String coiDispositionCode;
    private String coiDisclosureStatusCode;
    private String personId;

    public CoiDisclosureForm() {
        this.initialize();
    }

    public void initialize() {
        this.setDisclosureHelper(new DisclosureHelper(this));
        this.setCoiNotesAndAttachmentsHelper(new CoiNotesAndAttachmentsHelper(this));
        this.setDisclosureActionHelper(new DisclosureActionHelper(this));
        this.disclosureActionHelper.prepareView();
        this.setNotificationHelper(new NotificationHelper<CoiNotificationContext>());
    }

    public void setCoiNotesAndAttachmentsHelper(CoiNotesAndAttachmentsHelper coiNotesAndAttachmentsHelper) {
        this.coiNotesAndAttachmentsHelper = coiNotesAndAttachmentsHelper;
    }

    public CoiNotesAndAttachmentsHelper getCoiNotesAndAttachmentsHelper() {
        return this.coiNotesAndAttachmentsHelper;
    }

    public DisclosureQuestionnaireHelper getDisclosureQuestionnaireHelper() {
        if (this.disclosureQuestionnaireHelper == null) {
            this.disclosureQuestionnaireHelper = new DisclosureQuestionnaireHelper(this.getCoiDisclosureDocument().getCoiDisclosure());
        }
        return this.disclosureQuestionnaireHelper;
    }

    public void setDisclosureQuestionnaireHelper(DisclosureQuestionnaireHelper disclosureQuestionnaireHelper) {
        this.disclosureQuestionnaireHelper = disclosureQuestionnaireHelper;
    }

    public ScreeningQuestionnaireHelper getScreeningQuestionnaireHelper() {
        if (this.screeningQuestionnaireHelper == null) {
            this.screeningQuestionnaireHelper = new ScreeningQuestionnaireHelper(this.getCoiDisclosureDocument().getCoiDisclosure());
        }
        return this.screeningQuestionnaireHelper;
    }

    public void setScreeningQuestionnaireHelper(ScreeningQuestionnaireHelper screeningQuestionnaireHelper) {
        this.screeningQuestionnaireHelper = screeningQuestionnaireHelper;
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return "CoiDisclosureDocument";
    }

    @Override
    protected String getLockRegion() {
        return "COIDISCLOSURE";
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
    }

    @Override
    public boolean isAuditActivated() {
        return this.auditActivated;
    }

    @Override
    public void setAuditActivated(boolean auditActivated) {
        this.auditActivated = auditActivated;
    }

    public DisclosureHelper getDisclosureHelper() {
        return this.disclosureHelper;
    }

    public void setDisclosureHelper(DisclosureHelper disclosureHelper) {
        this.disclosureHelper = disclosureHelper;
    }

    public CoiDisclosureDocument getCoiDisclosureDocument() {
        return (CoiDisclosureDocument)this.getDocument();
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        CoiDisclosure disclosure = this.getCoiDisclosureDocument().getCoiDisclosure();
        for (HeaderNavigation nav : navigation) {
            if (!disclosure.isApprovedDisclosure() && !disclosure.isDisapprovedDisclosure() && !StringUtils.equals((String)"viewMasterDisclosure", (String)this.getMethodToCall()) || StringUtils.equals((String)nav.getHeaderTabNavigateTo(), (String)"disclosure")) {
                nav.setDisabled(StringUtils.equals((String)"viewMasterDisclosure", (String)this.getMethodToCall()) && disclosure.getCoiDisclosureId() == null);
                resultList.add(nav);
            }
            if (!StringUtils.equalsIgnoreCase((String)"disclosureActions", (String)nav.getHeaderTabNavigateTo())) continue;
            CoiDisclosureTask task = new CoiDisclosureTask("viewCoiDisclosureAction", this.getCoiDisclosureDocument().getCoiDisclosure());
            if (this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task)) continue;
            resultList.remove(nav);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        CoiDisclosureDocument document = this.getCoiDisclosureDocument();
        CoiDisclosure disclosure = document.getCoiDisclosure();
        ArrayList<HeaderField> newDocInfo = new ArrayList<HeaderField>();
        newDocInfo.add(this.getDocumentIdHeaderField(workflowDocument));
        CoiDisclosureStatus status = disclosure.getCoiDisclosureStatus();
        String disclosureStatus = status != null ? status.getDescription() : "NEW";
        String reviewStatus = disclosure.getCoiReviewStatus() != null ? disclosure.getCoiReviewStatus().getDescription() : "";
        String disclosureAndReviewStatus = disclosureStatus + " : " + reviewStatus;
        HeaderField headerStatus = new HeaderField("DataDictionary.CoiDisclosure.attributes.disclosureStatusReviewStatus", disclosureAndReviewStatus);
        newDocInfo.add(headerStatus);
        CoiDispositionStatus disposition = disclosure.getCoiDispositionStatus();
        String disclosureDisposition = disposition != null ? disposition.getDescription() : "NEW";
        HeaderField headerDisposition = new HeaderField("DataDictionary.CoiDisclosureStatus.attributes.description", disclosureDisposition);
        newDocInfo.add(headerDisposition);
        newDocInfo.add(this.getReporterAndCreatedHeaderField(workflowDocument));
        Timestamp timeStamp = document.getUpdateTimestamp();
        if (timeStamp == null) {
            timeStamp = new Timestamp(document.getDocumentHeader().getWorkflowDocument().getDateCreated().getMillis());
        }
        String lastUpdatedDateStr = CoreApiServiceLocator.getDateTimeService().toString((java.util.Date)timeStamp, "hh:mm a MM/dd/yyyy");
        newDocInfo.add(new HeaderField("DataDictionary.CoiDisclosure.attributes.updateTimestamp", lastUpdatedDateStr));
        String disclosureNumber = disclosure.getCoiDisclosureNumber();
        newDocInfo.add(new HeaderField("DataDictionary.CoiDisclosure.attributes.coiDisclosureNumber", disclosureNumber));
        this.setDocInfo(newDocInfo);
    }

    protected HeaderField getDocumentIdHeaderField(WorkflowDocument workflowDocument) {
        String documentId = "";
        if (workflowDocument != null) {
            documentId = this.getCoiDisclosureDocument().getDocumentNumber();
        }
        return new HeaderField("DataDictionary.CoiDisclosureDocument.attributes.documentNumber", documentId);
    }

    protected HeaderField getReporterAndCreatedHeaderField(WorkflowDocument workflowDocument) {
        String reporterCreated = ":";
        String reporter = this.getCoiDisclosureDocument().getCoiDisclosure().getDisclosureReporter().getPersonId();
        long creationMsecs = 0L;
        if (workflowDocument != null) {
            creationMsecs = workflowDocument.getDateCreated().getMillis();
        }
        reporter = reporter != null ? KcPerson.fromPersonId(reporter).getUserName() : GlobalVariables.getUserSession().getPrincipalId();
        String disclosureCreated = CoreApiServiceLocator.getDateTimeService().toString((java.util.Date)new Date(creationMsecs), "MM/dd/yyyy");
        reporterCreated = reporter + ":" + disclosureCreated;
        return new HeaderField("DataDictionary.CoiDisclosure.attributes.reporterCreated", reporterCreated);
    }

    private BusinessObjectService getBusinessObjectService() {
        return KRADServiceLocator.getBusinessObjectService();
    }

    public String getCoiDispositionCode() {
        return this.coiDispositionCode;
    }

    public void setCoiDispositionCode(String coiDispositionCode) {
        this.coiDispositionCode = coiDispositionCode;
    }

    public DisclosureActionHelper getDisclosureActionHelper() {
        return this.disclosureActionHelper;
    }

    public void setDisclosureActionHelper(DisclosureActionHelper disclosureActionHelper) {
        this.disclosureActionHelper = disclosureActionHelper;
    }

    public NotificationHelper<CoiNotificationContext> getNotificationHelper() {
        return this.notificationHelper;
    }

    public void setNotificationHelper(NotificationHelper<CoiNotificationContext> notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public void setCoiDisclosureStatusCode(String coiDisclosureStatusCode) {
        this.coiDisclosureStatusCode = coiDisclosureStatusCode;
    }

    public String getCoiDisclosureStatusCode() {
        return this.coiDisclosureStatusCode;
    }

    @Override
    public String getQuestionnaireFieldStarter() {
        return "disclosureQuestionnaireHelper.answerHeaders[";
    }

    @Override
    public String getQuestionnaireFieldMiddle() {
        return "].answers[";
    }

    @Override
    public String getQuestionnaireFieldEnd() {
        return "].answer";
    }

    @Override
    public String getQuestionnaireExpression() {
        return ".*[Qq]uestionnaireHelper\\.answerHeaders\\[\\d+\\]\\.answers\\[\\d+\\]\\.answer";
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }
}

