/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.actions;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiUserRole;
import org.kuali.kra.coi.actions.AddCoiReviewerEvent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AddCoiReviewerRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<AddCoiReviewerEvent> {
    private transient KcPersonService kcPersonService = KraServiceLocator.getService(KcPersonService.class);

    @Override
    public boolean processRules(AddCoiReviewerEvent event) {
        return this.validateRequired(event) && this.validateNonDuplicate(event);
    }

    private boolean validateRequired(AddCoiReviewerEvent event) {
        boolean valid = false;
        if (StringUtils.isNotBlank((String)event.getCoiUserRole().getUserId()) && this.getKcPersonService().getKcPersonByUserName(event.getCoiUserRole().getUserId()) != null) {
            valid = true;
        } else {
            GlobalVariables.getMessageMap().putError("disclosureActionHelper.newCoiUserRole.userId", "error.required", new String[]{"User Name"});
        }
        return valid;
    }

    private boolean validateNonDuplicate(AddCoiReviewerEvent event) {
        boolean valid = true;
        if (CollectionUtils.isNotEmpty(event.getCoiDisclosure().getCoiUserRoles())) {
            for (CoiUserRole userRole : event.getCoiDisclosure().getCoiUserRoles()) {
                if (!StringUtils.equalsIgnoreCase((String)userRole.getUserId(), (String)event.getCoiUserRole().getUserId())) continue;
                valid = false;
                GlobalVariables.getMessageMap().putError("disclosureActionHelper.newCoiUserRole.userId", "error.duplicate.entry", new String[]{"User Name"});
                break;
            }
        }
        return valid;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

