/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.actions;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.coi.CoiReviewer;
import org.kuali.kra.coi.CoiUserRole;
import org.kuali.kra.coi.actions.CoiDisclosureActionService;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.certification.SubmitDisclosureAction;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class DisclosureActionHelper
implements Serializable {
    private static final long serialVersionUID = -4602681870006425531L;
    private CoiUserRole newCoiUserRole;
    private CoiDisclosureForm coiDisclosureForm;
    private CoiDisclosureActionService coiDisclosureActionService;
    private CoiDisclosureService coiDisclosureService;
    private SubmitDisclosureAction submitDisclosureAction;
    private transient BusinessObjectService businessObjectService;
    private transient ParameterService parameterService;
    private transient TaskAuthorizationService taskAuthorizationService;
    private transient KcPersonService kcPersonService;
    private boolean approveDisclosure;
    private boolean maintainReviewers;

    public DisclosureActionHelper(CoiDisclosureForm coiDisclosureForm) {
        this.coiDisclosureForm = coiDisclosureForm;
        this.newCoiUserRole = new CoiUserRole();
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        this.parameterService = KraServiceLocator.getService(ParameterService.class);
        this.taskAuthorizationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        this.coiDisclosureActionService = KraServiceLocator.getService(CoiDisclosureActionService.class);
        this.coiDisclosureService = KraServiceLocator.getService(CoiDisclosureService.class);
        this.submitDisclosureAction = new SubmitDisclosureAction(this);
        this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
    }

    public void prepareView() {
        this.initializePermissions();
        this.populateCoiUserRoleData();
    }

    private void initializePermissions() {
        this.approveDisclosure = this.canApproveCoiDisclosure();
        this.maintainReviewers = this.canMaintainReviewers();
    }

    private boolean canApproveCoiDisclosure() {
        CoiDisclosureTask task = new CoiDisclosureTask("approveCoiDisclosure", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean canMaintainReviewers() {
        CoiDisclosureTask task = new CoiDisclosureTask("maintainCoiReviewers", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public CoiDisclosure getCoiDisclosure() {
        if (this.coiDisclosureForm.getDocument() == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure() == null) {
            throw new IllegalArgumentException("the coiDisclosure is null");
        }
        return this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return this.taskAuthorizationService;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public boolean getApproveDisclosure() {
        return this.approveDisclosure;
    }

    public void setApproveDisclosure(boolean approveDisclosure) {
        this.approveDisclosure = approveDisclosure;
    }

    public boolean isMaintainReviewers() {
        return this.maintainReviewers;
    }

    public void setMaintainReviewers(boolean maintainReviewers) {
        this.maintainReviewers = maintainReviewers;
    }

    public CoiUserRole getNewCoiUserRole() {
        return this.newCoiUserRole;
    }

    public void setNewCoiUserRole(CoiUserRole newCoiUserRole) {
        this.newCoiUserRole = newCoiUserRole;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public CoiDisclosureActionService getCoiDisclosureActionService() {
        return this.coiDisclosureActionService;
    }

    public CoiDisclosureService getCoiDisclosureService() {
        return this.coiDisclosureService;
    }

    public CoiDisclosureForm getCoiDisclosureForm() {
        return this.coiDisclosureForm;
    }

    public void setCoiDisclosureForm(CoiDisclosureForm coiDisclosureForm) {
        this.coiDisclosureForm = coiDisclosureForm;
    }

    public void approveDisclosure(String coiDispositionCode) throws WorkflowException {
        CoiDisclosureDocument coiDisclosureDocument = this.coiDisclosureForm.getCoiDisclosureDocument();
        this.getCoiDisclosureActionService().approveDisclosure(this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure(), coiDispositionCode);
        this.coiDisclosureForm.getDisclosureHelper().setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosureDocument.getCoiDisclosure()));
        this.coiDisclosureForm.getDisclosureQuestionnaireHelper().setAnswerHeaders(this.coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean().getAnswerHeaders());
        this.coiDisclosureForm.getDisclosureQuestionnaireHelper().resetHeaderLabels();
        this.coiDisclosureForm.getDisclosureQuestionnaireHelper().setAnswerQuestionnaire(false);
    }

    public void disapproveDisclosure(String coiDispositionCode) throws Exception {
        CoiDisclosureDocument coiDisclosureDocument = this.coiDisclosureForm.getCoiDisclosureDocument();
        this.getCoiDisclosureActionService().disapproveDisclosure(this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure(), coiDispositionCode);
        this.coiDisclosureForm.getDisclosureHelper().setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosureDocument.getCoiDisclosure()));
    }

    public SubmitDisclosureAction getSubmitDisclosureAction() {
        return this.submitDisclosureAction;
    }

    private void populateCoiUserRoleData() {
        List<CoiUserRole> userRoles = this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().getCoiUserRoles();
        this.syncUserRolesData(userRoles);
    }

    private void syncUserRolesData(List<CoiUserRole> userRoles) {
        if (CollectionUtils.isNotEmpty(userRoles)) {
            for (CoiUserRole userRole : userRoles) {
                userRole.setPerson(this.getKcPerson(userRole.getUserId()));
                userRole.setCoiReviewer(this.getCoiReviewer(userRole.getReviewerCode()));
            }
        }
    }

    public void setSubmitDisclosureAction(SubmitDisclosureAction submitDisclosureAction) {
        this.submitDisclosureAction = submitDisclosureAction;
    }

    public List<CoiUserRole> getCoiUserRoles() {
        this.populateCoiUserRoleData();
        if (!this.canMaintainReviewers()) {
            this.getCoiDisclosureActionService().tagUserRolesToCompleteReview(this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().getCoiUserRoles());
        }
        return this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().getCoiUserRoles();
    }

    public KcPerson getKcPerson(String userName) {
        return this.getKcPersonService().getKcPersonByUserName(userName);
    }

    public CoiReviewer getCoiReviewer(String reviewerCode) {
        CoiReviewer coiReviewer = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("reviewerCode", reviewerCode);
        List reviewers = (List)this.getBusinessObjectService().findMatching(CoiReviewer.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)reviewers)) {
            coiReviewer = (CoiReviewer)((Object)reviewers.get(0));
        }
        return coiReviewer;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public boolean isDisclosureReviewComplete() {
        return this.getCoiDisclosureActionService().isDisclosureReviewComplete(this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().getCoiUserRoles());
    }

    public boolean isDisclosureAssignedToReviewer() {
        return this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().getCoiUserRoles().size() > 0;
    }

    public boolean isUserDisclosureReporter() {
        String currentUser = this.getUserIdentifier();
        String disclosureReporter = this.getCoiDisclosure().getDisclosureReporter().getReporter().getPersonId();
        if (StringUtils.isNotBlank((String)currentUser) && StringUtils.isNotBlank((String)disclosureReporter)) {
            return currentUser.equalsIgnoreCase(disclosureReporter);
        }
        return false;
    }

    public CoiDispositionStatus getMaximumDispositionStatus() {
        return this.getCoiDisclosureService().calculateMaximumDispositionStatus(this.getCoiDisclosure());
    }
}

