/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.auth.CoiDisclosureAuthorizer;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Document;

public class AddCoiDisclosureAttachmentsAuthorizer
extends CoiDisclosureAuthorizer {
    @Override
    public boolean isAuthorized(String userId, CoiDisclosureTask task) {
        boolean hasPermission = true;
        CoiDisclosure coiDisclosure = task.getCoiDisclosure();
        hasPermission = this.isNewDisclosure(coiDisclosure) ? this.hasUnitPermission(userId, "KC-COIDISCLOSURE", "Report Coi Disclosure") : (this.isNotSubmitted(coiDisclosure) ? (this.isDisclosureReporter(userId, coiDisclosure) ? true : this.getPermissionService().isAuthorized(userId, "KC-COIDISCLOSURE", "Maintain Coi Disclosure Notes", this.getQualificationMap(task.getCoiDisclosure())) && this.isEditableByAdminReviewer(coiDisclosure)) : (this.isDisclosureReporter(userId, coiDisclosure) ? false : this.getPermissionService().isAuthorized(userId, "KC-COIDISCLOSURE", "Maintain Coi Disclosure Notes", this.getQualificationMap(task.getCoiDisclosure())) && !this.isDocumentFinal(coiDisclosure) && this.isEditableByAdminReviewer(coiDisclosure)));
        return hasPermission;
    }

    protected boolean isNewDisclosure(CoiDisclosure coiDisclosure) {
        if (coiDisclosure == null) {
            return true;
        }
        return coiDisclosure.getPersonId() == null;
    }

    protected boolean isNotSubmitted(CoiDisclosure coiDisclosure) {
        return !coiDisclosure.isSubmitted();
    }

    protected boolean isDocumentFinal(CoiDisclosure coiDisclosure) {
        return coiDisclosure.getCoiDisclosureDocument().getDocumentHeader().getWorkflowDocument().isFinal();
    }

    protected boolean isDisclosureReporter(String userId, CoiDisclosure coiDisclosure) {
        return StringUtils.equals((String)userId, (String)coiDisclosure.getPersonId());
    }

    @Override
    protected boolean isEditableByAdminReviewer(CoiDisclosure coiDisclosure) {
        return coiDisclosure != null && !coiDisclosure.getCoiDisclosureDocument().isViewOnly() && !this.isPessimisticLocked((Document)coiDisclosure.getCoiDisclosureDocument()) && !coiDisclosure.isApprovedDisclosure() && !coiDisclosure.isDisapprovedDisclosure();
    }

    protected PermissionService getPermissionService() {
        return KraServiceLocator.getService(PermissionService.class);
    }

    private Map<String, String> getQualificationMap(CoiDisclosure coiDisclosure) {
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put("coiDisclosureId", coiDisclosure.getCoiDisclosureId().toString());
        qualifications.put("unitNumber", "*");
        return qualifications;
    }
}

