/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.auth;

import org.kuali.kra.authorization.Task;
import org.kuali.kra.authorization.TaskAuthorizerImpl;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CoiDisclosureAuthorizer
extends TaskAuthorizerImpl {
    private KraAuthorizationService kraAuthorizationService;
    private CoiDisclosureService coiDisclosureService;

    @Override
    public final boolean isAuthorized(String userId, Task task) {
        return this.isAuthorized(userId, (CoiDisclosureTask)task);
    }

    public abstract boolean isAuthorized(String var1, CoiDisclosureTask var2);

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected final boolean hasPermission(String userId, CoiDisclosure coiDisclosure, String permissionName) {
        return this.kraAuthorizationService.hasPermission(userId, coiDisclosure, permissionName);
    }

    protected boolean isPessimisticLocked(Document document) {
        boolean isLocked = false;
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson())) continue;
            isLocked = true;
        }
        return isLocked;
    }

    protected CoiDisclosureService getCoiDisclosureService() {
        return this.coiDisclosureService;
    }

    public void setCoiDisclosureService(CoiDisclosureService coiDisclosureService) {
        this.coiDisclosureService = coiDisclosureService;
    }

    protected boolean isDisclosureEditable(CoiDisclosure coiDisclosure) {
        return coiDisclosure != null && !coiDisclosure.getCoiDisclosureDocument().isViewOnly() && !this.isPessimisticLocked((Document)coiDisclosure.getCoiDisclosureDocument()) && !this.kraWorkflowService.isInWorkflow((Document)coiDisclosure.getCoiDisclosureDocument()) && !coiDisclosure.isApprovedDisclosure();
    }

    protected boolean isEditableByAdminReviewer(CoiDisclosure coiDisclosure) {
        return coiDisclosure != null && !coiDisclosure.getCoiDisclosureDocument().isViewOnly() && !this.isPessimisticLocked((Document)coiDisclosure.getCoiDisclosureDocument()) && !coiDisclosure.isApprovedDisclosure() && !coiDisclosure.isDisapprovedDisclosure();
    }

    protected boolean isDocumentViewOnly(CoiDisclosure coiDisclosure) {
        return coiDisclosure.getCoiDisclosureDocument().isViewOnly();
    }
}

