/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.auth;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public class CoiDisclosureDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)document;
        String userId = user.getPrincipalId();
        if (coiDisclosureDocument.getCoiDisclosure().getCoiDisclosureId() == null) {
            if (this.canCreateCoiDisclosure(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
            if (this.canApprove(userId, coiDisclosureDocument, "approveCoiDisclosure")) {
                editModes.add("approveCoiDisclosure");
            }
        } else {
            if (this.canExecuteCoiDisclosureTask(userId, coiDisclosureDocument, "modifyCoiDisclosure")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteCoiDisclosureTask(userId, coiDisclosureDocument, "viewCoiDisclosure")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canApprove(userId, coiDisclosureDocument, "approveCoiDisclosure")) {
                editModes.add("approveCoiDisclosure");
            }
        }
        return editModes;
    }

    protected boolean canApprove(String userId, CoiDisclosureDocument doc, String taskName) {
        CoiDisclosureTask task = new CoiDisclosureTask(taskName, doc.getCoiDisclosure());
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateCoiDisclosure(user);
    }

    public boolean canOpen(Document document, Person user) {
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)document;
        if (coiDisclosureDocument.getCoiDisclosure().getCoiDisclosureId() == null) {
            return this.canCreateCoiDisclosure(user);
        }
        return this.canExecuteCoiDisclosureTask(user.getPrincipalId(), (CoiDisclosureDocument)document, "viewCoiDisclosure");
    }

    private boolean canCreateCoiDisclosure(Person user) {
        ApplicationTask task = new ApplicationTask("createCoiDisclosure");
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), task);
    }

    private boolean canExecuteCoiDisclosureTask(String userId, CoiDisclosureDocument doc, String taskName) {
        CoiDisclosureTask task = new CoiDisclosureTask(taskName, doc.getCoiDisclosure());
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteCoiDisclosureTask(user.getPrincipalId(), (CoiDisclosureDocument)document, "modifyCoiDisclosure") || this.canModifyAttachments((CoiDisclosureDocument)document, user) || this.canModifyNotes((CoiDisclosureDocument)document, user) || this.canApprove(user.getPrincipalId(), (CoiDisclosureDocument)document, "approveCoiDisclosure") && !((CoiDisclosureDocument)document).isViewOnly();
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    protected boolean canModifyAttachments(CoiDisclosureDocument doc, Person user) {
        return this.canExecuteCoiDisclosureTask(user.getPrincipalId(), doc, "maintainCoiDisclosureAttachments");
    }

    protected boolean canModifyNotes(CoiDisclosureDocument doc, Person user) {
        return this.canExecuteCoiDisclosureTask(user.getPrincipalId(), doc, "maintainCoiDisclosureNotes");
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canReload(Document document, Person user) {
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)document;
        return coiDisclosureDocument.getCoiDisclosure().getCoiDisclosureId() != null || coiDisclosureDocument.getCoiDisclosure().isApprovedDisclosure();
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return false;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }

    @Override
    protected Set<String> getDocumentActions(Document document, Person user) {
        Set<String> documentActions = super.getDocumentActions(document, user);
        if (document.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            documentActions.remove("canEditDocumentOverview");
        }
        return documentActions;
    }
}

