/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.DisclosureReporterUnit;
import org.kuali.kra.coi.disclosure.AddDisclosureReporterUnitEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class AddDisclosureReporterUnitRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<AddDisclosureReporterUnitEvent> {
    @Override
    public boolean processRules(AddDisclosureReporterUnitEvent event) {
        boolean isValid = true;
        GlobalVariables.getMessageMap().addToErrorPath(event.getPropertyName());
        if (StringUtils.isBlank((String)event.getDisclosureReporterUnit().getUnitNumber())) {
            GlobalVariables.getMessageMap().putError("unitNumber", "error.unitnumber.required", new String[0]);
        } else {
            if (!CollectionUtils.isEmpty(event.getDisclosureReporterUnits())) {
                boolean duplicateUnitNumber = false;
                for (DisclosureReporterUnit disclosureReporterUnit : event.getDisclosureReporterUnits()) {
                    if (!StringUtils.equals((String)disclosureReporterUnit.getUnitNumber(), (String)event.getDisclosureReporterUnit().getUnitNumber())) continue;
                    duplicateUnitNumber = true;
                    break;
                }
                if (duplicateUnitNumber) {
                    GlobalVariables.getMessageMap().putError("unitNumber", "error.protocolUnit.duplicate", new String[0]);
                }
            }
            if (event.getDisclosureReporterUnit().getUnit() == null) {
                GlobalVariables.getMessageMap().putError("unitNumber", "error.invalid.unit", new String[]{event.getDisclosureReporterUnit().getUnitNumber()});
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(event.getPropertyName());
        return isValid &= GlobalVariables.getMessageMap().hasNoErrors();
    }
}

