/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CoiDisclEventProject
implements Serializable {
    private static final long serialVersionUID = 3373941718110328593L;
    private String eventType;
    private KraPersistableBusinessObjectBase eventProjectBo;
    private List<CoiDiscDetail> coiDiscDetails;
    private boolean disclosureFlag;

    public CoiDisclEventProject() {
    }

    public CoiDisclEventProject(String eventType, KraPersistableBusinessObjectBase eventProjectBo, List<CoiDiscDetail> coiDiscDetails) {
        this.eventType = eventType;
        this.eventProjectBo = eventProjectBo;
        this.coiDiscDetails = coiDiscDetails;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public KraPersistableBusinessObjectBase getEventProjectBo() {
        return this.eventProjectBo;
    }

    public void setEventProjectBo(KraPersistableBusinessObjectBase eventProjectBo) {
        this.eventProjectBo = eventProjectBo;
    }

    public List<CoiDiscDetail> getCoiDiscDetails() {
        return this.coiDiscDetails;
    }

    public void setCoiDiscDetails(List<CoiDiscDetail> coiDiscDetails) {
        this.coiDiscDetails = coiDiscDetails;
    }

    public boolean isDisclosureFlag() {
        return this.disclosureFlag;
    }

    public void setDisclosureFlag(boolean disclosureFlag) {
        this.disclosureFlag = disclosureFlag;
    }

    public boolean isProposalEvent() {
        return StringUtils.equals((String)"2", (String)this.eventType);
    }

    public boolean isInstitutionalProposalEvent() {
        return StringUtils.equals((String)"10", (String)this.eventType);
    }

    public boolean isAwardEvent() {
        return StringUtils.equals((String)"1", (String)this.eventType);
    }

    public boolean isAnnual() {
        return StringUtils.equals((String)"14", (String)this.eventType);
    }

    public boolean isProtocolEvent() {
        return StringUtils.equals((String)"3", (String)this.eventType);
    }

    public boolean isEventExcludFE() {
        boolean eventExcludeFE = false;
        if (this.isAwardEvent()) {
            eventExcludeFE = this.isEventExcludFE("1");
        } else if (this.isProtocolEvent()) {
            eventExcludeFE = this.isEventExcludFE("3");
        } else if (this.isProposalEvent()) {
            eventExcludeFE = this.isEventExcludFE("2");
        } else if (this.isInstitutionalProposalEvent()) {
            eventExcludeFE = this.isEventExcludFE("10");
        }
        return eventExcludeFE;
    }

    private boolean isEventExcludFE(String eventTypeCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("eventTypeCode", eventTypeCode);
        CoiDisclosureEventType CoiDisclosureEventType2 = (CoiDisclosureEventType)KraServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(CoiDisclosureEventType.class, fieldValues);
        return CoiDisclosureEventType2.isExcludeFinancialEntities();
    }

    public String getProjectId() {
        String projectId = "";
        projectId = this.isAwardEvent() ? ((Award)this.eventProjectBo).getAwardNumber() : (this.isProtocolEvent() ? ((Protocol)this.eventProjectBo).getProtocolNumber() : (this.eventProjectBo instanceof DevelopmentProposal ? ((DevelopmentProposal)this.eventProjectBo).getProposalNumber() : ((InstitutionalProposal)this.eventProjectBo).getProposalNumber()));
        return projectId;
    }

    public String getCompleteMessage() {
        int completeCount = 0;
        if (CollectionUtils.isNotEmpty(this.getCoiDiscDetails())) {
            for (CoiDiscDetail coiDiscDetail : this.getCoiDiscDetails()) {
                if (coiDiscDetail.getEntityDispositionCode() == null || coiDiscDetail.getEntityDispositionCode() <= 0) continue;
                ++completeCount;
            }
        }
        return completeCount + "/" + this.getCoiDiscDetails().size() + " Reviews Complete";
    }

    public boolean isComplete() {
        boolean isComplete = true;
        if (CollectionUtils.isNotEmpty(this.getCoiDiscDetails())) {
            for (CoiDiscDetail coiDiscDetail : this.getCoiDiscDetails()) {
                if (coiDiscDetail.getEntityDispositionCode() != null && coiDiscDetail.getEntityDispositionCode() != 0) continue;
                isComplete = false;
                break;
            }
        }
        return isComplete;
    }
}

