/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.codehaus.jackson.map.ObjectMapper;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.coi.CoiAction;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.actions.CoiDisclosureActionService;
import org.kuali.kra.coi.certification.CertifyDisclosureEvent;
import org.kuali.kra.coi.certification.SubmitDisclosureAction;
import org.kuali.kra.coi.disclosure.AddDisclosureReporterUnitEvent;
import org.kuali.kra.coi.disclosure.AddManualProjectEvent;
import org.kuali.kra.coi.disclosure.CoiDisclosureAdministratorActionRule;
import org.kuali.kra.coi.disclosure.CoiDisclosureEventTypeAjaxBean;
import org.kuali.kra.coi.disclosure.CoiDisclosureProjectBean;
import org.kuali.kra.coi.disclosure.DisclosureHelper;
import org.kuali.kra.coi.disclosure.DisclosurePersonUnit;
import org.kuali.kra.coi.notesandattachments.CoiNotesAndAttachmentsHelper;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.notification.CoiNotification;
import org.kuali.kra.coi.print.CoiReportType;
import org.kuali.kra.coi.questionnaire.DisclosureModuleQuestionnaireBean;
import org.kuali.kra.coi.questionnaire.DisclosureQuestionnaireHelper;
import org.kuali.kra.coi.service.CoiPrintingService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.questionnaire.QuestionnaireHelperBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.questionnaire.answer.SaveQuestionnaireAnswerEvent;
import org.kuali.kra.questionnaire.print.QuestionnairePrintingService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.CollectionUtils;

public class CoiDisclosureAction
extends CoiAction {
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String ATTACHMENT_PATH = "document.coiDisclosureList[0].attachmentCoiDisclosures[";
    private static final String CONFIRM_NO_DELETE = "";
    private static final String DEFAULT_EVENT_ID_STRING = "label.coi.disclosure.type.id";
    private static final String DEFAULT_EVENT_TITLE_STRING = "label.coi.disclosure.type.title";
    protected static final String SCREENING_QUESTIONNAIRE_FAILURE_QUESTION = "CoiDisclosureScreeningQuestionnaireFailureQuestion";

    public ActionForward addDisclosurePersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        DisclosureHelper disclosureHelper = coiDisclosureForm.getDisclosureHelper();
        if (this.checkRule(new AddDisclosureReporterUnitEvent("disclosureHelper.newDisclosurePersonUnit", disclosureHelper.getNewDisclosurePersonUnit(), ((CoiDisclosureDocument)coiDisclosureForm.getDocument()).getCoiDisclosure().getDisclosureReporter().getDisclosurePersonUnits()))) {
            this.getCoiDisclosureService().addDisclosureReporterUnit(((CoiDisclosureDocument)coiDisclosureForm.getDocument()).getCoiDisclosure().getDisclosureReporter(), disclosureHelper.getNewDisclosurePersonUnit());
            disclosureHelper.setNewDisclosurePersonUnit(new DisclosurePersonUnit());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteDisclosurePersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        DisclosureHelper disclosureHelper = coiDisclosureForm.getDisclosureHelper();
        this.getCoiDisclosureService().deleteDisclosureReporterUnit(((CoiDisclosureDocument)coiDisclosureForm.getDocument()).getCoiDisclosure().getDisclosureReporter(), disclosureHelper.getDeletedUnits(), this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    @Override
    public final ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)coiDisclosureForm.getDocument();
        boolean isValid = true;
        ActionForward actionForward = mapping.findForward("basic");
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        CoiDisclosure coiDisclosure = coiDisclosureDocument.getCoiDisclosure();
        helper.setOriginalDisclosureIdsIfNecessary(coiDisclosure);
        if (coiDisclosure.getCoiDisclosureId() == null) {
            coiDisclosure.initRequiredFields();
        } else {
            this.getCoiDisclosureService().resetLeadUnit(coiDisclosure.getDisclosureReporter());
        }
        if (coiDisclosure.isUpdateEvent() || coiDisclosure.isAnnualEvent() && coiDisclosure.isAnnualUpdate()) {
            isValid &= this.getCoiDisclosureService().setDisclProjectForSave(coiDisclosure, coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean());
        }
        this.getCoiDisclosureService().updateDisclosureAndProjectDisposition(coiDisclosure);
        if (coiDisclosure.getCoiDisclProjects() != null || !coiDisclosure.getCoiDisclProjects().isEmpty()) {
            for (CoiDisclProject coiDisclProject : coiDisclosure.getCoiDisclProjects()) {
                if (new CoiDisclosureAdministratorActionRule().isValidDispositionStatus(coiDisclProject.getDisclosureDispositionCode())) continue;
                isValid = false;
            }
        }
        if (this.validateQuestionnaires(coiDisclosureForm)) {
            if (isValid) {
                actionForward = super.save(mapping, form, request, response);
                this.saveQuestionnaires(coiDisclosureForm);
            }
            helper.fixReloadedAttachments(request.getParameterMap());
        }
        if ("save".equals(coiDisclosureForm.getMethodToCall()) && coiDisclosureForm.isAuditActivated() && GlobalVariables.getMessageMap().hasNoErrors()) {
            actionForward = mapping.findForward("disclosureActions");
        } else if (coiDisclosure.isUpdateEvent() || coiDisclosure.isAnnualEvent() && coiDisclosure.isAnnualUpdate()) {
            actionForward = mapping.findForward("updateDisclosure");
        }
        return actionForward;
    }

    protected boolean validateQuestionnaires(CoiDisclosureForm coiDisclosureForm) {
        List<AnswerHeader> answerHeaders = this.generateListOfQuestionnaires(coiDisclosureForm);
        return this.applyRules((KualiDocumentEvent)new SaveQuestionnaireAnswerEvent((Document)coiDisclosureForm.getCoiDisclosureDocument(), answerHeaders));
    }

    protected List<AnswerHeader> generateListOfQuestionnaires(CoiDisclosureForm coiDisclosureForm) {
        ArrayList<AnswerHeader> answerHeaders = new ArrayList<AnswerHeader>();
        answerHeaders.addAll(coiDisclosureForm.getDisclosureQuestionnaireHelper().getAnswerHeaders());
        answerHeaders.addAll(coiDisclosureForm.getScreeningQuestionnaireHelper().getAnswerHeaders());
        if (coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean() != null) {
            List<List<CoiDisclosureProjectBean>> allProjects = coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean().getProjectLists();
            for (List<CoiDisclosureProjectBean> projectList : allProjects) {
                for (CoiDisclosureProjectBean bean : projectList) {
                    answerHeaders.addAll(bean.getAnswerHeaders());
                }
            }
        }
        return answerHeaders;
    }

    protected void saveQuestionnaires(CoiDisclosureForm coiDisclosureForm) {
        List<AnswerHeader> answerHeaders = this.generateListOfQuestionnaires(coiDisclosureForm);
        coiDisclosureForm.getDisclosureQuestionnaireHelper().preSave();
        coiDisclosureForm.getScreeningQuestionnaireHelper().preSave();
        if (coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean() != null) {
            List<List<CoiDisclosureProjectBean>> allProjects = coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean().getProjectLists();
            for (List<CoiDisclosureProjectBean> projectList : allProjects) {
                for (CoiDisclosureProjectBean bean : projectList) {
                    bean.getProjectQuestionnaireHelper().preSave(coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure());
                }
            }
        }
        this.getBusinessObjectService().save(answerHeaders);
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String command = request.getParameter("command");
        if (StringUtils.isNotBlank((String)command) && !StringUtils.containsIgnoreCase((String)command, (String)"initiate")) {
            super.loadDocument((KualiDocumentFormBase)form);
        }
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        ActionForward actionForward = super.execute(mapping, form, request, response);
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)coiDisclosureForm.getDocument();
        CoiDisclosure coiDisclosure = coiDisclosureDocument.getCoiDisclosure();
        if (!(!coiDisclosureDocument.getDocumentHeader().hasWorkflowDocument() || coiDisclosure.isManualEvent() && CollectionUtils.isEmpty(coiDisclosure.getCoiDisclProjects()))) {
            boolean forceQnnrReload = false;
            if (StringUtils.equals((String)"reload", (String)coiDisclosureForm.getMethodToCall()) && !coiDisclosure.isApprovedDisclosure() && !coiDisclosure.isAnnualUpdate() && !coiDisclosure.isUpdateEvent() || StringUtils.equals((String)"addManualProject", (String)coiDisclosureForm.getMethodToCall())) {
                forceQnnrReload = true;
            }
            coiDisclosureForm.getDisclosureQuestionnaireHelper().prepareView(forceQnnrReload);
            coiDisclosureForm.getScreeningQuestionnaireHelper().prepareView(forceQnnrReload);
        }
        coiDisclosureDocument.getCoiDisclosure().initSelectedUnit();
        if ((StringUtils.equals((String)"reload", (String)coiDisclosureForm.getMethodToCall()) || StringUtils.equals((String)"updateAttachmentFilter", (String)coiDisclosureForm.getMethodToCall()) || StringUtils.equals((String)"headerTab", (String)coiDisclosureForm.getMethodToCall()) || StringUtils.equals((String)"docHandler", (String)coiDisclosureForm.getMethodToCall())) && coiDisclosureDocument.getCoiDisclosure().isApprovedDisclosure()) {
            coiDisclosureForm.getDisclosureHelper().setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosureDocument.getCoiDisclosure()));
            this.setQuestionnaireStatuses(coiDisclosureForm);
            actionForward = mapping.findForward("masterDisclosure");
        } else if (StringUtils.isNotBlank((String)command) && "masterDisclosure".equals(command)) {
            coiDisclosureDocument = (CoiDisclosureDocument)coiDisclosureForm.getDocument();
            coiDisclosureDocument.getCoiDisclosure().initSelectedUnit();
            coiDisclosureForm.getDisclosureHelper().setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosureDocument.getCoiDisclosure()));
            this.setQuestionnaireStatuses(coiDisclosureForm);
            actionForward = mapping.findForward("masterDisclosure");
        }
        if (coiDisclosure.isManualEvent() && !CollectionUtils.isEmpty(coiDisclosure.getCoiDisclProjects())) {
            coiDisclosure.getCoiDisclProjects().get(0).initHeaderItems();
        }
        coiDisclosureForm.getCoiNotesAndAttachmentsHelper().prepareView();
        return actionForward;
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        String command = coiDisclosureForm.getCommand();
        ActionForward forward = mapping.findForward("basic");
        String eventTypeCode = "14";
        if (command.startsWith("initiate")) {
            String[] parts = command.split("_");
            if (parts.length > 1) {
                eventTypeCode = parts[1];
            }
            CoiDisclosure coiDisclosure = null;
            if (StringUtils.equals((String)eventTypeCode, (String)"6") || StringUtils.equals((String)eventTypeCode, (String)"14")) {
                coiDisclosure = this.getExistingDisclosure(eventTypeCode);
            }
            if (coiDisclosure != null) {
                coiDisclosureForm.setCommand("displayDocSearchView");
                coiDisclosureForm.setDocId(coiDisclosure.getCoiDisclosureDocument().getDocumentNumber());
            } else {
                coiDisclosureForm.setCommand("initiate");
                coiDisclosure = this.getCoiDisclosureService().versionCoiDisclosure();
                if (coiDisclosure != null) {
                    coiDisclosure.setAnnualUpdate(false);
                }
            }
            forward = super.docHandler(mapping, form, request, response);
            if ("6".equals(eventTypeCode) || "initiate".startsWith(command) && "docHandler".equals(coiDisclosureForm.getMethodToCall()) && this.isMasterDisclosureExist()) {
                if (!this.isMasterDisclosureExist()) {
                    coiDisclosureForm.setMethodToCall("viewMasterDisclosure");
                    forward = mapping.findForward("masterDisclosureNotAvailable");
                } else {
                    if (StringUtils.equals((String)coiDisclosureForm.getCommand(), (String)"initiate")) {
                        this.getCoiDisclosureService().initDisclosureFromMasterDisclosure(coiDisclosure);
                        if (StringUtils.equals((String)eventTypeCode, (String)"14")) {
                            coiDisclosure.setAnnualUpdate(true);
                        }
                        coiDisclosure.setEventTypeCode(eventTypeCode);
                        coiDisclosureForm.getDisclosureHelper().setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosure));
                        if (coiDisclosure != null) {
                            coiDisclosureForm.getCoiDisclosureDocument().setCoiDisclosure(coiDisclosure);
                            coiDisclosure.setCoiDisclosureDocument(coiDisclosureForm.getCoiDisclosureDocument());
                        }
                        this.setQuestionnaireStatuses(coiDisclosureForm, coiDisclosure);
                    } else {
                        coiDisclosureForm.getDisclosureHelper().setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosure));
                    }
                    forward = mapping.findForward("updateDisclosure");
                }
            }
            if (coiDisclosure != null) {
                coiDisclosureForm.getCoiDisclosureDocument().setCoiDisclosure(coiDisclosure);
                coiDisclosure.setCoiDisclosureDocument(coiDisclosureForm.getCoiDisclosureDocument());
            }
            coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().setEventTypeCode(eventTypeCode);
            if (coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().getCoiDisclosureId() == null) {
                coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().initRequiredFields();
            } else {
                this.getCoiDisclosureService().resetLeadUnit(coiDisclosure.getDisclosureReporter());
            }
        } else {
            coiDisclosureForm.setCommand("displayDocSearchView");
            super.docHandler(mapping, form, request, response);
            CoiDisclosure coiDisclosure = coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
            if (coiDisclosure.isUpdateEvent() || coiDisclosure.isAnnualEvent() && coiDisclosure.isAnnualUpdate()) {
                coiDisclosureForm.getDisclosureHelper().setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure()));
                this.setQuestionnaireStatuses(coiDisclosureForm);
                forward = mapping.findForward("updateDisclosure");
            }
        }
        ((CoiDisclosureForm)form).getDisclosureHelper().prepareView();
        ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper().prepareView();
        if (!coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().isUpdateEvent() && (coiDisclosureForm.getCoiDisclosureDocument().getDocumentHeader().getWorkflowDocument().isInitiated() || coiDisclosureForm.getCoiDisclosureDocument().getDocumentHeader().getWorkflowDocument().isSaved())) {
            this.checkToLoadDisclosureDetails(coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure(), ((CoiDisclosureForm)form).getMethodToCall(), coiDisclosureForm.getDisclosureHelper().getNewProjectId(), coiDisclosureForm.getDisclosureHelper().getNewModuleItemKey());
        }
        coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().refreshReferenceObject("coiDispositionStatus");
        coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().setCoiDisclosureAttachmentFilter(coiDisclosureForm.getCoiNotesAndAttachmentsHelper().getNewAttachmentFilter());
        return forward;
    }

    private void setQuestionnaireStatuses(CoiDisclosureForm coiDisclosureForm) {
        coiDisclosureForm.getDisclosureQuestionnaireHelper().setAnswerHeaders(coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean().getAnswerHeaders());
        coiDisclosureForm.getDisclosureQuestionnaireHelper().resetHeaderLabels();
        coiDisclosureForm.getDisclosureQuestionnaireHelper().setAnswerQuestionnaire(false);
        coiDisclosureForm.getDisclosureQuestionnaireHelper().setQuestionnaireActiveStatuses();
        for (AnswerHeader answerHeader : coiDisclosureForm.getDisclosureQuestionnaireHelper().getAnswerHeaders()) {
            this.getQuestionnaireAnswerService().setupChildAnswerIndicator(answerHeader);
        }
    }

    private void setQuestionnaireStatuses(CoiDisclosureForm coiDisclosureForm, CoiDisclosure coiDisclosure) {
        coiDisclosureForm.getDisclosureQuestionnaireHelper().setAnswerHeaders(coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean().getAnswerHeaders());
        List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(new DisclosureModuleQuestionnaireBean(coiDisclosure));
        if (CollectionUtils.isEmpty(coiDisclosureForm.getDisclosureQuestionnaireHelper().getAnswerHeaders())) {
            coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean().getAnswerHeaders().addAll(answerHeaders);
        } else {
            for (AnswerHeader answerHeader : answerHeaders) {
                boolean exists = false;
                for (AnswerHeader existingHeader : coiDisclosureForm.getDisclosureQuestionnaireHelper().getAnswerHeaders()) {
                    if (!StringUtils.equals((String)existingHeader.getModuleSubItemCode(), (String)answerHeader.getModuleSubItemCode()) || !StringUtils.equals((String)existingHeader.getQuestionnaireRefIdFk(), (String)answerHeader.getQuestionnaireRefIdFk())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean().getAnswerHeaders().add(answerHeader);
            }
        }
        coiDisclosureForm.getDisclosureQuestionnaireHelper().resetHeaderLabels();
        coiDisclosureForm.getDisclosureQuestionnaireHelper().setAnswerQuestionnaire(false);
        coiDisclosureForm.getDisclosureQuestionnaireHelper().setQuestionnaireActiveStatuses();
    }

    private QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    private void checkToLoadDisclosureDetails(CoiDisclosure coiDisclosure, String methodToCall, String projectId, String moduleItemKey) {
        if (coiDisclosure.getCoiDisclosureId() == null && !this.hasDisclosureDetails(coiDisclosure)) {
            if (StringUtils.equals((String)"newProjectDisclosure", (String)methodToCall) && projectId != null) {
                this.getCoiDisclosureService().initializeDisclosureProject(coiDisclosure, projectId);
                coiDisclosure.setModuleItemKey(moduleItemKey);
            } else {
                this.getCoiDisclosureService().initializeDisclosureDetails(coiDisclosure);
                coiDisclosure.setModuleItemKey(projectId);
            }
        } else if (!(StringUtils.equals((String)"addProposal", (String)methodToCall) || StringUtils.equals((String)"save", (String)methodToCall) || CollectionUtils.isEmpty(coiDisclosure.getCoiDisclProjects()))) {
            for (CoiDisclProject coiDisclProject : coiDisclosure.getCoiDisclProjects()) {
                if (StringUtils.equals((String)"addProposal", (String)methodToCall) || StringUtils.equals((String)"save", (String)methodToCall) || coiDisclProject.getCoiDisclProjectsId() == null) continue;
                this.getCoiDisclosureService().updateDisclosureDetails(coiDisclProject);
            }
        }
        if (coiDisclosure.isManualEvent() && !CollectionUtils.isEmpty(coiDisclosure.getCoiDisclProjects())) {
            for (CoiDisclProject coiDisclProject : coiDisclosure.getCoiDisclProjects()) {
                if (StringUtils.equals((String)"addProposal", (String)methodToCall) || StringUtils.equals((String)"save", (String)methodToCall) || coiDisclProject.getCoiDisclProjectsId() == null) continue;
                this.getCoiDisclosureService().updateDisclosureDetails(coiDisclProject);
            }
        }
    }

    public ActionForward newFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = this.save(mapping, form, request, response);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
            CoiDisclosure coiDisclosure = ((CoiDisclosureDocument)coiDisclosureForm.getDocument()).getCoiDisclosure();
            String forward = ConfigContext.getCurrentContextConfig().getProperty("kuali.docHandler.url.prefix") + "/financialEntityEditNew.do?methodToCall=addNewCoiDiscFinancialEntity&coiDocId=" + ((CoiDisclosureForm)form).getDocument().getDocumentNumber() + "&financialEntityHelper.reporterId=" + coiDisclosure.getPersonId();
            return new ActionForward(forward, true);
        }
        return actionForward;
    }

    public ActionForward editFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = this.save(mapping, form, request, response);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
            CoiDisclosure coiDisclosure = ((CoiDisclosureDocument)coiDisclosureForm.getDocument()).getCoiDisclosure();
            String forward = ConfigContext.getCurrentContextConfig().getProperty("kuali.docHandler.url.prefix") + "/financialEntityEditList.do?methodToCall=editActiveFinancialEntity&coiDocId=" + ((CoiDisclosureForm)form).getDocument().getDocumentNumber() + "&financialEntityHelper.editCoiEntityId=" + coiDisclosure.getCoiDisclProjects().get(0).getCoiDiscDetails().get(this.getSelectedLine(request)).getPersonFinIntDisclosureId();
            return new ActionForward(forward, true);
        }
        return actionForward;
    }

    public ActionForward addManualProject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        DisclosureHelper disclosureHelper = coiDisclosureForm.getDisclosureHelper();
        CoiDisclosure coiDisclosure = coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
        disclosureHelper.getNewCoiDisclProject().setCoiDisclosure(coiDisclosure);
        disclosureHelper.getNewCoiDisclProject().setCoiDisclosureNumber(coiDisclosure.getCoiDisclosureNumber());
        disclosureHelper.getNewCoiDisclProject().setModuleItemKey(disclosureHelper.getNewCoiDisclProject().getCoiProjectId());
        disclosureHelper.getNewCoiDisclProject().setDisclosureStatusCode("1");
        disclosureHelper.getNewCoiDisclProject().setDisclosureDispositionCode("100");
        disclosureHelper.getNewCoiDisclProject().refreshReferenceObject("coiDispositionStatus");
        if (this.checkRule(new AddManualProjectEvent("disclosureHelper.newCoiDisclProject", disclosureHelper.getNewCoiDisclProject()))) {
            this.getCoiDisclosureService().initializeDisclosureDetails(disclosureHelper.getNewCoiDisclProject());
            disclosureHelper.getNewCoiDisclProject().setSequenceNumber(coiDisclosure.getSequenceNumber());
            disclosureHelper.getNewCoiDisclProject().initHeaderItems();
            coiDisclosure.getCoiDisclProjects().add(disclosureHelper.getNewCoiDisclProject());
            coiDisclosure.setModuleItemKey(disclosureHelper.getNewCoiDisclProject().getProjectId());
            coiDisclosure.setEventTypeCode(disclosureHelper.getNewCoiDisclProject().getDisclosureEventType());
            disclosureHelper.setNewCoiDisclProject(new CoiDisclProject(coiDisclosure.getCoiDisclosureNumber(), coiDisclosure.getSequenceNumber()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward getDisclosuresToComplete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userId = this.getUserId();
        DisclosureHelper disclosureHelper = ((CoiDisclosureForm)form).getDisclosureHelper();
        this.getCoiDisclosureService().populateProposalsAndAwardToCompleteDisclosure(userId, disclosureHelper);
        disclosureHelper.setNewProtocols(this.getCoiDisclosureService().getProtocols(userId));
        disclosureHelper.setNewIacucProtocols(this.getCoiDisclosureService().getIacucProtocols(userId));
        return mapping.findForward("basic");
    }

    public ActionForward newProjectDisclosure(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        coiDisclosureForm.setCommand("initiate_" + coiDisclosureForm.getDisclosureHelper().getEventTypeCode());
        ActionForward forward = this.docHandler(mapping, form, request, response);
        coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().setEventTypeCode(coiDisclosureForm.getDisclosureHelper().getEventTypeCode());
        coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure().setCoiDisclProjects(null);
        this.checkToLoadDisclosureDetails(coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure(), ((CoiDisclosureForm)form).getMethodToCall(), coiDisclosureForm.getDisclosureHelper().getNewProjectId(), coiDisclosureForm.getDisclosureHelper().getNewModuleItemKey());
        return forward;
    }

    public ActionForward submitDisclosureCertification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        this.save(mapping, (ActionForm)coiDisclosureForm, request, response);
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)coiDisclosureForm.getDocument();
        CoiDisclosure coiDisclosure = coiDisclosureDocument.getCoiDisclosure();
        if (this.checkRule(new CertifyDisclosureEvent("disclosureHelper.certifyDisclosure", coiDisclosure))) {
            coiDisclosureForm.setAuditActivated(true);
            coiDisclosureForm.setUnitRulesMessages(this.getUnitRulesMessages(coiDisclosureForm.getCoiDisclosureDocument()));
            AuditActionHelper auditActionHelper = new AuditActionHelper();
            if (auditActionHelper.auditUnconditionally((Document)coiDisclosureDocument) && !coiDisclosureForm.isUnitRulesErrorsExist()) {
                if (coiDisclosure.getCoiDisclosureId() == null) {
                    coiDisclosure.initRequiredFields();
                } else {
                    this.getCoiDisclosureService().resetLeadUnit(coiDisclosure.getDisclosureReporter());
                }
                if (this.validateQuestionnaires(coiDisclosureForm)) {
                    if (!this.getCoiDisclosureService().checkScreeningQuestionnaireRule(coiDisclosureDocument)) {
                        return this.promptForScreeningQuestionnaireFailure(mapping, form, request, response);
                    }
                    this.getDocumentService().saveDocument((Document)coiDisclosureDocument);
                    this.saveQuestionnaires(coiDisclosureForm);
                    coiDisclosure.setDisclosureDispositionCode("300");
                    coiDisclosure.setDisclosureStatusCode("2");
                    this.getCoiDisclosureActionService().updateCoiDisclProjectStatus(coiDisclosure, "2");
                    this.getCoiDisclosureActionService().updateCoiDisclProjectDisposition(coiDisclosure, "210");
                    coiDisclosure.certifyDisclosure();
                    GlobalVariables.getMessageMap().putInfo("datavalidation", "message.coi.cert.submitted", new String[0]);
                    forward = this.submitForReviewAndRedirect(mapping, form, request, response, coiDisclosureForm, coiDisclosure, coiDisclosureDocument);
                }
            } else {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            }
        }
        return forward;
    }

    protected ActionForward promptForScreeningQuestionnaireFailure(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, SCREENING_QUESTIONNAIRE_FAILURE_QUESTION, "Based on answers to the screening questionnaire you are required to have at least one active financial entity to submit this disclosure. Would you like add a financial entity at this time?", "confirmationQuestion", methodToCall, CONFIRM_NO_DELETE);
        }
        if (SCREENING_QUESTIONNAIRE_FAILURE_QUESTION.equals(question) && "0".equals(buttonClicked)) {
            return this.newFinancialEntity(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward printDisclosureCertification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        CoiDisclosure coiDisclosure = ((CoiDisclosureForm)form).getCoiDisclosureDocument().getCoiDisclosure();
        coiDisclosure.setCertificationText(new String(coiDisclosure.getAcknowledgementStatement()));
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        AbstractPrint printable = this.getCoiPrintingService().getCoiPrintable(CoiReportType.COI_APPROVED_DISCLOSURE);
        printable.setPrintableBusinessObject(coiDisclosure);
        printableArtifactList.add(printable);
        AttachmentDataSource dataStream = this.getCoiPrintingService().print(printableArtifactList);
        this.streamToResponse(dataStream, response);
        actionForward = RESPONSE_ALREADY_HANDLED;
        return actionForward;
    }

    private String getUserId() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public ActionForward replaceAttachmentCoi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        return mapping.findForward("basic");
    }

    public ActionForward addAttachmentCoi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.save(mapping, form, request, response);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        helper.addNewCoiDisclosureAttachment();
        return mapping.findForward("basic");
    }

    public ActionForward deleteCoiDisclosureAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        if (this.isValidContactData((CoiDisclosureAttachment)attachment, ATTACHMENT_PATH + selection + "]")) {
            return this.confirmDeleteAttachment(mapping, (CoiDisclosureForm)form, request, response);
        }
        return mapping.findForward("basic");
    }

    protected boolean isValidContactData(CoiDisclosureAttachment attachment, String errorPath) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(errorPath);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)attachment);
        errorMap.removeFromErrorPath(errorPath);
        return errorMap.hasNoErrors();
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }

    protected ActionForward confirmDeleteAttachment(ActionMapping mapping, CoiDisclosureForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = form.getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        String confirmMethod = helper.retrieveConfirmMethodByType();
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, confirmMethod, "document.question.deleteAttachment.text", ((CoiDisclosureAttachment)attachment).getDescription(), ((CoiDisclosureAttachment)attachment).getFile().getName());
        return this.confirm(confirm, confirmMethod, CONFIRM_NO_DELETE);
    }

    public ActionForward confirmDeleteCoiDisclosureAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteAttachment(mapping, (CoiDisclosureForm)form, request, response, CoiDisclosureAttachment.class);
    }

    private ActionForward deleteAttachment(ActionMapping mapping, CoiDisclosureForm form, HttpServletRequest request, HttpServletResponse response, Class<CoiDisclosureAttachment> attachmentType) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = form.getCoiNotesAndAttachmentsHelper();
        if (!helper.deleteExistingAttachmentByType(selection)) {
            // empty if block
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachmentCoi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = ((CoiDisclosureAttachment)attachment).getFile();
        Object attachmentFile = null;
        String attachmentFileType = file.getType().replace("\"", CONFIRM_NO_DELETE);
        this.streamToResponse(file.getData(), CoiDisclosureAction.getValidHeaderString(file.getName()), CoiDisclosureAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private byte[] getCoiDisclosureAttachmentFile(ActionForm form, CoiDisclosureAttachment attachment) {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getCoiPrintingService().getCoiPrintArtifacts(helper.getCoiDisclosure());
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                Integer attachmentDocumentId = attachment.getDocumentId();
                List<CoiDisclosureAttachment> coiDisclosureAttachmentList = helper.getCoiDisclosure().getCoiDisclosureAttachments();
                if (coiDisclosureAttachmentList.size() > 0) {
                    for (CoiDisclosureAttachment coiDisclosureAttachment : coiDisclosureAttachmentList) {
                        if (!attachmentDocumentId.equals(coiDisclosureAttachment.getDocumentId())) continue;
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return attachmentFile;
    }

    public ActionForward updateAttachmentFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        helper.addNewCoiDisclosureAttachmentFilter();
        return mapping.findForward("basic");
    }

    @Override
    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        if (!helper.getFilesToDelete().isEmpty()) {
            this.getBusinessObjectService().delete(helper.getFilesToDelete());
            helper.getFilesToDelete().clear();
        }
        for (CoiDisclosureAttachment attachment : ((CoiDisclosureForm)form).getCoiDisclosureDocument().getCoiDisclosure().getCoiDisclosureAttachments()) {
            attachment.getCoiDisclosure().refreshReferenceObject("coiDisclosureAttachments");
        }
    }

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        helper.addNewNote();
        this.save(mapping, form, request, response);
        helper.setManageNotesOpen();
        return mapping.findForward("basic");
    }

    public ActionForward editNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiDisclosureForm disclosureForm = (CoiDisclosureForm)form;
        CoiNotesAndAttachmentsHelper helper = disclosureForm.getCoiNotesAndAttachmentsHelper();
        helper.editNote(selection);
        return mapping.findForward("basic");
    }

    public ActionForward deleteNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        return this.confirmDeleteNote(mapping, (CoiDisclosureForm)form, request, response);
    }

    protected ActionForward confirmDeleteNote(ActionMapping mapping, CoiDisclosureForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        String confirmMethod = "deleteNoteConfirmed";
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, "deleteNoteConfirmed", "document.question.deleteNote.text", new String[0]);
        return this.confirm(confirm, "deleteNoteConfirmed", CONFIRM_NO_DELETE);
    }

    public ActionForward deleteNoteConfirmed(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        if (!((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper().deleteNote(selection)) {
            // empty if block
        }
        return mapping.findForward("basic");
    }

    protected CoiPrintingService getCoiPrintingService() {
        return KraServiceLocator.getService(CoiPrintingService.class);
    }

    protected WatermarkService getWatermarkService() {
        return KraServiceLocator.getService(WatermarkService.class);
    }

    protected CoiDisclosureActionService getDisclosureActionService() {
        return KraServiceLocator.getService(CoiDisclosureActionService.class);
    }

    public ActionForward viewMasterDisclosure(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        return this.viewMasterDisclosure(GlobalVariables.getUserSession().getPrincipalId(), coiDisclosureForm, mapping);
    }

    public ActionForward viewMasterDisclosure(String personId, CoiDisclosureForm coiDisclosureForm, ActionMapping mapping) throws WorkflowException {
        DisclosureHelper disclosureHelper = coiDisclosureForm.getDisclosureHelper();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        fieldValues.put("currentDisclosure", "Y");
        List disclosures = (List)this.getBusinessObjectService().findMatching(CoiDisclosure.class, fieldValues);
        disclosureHelper.prepareView();
        if (CollectionUtils.isEmpty((Collection)disclosures)) {
            return mapping.findForward("masterDisclosureNotAvailable");
        }
        coiDisclosureForm.setDocId(((CoiDisclosure)disclosures.get(0)).getCoiDisclosureDocument().getDocumentNumber());
        this.loadDocument((KualiDocumentFormBase)coiDisclosureForm);
        disclosureHelper.setMasterDisclosureBean(this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure()));
        this.setQuestionnaireStatuses(coiDisclosureForm);
        return mapping.findForward("masterDisclosure");
    }

    private ActionForward submitForReviewAndRedirect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, CoiDisclosureForm coiDisclosureForm, CoiDisclosure coiDisclosure, CoiDisclosureDocument coiDisclosureDocument) throws Exception {
        SubmitDisclosureAction submitAction = coiDisclosureForm.getDisclosureActionHelper().getSubmitDisclosureAction();
        ActionForward action = this.getDisclosureActionService().sendCertificationNotifications(coiDisclosureDocument, coiDisclosureForm, submitAction, mapping);
        if (action != null) {
            return action;
        }
        this.getDisclosureActionService().submitToWorkflow(coiDisclosureDocument, coiDisclosureForm, submitAction);
        this.attemptLockRelease((Document)coiDisclosureDocument, "close");
        return this.routeDisclosureToHoldingPage(mapping, coiDisclosureForm);
    }

    private ActionForward routeDisclosureToHoldingPage(ActionMapping mapping, CoiDisclosureForm coiDisclosureForm) {
        String routeHeaderId = coiDisclosureForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "basic", "CoiDisclosureDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    public ActionForward getDisclosureEventTypeInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String eventType = request.getParameter("eventType");
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("eventTypeCode", eventType);
        List disclosureEventTypes = (List)this.getBusinessObjectService().findMatching(CoiDisclosureEventType.class, fieldValues);
        StringWriter writer = new StringWriter();
        if (!CollectionUtils.isEmpty((Collection)disclosureEventTypes)) {
            CoiDisclosureEventType disclosureEventType = (CoiDisclosureEventType)((Object)disclosureEventTypes.get(0));
            CoiDisclosureEventTypeAjaxBean disclosureEventTypeAjaxBean = new CoiDisclosureEventTypeAjaxBean();
            disclosureEventTypeAjaxBean.setDisclosureEventType(disclosureEventType);
            if (disclosureEventType.isUseSelectBox1()) {
                try {
                    Class<?> valuesFinderClass;
                    KeyValuesFinder keyValuesFinder;
                    List keyValues;
                    String valuesFinder = disclosureEventType.getSelectBox1ValuesFinder();
                    if (StringUtils.isNotBlank((String)valuesFinder) && !CollectionUtils.isEmpty((Collection)(keyValues = (keyValuesFinder = (KeyValuesFinder)(valuesFinderClass = Class.forName(valuesFinder)).newInstance()).getKeyValues()))) {
                        disclosureEventTypeAjaxBean.setKeyValues(keyValues);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((String)disclosureEventType.getProjectIdLabel())) {
                disclosureEventType.setProjectIdLabel(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(DEFAULT_EVENT_ID_STRING));
            }
            if (StringUtils.isEmpty((String)disclosureEventType.getProjectTitleLabel())) {
                disclosureEventType.setProjectTitleLabel(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(DEFAULT_EVENT_TITLE_STRING));
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((Writer)writer, (Object)disclosureEventTypeAjaxBean);
            response.setContentType("application/json");
            ServletOutputStream out = response.getOutputStream();
            try {
                out.write(writer.getBuffer().toString().getBytes());
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace(new PrintWriter((OutputStream)out));
            }
        }
        return null;
    }

    private boolean hasDisclosureDetails(CoiDisclosure coiDisclosure) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(coiDisclosure.getCoiDisclProjects())) {
            for (CoiDisclProject project : coiDisclosure.getCoiDisclProjects()) {
                if (CollectionUtils.isEmpty(project.getCoiDiscDetails())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        Document document = coiDisclosureForm.getDocument();
        CoiDisclosure coiDisclosure = ((CoiDisclosureDocument)document).getCoiDisclosure();
        boolean isValid = true;
        if (coiDisclosure.getCoiDisclProjects() != null || !coiDisclosure.getCoiDisclProjects().isEmpty()) {
            for (CoiDisclProject coiDisclProject : coiDisclosure.getCoiDisclProjects()) {
                if (new CoiDisclosureAdministratorActionRule().isValidStatus(coiDisclosure.getCoiDisclosureStatus().getCoiDisclosureStatusCode(), coiDisclProject.getDisclosureDispositionCode())) continue;
                isValid = false;
            }
        }
        if (this.validateQuestionnaires(coiDisclosureForm) && isValid) {
            actionForward = super.saveOnClose(mapping, form, request, response);
            this.saveQuestionnaires(coiDisclosureForm);
        }
        return actionForward;
    }

    public ActionForward printQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        CoiDisclosure disclosure = coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
        int answerHeaderIndex = this.getSelectedLine(request);
        String methodToCall = (String)request.getAttribute("methodToCallAttribute");
        String formProperty = StringUtils.substringBetween((String)methodToCall, (String)".printQuestionnaireAnswer.", (String)".line");
        DisclosureQuestionnaireHelper helper = (DisclosureQuestionnaireHelper)BeanUtilsBean.getInstance().getPropertyUtils().getProperty((Object)form, formProperty);
        AnswerHeader answerHeader = helper.getAnswerHeaders().get(answerHeaderIndex);
        reportParameters.put("questionnaireId", answerHeader.getQuestionnaire().getQuestionnaireIdAsInteger());
        reportParameters.put("template", answerHeader.getQuestionnaire().getTemplate());
        reportParameters.put("coeusModuleSubItemCode", answerHeader.getModuleSubItemCode());
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer(disclosure, reportParameters);
        if (dataStream.getContent() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    protected QuestionnairePrintingService getQuestionnairePrintingService() {
        return KraServiceLocator.getService(QuestionnairePrintingService.class);
    }

    public ActionForward updateAnswerToNewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodToCallStart = "methodToCall.updateAnswerToNewVersion.";
        String methodToCallEnd = ".line";
        String methodToCall = (String)request.getAttribute("methodToCallAttribute");
        String questionnaireHelperPath = methodToCall.substring(methodToCallStart.length(), methodToCall.indexOf(methodToCallEnd));
        QuestionnaireHelperBase helper = (QuestionnaireHelperBase)PropertyUtils.getNestedProperty((Object)form, (String)questionnaireHelperPath);
        helper.updateQuestionnaireAnswer(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        if (request.getParameter("refreshCaller") != null && request.getParameter("refreshCaller").toString().equals("kualiLookupable")) {
            for (Object obj : request.getParameterMap().keySet()) {
                if (StringUtils.indexOf((String)((String)obj), (String)((CoiDisclosureForm)form).getQuestionnaireFieldStarter()) != 0) continue;
                ((CoiDisclosureForm)form).getDisclosureQuestionnaireHelper().updateChildIndicator(Integer.parseInt(StringUtils.substringBetween((String)((String)obj), (String)((CoiDisclosureForm)form).getQuestionnaireFieldStarter(), (String)"].answers[")));
            }
        }
        return forward;
    }

    private boolean isMasterDisclosureExist() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", GlobalVariables.getUserSession().getPrincipalId());
        fieldValues.put("currentDisclosure", "Y");
        List disclosures = (List)this.getBusinessObjectService().findMatching(CoiDisclosure.class, fieldValues);
        return !CollectionUtils.isEmpty((Collection)disclosures);
    }

    private CoiDisclosure getExistingDisclosure(String eventTypeCode) {
        CoiDisclosure updateMaster = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", GlobalVariables.getUserSession().getPrincipalId());
        fieldValues.put("eventTypeCode", eventTypeCode);
        List disclosures = (List)this.getBusinessObjectService().findMatchingOrderBy(CoiDisclosure.class, fieldValues, "sequenceNumber", false);
        if (!CollectionUtils.isEmpty((Collection)disclosures)) {
            for (CoiDisclosure disc : disclosures) {
                if (StringUtils.equals((String)disc.getDisclosureStatusCode(), (String)"3") || StringUtils.equals((String)disc.getDisclosureStatusCode(), (String)"4")) continue;
                updateMaster = disc;
                break;
            }
        }
        return updateMaster;
    }

    public ActionForward viewDisclosureNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        String notificationId = request.getParameter("notificationId");
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("notificationId", notificationId);
        List notifications = (List)this.getBusinessObjectService().findMatching(CoiNotification.class, fieldValues);
        coiDisclosureForm.getDisclosureHelper().setViewNotification((CoiNotification)((Object)notifications.get(0)));
        return mapping.findForward("viewNotification");
    }
}

