/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.CoiDisclosureHistory;
import org.kuali.kra.coi.CoiDisclosureUndisclosedEvents;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.coi.CoiUserRole;
import org.kuali.kra.coi.DisclosureReporter;
import org.kuali.kra.coi.DisclosureReporterUnit;
import org.kuali.kra.coi.disclosure.CoiDisclEventProject;
import org.kuali.kra.coi.disclosure.CoiDisclosedProjectBean;
import org.kuali.kra.coi.disclosure.CoiDisclosureProjectBean;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.coi.disclosure.CoiGroupedMasterDisclosureBean;
import org.kuali.kra.coi.disclosure.CoiProjectsToCompleteDisclosureBean;
import org.kuali.kra.coi.disclosure.DisclosureHelper;
import org.kuali.kra.coi.disclosure.DisclosurePerson;
import org.kuali.kra.coi.disclosure.DisclosurePersonUnit;
import org.kuali.kra.coi.disclosure.MasterDisclosureBean;
import org.kuali.kra.coi.lookup.dao.CoiDisclosureDao;
import org.kuali.kra.coi.lookup.dao.CoiDisclosureUndisclosedEventsDao;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.notesandattachments.notes.CoiDisclosureNotepad;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityService;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.personnel.IacucProtocolPerson;
import org.kuali.kra.iacuc.protocol.IacucProtocolType;
import org.kuali.kra.infrastructure.DisclosureEventTypeConstants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.protocol.ProtocolType;
import org.kuali.kra.krms.service.KrmsRulesExecutionService;
import org.kuali.kra.medusa.MedusaNode;
import org.kuali.kra.medusa.service.MedusaService;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class CoiDisclosureServiceImpl
implements CoiDisclosureService {
    private BusinessObjectService businessObjectService;
    private KcPersonService kcPersonService;
    private FinancialEntityService financialEntityService;
    private ProtocolFinderDao protocolFinderDao;
    private VersioningService versioningService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;
    private CoiDisclosureDao coiDisclosureDao;
    private CoiDisclosureUndisclosedEventsDao coiDisclosureUndisclosedEventsDao;
    private MedusaService medusaService;
    private KrmsRulesExecutionService krmsRulesExecutionService;
    private static final String PROTOCOL_DISCLOSE_STATUS_CODES = "PROTOCOL_DISCLOSE_STATUS_CODES";
    private static final String IACUC_DISCLOSE_STATUS_CODES = "IACUC_DISCLOSE_STATUS_CODES";
    private static final String PROPOSAL_DISCLOSE_STATUS_CODES = "PROPOSAL_DISCLOSE_STATUS_CODES";
    private static final String INSTITUTIONAL_PROPOSAL_DISCLOSE_STATUS_CODES = "INSTITUTIONAL_PROPOSAL_DISCLOSE_STATUS_CODES";
    private static final String AWARD_DISCLOSE_STATUS_CODES = "AWARD_DISCLOSE_STATUS_CODES";
    private static final String SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE = "SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE";
    private static final String SPONSORS_FOR_PROTOCOL_DISCLOSE = "SPONSORS_FOR_PROTOCOL_DISCLOSE";
    private static final String ALL_SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE = "ALL_SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE";
    private static final String ALL_SPONSORS_FOR_PROTOCOL_DISCLOSE = "ALL_SPONSORS_FOR_PROTOCOL_DISCLOSE";
    private static final String ALL_SPONSORS_FOR_IACUC_PROTOCOL_DISCLOSE = "ALL_SPONSORS_FOR_IACUC_PROTOCOL_DISCLOSE";
    private static Map<String, String> eventModuleMap = new HashMap<String, String>();
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private static final String MODULE_SUB_ITEM_KEY = "moduleSubItemKey";

    @Override
    public DisclosurePerson getDisclosureReporter(String personId, Long coiDisclosureId) {
        List reporters = new ArrayList();
        if (coiDisclosureId != null) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("personId", personId);
            fieldValues.put("personRoleId", "COIR");
            fieldValues.put("coiDisclosureId", coiDisclosureId);
            reporters = (List)this.businessObjectService.findMatching(DisclosurePerson.class, fieldValues);
        }
        if (reporters.isEmpty()) {
            DisclosurePerson reporter = new DisclosurePerson();
            reporter.setDisclosurePersonUnits(new ArrayList<DisclosurePersonUnit>());
            reporter.setPersonId(personId);
            reporter.setPersonRoleId("COIR");
            DisclosurePersonUnit leadUnit = this.createLeadUnit(personId);
            if (leadUnit != null) {
                reporter.getDisclosurePersonUnits().add(leadUnit);
            }
            return reporter;
        }
        int i = 0;
        for (DisclosurePersonUnit disclosurePersonUnit : ((DisclosurePerson)reporters.get(0)).getDisclosurePersonUnits()) {
            if (disclosurePersonUnit.isLeadUnitFlag()) {
                ((DisclosurePerson)reporters.get(0)).setSelectedUnit(i);
                break;
            }
            ++i;
        }
        return (DisclosurePerson)reporters.get(0);
    }

    @Override
    public void addDisclosureReporterUnit(DisclosureReporter disclosureReporter, DisclosureReporterUnit newDisclosureReporterUnit) {
        List<? extends DisclosureReporterUnit> disclosureReporterUnits = disclosureReporter.getDisclosureReporterUnits();
        if (newDisclosureReporterUnit.isLeadUnitFlag()) {
            this.resetLeadUnit(disclosureReporterUnits);
            disclosureReporter.setSelectedUnit(disclosureReporterUnits.size());
        }
        disclosureReporterUnits.add(newDisclosureReporterUnit);
    }

    @Override
    public void deleteDisclosureReporterUnit(DisclosureReporter disclosureReporter, List<? extends DisclosureReporterUnit> deletedUnits, int unitIndex) {
        List<? extends DisclosureReporterUnit> disclosureReporterUnits = disclosureReporter.getDisclosureReporterUnits();
        DisclosureReporterUnit deletedUnit = disclosureReporterUnits.get(unitIndex);
        if (deletedUnit.getReporterUnitId() != null) {
            deletedUnits.add(deletedUnit);
        }
        disclosureReporterUnits.remove(unitIndex);
        if (deletedUnit.isLeadUnitFlag() && !disclosureReporterUnits.isEmpty()) {
            disclosureReporterUnits.get(0).setLeadUnitFlag(true);
            disclosureReporter.setSelectedUnit(0);
        }
    }

    @Override
    public void resetLeadUnit(DisclosureReporter disclosureReporter) {
        List<? extends DisclosureReporterUnit> disclosureReporterUnits = disclosureReporter.getDisclosureReporterUnits();
        if (CollectionUtils.isNotEmpty(disclosureReporterUnits)) {
            this.resetLeadUnit(disclosureReporterUnits);
            disclosureReporterUnits.get(disclosureReporter.getSelectedUnit()).setLeadUnitFlag(true);
        }
    }

    @Override
    public boolean setDisclProjectForSave(CoiDisclosure coiDisclosure, MasterDisclosureBean masterDisclosureBean) {
        coiDisclosure.setCoiDisclProjects(new ArrayList<CoiDisclProject>());
        if (masterDisclosureBean != null) {
            for (List<CoiDisclosureProjectBean> projects : masterDisclosureBean.getProjectLists()) {
                for (CoiDisclosureProjectBean coiDisclProject : projects) {
                    coiDisclosure.getCoiDisclProjects().add(coiDisclProject.getCoiDisclProject());
                }
            }
            return true;
        }
        return false;
    }

    private void resetLeadUnit(List<? extends DisclosureReporterUnit> disclosureReporterUnits) {
        for (DisclosureReporterUnit disclosureReporterUnit : disclosureReporterUnits) {
            disclosureReporterUnit.setLeadUnitFlag(false);
        }
    }

    private DisclosurePersonUnit createLeadUnit(String personId) {
        DisclosurePersonUnit leadUnit = null;
        KcPerson kcPerson = this.kcPersonService.getKcPersonByPersonId(personId);
        if (kcPerson != null && kcPerson.getUnit() != null) {
            leadUnit = new DisclosurePersonUnit();
            leadUnit.setLeadUnitFlag(true);
            leadUnit.setUnitNumber(kcPerson.getUnit().getUnitNumber());
            leadUnit.setUnitName(kcPerson.getUnit().getUnitName());
            leadUnit.setPersonId(personId);
        }
        return leadUnit;
    }

    @Override
    public void initializeDisclosureDetails(CoiDisclosure coiDisclosure) {
        ArrayList<CoiDisclProject> coiDisclProjects = new ArrayList<CoiDisclProject>();
        List<PersonFinIntDisclosure> financialEntities = this.financialEntityService.getFinancialEntities(GlobalVariables.getUserSession().getPrincipalId(), true);
        if (coiDisclosure.isProtocolEvent() || coiDisclosure.isAnnualEvent()) {
            this.initProtocols(coiDisclProjects, financialEntities, coiDisclosure);
        }
        if (coiDisclosure.isIacucProtocolEvent() || coiDisclosure.isAnnualEvent()) {
            this.initIacucProtocols(coiDisclProjects, financialEntities, coiDisclosure);
        }
        if (coiDisclosure.isProposalEvent() || coiDisclosure.isAnnualEvent()) {
            this.initProposals(coiDisclProjects, financialEntities, coiDisclosure);
        }
        if (coiDisclosure.isInstitutionalProposalEvent() || coiDisclosure.isAnnualEvent()) {
            this.initInstitutionalProposals(coiDisclProjects, financialEntities, coiDisclosure);
        }
        if (coiDisclosure.isAwardEvent() || coiDisclosure.isAnnualEvent()) {
            this.initAwards(coiDisclProjects, financialEntities, coiDisclosure);
        }
        coiDisclosure.setCoiDisclProjects(coiDisclProjects);
    }

    private void initProtocols(List<CoiDisclProject> coiDisclProjects, List<PersonFinIntDisclosure> financialEntities, CoiDisclosure coiDisclosure) {
        List<Protocol> protocols = this.getProtocols(GlobalVariables.getUserSession().getPrincipalId());
        for (Protocol protocol : protocols) {
            CoiDisclProject coiDisclProject = this.createNewCoiDisclProject(coiDisclosure, "3");
            coiDisclProject.setProtocolType((ProtocolType)protocol.getProtocolType());
            coiDisclProject.setCoiProjectId(protocol.getProtocolId().toString());
            coiDisclProject.setModuleItemKey(protocol.getProtocolNumber());
            coiDisclProject.setCoiProjectTitle(protocol.getTitle());
            for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
                CoiDiscDetail disclosureDetail = this.createNewCoiDiscDetail(coiDisclosure, personFinIntDisclosure, protocol.getProtocolNumber(), protocol.getProtocolId().toString(), "3");
                coiDisclProject.getCoiDiscDetails().add(disclosureDetail);
            }
            coiDisclProjects.add(coiDisclProject);
        }
    }

    private void initIacucProtocols(List<CoiDisclProject> coiDisclProjects, List<PersonFinIntDisclosure> financialEntities, CoiDisclosure coiDisclosure) {
        List<IacucProtocol> protocols = this.getIacucProtocols(GlobalVariables.getUserSession().getPrincipalId());
        for (IacucProtocol protocol : protocols) {
            CoiDisclProject coiDisclProject = this.createNewCoiDisclProject(coiDisclosure, "4");
            coiDisclProject.setIacucProtocolType((IacucProtocolType)protocol.getProtocolType());
            coiDisclProject.setCoiProjectId(protocol.getProtocolId().toString());
            coiDisclProject.setModuleItemKey(protocol.getProtocolNumber());
            coiDisclProject.setCoiProjectTitle(protocol.getTitle());
            for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
                CoiDiscDetail disclosureDetail = this.createNewCoiDiscDetail(coiDisclosure, personFinIntDisclosure, protocol.getProtocolNumber(), protocol.getProtocolId().toString(), "4");
                coiDisclProject.getCoiDiscDetails().add(disclosureDetail);
            }
            coiDisclProjects.add(coiDisclProject);
        }
    }

    private void initProposals(List<CoiDisclProject> coiDisclProjects, List<PersonFinIntDisclosure> financialEntities, CoiDisclosure coiDisclosure) {
        List<DevelopmentProposal> proposals = this.getProposals(GlobalVariables.getUserSession().getPrincipalId());
        for (DevelopmentProposal proposal : proposals) {
            CoiDisclProject coiDisclProject = this.createNewCoiDisclProject(coiDisclosure, "2");
            coiDisclProject.setProposalType(proposal.getProposalType());
            coiDisclProject.setCoiProjectId(proposal.getProposalNumber());
            coiDisclProject.setModuleItemKey(proposal.getProposalNumber());
            coiDisclProject.setCoiProjectTitle(proposal.getTitle());
            for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
                CoiDiscDetail disclosureDetail = this.createNewCoiDiscDetail(coiDisclosure, personFinIntDisclosure, proposal.getProposalNumber(), proposal.getProposalNumber(), "2");
                coiDisclProject.getCoiDiscDetails().add(disclosureDetail);
            }
            coiDisclProjects.add(coiDisclProject);
        }
    }

    private void initInstitutionalProposals(List<CoiDisclProject> coiDisclProjects, List<PersonFinIntDisclosure> financialEntities, CoiDisclosure coiDisclosure) {
        List<InstitutionalProposal> iProposals = this.getInstitutionalProposals(GlobalVariables.getUserSession().getPrincipalId());
        for (InstitutionalProposal proposal : iProposals) {
            CoiDisclProject coiDisclProject = this.createNewCoiDisclProject(coiDisclosure, "10");
            coiDisclProject.setProposalType(proposal.getProposalType());
            coiDisclProject.setCoiProjectId(proposal.getProposalId().toString());
            coiDisclProject.setModuleItemKey(proposal.getProposalNumber());
            coiDisclProject.setCoiProjectTitle(proposal.getTitle());
            for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
                CoiDiscDetail disclosureDetail = this.createNewCoiDiscDetail(coiDisclosure, personFinIntDisclosure, proposal.getProposalNumber(), proposal.getProposalId().toString(), "10");
                coiDisclProject.getCoiDiscDetails().add(disclosureDetail);
            }
            coiDisclProjects.add(coiDisclProject);
        }
    }

    private void initAwards(List<CoiDisclProject> coiDisclProjects, List<PersonFinIntDisclosure> financialEntities, CoiDisclosure coiDisclosure) {
        List<Award> awards = this.getAwards(GlobalVariables.getUserSession().getPrincipalId());
        ArrayList<String> rootAwardNumbers = new ArrayList<String>();
        for (Award award : awards) {
            if (this.isAwardHierarchyIncluded(rootAwardNumbers, award)) continue;
            CoiDisclProject coiDisclProject = this.createNewCoiDisclProject(coiDisclosure, "1");
            coiDisclProject.setCoiProjectId(award.getAwardId().toString());
            coiDisclProject.setModuleItemKey(award.getAwardNumber());
            coiDisclProject.setCoiProjectTitle(award.getTitle());
            for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
                CoiDiscDetail disclosureDetail = this.createNewCoiDiscDetail(coiDisclosure, personFinIntDisclosure, award.getAwardNumber(), award.getAwardId().toString(), "1");
                coiDisclProject.getCoiDiscDetails().add(disclosureDetail);
            }
            coiDisclProjects.add(coiDisclProject);
        }
    }

    private boolean isAwardHierarchyIncluded(List<String> rootAwardNumbers, Award award) {
        boolean isIncluded = true;
        if (rootAwardNumbers.isEmpty()) {
            String rootAwardNumber = this.getRootAwardNumber(award.getAwardNumber());
            if (StringUtils.isNotBlank((String)rootAwardNumber)) {
                rootAwardNumbers.add(rootAwardNumber);
            }
            isIncluded = false;
        } else {
            String rootAwardNumber = this.getRootAwardNumber(award.getAwardNumber());
            if (StringUtils.isNotBlank((String)rootAwardNumber) && !rootAwardNumbers.contains(rootAwardNumber)) {
                rootAwardNumbers.add(rootAwardNumber);
                isIncluded = false;
            }
            if (StringUtils.isBlank((String)rootAwardNumber)) {
                isIncluded = false;
            }
        }
        return isIncluded;
    }

    private String getRootAwardNumber(String awardNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("awardNumber", awardNumber);
        List awardHierarchies = (List)this.businessObjectService.findMatching(AwardHierarchy.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)awardHierarchies)) {
            return ((AwardHierarchy)awardHierarchies.get(0)).getRootAwardNumber();
        }
        return null;
    }

    @Override
    public void initializeDisclosureDetails(CoiDisclProject coiDisclProject) {
        ArrayList<CoiDiscDetail> disclosureDetails = new ArrayList<CoiDiscDetail>();
        List<PersonFinIntDisclosure> financialEntities = this.financialEntityService.getFinancialEntities(coiDisclProject.getCoiDisclosure().getPersonId(), true);
        for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
            CoiDiscDetail disclosureDetail = this.createNewCoiDiscDetail(coiDisclProject.getCoiDisclosure(), personFinIntDisclosure, coiDisclProject.getProjectId(), coiDisclProject.getProjectId(), coiDisclProject.getDisclosureEventType());
            disclosureDetail.setCoiDisclProject(coiDisclProject);
            disclosureDetail.setProjectType(coiDisclProject.getDisclosureEventType());
            disclosureDetails.add(disclosureDetail);
        }
        coiDisclProject.setCoiDiscDetails(disclosureDetails);
    }

    private String getModuleItemKey(CoiDisclosure coiDisclosure, KraPersistableBusinessObjectBase eventBo) {
        String moduleItemKey = null;
        if (coiDisclosure.isProtocolEvent()) {
            moduleItemKey = ((Protocol)eventBo).getProtocolNumber();
        } else if (coiDisclosure.isIacucProtocolEvent()) {
            moduleItemKey = ((IacucProtocol)eventBo).getProtocolNumber();
        } else if (coiDisclosure.isProposalEvent()) {
            moduleItemKey = ((DevelopmentProposal)eventBo).getProposalNumber();
        } else if (coiDisclosure.isInstitutionalProposalEvent()) {
            moduleItemKey = ((InstitutionalProposal)eventBo).getProposalNumber();
        } else if (coiDisclosure.isAwardEvent()) {
            moduleItemKey = ((Award)eventBo).getAwardNumber();
        }
        return moduleItemKey;
    }

    private String getProjectIdFk(CoiDisclosure coiDisclosure, KraPersistableBusinessObjectBase eventBo) {
        String projectIdFk = null;
        if (coiDisclosure.isProtocolEvent()) {
            projectIdFk = ((Protocol)eventBo).getProtocolId().toString();
        } else if (coiDisclosure.isIacucProtocolEvent()) {
            projectIdFk = ((IacucProtocol)eventBo).getProtocolId().toString();
        } else if (coiDisclosure.isProposalEvent()) {
            projectIdFk = ((DevelopmentProposal)eventBo).getProposalNumber();
        } else if (coiDisclosure.isInstitutionalProposalEvent()) {
            projectIdFk = ((InstitutionalProposal)eventBo).getProposalId().toString();
        } else if (coiDisclosure.isAwardEvent()) {
            projectIdFk = ((Award)eventBo).getAwardId().toString();
        }
        return projectIdFk;
    }

    private String getProjectTitle(CoiDisclosure coiDisclosure, KraPersistableBusinessObjectBase eventBo) {
        String projectTitle = null;
        if (coiDisclosure.isProtocolEvent()) {
            projectTitle = ((Protocol)eventBo).getTitle();
        } else if (coiDisclosure.isIacucProtocolEvent()) {
            projectTitle = ((IacucProtocol)eventBo).getTitle();
        } else if (coiDisclosure.isProposalEvent()) {
            projectTitle = ((DevelopmentProposal)eventBo).getTitle();
        } else if (coiDisclosure.isInstitutionalProposalEvent()) {
            projectTitle = ((InstitutionalProposal)eventBo).getTitle();
        } else if (coiDisclosure.isAwardEvent()) {
            projectTitle = ((Award)eventBo).getTitle();
        }
        return projectTitle;
    }

    private KraPersistableBusinessObjectBase getEventBo(CoiDisclosure coiDisclosure, String projectId) {
        KraPersistableBusinessObjectBase eventBo = null;
        if (coiDisclosure.isProtocolEvent()) {
            eventBo = this.getProtocol(Long.valueOf(projectId));
        } else if (coiDisclosure.isIacucProtocolEvent()) {
            eventBo = this.getIacucProtocol(Long.valueOf(projectId));
        } else if (coiDisclosure.isProposalEvent()) {
            eventBo = this.getDevelopmentProposal(projectId);
        } else if (coiDisclosure.isInstitutionalProposalEvent()) {
            eventBo = this.getInstitutionalProposal(projectId);
        } else if (coiDisclosure.isAwardEvent()) {
            eventBo = this.getAwardById(projectId);
        }
        return eventBo;
    }

    private KraPersistableBusinessObjectBase getEventBo(CoiDiscDetail coiDiscdetail, String projectId) {
        KraPersistableBusinessObjectBase eventBo = null;
        if (coiDiscdetail.isProtocolEvent()) {
            eventBo = this.getProtocol(Long.valueOf(projectId));
        } else if (coiDiscdetail.isIacucProtocolEvent()) {
            eventBo = this.getIacucProtocol(Long.valueOf(projectId));
        } else if (coiDiscdetail.isProposalEvent()) {
            eventBo = this.getDevelopmentProposal(projectId);
        } else if (coiDiscdetail.isInstitutionalProposalEvent()) {
            eventBo = this.getInstitutionalProposal(projectId);
        } else if (coiDiscdetail.isAwardEvent()) {
            eventBo = this.getAwardById(projectId);
        }
        return eventBo;
    }

    private Protocol getProtocol(Long protocolId) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("protocolId", protocolId);
        return (Protocol)this.businessObjectService.findByPrimaryKey(Protocol.class, pkMap);
    }

    private IacucProtocol getIacucProtocol(Long protocolId) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("protocolId", protocolId);
        return (IacucProtocol)this.businessObjectService.findByPrimaryKey(IacucProtocol.class, pkMap);
    }

    private void checkToAddNewFinancialEntity(List<PersonFinIntDisclosure> financialEntities, List<CoiDiscDetail> coiDiscDetails, List<String> disclEntityNumbers, String projectId, CoiDisclosure coiDisclosure, String projectType, String projectIdFk) {
        for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
            if (disclEntityNumbers.contains(personFinIntDisclosure.getEntityNumber())) continue;
            coiDiscDetails.add(this.createNewCoiDiscDetail(coiDisclosure, personFinIntDisclosure, projectId, projectIdFk, projectType));
        }
    }

    private void getCurrentFinancialEntity(CoiDiscDetail coiDiscDetail) {
        if (!coiDiscDetail.getPersonFinIntDisclosure().isCurrentFlag()) {
            PersonFinIntDisclosure financialEntity = this.financialEntityService.getCurrentFinancialEntities(coiDiscDetail.getPersonFinIntDisclosure().getEntityNumber());
            coiDiscDetail.setEntitySequenceNumber(financialEntity.getSequenceNumber());
            coiDiscDetail.setPersonFinIntDisclosureId(financialEntity.getPersonFinIntDisclosureId());
            coiDiscDetail.setPersonFinIntDisclosure(financialEntity);
        }
    }

    private CoiDisclEventProject getEventBo(CoiDisclosure coiDisclosure, CoiDiscDetail coiDiscDetail) {
        CoiDisclEventProject coiDisclEventProject = new CoiDisclEventProject();
        if (coiDisclosure.isProtocolEvent()) {
            Protocol protocol = this.protocolFinderDao.findCurrentProtocolByNumber(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("3", protocol, new ArrayList<CoiDiscDetail>());
            coiDisclosure.setEventBo(protocol);
        } else if (coiDisclosure.isProposalEvent()) {
            DevelopmentProposal proposal = this.getDevelopmentProposal(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("2", proposal, new ArrayList<CoiDiscDetail>());
            coiDisclosure.setEventBo(proposal);
        } else if (coiDisclosure.isInstitutionalProposalEvent()) {
            InstitutionalProposal proposal = this.getInstitutionalProposal(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("10", proposal, new ArrayList<CoiDiscDetail>());
            coiDisclosure.setEventBo(proposal);
        } else if (coiDisclosure.isAwardEvent()) {
            Award award = this.getAward(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("1", award, new ArrayList<CoiDiscDetail>());
            coiDisclosure.setEventBo(award);
        }
        return coiDisclEventProject;
    }

    private CoiDisclEventProject getEventBoForAnnualDiscl(CoiDisclosure coiDisclosure, CoiDiscDetail coiDiscDetail) {
        CoiDisclEventProject coiDisclEventProject = new CoiDisclEventProject();
        if (coiDiscDetail.isProtocolEvent()) {
            Protocol protocol = this.protocolFinderDao.findCurrentProtocolByNumber(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("3", protocol, new ArrayList<CoiDiscDetail>());
        } else if (coiDiscDetail.isProposalEvent()) {
            DevelopmentProposal proposal = this.getDevelopmentProposal(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("2", proposal, new ArrayList<CoiDiscDetail>());
        } else if (coiDiscDetail.isInstitutionalProposalEvent()) {
            InstitutionalProposal proposal = this.getInstitutionalProposal(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("10", proposal, new ArrayList<CoiDiscDetail>());
        } else {
            Award award = this.getAward(coiDiscDetail.getModuleItemKey());
            coiDisclEventProject = new CoiDisclEventProject("1", award, new ArrayList<CoiDiscDetail>());
        }
        return coiDisclEventProject;
    }

    private Award getAwardById(String awardId) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("awardId", awardId);
        return (Award)this.businessObjectService.findByPrimaryKey(Award.class, values);
    }

    private Award getAward(String awardNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("awardNumber", awardNumber);
        List awards = (List)this.businessObjectService.findMatchingOrderBy(Award.class, values, "sequenceNumber", false);
        return (Award)awards.get(0);
    }

    private DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        DevelopmentProposal currentProposal = (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, primaryKeys);
        return currentProposal;
    }

    private InstitutionalProposal getInstitutionalProposal(String proposalNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalId", proposalNumber);
        InstitutionalProposal currentProposal = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, primaryKeys);
        return currentProposal;
    }

    @Override
    public void updateDisclosureDetails(CoiDisclProject coiDisclProject) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("coiDisclProjectId", coiDisclProject.getCoiDisclProjectsId());
        ArrayList<String> disclEntityNumbers = new ArrayList<String>();
        ArrayList<CoiDiscDetail> activeDetails = new ArrayList<CoiDiscDetail>();
        List coiDiscDetails = (List)this.businessObjectService.findMatching(CoiDiscDetail.class, fieldValues);
        String personId = coiDisclProject.getCoiDisclosure().getPersonId();
        List<PersonFinIntDisclosure> financialEntities = this.financialEntityService.getFinancialEntities(personId, true);
        for (CoiDiscDetail coiDiscDetail : coiDiscDetails) {
            this.getCurrentFinancialEntity(coiDiscDetail);
            if (!coiDiscDetail.getPersonFinIntDisclosure().isStatusActive()) continue;
            if (!disclEntityNumbers.contains(coiDiscDetail.getPersonFinIntDisclosure().getEntityNumber())) {
                disclEntityNumbers.add(coiDiscDetail.getPersonFinIntDisclosure().getEntityNumber());
            }
            activeDetails.add(coiDiscDetail);
        }
        this.checkToAddNewFinancialEntity(financialEntities, activeDetails, disclEntityNumbers, coiDisclProject.getProjectId().toString(), coiDisclProject.getCoiDisclosure(), coiDisclProject.getDisclosureEventType(), coiDisclProject.getProjectId());
        coiDisclProject.setCoiDiscDetails(activeDetails);
    }

    private CoiDisclProject createNewCoiDisclProject(CoiDisclosure coiDisclosure, String disclosureEventType) {
        CoiDisclProject coiDisclProject = new CoiDisclProject();
        coiDisclProject.setDisclosureEventType(disclosureEventType);
        coiDisclProject.refreshReferenceObject("coiDisclosureEventType");
        coiDisclProject.setCoiDisclosure(coiDisclosure);
        coiDisclProject.setCoiDisclosureId(coiDisclosure.getCoiDisclosureId());
        coiDisclProject.setCoiDisclosureNumber(coiDisclosure.getCoiDisclosureNumber());
        coiDisclProject.setSequenceNumber(coiDisclosure.getSequenceNumber());
        coiDisclProject.setCoiDiscDetails(new ArrayList<CoiDiscDetail>());
        coiDisclProject.setDisclosureStatusCode("1");
        coiDisclProject.setDisclosureDispositionCode("100");
        coiDisclProject.refreshReferenceObject("coiDispositionStatus");
        return coiDisclProject;
    }

    private CoiDiscDetail createNewCoiDiscDetail(CoiDisclosure coiDisclosure, PersonFinIntDisclosure personFinIntDisclosure, String moduleItemKey, String projectIdFk, String projectType) {
        CoiDiscDetail disclosureDetail = new CoiDiscDetail(personFinIntDisclosure);
        disclosureDetail.setModuleItemKey(moduleItemKey);
        disclosureDetail.setProjectIdFk(projectIdFk);
        disclosureDetail.setProjectType(projectType);
        disclosureDetail.setModuleCode(eventModuleMap.get(projectType));
        coiDisclosure.initCoiDisclosureNumber();
        disclosureDetail.setCoiDisclosureNumber(coiDisclosure.getCoiDisclosureNumber());
        disclosureDetail.setCoiDisclosureId(coiDisclosure.getCoiDisclosureId());
        disclosureDetail.setSequenceNumber(coiDisclosure.getSequenceNumber());
        disclosureDetail.setDescription("Sample Description");
        return disclosureDetail;
    }

    @Override
    public List<Protocol> getProtocols(String personId) {
        return this.getProtocols(this.getProtocolPersons(personId));
    }

    private List<ProtocolPerson> getProtocolPersons(String personId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        List protocolPersons = (List)this.businessObjectService.findMatching(ProtocolPerson.class, fieldValues);
        return protocolPersons;
    }

    private List<Protocol> getProtocols(List<ProtocolPerson> protocolPersons) {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        for (ProtocolPerson protocolPerson : protocolPersons) {
            if (!protocolPerson.getProtocol().isActive() || !this.isProtocolDisclosurable((Protocol)protocolPerson.getProtocol()) || this.isProjectReported(protocolPerson.getProtocol().getProtocolNumber(), "3", protocolPerson.getPersonId())) continue;
            protocols.add((Protocol)protocolPerson.getProtocol());
        }
        return protocols;
    }

    @Override
    public List<IacucProtocol> getIacucProtocols(String personId) {
        return this.getIacucProtocols(this.getIacucProtocolPersons(personId));
    }

    private List<IacucProtocolPerson> getIacucProtocolPersons(String personId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        List protocolPersons = (List)this.businessObjectService.findMatching(IacucProtocolPerson.class, fieldValues);
        return protocolPersons;
    }

    private List<IacucProtocol> getIacucProtocols(List<IacucProtocolPerson> protocolPersons) {
        ArrayList<IacucProtocol> protocols = new ArrayList<IacucProtocol>();
        for (IacucProtocolPerson protocolPerson : protocolPersons) {
            if (!protocolPerson.getProtocol().isActive() || !this.isIacucProtocolDisclosurable(protocolPerson.getIacucProtocol()) || this.isProjectReported(protocolPerson.getProtocol().getProtocolNumber(), "4", protocolPerson.getPersonId())) continue;
            protocols.add(protocolPerson.getIacucProtocol());
        }
        return protocols;
    }

    @Override
    public List<DevelopmentProposal> getProposals(String personId) {
        return this.getProposals(this.getProposalPersons(personId));
    }

    private List<ProposalPerson> getProposalPersons(String personId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        List proposalPersons = (List)this.businessObjectService.findMatching(ProposalPerson.class, fieldValues);
        return proposalPersons;
    }

    private List<DevelopmentProposal> getProposals(List<ProposalPerson> proposalPersons) {
        ArrayList<DevelopmentProposal> proposals = new ArrayList<DevelopmentProposal>();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!this.isProposalDisclosurable(proposalPerson.getDevelopmentProposal()) || this.isProjectReported(proposalPerson.getDevelopmentProposal().getProposalNumber(), "2", proposalPerson.getPersonId())) continue;
            proposals.add(proposalPerson.getDevelopmentProposal());
        }
        return proposals;
    }

    private boolean isEventExcluded(String eventTypeCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("eventTypeCode", eventTypeCode);
        CoiDisclosureEventType CoiDisclosureEventType2 = (CoiDisclosureEventType)this.businessObjectService.findByPrimaryKey(CoiDisclosureEventType.class, fieldValues);
        return CoiDisclosureEventType2.isExcludeFromMasterDisclosure();
    }

    @Override
    public List<InstitutionalProposal> getInstitutionalProposals(String personId) {
        return this.getInstitutionalProposals(this.getInstituteProposalPersons(personId));
    }

    private List<InstitutionalProposalPerson> getInstituteProposalPersons(String personId) {
        HashMap<String, String> propFieldValues = new HashMap<String, String>();
        propFieldValues.put("personId", personId);
        List proposalPersons = (List)this.businessObjectService.findMatching(InstitutionalProposalPerson.class, propFieldValues);
        return proposalPersons;
    }

    private List<InstitutionalProposal> getInstitutionalProposals(List<InstitutionalProposalPerson> proposalPersons) {
        ArrayList<InstitutionalProposal> proposals = new ArrayList<InstitutionalProposal>();
        HashMap<String, Integer> propNumbers = new HashMap<String, Integer>();
        HashMap<String, String> propPerson = new HashMap<String, String>();
        for (InstitutionalProposalPerson proposalPerson : proposalPersons) {
            Integer newSequenceNumber = proposalPerson.getSequenceNumber();
            Integer oldSequenceNumber = (Integer)propNumbers.get(proposalPerson.getProposalNumber());
            if (oldSequenceNumber != null && oldSequenceNumber.compareTo(newSequenceNumber) >= 0) continue;
            propNumbers.put(proposalPerson.getProposalNumber(), newSequenceNumber);
            propPerson.put(proposalPerson.getProposalNumber(), proposalPerson.getPersonId());
        }
        for (String propNumber : propNumbers.keySet()) {
            HashMap<String, String> ipFieldValues = new HashMap<String, String>();
            ipFieldValues.put("proposalNumber", propNumber);
            ipFieldValues.put("sequenceNumber", (String)propNumbers.get(propNumber));
            String personId = (String)propPerson.get(propNumber);
            List searchResults = (List)this.businessObjectService.findMatching(InstitutionalProposal.class, ipFieldValues);
            for (InstitutionalProposal institutionalProposal : searchResults) {
                if (!this.isInstitutionalProposalDisclosurable(institutionalProposal) || this.isProjectReported(institutionalProposal.getProposalNumber(), "10", personId)) continue;
                proposals.add(institutionalProposal);
            }
        }
        return proposals;
    }

    @Override
    public List<Award> getAwards(String personId) {
        return this.getAwards(this.getAwardPersons(personId));
    }

    private List<AwardPerson> getAwardPersons(String personId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        List awardPersons = (List)this.businessObjectService.findMatchingOrderBy(AwardPerson.class, fieldValues, "awardNumber", true);
        return awardPersons;
    }

    private List<Award> getAwards(List<AwardPerson> awardPersons) {
        ArrayList<Award> awards = new ArrayList<Award>();
        for (AwardPerson awardPerson : awardPersons) {
            if (!this.isCurrentAward(awardPerson.getAward()) || !this.isAwardDisclosurable(awardPerson.getAward()) || this.isProjectReported(awardPerson.getAward().getAwardNumber(), "1", awardPerson.getPersonId())) continue;
            awards.add(awardPerson.getAward());
        }
        return awards;
    }

    private boolean isCurrentAward(Award award) {
        Award currentAward = this.getAward(award.getAwardNumber());
        return award.getAwardId().equals(currentAward.getAwardId());
    }

    private boolean isProjectReported(String projectId, String projectType, String personId) {
        boolean isDisclosed = false;
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        if (StringUtils.equals((String)"1", (String)projectType)) {
            fieldValues.put(MODULE_ITEM_KEY, this.getAwardNumbersForHierarchy(projectId));
        } else {
            fieldValues.put(MODULE_ITEM_KEY, projectId);
        }
        fieldValues.put("disclosureEventType", projectType);
        List disclProjects = (List)this.businessObjectService.findMatching(CoiDisclProject.class, fieldValues);
        Date currentDate = this.dateTimeService.getCurrentSqlDateMidnight();
        for (CoiDisclProject disclProject : disclProjects) {
            if (!StringUtils.equals((String)disclProject.getCoiDisclosure().getPersonId(), (String)personId) || !disclProject.getCoiDisclosure().getExpirationDate().after(currentDate)) continue;
            isDisclosed = true;
            break;
        }
        return isDisclosed;
    }

    private List<String> getAwardNumbersForHierarchy(String projectId) {
        ArrayList<String> awardNumbers = new ArrayList<String>();
        awardNumbers.add(projectId);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("awardNumber", projectId);
        List awardHierarchies = (List)this.businessObjectService.findMatching(AwardHierarchy.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)awardHierarchies)) {
            fieldValues.clear();
            fieldValues.put("rootAwardNumber", ((AwardHierarchy)awardHierarchies.get(0)).getRootAwardNumber());
            awardHierarchies = (List)this.businessObjectService.findMatching(AwardHierarchy.class, fieldValues);
            for (AwardHierarchy awardHierarchy : awardHierarchies) {
                awardNumbers.add(awardHierarchy.getAwardNumber());
            }
        }
        return awardNumbers;
    }

    @Override
    public CoiDisclosure versionCoiDisclosure() throws VersionException {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", GlobalVariables.getUserSession().getPrincipalId());
        List disclosures = (List)this.businessObjectService.findMatchingOrderBy(CoiDisclosure.class, fieldValues, "sequenceNumber", false);
        CoiDisclosure newDisclosure = null;
        if (CollectionUtils.isNotEmpty((Collection)disclosures)) {
            newDisclosure = (CoiDisclosure)this.versioningService.createNewVersion((SequenceOwner)disclosures.get(0));
            newDisclosure.setCoiDisclProjects(null);
            newDisclosure.setCoiDisclosureAttachments(null);
            newDisclosure.setCoiDisclosureNotepads(null);
            newDisclosure.setCoiUserRoles(new ArrayList<CoiUserRole>());
            newDisclosure.setCurrentDisclosure(false);
            newDisclosure.setCertificationTimestamp(null);
            newDisclosure.setDisclosureDispositionCode("100");
            newDisclosure.setDisclosureStatusCode("1");
            newDisclosure.setExpirationDate(new Date(DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)365).getTime()));
            newDisclosure.setReviewStatusCode("1");
            newDisclosure.refreshReferenceObject("coiReviewStatus");
        }
        return newDisclosure;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public void setFinancialEntityService(FinancialEntityService financialEntityService) {
        this.financialEntityService = financialEntityService;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    private boolean isAwardDisclosurable(Award award) {
        Collection params = this.parameterService.getParameterValuesAsString(AwardDocument.class, AWARD_DISCLOSE_STATUS_CODES);
        return params.contains(award.getStatusCode().toString()) && this.isSponsorForDisclosure(ProposalDevelopmentDocument.class, award.getSponsorCode(), SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE, ALL_SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE);
    }

    private boolean isProposalDisclosurable(DevelopmentProposal proposal) {
        Collection params = this.parameterService.getParameterValuesAsString(ProposalDevelopmentDocument.class, PROPOSAL_DISCLOSE_STATUS_CODES);
        return params.contains(proposal.getProposalStateTypeCode()) && this.isSponsorForDisclosure(ProposalDevelopmentDocument.class, proposal.getSponsorCode(), SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE, ALL_SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE);
    }

    private boolean isInstitutionalProposalDisclosurable(InstitutionalProposal proposal) {
        Collection params = this.parameterService.getParameterValuesAsString(InstitutionalProposalDocument.class, INSTITUTIONAL_PROPOSAL_DISCLOSE_STATUS_CODES);
        return params.contains(proposal.getStatusCode().toString()) && this.isSponsorForDisclosure(ProposalDevelopmentDocument.class, proposal.getSponsorCode(), SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE, ALL_SPONSORS_FOR_PROPOSAL_AWD_DISCLOSE);
    }

    private boolean isProtocolDisclosurable(Protocol protocol) {
        Collection params = this.parameterService.getParameterValuesAsString(ProtocolDocument.class, PROTOCOL_DISCLOSE_STATUS_CODES);
        return params.contains(protocol.getProtocolStatusCode()) && this.isProtocolFundedByActiveSponsor(protocol);
    }

    private boolean isIacucProtocolDisclosurable(IacucProtocol protocol) {
        Collection params = this.parameterService.getParameterValuesAsString(IacucProtocolDocument.class, IACUC_DISCLOSE_STATUS_CODES);
        return params.contains(protocol.getProtocolStatusCode()) && this.isProtocolFundedByActiveSponsor(protocol);
    }

    private boolean isProtocolFundedByActiveSponsor(Protocol protocol) {
        boolean isActive = false;
        for (ProtocolFundingSourceBase fundingSource : protocol.getProtocolFundingSources()) {
            if (!fundingSource.isSponsorFunding() || !this.isSponsorForDisclosure(ProtocolDocument.class, fundingSource.getFundingSourceNumber(), SPONSORS_FOR_PROTOCOL_DISCLOSE, ALL_SPONSORS_FOR_PROTOCOL_DISCLOSE)) continue;
            isActive = true;
            break;
        }
        if (CollectionUtils.isEmpty(protocol.getProtocolFundingSources())) {
            isActive = this.isAllSponsorActiveForDisclose(ProtocolDocument.class, ALL_SPONSORS_FOR_PROTOCOL_DISCLOSE);
        }
        return isActive;
    }

    private boolean isProtocolFundedByActiveSponsor(IacucProtocol protocol) {
        boolean isActive = false;
        for (ProtocolFundingSourceBase fundingSource : protocol.getProtocolFundingSources()) {
            if (!fundingSource.isSponsorFunding() || !this.isSponsorForDisclosure(ProtocolDocument.class, fundingSource.getFundingSourceNumber(), SPONSORS_FOR_PROTOCOL_DISCLOSE, ALL_SPONSORS_FOR_PROTOCOL_DISCLOSE)) continue;
            isActive = true;
            break;
        }
        if (CollectionUtils.isEmpty(protocol.getProtocolFundingSources())) {
            isActive = this.isAllSponsorActiveForDisclose(ProtocolDocument.class, ALL_SPONSORS_FOR_IACUC_PROTOCOL_DISCLOSE);
        }
        return isActive;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    private boolean isSponsorForDisclosure(Class clazz, String sponsorCode, String paramName, String paramNameAllSponsor) {
        return this.isAllSponsorActiveForDisclose(clazz, paramNameAllSponsor) || this.isSponsorHierarchyActiveForDisclose(clazz, sponsorCode, paramName);
    }

    private boolean isSponsorHierarchyActiveForDisclose(Class clazz, String sponsorCode, String paramName) {
        Collection params = new ArrayList();
        try {
            params = this.parameterService.getParameterValuesAsString(clazz, paramName);
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> sponsorCodes = new ArrayList<String>();
        for (String hierarchyName : params) {
            List<SponsorHierarchy> sponsors = this.getAllSponsors(hierarchyName);
            for (SponsorHierarchy sponsor : sponsors) {
                sponsorCodes.add(sponsor.getSponsorCode());
            }
        }
        if (sponsorCodes.isEmpty()) {
            return true;
        }
        return sponsorCodes.contains(sponsorCode);
    }

    protected List<SponsorHierarchy> getAllSponsors(String hierarchyName) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("hierarchyName", hierarchyName);
        List sponsors = (List)this.businessObjectService.findMatching(SponsorHierarchy.class, criteria);
        return sponsors;
    }

    private boolean isAllSponsorActiveForDisclose(Class clazz, String paramName) {
        boolean isAllSponsors = false;
        try {
            isAllSponsors = this.parameterService.getParameterValueAsBoolean(clazz, paramName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return isAllSponsors;
    }

    @Override
    public boolean isReporter() {
        String personId = GlobalVariables.getUserSession().getPrincipalId();
        return this.hasExistingCoiDisclosure() || CollectionUtils.isNotEmpty(this.getProtocols(personId)) || CollectionUtils.isNotEmpty(this.getProposals(personId)) || CollectionUtils.isNotEmpty(this.getAwards(personId)) || CollectionUtils.isNotEmpty(this.getInstitutionalProposals(personId));
    }

    private boolean hasExistingCoiDisclosure() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", GlobalVariables.getUserSession().getPrincipalId());
        return this.businessObjectService.countMatching(CoiDisclosure.class, fieldValues) > 0;
    }

    @Override
    public MasterDisclosureBean getMasterDisclosureDetail(CoiDisclosure coiDisclosure) {
        MasterDisclosureBean masterDisclosureBean = new MasterDisclosureBean();
        String moduleItemKey = "";
        String projectType = "";
        CoiDisclosureProjectBean disclosureProjectBean = null;
        if (coiDisclosure.isUpdateEvent() || coiDisclosure.isAnnualEvent() && coiDisclosure.isAnnualUpdate()) {
            this.updateMasterDisclosureDetails(coiDisclosure);
        }
        ArrayList<AnswerHeader> answerHeaders = new ArrayList();
        CoiDisclosure currentDisclosure = coiDisclosure;
        boolean newMaster = false;
        if (currentDisclosure == null || currentDisclosure.getCoiDisclosureId() == null) {
            CoiDisclosure masterDisclosure;
            newMaster = true;
            currentDisclosure = masterDisclosure = this.getCurrentDisclosure();
            answerHeaders = this.copyDisclosureQuestionnaire(masterDisclosure, coiDisclosure);
        } else {
            answerHeaders = this.retrieveAnswerHeaders(coiDisclosure);
        }
        masterDisclosureBean.setAnswerHeaders(answerHeaders);
        for (CoiDisclProject coiDisclProject : coiDisclosure.getCoiDisclProjects()) {
            CoiDisclProject coiDisclProject1 = (CoiDisclProject)((Object)ObjectUtils.deepCopy((Serializable)((Object)coiDisclProject)));
            coiDisclProject1.setCoiDispositionStatus(coiDisclProject.getCoiDispositionStatus());
            if (CollectionUtils.isNotEmpty(coiDisclProject1.getCoiDiscDetails())) {
                for (CoiDiscDetail coiDiscDetail : coiDisclProject1.getCoiDiscDetails()) {
                    if (StringUtils.equals((String)projectType, (String)coiDiscDetail.getProjectType()) && StringUtils.equals((String)moduleItemKey, (String)coiDiscDetail.getModuleItemKey())) continue;
                    disclosureProjectBean = this.getCoiDisclosureProjectBean(coiDiscDetail);
                    masterDisclosureBean.addProject(disclosureProjectBean, coiDiscDetail.getProjectType());
                    if (!StringUtils.equals((String)projectType, (String)coiDiscDetail.getProjectType())) {
                        projectType = coiDiscDetail.getProjectType();
                    }
                    moduleItemKey = coiDiscDetail.getModuleItemKey();
                    this.addProjectDisclAttachments(disclosureProjectBean, coiDisclosure, coiDiscDetail.getOriginalCoiDisclosureId());
                    this.addProjectDisclNotepads(disclosureProjectBean, coiDisclosure, coiDiscDetail.getOriginalCoiDisclosureId());
                    if (newMaster) {
                        this.versionProjectDisclQuestionnaires(disclosureProjectBean, answerHeaders, currentDisclosure);
                        continue;
                    }
                    this.addProjectDisclQuestionnaires(disclosureProjectBean, answerHeaders, currentDisclosure);
                }
                continue;
            }
            disclosureProjectBean = this.getCoiDisclosureProjectBean(coiDisclProject1);
            masterDisclosureBean.addProject(disclosureProjectBean, coiDisclProject1.getDisclosureEventType());
            projectType = coiDisclProject1.getDisclosureEventType();
            moduleItemKey = coiDisclProject1.getModuleItemKey();
            if (newMaster) {
                this.versionProjectDisclQuestionnaires(disclosureProjectBean, answerHeaders, currentDisclosure);
                continue;
            }
            this.addProjectDisclQuestionnaires(disclosureProjectBean, answerHeaders, currentDisclosure);
        }
        if (coiDisclosure.isApprovedDisclosure() || coiDisclosure.isDisapprovedDisclosure() || !coiDisclosure.isUpdateEvent() && !coiDisclosure.isAnnualEvent()) {
            this.setupDisclosures(masterDisclosureBean, coiDisclosure);
        }
        this.createDisclosuresGroupedByEvent(masterDisclosureBean);
        return masterDisclosureBean;
    }

    @Override
    public void createDisclosuresGroupedByEvent(MasterDisclosureBean masterDisclosureBean) {
        ArrayList<CoiGroupedMasterDisclosureBean> disclosuresGroupedByEvent = new ArrayList<CoiGroupedMasterDisclosureBean>();
        for (CoiDisclosureProjectBean coiDisclosureProjectBean : masterDisclosureBean.getAllDisclosureProjects()) {
            CoiGroupedMasterDisclosureBean coiGroupedMasterDisclosureBean = new CoiGroupedMasterDisclosureBean();
            CoiDisclosure coiDisclosure = null;
            coiDisclosure = coiDisclosureProjectBean.getCoiDisclProject().getOriginalCoiDisclosureId() != null ? coiDisclosureProjectBean.getCoiDisclProject().getOriginalCoiDisclosure() : coiDisclosureProjectBean.getCoiDisclProject().getCoiDisclosure();
            String projectEventTypeDescription = coiDisclosureProjectBean.getCoiDisclProject().getCoiDisclosureEventType().getDescription();
            coiGroupedMasterDisclosureBean.setDisclosureEventType(projectEventTypeDescription);
            coiGroupedMasterDisclosureBean.setDisclosureStatus(coiDisclosure.getCoiDisclosureStatus().getDescription());
            coiGroupedMasterDisclosureBean.setDispositionStatus(coiDisclosure.getCoiDispositionStatus().getDescription());
            coiGroupedMasterDisclosureBean.setProjectId(coiDisclosureProjectBean.getCoiDisclProject().getCoiProjectId());
            coiGroupedMasterDisclosureBean.setProjectTitle(coiDisclosureProjectBean.getCoiDisclProject().getCoiProjectTitle());
            coiGroupedMasterDisclosureBean.getAllRelatedProjects().add(coiDisclosureProjectBean);
            disclosuresGroupedByEvent.add(coiGroupedMasterDisclosureBean);
        }
        masterDisclosureBean.setDisclosureGroupedByEvent(true);
        masterDisclosureBean.setAllDisclosuresGroupedByProjects(disclosuresGroupedByEvent);
    }

    @Override
    public List<CoiGroupedMasterDisclosureBean> getUndisclosedProjectsGroupedByEvent(List<CoiDisclProject> coiDisclProjects) {
        ArrayList<CoiGroupedMasterDisclosureBean> disclosuresGroupedByEvent = new ArrayList<CoiGroupedMasterDisclosureBean>();
        for (CoiDisclProject coiDisclProject : coiDisclProjects) {
            CoiGroupedMasterDisclosureBean coiGroupedMasterDisclosureBean = new CoiGroupedMasterDisclosureBean();
            CoiDisclosureProjectBean coiDisclosureProjectBean = new CoiDisclosureProjectBean();
            coiDisclosureProjectBean.setCoiDisclProject(coiDisclProject);
            coiGroupedMasterDisclosureBean.setDisclosureEventType(coiDisclProject.getCoiDisclosureEventType().getDescription());
            coiGroupedMasterDisclosureBean.setProjectId(coiDisclProject.getCoiProjectId());
            coiGroupedMasterDisclosureBean.setProjectTitle(coiDisclProject.getCoiProjectTitle());
            coiGroupedMasterDisclosureBean.getAllRelatedProjects().add(coiDisclosureProjectBean);
            disclosuresGroupedByEvent.add(coiGroupedMasterDisclosureBean);
        }
        return disclosuresGroupedByEvent;
    }

    @Override
    public List<CoiGroupedMasterDisclosureBean> getUndisclosedProjectsGroupedByFinancialEntity(List<CoiDisclProject> coiDisclProjects) {
        ArrayList<CoiGroupedMasterDisclosureBean> disclosureGroupedByFinancialEntity = new ArrayList<CoiGroupedMasterDisclosureBean>();
        String personId = coiDisclProjects.get(0).getCoiDiscDetails().get(0).getPersonFinIntDisclosure().getPersonId();
        List<PersonFinIntDisclosure> financialEntities = this.financialEntityService.getFinancialEntities(personId, true);
        for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
            CoiGroupedMasterDisclosureBean coiGroupedMasterDisclosureBean = this.getPersonEntityDisclosureBean(personFinIntDisclosure);
            ArrayList<CoiDisclosureProjectBean> entityRelatedProjects = new ArrayList<CoiDisclosureProjectBean>();
            block1: for (CoiDisclProject coiDisclProject : coiDisclProjects) {
                List<CoiDiscDetail> coiDiscDetails = coiDisclProject.getCoiDiscDetails();
                for (CoiDiscDetail coiDiscDetail : coiDiscDetails) {
                    if (!coiDiscDetail.getPersonFinIntDisclosureId().equals(personFinIntDisclosure.getPersonFinIntDisclosureId())) continue;
                    CoiDisclosureProjectBean coiDisclosureProjectBean = new CoiDisclosureProjectBean();
                    coiDisclosureProjectBean.setCoiDisclProject(coiDisclProject);
                    entityRelatedProjects.add(coiDisclosureProjectBean);
                    continue block1;
                }
            }
            coiGroupedMasterDisclosureBean.getAllRelatedProjects().addAll(entityRelatedProjects);
            disclosureGroupedByFinancialEntity.add(coiGroupedMasterDisclosureBean);
        }
        return disclosureGroupedByFinancialEntity;
    }

    @Override
    public void createDisclosuresGroupedByFinancialEntity(CoiDisclosure coiDisclosure, MasterDisclosureBean masterDisclosureBean) {
        ArrayList<CoiGroupedMasterDisclosureBean> disclosureGroupedByFinancialEntity = new ArrayList<CoiGroupedMasterDisclosureBean>();
        String personId = coiDisclosure.getPersonId();
        List<PersonFinIntDisclosure> financialEntities = this.financialEntityService.getFinancialEntities(personId, true);
        for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
            disclosureGroupedByFinancialEntity.add(this.getMasterDisclosureBeanGroupedByFinancialEntity(masterDisclosureBean, personFinIntDisclosure));
        }
        masterDisclosureBean.setAllDisclosuresGroupedByProjects(disclosureGroupedByFinancialEntity);
        masterDisclosureBean.setDisclosureGroupedByEvent(false);
    }

    private CoiGroupedMasterDisclosureBean getMasterDisclosureBeanGroupedByFinancialEntity(MasterDisclosureBean masterDisclosureBean, PersonFinIntDisclosure personFinIntDisclosure) {
        CoiGroupedMasterDisclosureBean coiGroupedMasterDisclosureBean = this.getPersonEntityDisclosureBean(personFinIntDisclosure);
        coiGroupedMasterDisclosureBean.getAllRelatedProjects().addAll(this.getAllFinancialEntityRelatedProjects(masterDisclosureBean, personFinIntDisclosure));
        return coiGroupedMasterDisclosureBean;
    }

    private CoiGroupedMasterDisclosureBean getPersonEntityDisclosureBean(PersonFinIntDisclosure personFinIntDisclosure) {
        CoiGroupedMasterDisclosureBean coiGroupedMasterDisclosureBean = new CoiGroupedMasterDisclosureBean();
        coiGroupedMasterDisclosureBean.setEntityNumber(personFinIntDisclosure.getEntityNumber());
        coiGroupedMasterDisclosureBean.setEntityName(personFinIntDisclosure.getEntityName());
        return coiGroupedMasterDisclosureBean;
    }

    private List<CoiDisclosureProjectBean> getAllFinancialEntityRelatedProjects(MasterDisclosureBean masterDisclosureBean, PersonFinIntDisclosure personFinIntDisclosure) {
        ArrayList<CoiDisclosureProjectBean> coiDisclosureProjectBeans = new ArrayList<CoiDisclosureProjectBean>();
        block0: for (CoiDisclosureProjectBean coiDisclosureProjectBean : masterDisclosureBean.getAllDisclosureProjects()) {
            List<CoiDiscDetail> coiDiscDetails = coiDisclosureProjectBean.getCoiDisclProject().getCoiDiscDetails();
            for (CoiDiscDetail coiDiscDetail : coiDiscDetails) {
                if (!coiDiscDetail.getPersonFinIntDisclosureId().equals(personFinIntDisclosure.getPersonFinIntDisclosureId()) || coiDiscDetail.getEntityDispositionCode() == null) continue;
                coiDisclosureProjectBeans.add(coiDisclosureProjectBean);
                continue block0;
            }
        }
        return coiDisclosureProjectBeans;
    }

    private List<AnswerHeader> retrieveAnswerHeaders(CoiDisclosure coiDisclosure) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(MODULE_ITEM_CODE, "8");
        fieldValues.put(MODULE_ITEM_KEY, coiDisclosure.getCoiDisclosureId());
        fieldValues.put(MODULE_SUB_ITEM_KEY, "-1");
        return (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
    }

    private void addProjectDisclQuestionnaires(CoiDisclosureProjectBean disclosureProjectBean, List<AnswerHeader> answerHeaders, CoiDisclosure originalDisclosure) {
        disclosureProjectBean.populateAnswers(originalDisclosure);
    }

    private void versionProjectDisclQuestionnaires(CoiDisclosureProjectBean disclosureProjectBean, List<AnswerHeader> answerHeaders, CoiDisclosure originalDisclosure) {
        disclosureProjectBean.versionDisclosureAnswers(originalDisclosure);
    }

    private void addProjectDisclAttachments(CoiDisclosureProjectBean disclosureProjectBean, CoiDisclosure coiDisclosure, Long originalDisclosureId) {
        for (CoiDisclosureAttachment disclattachment : coiDisclosure.getCoiDisclosureAttachments()) {
            if ((disclattachment.getOriginalCoiDisclosureId() != null || originalDisclosureId != null) && (disclattachment.getOriginalCoiDisclosureId() == null || originalDisclosureId == null || !disclattachment.getOriginalCoiDisclosureId().equals(originalDisclosureId))) continue;
            disclosureProjectBean.getProjectDiscAttachments().add(disclattachment);
        }
    }

    private void addProjectDisclNotepads(CoiDisclosureProjectBean disclosureProjectBean, CoiDisclosure coiDisclosure, Long originalDisclosureId) {
        for (CoiDisclosureNotepad disclNotepad : coiDisclosure.getCoiDisclosureNotepads()) {
            if ((disclNotepad.getOriginalCoiDisclosureId() != null || originalDisclosureId != null) && (disclNotepad.getOriginalCoiDisclosureId() == null || originalDisclosureId == null || !disclNotepad.getOriginalCoiDisclosureId().equals(originalDisclosureId))) continue;
            disclosureProjectBean.getProjectDiscNotepads().add(disclNotepad);
        }
    }

    private void setupDisclosures(MasterDisclosureBean masterDisclosureBean, CoiDisclosure coiDisclosure) {
        List<CoiDisclosureHistory> disclosureHistories = this.getDisclosureHistory(coiDisclosure.getCoiDisclosureNumber());
        CoiDisclosureHistory disclosureHistoryForView = this.getDisclosureHistoryForSelectedDiscl(disclosureHistories, coiDisclosure);
        List<CoiDisclProject> coiDisclProjects = this.getCoiDisclProjects(coiDisclosure);
        disclosureHistoryForView.refreshReferenceObject("coiDisclosure");
        for (CoiDisclosureHistory disclosureHistory : disclosureHistories) {
            if (disclosureHistory.getCoiDisclosureHistoryId().compareTo(disclosureHistoryForView.getCoiDisclosureHistoryId()) > 0) continue;
            CoiDiscDetail coiDiscDetail = this.getCurrentProjectDetail(disclosureHistory.getCoiDisclosure());
            CoiDisclosureProjectBean disclosureProjectBean = this.getCoiDisclosureProjectBean(coiDiscDetail);
            disclosureProjectBean.setApprovalDate(new Date(disclosureHistory.getUpdateTimestamp().getTime()));
            if (disclosureHistory.getCoiDisclosure() == null) {
                disclosureHistory.refreshReferenceObject("coiDisclosure");
            }
            disclosureHistory.getCoiDisclosure().refreshReferenceObject("coiDisclosureEventType");
            disclosureHistory.getCoiDisclosure().refreshReferenceObject("coiDisclosureStatus");
            disclosureHistory.getCoiDisclosure().refreshReferenceObject("coiDispositionStatus");
            disclosureProjectBean.setCoiDisclosure(disclosureHistory.getCoiDisclosure());
            String projectId = null;
            String projectTitle = null;
            if (coiDiscDetail != null) {
                projectId = coiDiscDetail.getCoiDisclProject().getCoiProjectId();
                projectTitle = coiDiscDetail.getCoiDisclProject().getCoiProjectTitle();
            } else {
                CoiDisclProject coiDisclProject = this.getCurrentProject(disclosureHistory.getCoiDisclosure(), coiDisclProjects);
                if (coiDisclProject != null) {
                    projectId = coiDisclProject.getCoiProjectId();
                    projectTitle = coiDisclProject.getCoiProjectTitle();
                }
            }
            disclosureProjectBean.setProjectId(projectId);
            disclosureProjectBean.setProjectName(projectTitle);
            masterDisclosureBean.getAllProjects().add(disclosureProjectBean);
        }
    }

    private CoiDisclosureHistory getDisclosureHistoryForSelectedDiscl(List<CoiDisclosureHistory> disclosureHistories, CoiDisclosure coiDisclosure) {
        for (CoiDisclosureHistory disclosureHistory : disclosureHistories) {
            if (!disclosureHistory.getCoiDisclosureId().equals(coiDisclosure.getCoiDisclosureId())) continue;
            return disclosureHistory;
        }
        return null;
    }

    public void setCoiDisclosureDao(CoiDisclosureDao coiDisclosureDao) {
        this.coiDisclosureDao = coiDisclosureDao;
    }

    public CoiDisclosureDao getCoiDisclosureDao() {
        return this.coiDisclosureDao;
    }

    protected List<CoiDisclosureHistory> getDisclosureHistory(String coiDisclosureNumber) {
        return this.getCoiDisclosureDao().getApprovedAndDisapprovedDisclosureHistory(coiDisclosureNumber);
    }

    protected CoiDiscDetail getCurrentProjectDetail(CoiDisclosure coiDisclosure) {
        if (CollectionUtils.isEmpty(coiDisclosure.getCoiDisclProjects())) {
            coiDisclosure.refreshReferenceObject("coiDisclProjects");
        }
        for (CoiDisclProject coiDisclProject : coiDisclosure.getCoiDisclProjects()) {
            for (CoiDiscDetail coiDiscDetail : coiDisclProject.getCoiDiscDetails()) {
                if (coiDiscDetail.getOriginalCoiDisclosure() != null && !coiDisclProject.getCoiDisclosureId().equals(coiDiscDetail.getOriginalCoiDisclosureId())) continue;
                return coiDiscDetail;
            }
        }
        return null;
    }

    protected CoiDisclProject getCurrentProject(CoiDisclosure historyDisclosure, List<CoiDisclProject> coiDisclProjects) {
        CoiDisclProject currentDisclProject = null;
        for (CoiDisclProject coiDisclProject : coiDisclProjects) {
            Long projectDisclosureId = coiDisclProject.getOriginalCoiDisclosureId() == null ? coiDisclProject.getCoiDisclosureId() : coiDisclProject.getOriginalCoiDisclosureId();
            if (!projectDisclosureId.equals(historyDisclosure.getCoiDisclosureId())) continue;
            currentDisclProject = coiDisclProject;
            break;
        }
        return currentDisclProject;
    }

    private List<CoiDisclProject> getCoiDisclProjects(CoiDisclosure coiDisclosure) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("coiDisclosureNumber", coiDisclosure.getCoiDisclosureNumber());
        List coiDisclProjects = (List)this.businessObjectService.findMatching(CoiDisclProject.class, fieldValues);
        return coiDisclProjects;
    }

    protected CoiDisclosureProjectBean getCoiDisclosureProjectBean(CoiDiscDetail coiDiscDetail) {
        CoiDisclosureProjectBean disclosureProjectBean = new CoiDisclosureProjectBean();
        if (ObjectUtils.isNotNull((Object)coiDiscDetail)) {
            disclosureProjectBean.setCoiDisclProject(coiDiscDetail.getCoiDisclProject());
            if (disclosureProjectBean.getCoiDisclProject().isManualEvent()) {
                disclosureProjectBean.getCoiDisclProject().initHeaderItems();
            }
        }
        return disclosureProjectBean;
    }

    protected CoiDisclosureProjectBean getCoiDisclosureProjectBean(CoiDisclProject coiDisclProject) {
        CoiDisclosureProjectBean disclosureProjectBean = new CoiDisclosureProjectBean();
        disclosureProjectBean.setCoiDisclProject(coiDisclProject);
        if (disclosureProjectBean.getCoiDisclProject().isManualEvent()) {
            disclosureProjectBean.getCoiDisclProject().initHeaderItems();
        }
        return disclosureProjectBean;
    }

    private CoiDisclProject getCoiDisclProject(CoiDiscDetail coiDiscDetail) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("coiDisclosureNumber", coiDiscDetail.getCoiDisclosureNumber());
        fieldValues.put(MODULE_ITEM_KEY, coiDiscDetail.getModuleItemKey());
        List coiDisclProjects = (List)this.businessObjectService.findMatching(CoiDisclProject.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)coiDisclProjects)) {
            return (CoiDisclProject)coiDisclProjects.get(0);
        }
        return null;
    }

    @Override
    public List<CoiDispositionStatus> getDispositionStatuses(String disclosureStatusCode) {
        List<CoiDispositionStatus> coiDispositionStatuses = new ArrayList<CoiDispositionStatus>();
        if (ObjectUtils.isNotNull((Object)disclosureStatusCode)) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("coiDisclosureStatusCode", disclosureStatusCode);
            coiDispositionStatuses = (List)this.businessObjectService.findMatching(CoiDispositionStatus.class, criteria);
        }
        return coiDispositionStatuses;
    }

    @Override
    public void initDisclosureFromMasterDisclosure(CoiDisclosure coiDisclosure) {
        CoiDisclosure masterDisclosure = this.getCurrentDisclosure();
        coiDisclosure.setCoiDisclProjects(new ArrayList<CoiDisclProject>());
        coiDisclosure.setCoiDisclosureAttachments(new ArrayList<CoiDisclosureAttachment>());
        coiDisclosure.setCoiDisclosureNotepads(new ArrayList<CoiDisclosureNotepad>());
        this.copyCollections(masterDisclosure, coiDisclosure);
    }

    @Override
    public CoiDisclosure getCurrentDisclosure() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", GlobalVariables.getUserSession().getPrincipalId());
        fieldValues.put("currentDisclosure", "Y");
        List disclosures = (List)this.businessObjectService.findMatching(CoiDisclosure.class, fieldValues);
        if (CollectionUtils.isEmpty((Collection)disclosures)) {
            return null;
        }
        return (CoiDisclosure)disclosures.get(0);
    }

    private void copyCollections(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        this.copyDisclosureProjects(masterCoiDisclosure, coiDisclosure);
        this.copyDisclosureNotePads(masterCoiDisclosure, coiDisclosure);
        this.copyDisclosureAttachments(masterCoiDisclosure, coiDisclosure);
        this.copyDisclosureQuestionnaire(masterCoiDisclosure, coiDisclosure);
    }

    private List<AnswerHeader> copyDisclosureQuestionnaire(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        List<AnswerHeader> newAnswerHeaders = this.versioningQuestionnaireAnswer(masterCoiDisclosure);
        if (!newAnswerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : newAnswerHeaders) {
                if (coiDisclosure.getCoiDisclosureId() == null) continue;
                answerHeader.setModuleItemKey(coiDisclosure.getCoiDisclosureId().toString());
            }
        }
        return newAnswerHeaders;
    }

    private List<AnswerHeader> versioningQuestionnaireAnswer(CoiDisclosure coiDisclosure) {
        ArrayList<AnswerHeader> newAnswerHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : this.retrieveAnswerHeaders(coiDisclosure)) {
            AnswerHeader copiedAnswerHeader = (AnswerHeader)((Object)ObjectUtils.deepCopy((Serializable)((Object)answerHeader)));
            copiedAnswerHeader.setAnswerHeaderId(null);
            for (Answer answer : copiedAnswerHeader.getAnswers()) {
                answer.setId(null);
            }
            newAnswerHeaders.add(copiedAnswerHeader);
        }
        return newAnswerHeaders;
    }

    private void copyDisclosureDetails(List<CoiDiscDetail> originalDiscDetails, CoiDisclProject copiedDisclProject) {
        ArrayList<CoiDiscDetail> copiedDiscDetails = new ArrayList<CoiDiscDetail>();
        for (CoiDiscDetail coiDiscDetail : originalDiscDetails) {
            CoiDiscDetail copiedDiscDetail = (CoiDiscDetail)((Object)ObjectUtils.deepCopy((Serializable)((Object)coiDiscDetail)));
            copiedDiscDetail.setCopiedCoiDiscDetailId(copiedDiscDetail.getCoiDiscDetailId());
            copiedDiscDetail.setSequenceNumber(copiedDisclProject.getSequenceNumber());
            copiedDiscDetail.setCoiDiscDetailId(null);
            if (copiedDiscDetail.getOriginalCoiDisclosureId() == null) {
                copiedDiscDetail.setOriginalCoiDisclosureId(copiedDisclProject.getCoiDisclosureId());
            }
            copiedDiscDetail.setCoiDisclProject(copiedDisclProject);
            copiedDiscDetails.add(copiedDiscDetail);
        }
        copiedDisclProject.setCoiDiscDetails(copiedDiscDetails);
        if (copiedDisclProject.getOriginalCoiDisclosureId() == null) {
            copiedDisclProject.setOriginalCoiDisclosureId(copiedDisclProject.getCoiDisclosureId());
        }
    }

    private void copyDisclosureProjects(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        ArrayList<CoiDisclProject> copiedDisclProjects = new ArrayList<CoiDisclProject>();
        for (CoiDisclProject coiDisclProject : masterCoiDisclosure.getCoiDisclProjects()) {
            List<CoiDiscDetail> coiDiscDetails = coiDisclProject.getCoiDiscDetails();
            CoiDisclProject copiedDisclProject = (CoiDisclProject)((Object)ObjectUtils.deepCopy((Serializable)((Object)coiDisclProject)));
            copiedDisclProject.setCoiDispositionStatus(coiDisclProject.getCoiDispositionStatus());
            if (copiedDisclProject.getCoiDispositionStatus() == null) {
                copiedDisclProject.refreshReferenceObject("coiDispositionStatus");
            }
            copiedDisclProject.setSequenceNumber(coiDisclosure.getSequenceNumber());
            copiedDisclProject.setCoiDisclProjectsId(null);
            this.copyDisclosureDetails(coiDiscDetails, copiedDisclProject);
            copiedDisclProjects.add(copiedDisclProject);
            copiedDisclProject.setCoiDisclosure(coiDisclosure);
            copiedDisclProject.setCoiDisclosureId(null);
        }
        coiDisclosure.setCoiDisclProjects(copiedDisclProjects);
    }

    private void copyDisclosureNotePads(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        for (CoiDisclosureNotepad coiDisclosureNotepad : masterCoiDisclosure.getCoiDisclosureNotepads()) {
            CoiDisclosureNotepad copiedCoiDisclosureNotepad = this.copyCoiDisclosureNotepad(coiDisclosureNotepad);
            copiedCoiDisclosureNotepad.setSequenceNumber(coiDisclosure.getSequenceNumber());
            copiedCoiDisclosureNotepad.setId(null);
            if (copiedCoiDisclosureNotepad.getOriginalCoiDisclosureId() == null) {
                copiedCoiDisclosureNotepad.setOriginalCoiDisclosureId(masterCoiDisclosure.getCoiDisclosureId());
            }
            coiDisclosure.getCoiDisclosureNotepads().add(copiedCoiDisclosureNotepad);
        }
    }

    private void copyDisclosureAttachments(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        for (CoiDisclosureAttachment coiDisclosureAttachment : masterCoiDisclosure.getCoiDisclosureAttachments()) {
            CoiDisclosureAttachment copiedCoiDisclosureAttachment = this.copyCoiDisclosureAttachment(coiDisclosureAttachment);
            copiedCoiDisclosureAttachment.setSequenceNumber(coiDisclosure.getSequenceNumber());
            copiedCoiDisclosureAttachment.setAttachmentId(null);
            copiedCoiDisclosureAttachment.setFileId(coiDisclosureAttachment.getFileId());
            copiedCoiDisclosureAttachment.setFile(coiDisclosureAttachment.getFile());
            if (copiedCoiDisclosureAttachment.getOriginalCoiDisclosureId() == null) {
                copiedCoiDisclosureAttachment.setOriginalCoiDisclosureId(masterCoiDisclosure.getCoiDisclosureId());
            }
            coiDisclosure.getCoiDisclosureAttachments().add(copiedCoiDisclosureAttachment);
        }
    }

    @Override
    public void initializeDisclosureProject(CoiDisclosure coiDisclosure, String projectId) {
        List<CoiDisclProject> coiDisclProjects = coiDisclosure.getCoiDisclProjects();
        if (CollectionUtils.isEmpty(coiDisclProjects)) {
            coiDisclProjects = new ArrayList<CoiDisclProject>();
        }
        coiDisclosure.setEventBo(this.getEventBo(coiDisclosure, projectId));
        String moduleItemKey = this.getModuleItemKey(coiDisclosure, coiDisclosure.getEventBo());
        String projectIdFk = this.getProjectIdFk(coiDisclosure, coiDisclosure.getEventBo());
        String projectTitle = this.getProjectTitle(coiDisclosure, coiDisclosure.getEventBo());
        CoiDisclProject newProject = new CoiDisclProject();
        newProject.setCoiDisclosureId(coiDisclosure.getCoiDisclosureId());
        newProject.setDisclosureEventType(coiDisclosure.getEventTypeCode());
        newProject.refreshReferenceObject("coiDisclosureEventType");
        newProject.setCoiDisclosure(coiDisclosure);
        newProject.setCoiDisclosureNumber(coiDisclosure.getCoiDisclosureNumber());
        newProject.setSequenceNumber(coiDisclosure.getSequenceNumber());
        newProject.setCoiProjectId(projectIdFk);
        newProject.setModuleItemKey(moduleItemKey);
        newProject.setCoiProjectTitle(projectTitle);
        newProject.setDisclosureDispositionCode("100");
        newProject.refreshReferenceObject("coiDispositionStatus");
        newProject.setDisclosureStatusCode("1");
        this.initializeDisclosureDetails(newProject);
        coiDisclProjects.add(newProject);
        coiDisclosure.setCoiDisclProjects(coiDisclProjects);
    }

    private void updateMasterDisclosureDetails(CoiDisclosure coiDisclosure) {
        Map<Long, List<CoiDiscDetail>> projectDetailMap = this.setupDetailMap(coiDisclosure);
        String personId = coiDisclosure.getPersonId();
        List<PersonFinIntDisclosure> financialEntities = this.financialEntityService.getFinancialEntities(personId, true);
        Long disclosureId = coiDisclosure.getCoiDisclosureId();
        for (CoiDisclProject coiDisclProject : coiDisclosure.getCoiDisclProjects()) {
            ArrayList<CoiDiscDetail> coiDiscDetails = new ArrayList<CoiDiscDetail>();
            if (coiDisclProject.getCoiDiscDetails().size() == 0 && financialEntities.size() > 0) {
                this.initializeDisclosureDetails(coiDisclProject);
                this.checkToAddNewFinancialEntity(financialEntities, coiDiscDetails, disclosureId, coiDisclosure, projectDetailMap.get(disclosureId), coiDisclProject);
            } else if (!coiDisclProject.getCoiDisclosureEventType().isExcludeFromMasterDisclosure()) {
                this.checkToAddNewFinancialEntity(financialEntities, coiDiscDetails, disclosureId, coiDisclosure, coiDisclProject.getCoiDiscDetails(), coiDisclProject);
                for (CoiDiscDetail coiDiscDetail : coiDisclProject.getCoiDiscDetails()) {
                    this.getCurrentFinancialEntity(coiDiscDetail);
                    if (!coiDiscDetail.getPersonFinIntDisclosure().isStatusActive() || !coiDiscDetail.getPersonFinIntDisclosure().isCurrentFlag()) continue;
                    coiDiscDetails.add(coiDiscDetail);
                }
            }
            if (coiDiscDetails.size() <= 0) continue;
            coiDisclProject.setCoiDiscDetails(coiDiscDetails);
        }
    }

    private Map<Long, List<CoiDiscDetail>> setupDetailMap(CoiDisclosure coiDisclosure) {
        HashMap<Long, List<CoiDiscDetail>> projectDetailMap = new HashMap<Long, List<CoiDiscDetail>>();
        for (CoiDisclProject disclProject : coiDisclosure.getCoiDisclProjects()) {
            for (CoiDiscDetail detail : disclProject.getCoiDiscDetails()) {
                if (detail.getOriginalCoiDisclosureId() == null) {
                    detail.setOriginalCoiDisclosureId(coiDisclosure.getCoiDisclosureId());
                }
                if (!projectDetailMap.containsKey(detail.getOriginalCoiDisclosureId())) {
                    projectDetailMap.put(detail.getOriginalCoiDisclosureId(), new ArrayList());
                }
                ((List)projectDetailMap.get(detail.getOriginalCoiDisclosureId())).add(detail);
            }
        }
        return projectDetailMap;
    }

    private void checkToAddNewFEForAnnualEvent(List<PersonFinIntDisclosure> financialEntities, List<CoiDiscDetail> coiDiscDetails, Long disclosureId, CoiDisclosure coiDisclosure, List<CoiDiscDetail> projectDetails, CoiDisclProject coiDisclProject) {
        Map<String, List<CoiDiscDetail>> projectDetailMap = this.setupDetailMapForAnnual(projectDetails);
        for (String itemKey : projectDetailMap.keySet()) {
            this.checkToAddNewFinancialEntity(financialEntities, coiDiscDetails, disclosureId, coiDisclosure, projectDetailMap.get(itemKey), coiDisclProject);
        }
    }

    private Map<String, List<CoiDiscDetail>> setupDetailMapForAnnual(List<CoiDiscDetail> projectDetails) {
        HashMap<String, List<CoiDiscDetail>> projectDetailMap = new HashMap<String, List<CoiDiscDetail>>();
        for (CoiDiscDetail detail : projectDetails) {
            if (!projectDetailMap.containsKey(detail.getModuleItemKey())) {
                projectDetailMap.put(detail.getModuleItemKey(), new ArrayList());
            }
            ((List)projectDetailMap.get(detail.getModuleItemKey())).add(detail);
        }
        return projectDetailMap;
    }

    private void checkToAddNewFinancialEntity(List<PersonFinIntDisclosure> financialEntities, List<CoiDiscDetail> coiDiscDetails, Long disclosureId, CoiDisclosure coiDisclosure, List<CoiDiscDetail> projectDetails, CoiDisclProject coiDisclProject) {
        for (PersonFinIntDisclosure personFinIntDisclosure : financialEntities) {
            boolean isNewFe = true;
            String projectType = "";
            String projectIdFk = "";
            String moduleItemKey = "";
            boolean isSet = false;
            if (projectDetails != null) {
                for (CoiDiscDetail detail : projectDetails) {
                    if (detail.getPersonFinIntDisclosure().getEntityNumber().equals(personFinIntDisclosure.getEntityNumber())) {
                        isNewFe = false;
                        break;
                    }
                    if (isSet) continue;
                    projectType = detail.getProjectType();
                    projectIdFk = detail.getProjectIdFk();
                    moduleItemKey = detail.getModuleItemKey();
                    isSet = true;
                }
            } else {
                projectType = coiDisclProject.getCoiDiscDetails().get(0).getProjectType();
                projectIdFk = coiDisclProject.getCoiDiscDetails().get(0).getProjectIdFk();
                moduleItemKey = coiDisclProject.getCoiDiscDetails().get(0).getModuleItemKey();
            }
            if (!isNewFe) continue;
            CoiDiscDetail newDetail = this.createNewCoiDiscDetail(coiDisclosure, personFinIntDisclosure, moduleItemKey, projectIdFk, projectType);
            newDetail.setOriginalCoiDisclosureId(disclosureId);
            newDetail.setCoiDisclProject(coiDisclProject);
            coiDiscDetails.add(newDetail);
        }
    }

    private CoiDisclosureAttachment copyCoiDisclosureAttachment(CoiDisclosureAttachment attachment) {
        CoiDisclosureAttachment attachCopy = new CoiDisclosureAttachment();
        attachCopy.setAttachmentId(attachment.getAttachmentId());
        attachCopy.setAttachmentIdForPermission(attachment.getAttachmentIdForPermission());
        attachCopy.setCoiAttachmentType(attachment.getCoiAttachmentType());
        attachCopy.setCoiDisclosure(attachment.getCoiDisclosure());
        attachCopy.setCoiDisclosureId(attachment.getCoiDisclosureId());
        attachCopy.setCoiDisclosureNumber(attachment.getCoiDisclosureNumber());
        attachCopy.setComments(attachment.getComments());
        attachCopy.setContactEmailAddress(attachment.getContactEmailAddress());
        attachCopy.setContactName(attachment.getContactName());
        attachCopy.setContactPhoneNumber(attachment.getContactPhoneNumber());
        attachCopy.setCreateTimestamp(attachment.getCreateTimestamp());
        attachCopy.setDescription(attachment.getDescription());
        attachCopy.setDocumentId(attachment.getDocumentId());
        attachCopy.setDocumentStatusCode(attachment.getDocumentStatusCode());
        attachCopy.setEventTypeCode(attachment.getEventTypeCode());
        attachCopy.setFileId(attachment.getFileId());
        attachCopy.setFinancialEntityId(attachment.getFinancialEntityId());
        attachCopy.setOriginalCoiDisclosureId(attachment.getOriginalCoiDisclosureId());
        attachCopy.setProjectId(attachment.getProjectId());
        attachCopy.setSequenceNumber(attachment.getSequenceNumber());
        attachCopy.setTypeCode(attachment.getTypeCode());
        attachCopy.setUpdateTimestamp(attachment.getUpdateTimestamp());
        attachCopy.setUpdateUser(attachment.getUpdateUser());
        attachCopy.setUpdateUserFullName(attachment.getUpdateUserFullName());
        attachCopy.setVersionNumber(attachment.getVersionNumber());
        attachCopy.setObjectId(attachment.getObjectId());
        return attachCopy;
    }

    private CoiDisclosureNotepad copyCoiDisclosureNotepad(CoiDisclosureNotepad notepad) {
        CoiDisclosureNotepad notesCopy = new CoiDisclosureNotepad();
        notesCopy.setCoiDisclosure(notepad.getCoiDisclosure());
        notesCopy.setCoiDisclosureId(notepad.getCoiDisclosureId());
        notesCopy.setCoiDisclosureNumber(notepad.getCoiDisclosureNumber());
        notesCopy.setComments(notepad.getComments());
        notesCopy.setEditable(notepad.isEditable());
        notesCopy.setEntryNumber(notepad.getEntryNumber());
        notesCopy.setEventTypeCode(notepad.getEventTypeCode());
        notesCopy.setFinancialEntityId(notepad.getFinancialEntityId());
        notesCopy.setFinancialEntity(notepad.getFinancialEntity());
        notesCopy.setId(notepad.getId());
        notesCopy.setNoteTopic(notepad.getNoteTopic());
        notesCopy.setNoteTypeCode(notepad.getNoteTypeCode());
        notesCopy.setNoteType(notepad.getNoteType());
        notesCopy.setObjectId(notepad.getObjectId());
        notesCopy.setOriginalCoiDisclosure(notepad.getOriginalCoiDisclosure());
        notesCopy.setOriginalCoiDisclosureId(notepad.getOriginalCoiDisclosureId());
        notesCopy.setProjectId(notepad.getProjectId());
        notesCopy.setRestrictedView(notepad.getRestrictedView());
        notesCopy.setSequenceNumber(notepad.getSequenceNumber());
        notesCopy.setUpdateTimestamp(notepad.getUpdateTimestamp());
        notesCopy.setUpdateUser(notepad.getUpdateUser());
        notesCopy.setUpdateUserFullName(notepad.getUpdateUserFullName());
        notesCopy.setVersionNumber(notepad.getVersionNumber());
        return notesCopy;
    }

    @Override
    public void populateProposalsAndAwardToCompleteDisclosure(String userId, DisclosureHelper disclosureHelper) {
        List<DevelopmentProposal> initDevProposalsToCompleteDiscl = this.getProposals(userId);
        List<InstitutionalProposal> initInstProposalsToCompleteDiscl = this.getInstitutionalProposals(userId);
        List<Award> initAwardsToCompleteDiscl = this.getAwards(userId);
        ArrayList<CoiDisclosedProjectBean> disclosedProjects = new ArrayList<CoiDisclosedProjectBean>();
        disclosedProjects.addAll(this.getDisclosedProjectsBasedOnDevelopmentProposalLink(initDevProposalsToCompleteDiscl, userId));
        disclosedProjects.addAll(this.getDisclosedProjectsBasedOnInstituteProposalLink(initInstProposalsToCompleteDiscl, userId));
        disclosedProjects.addAll(this.getDisclosedProjectsBasedOnAwardLink(initAwardsToCompleteDiscl, userId));
        CoiProjectsToCompleteDisclosureBean projectsToCompleteDisclosure = this.getRevisedProposalsAndAwardsToCompleteDisclosure(disclosedProjects, initDevProposalsToCompleteDiscl, initInstProposalsToCompleteDiscl, initAwardsToCompleteDiscl);
        disclosureHelper.setNewProposals(projectsToCompleteDisclosure.getDevProposalsToDisclose());
        disclosureHelper.setNewInstitutionalProposals(projectsToCompleteDisclosure.getInstituteProposalsToDisclose());
        disclosureHelper.setNewAwards(projectsToCompleteDisclosure.getAwardsToDisclose());
    }

    private CoiProjectsToCompleteDisclosureBean getRevisedProposalsAndAwardsToCompleteDisclosure(List<CoiDisclosedProjectBean> disclosedProjects, List<DevelopmentProposal> initDevProposalsToCompleteDiscl, List<InstitutionalProposal> initInstProposalsToCompleteDiscl, List<Award> initAwardsToCompleteDiscl) {
        CoiProjectsToCompleteDisclosureBean projectsToCompleteDisclosure = new CoiProjectsToCompleteDisclosureBean();
        ArrayList<DevelopmentProposal> disclosedDevProposals = new ArrayList<DevelopmentProposal>();
        ArrayList<InstitutionalProposal> disclosedInstProposals = new ArrayList<InstitutionalProposal>();
        ArrayList<Award> disclosedAwards = new ArrayList<Award>();
        for (CoiDisclosedProjectBean disclosedProjectBean : disclosedProjects) {
            if (!disclosedProjectBean.isProjectDisclosed()) continue;
            disclosedDevProposals.addAll(disclosedProjectBean.getDisclosedDevProposals());
            disclosedInstProposals.addAll(disclosedProjectBean.getDisclosedInstProposals());
            disclosedAwards.addAll(disclosedProjectBean.getDisclosedAwards());
        }
        projectsToCompleteDisclosure.setDevProposalsToDisclose(this.getRevisedDevProposalToCompleteDiscl(initDevProposalsToCompleteDiscl, disclosedDevProposals));
        projectsToCompleteDisclosure.setInstituteProposalsToDisclose(this.getRevisedInstProposalToCompleteDiscl(initInstProposalsToCompleteDiscl, disclosedInstProposals));
        projectsToCompleteDisclosure.setAwardsToDisclose(this.getRevisedAwardsToCompleteDiscl(initAwardsToCompleteDiscl, disclosedAwards));
        return projectsToCompleteDisclosure;
    }

    private List<CoiDisclosedProjectBean> getDisclosedProjectsBasedOnDevelopmentProposalLink(List<DevelopmentProposal> devProposalsToCompleteDiscl, String userId) {
        ArrayList<CoiDisclosedProjectBean> disclosedProjects = new ArrayList<CoiDisclosedProjectBean>();
        for (DevelopmentProposal devProposal : devProposalsToCompleteDiscl) {
            List<MedusaNode> medusaNodes = this.getMedusaService().getMedusaByProposal("DP", Long.parseLong(devProposal.getProposalNumber()));
            CoiDisclosedProjectBean disclosedProjectBean = new CoiDisclosedProjectBean();
            this.populateDisclosedAwardsAndProposals(medusaNodes, userId, disclosedProjectBean);
            disclosedProjects.add(disclosedProjectBean);
        }
        return disclosedProjects;
    }

    private List<CoiDisclosedProjectBean> getDisclosedProjectsBasedOnInstituteProposalLink(List<InstitutionalProposal> instProposalsToCompleteDiscl, String userId) {
        ArrayList<CoiDisclosedProjectBean> disclosedProjects = new ArrayList<CoiDisclosedProjectBean>();
        for (InstitutionalProposal instProposal : instProposalsToCompleteDiscl) {
            List<MedusaNode> medusaNodes = this.getMedusaService().getMedusaByProposal("IP", instProposal.getProposalId());
            CoiDisclosedProjectBean disclosedProjectBean = new CoiDisclosedProjectBean();
            this.populateDisclosedAwardsAndProposals(medusaNodes, userId, disclosedProjectBean);
            disclosedProjects.add(disclosedProjectBean);
        }
        return disclosedProjects;
    }

    private List<CoiDisclosedProjectBean> getDisclosedProjectsBasedOnAwardLink(List<Award> awardsToCompleteDiscl, String userId) {
        ArrayList<CoiDisclosedProjectBean> disclosedProjects = new ArrayList<CoiDisclosedProjectBean>();
        for (Award award : awardsToCompleteDiscl) {
            List<MedusaNode> medusaNodes = this.getMedusaService().getMedusaByAward("award", award.getAwardId());
            CoiDisclosedProjectBean disclosedProjectBean = new CoiDisclosedProjectBean();
            this.populateDisclosedAwardsAndProposals(medusaNodes, userId, disclosedProjectBean);
            disclosedProjects.add(disclosedProjectBean);
        }
        return disclosedProjects;
    }

    private List<Award> getRevisedAwardsToCompleteDiscl(List<Award> initAwardsToCompleteDiscl, List<Award> disclosedAwards) {
        List<Award> revisedAwardsToCompleteDiscl = initAwardsToCompleteDiscl;
        ArrayList<Award> awardsDisclosed = new ArrayList<Award>();
        block0: for (Award initAward : revisedAwardsToCompleteDiscl) {
            for (Award disclAward : disclosedAwards) {
                if (!initAward.getAwardNumber().equals(disclAward.getAwardNumber())) continue;
                awardsDisclosed.add(initAward);
                continue block0;
            }
        }
        revisedAwardsToCompleteDiscl.removeAll(awardsDisclosed);
        return revisedAwardsToCompleteDiscl;
    }

    private List<InstitutionalProposal> getRevisedInstProposalToCompleteDiscl(List<InstitutionalProposal> initInstProposalsToCompleteDiscl, List<InstitutionalProposal> disclosedInstProposals) {
        List<InstitutionalProposal> revisedProposalToCompleteDiscl = initInstProposalsToCompleteDiscl;
        ArrayList<InstitutionalProposal> proposalsDisclosed = new ArrayList<InstitutionalProposal>();
        block0: for (InstitutionalProposal initInstProposal : revisedProposalToCompleteDiscl) {
            for (InstitutionalProposal disclInstProposal : disclosedInstProposals) {
                if (!initInstProposal.getProposalNumber().equals(disclInstProposal.getProposalNumber())) continue;
                proposalsDisclosed.add(initInstProposal);
                continue block0;
            }
        }
        revisedProposalToCompleteDiscl.removeAll(proposalsDisclosed);
        return revisedProposalToCompleteDiscl;
    }

    private List<DevelopmentProposal> getRevisedDevProposalToCompleteDiscl(List<DevelopmentProposal> initDevProposalsToCompleteDiscl, List<DevelopmentProposal> disclosedDevProposals) {
        List<DevelopmentProposal> revisedProposalToCompleteDiscl = initDevProposalsToCompleteDiscl;
        ArrayList<DevelopmentProposal> proposalsDisclosed = new ArrayList<DevelopmentProposal>();
        block0: for (DevelopmentProposal initDevProposal : revisedProposalToCompleteDiscl) {
            for (DevelopmentProposal disclDevProposal : disclosedDevProposals) {
                if (!initDevProposal.getProposalNumber().equals(disclDevProposal.getProposalNumber())) continue;
                proposalsDisclosed.add(initDevProposal);
                continue block0;
            }
        }
        revisedProposalToCompleteDiscl.removeAll(proposalsDisclosed);
        return revisedProposalToCompleteDiscl;
    }

    private void populateDisclosedAwardsAndProposals(List<MedusaNode> medusaNodes, String userId, CoiDisclosedProjectBean projectDisclosureHelper) {
        for (MedusaNode medusaNode : medusaNodes) {
            this.addAwardAndProposalNodes(medusaNode, userId, projectDisclosureHelper);
            this.populateDisclosedAwardsAndProposals(medusaNode.getChildNodes(), userId, projectDisclosureHelper);
        }
    }

    private void addAwardAndProposalNodes(MedusaNode medusaNode, String userId, CoiDisclosedProjectBean projectDisclosureHelper) {
        boolean isAwardOrProposalDisclosed = false;
        if (StringUtils.equals((String)medusaNode.getType(), (String)"award")) {
            Award award = (Award)medusaNode.getBo();
            projectDisclosureHelper.getDisclosedAwards().add(award);
            isAwardOrProposalDisclosed = this.isProjectReported(award.getAwardNumber(), "1", userId);
        } else if (StringUtils.equals((String)medusaNode.getType(), (String)"DP")) {
            DevelopmentProposal devProposal = (DevelopmentProposal)medusaNode.getBo();
            projectDisclosureHelper.getDisclosedDevProposals().add(devProposal);
            isAwardOrProposalDisclosed = this.isProjectReported(devProposal.getProposalNumber(), "2", userId);
        } else if (StringUtils.equals((String)medusaNode.getType(), (String)"IP")) {
            InstitutionalProposal instProposal = (InstitutionalProposal)medusaNode.getBo();
            projectDisclosureHelper.getDisclosedInstProposals().add(instProposal);
            isAwardOrProposalDisclosed = this.isProjectReported(instProposal.getProposalNumber(), "10", userId);
        }
        projectDisclosureHelper.setProjectDisclosed(isAwardOrProposalDisclosed |= projectDisclosureHelper.isProjectDisclosed());
    }

    public MedusaService getMedusaService() {
        if (ObjectUtils.isNull((Object)this.medusaService)) {
            this.medusaService = KraServiceLocator.getService(MedusaService.class);
        }
        return this.medusaService;
    }

    public void setMedusaService(MedusaService medusaService) {
        this.medusaService = medusaService;
    }

    @Override
    public List<CoiDisclosureUndisclosedEvents> getUndisclosedEvents(Map<String, String> searchCriteria) {
        List<CoiDisclosureUndisclosedEvents> undisclosedEvents = new ArrayList<CoiDisclosureUndisclosedEvents>();
        String eventType = searchCriteria.get("disclosureEventType");
        DisclosureEventTypeConstants selectedEventType = null;
        selectedEventType = StringUtils.isBlank((String)eventType) ? DisclosureEventTypeConstants.AllEvents : DisclosureEventTypeConstants.valueOf(eventType);
        switch (selectedEventType) {
            case AllEvents: {
                undisclosedEvents = this.getAllUndisclosedEvents(searchCriteria);
                break;
            }
            case DevelopmentProposal: {
                undisclosedEvents = this.getDevelopmentProposalUndisclosedEvents(searchCriteria);
                break;
            }
            case InstituteProposal: {
                undisclosedEvents = this.getInstitutionalProposalUndisclosedEvents(searchCriteria);
                break;
            }
            case Award: {
                undisclosedEvents = this.getAwardUndisclosedEvents(searchCriteria);
                break;
            }
            case IRBProtocol: {
                undisclosedEvents = this.getIrbProtocolUndisclosedEvents(searchCriteria);
                break;
            }
            case IACUCProtocol: {
                undisclosedEvents = this.getIacucProtocolUndisclosedEvents(searchCriteria);
            }
        }
        return undisclosedEvents;
    }

    private List<CoiProjectsToCompleteDisclosureBean> getAllProjectsToDisclose(DisclosureEventTypeConstants selectedEventType, Map<String, String> searchCriteria) {
        Map<String, List<ProposalPerson>> personAndDevelopmentProposals = new HashMap<String, List<ProposalPerson>>();
        Map<String, List<InstitutionalProposalPerson>> personAndInstituteProposals = new HashMap<String, List<InstitutionalProposalPerson>>();
        Map<Object, Object> personAndAwards = new HashMap();
        Map<Object, Object> personAndIrbProtocols = new HashMap();
        Map<Object, Object> personAndIacucProtocols = new HashMap();
        ArrayList<CoiProjectsToCompleteDisclosureBean> allProjectsToDisclose = new ArrayList();
        switch (selectedEventType) {
            case AllEvents: {
                personAndDevelopmentProposals = this.getDevelopmentProposalPersonsForUndisclosedEvents(searchCriteria);
                personAndInstituteProposals = this.getInstitutionalProposalPersonsForUndisclosedEvents(searchCriteria);
                personAndAwards = this.getAwardPersonsForUndisclosedEvents(searchCriteria);
                personAndIrbProtocols = this.getIrbProtocolPersonsForUndisclosedEvents(searchCriteria);
                personAndIacucProtocols = this.getIacucProtocolPersonsForUndisclosedEvents(searchCriteria);
                break;
            }
            case DevelopmentProposal: {
                personAndDevelopmentProposals = this.getDevelopmentProposalPersonsForUndisclosedEvents(searchCriteria);
                break;
            }
            case InstituteProposal: {
                personAndInstituteProposals = this.getInstitutionalProposalPersonsForUndisclosedEvents(searchCriteria);
                break;
            }
            case Award: {
                personAndAwards = this.getAwardPersonsForUndisclosedEvents(searchCriteria);
                break;
            }
            case IRBProtocol: {
                personAndIrbProtocols = this.getIrbProtocolPersonsForUndisclosedEvents(searchCriteria);
                break;
            }
            case IACUCProtocol: {
                personAndIacucProtocols = this.getIacucProtocolPersonsForUndisclosedEvents(searchCriteria);
            }
        }
        allProjectsToDisclose = this.getAllProjectsToCompleteDisclosure(personAndDevelopmentProposals, personAndInstituteProposals, personAndAwards, personAndIrbProtocols, personAndIacucProtocols);
        return allProjectsToDisclose;
    }

    private List<CoiProjectsToCompleteDisclosureBean> getAllProjectsToCompleteDisclosure(Map<String, List<ProposalPerson>> personAndDevelopmentProposals, Map<String, List<InstitutionalProposalPerson>> personAndInstituteProposals, Map<String, List<AwardPerson>> personAndAwards, Map<String, List<ProtocolPerson>> personAndIrbProtocols, Map<String, List<IacucProtocolPerson>> personAndIacucProtocols) {
        HashMap<String, String> allProjectPersonsForDisclosure = this.getAllProjectPersonsForUndisclosedEvents(personAndDevelopmentProposals, personAndInstituteProposals, personAndAwards, personAndIrbProtocols, personAndIacucProtocols);
        Set<String> allProjectPersons = allProjectPersonsForDisclosure.keySet();
        ArrayList<CoiDisclosedProjectBean> disclosedProjects = new ArrayList<CoiDisclosedProjectBean>();
        ArrayList<DevelopmentProposal> initDevProposalsToCompleteDiscl = new ArrayList();
        ArrayList<InstitutionalProposal> initInstProposalsToCompleteDiscl = new ArrayList();
        ArrayList<Award> initAwardsToCompleteDiscl = new ArrayList();
        ArrayList<CoiProjectsToCompleteDisclosureBean> allProjectsToDisclose = new ArrayList<CoiProjectsToCompleteDisclosureBean>();
        for (String personId : allProjectPersons) {
            List<ProposalPerson> devProposalPersons = personAndDevelopmentProposals.get(personId);
            List<InstitutionalProposalPerson> instProposalPersons = personAndInstituteProposals.get(personId);
            List<AwardPerson> awardPersons = personAndAwards.get(personId);
            if (devProposalPersons != null && !devProposalPersons.isEmpty()) {
                initDevProposalsToCompleteDiscl = this.getProposals(devProposalPersons);
            }
            if (instProposalPersons != null && !instProposalPersons.isEmpty()) {
                initInstProposalsToCompleteDiscl = this.getInstitutionalProposals(instProposalPersons);
            }
            if (awardPersons != null && !awardPersons.isEmpty()) {
                initAwardsToCompleteDiscl = this.getAwards(awardPersons);
            }
            disclosedProjects.addAll(this.getDisclosedProjectsBasedOnDevelopmentProposalLink(initDevProposalsToCompleteDiscl, personId));
            disclosedProjects.addAll(this.getDisclosedProjectsBasedOnInstituteProposalLink(initInstProposalsToCompleteDiscl, personId));
            disclosedProjects.addAll(this.getDisclosedProjectsBasedOnAwardLink(initAwardsToCompleteDiscl, personId));
            CoiProjectsToCompleteDisclosureBean personProjectsToCompleteDisclosure = this.getRevisedProposalsAndAwardsToCompleteDisclosure(disclosedProjects, initDevProposalsToCompleteDiscl, initInstProposalsToCompleteDiscl, initAwardsToCompleteDiscl);
            personProjectsToCompleteDisclosure.setPersonId(personId);
            personProjectsToCompleteDisclosure.setPersonName(allProjectPersonsForDisclosure.get(personId));
            List<ProtocolPerson> irbProtocolPersons = personAndIrbProtocols.get(personId);
            List<Protocol> initIrbProtocolsToCompleteDiscl = new ArrayList<Protocol>();
            if (irbProtocolPersons != null && !irbProtocolPersons.isEmpty()) {
                initIrbProtocolsToCompleteDiscl = this.getProtocols(irbProtocolPersons);
            }
            personProjectsToCompleteDisclosure.setIrbProtocolsToDisclose(initIrbProtocolsToCompleteDiscl);
            List<IacucProtocolPerson> iacucProtocolPersons = personAndIacucProtocols.get(personId);
            List<IacucProtocol> initIacucProtocolsToCompleteDiscl = new ArrayList<IacucProtocol>();
            if (iacucProtocolPersons != null && !iacucProtocolPersons.isEmpty()) {
                initIacucProtocolsToCompleteDiscl = this.getIacucProtocols(iacucProtocolPersons);
            }
            personProjectsToCompleteDisclosure.setIacucProtocolsToDisclose(initIacucProtocolsToCompleteDiscl);
            allProjectsToDisclose.add(personProjectsToCompleteDisclosure);
        }
        return allProjectsToDisclose;
    }

    private HashMap<String, String> getAllProjectPersonsForUndisclosedEvents(Map<String, List<ProposalPerson>> personAndDevelopmentProposals, Map<String, List<InstitutionalProposalPerson>> personAndInstituteProposals, Map<String, List<AwardPerson>> personAndAwards, Map<String, List<ProtocolPerson>> personAndIrbProtocols, Map<String, List<IacucProtocolPerson>> personAndIacucProtocols) {
        String personName;
        String personId;
        HashMap<String, String> allProjectPersons = new HashMap<String, String>();
        for (Map.Entry<String, List<ProposalPerson>> entry : personAndDevelopmentProposals.entrySet()) {
            personId = entry.getKey();
            personName = entry.getValue().get(0).getFullName();
            allProjectPersons.put(personId, personName);
        }
        for (Map.Entry<String, List<KraPersistableBusinessObjectBase>> entry : personAndInstituteProposals.entrySet()) {
            personId = entry.getKey();
            personName = ((InstitutionalProposalPerson)entry.getValue().get(0)).getFullName();
            allProjectPersons.put(personId, personName);
        }
        for (Map.Entry<String, List<KraPersistableBusinessObjectBase>> entry : personAndAwards.entrySet()) {
            personId = entry.getKey();
            personName = ((AwardPerson)entry.getValue().get(0)).getFullName();
            allProjectPersons.put(personId, personName);
        }
        for (Map.Entry<String, List<KraPersistableBusinessObjectBase>> entry : personAndIrbProtocols.entrySet()) {
            personId = entry.getKey();
            personName = ((ProtocolPerson)entry.getValue().get(0)).getFullName();
            allProjectPersons.put(personId, personName);
        }
        for (Map.Entry<String, List<KraPersistableBusinessObjectBase>> entry : personAndIacucProtocols.entrySet()) {
            personId = entry.getKey();
            personName = ((IacucProtocolPerson)entry.getValue().get(0)).getFullName();
            allProjectPersons.put(personId, personName);
        }
        return allProjectPersons;
    }

    private List<CoiDisclosureUndisclosedEvents> getAllUndisclosedEvents(Map<String, String> searchCriteria) {
        List<CoiProjectsToCompleteDisclosureBean> allProjectsToCompleteDisclosure = this.getAllProjectsToDisclose(DisclosureEventTypeConstants.AllEvents, searchCriteria);
        return this.getFormattedUndsclosedEvents(allProjectsToCompleteDisclosure);
    }

    private List<CoiDisclosureUndisclosedEvents> getDevelopmentProposalUndisclosedEvents(Map<String, String> searchCriteria) {
        List<CoiProjectsToCompleteDisclosureBean> allProjectsToCompleteDisclosure = this.getAllProjectsToDisclose(DisclosureEventTypeConstants.DevelopmentProposal, searchCriteria);
        return this.getFormattedUndsclosedEvents(allProjectsToCompleteDisclosure);
    }

    private List<CoiDisclosureUndisclosedEvents> getInstitutionalProposalUndisclosedEvents(Map<String, String> searchCriteria) {
        List<CoiProjectsToCompleteDisclosureBean> allProjectsToCompleteDisclosure = this.getAllProjectsToDisclose(DisclosureEventTypeConstants.InstituteProposal, searchCriteria);
        return this.getFormattedUndsclosedEvents(allProjectsToCompleteDisclosure);
    }

    private List<CoiDisclosureUndisclosedEvents> getAwardUndisclosedEvents(Map<String, String> searchCriteria) {
        List<CoiProjectsToCompleteDisclosureBean> allProjectsToCompleteDisclosure = this.getAllProjectsToDisclose(DisclosureEventTypeConstants.Award, searchCriteria);
        return this.getFormattedUndsclosedEvents(allProjectsToCompleteDisclosure);
    }

    private List<CoiDisclosureUndisclosedEvents> getIrbProtocolUndisclosedEvents(Map<String, String> searchCriteria) {
        List<CoiProjectsToCompleteDisclosureBean> allProjectsToCompleteDisclosure = this.getAllProjectsToDisclose(DisclosureEventTypeConstants.IRBProtocol, searchCriteria);
        return this.getFormattedUndsclosedEvents(allProjectsToCompleteDisclosure);
    }

    private List<CoiDisclosureUndisclosedEvents> getIacucProtocolUndisclosedEvents(Map<String, String> searchCriteria) {
        List<CoiProjectsToCompleteDisclosureBean> allProjectsToCompleteDisclosure = this.getAllProjectsToDisclose(DisclosureEventTypeConstants.IACUCProtocol, searchCriteria);
        return this.getFormattedUndsclosedEvents(allProjectsToCompleteDisclosure);
    }

    private List<CoiDisclosureUndisclosedEvents> getFormattedUndsclosedEvents(List<CoiProjectsToCompleteDisclosureBean> allProjectsToCompleteDisclosure) {
        ArrayList<CoiDisclosureUndisclosedEvents> undisclosedEvents = new ArrayList<CoiDisclosureUndisclosedEvents>();
        for (CoiProjectsToCompleteDisclosureBean projectsToCompleteDisclosure : allProjectsToCompleteDisclosure) {
            String personId = projectsToCompleteDisclosure.getPersonId();
            String personName = projectsToCompleteDisclosure.getPersonName();
            undisclosedEvents.addAll(this.getUndisclosedEventsForDevProposal(projectsToCompleteDisclosure.getDevProposalsToDisclose(), personId, personName));
            undisclosedEvents.addAll(this.getUndisclosedEventsForInstProposal(projectsToCompleteDisclosure.getInstituteProposalsToDisclose(), personId, personName));
            undisclosedEvents.addAll(this.getUndisclosedEventsForAward(projectsToCompleteDisclosure.getAwardsToDisclose(), personId, personName));
            undisclosedEvents.addAll(this.getUndisclosedEventsForIrbProtocol(projectsToCompleteDisclosure.getIrbProtocolsToDisclose(), personId, personName));
            undisclosedEvents.addAll(this.getUndisclosedEventsForIacucProtocol(projectsToCompleteDisclosure.getIacucProtocolsToDisclose(), personId, personName));
        }
        return undisclosedEvents;
    }

    private List<CoiDisclosureUndisclosedEvents> getUndisclosedEventsForDevProposal(List<DevelopmentProposal> devProposalsToDisclose, String personId, String personName) {
        ArrayList<CoiDisclosureUndisclosedEvents> undisclosedEvents = new ArrayList<CoiDisclosureUndisclosedEvents>();
        for (DevelopmentProposal devProposal : devProposalsToDisclose) {
            String projectId = devProposal.getProjectId();
            String projectTitle = devProposal.getProjectName();
            String createDate = this.getFormattedCreateDate(devProposal.getUpdateTimestamp());
            String disclosureEventType = DisclosureEventTypeConstants.DevelopmentProposal.description();
            String projectStatus = devProposal.getProposalState().getDescription();
            undisclosedEvents.add(this.getNewUndisclosedEvent(personId, personName, projectId, projectTitle, disclosureEventType, createDate, projectStatus));
        }
        return undisclosedEvents;
    }

    private List<CoiDisclosureUndisclosedEvents> getUndisclosedEventsForInstProposal(List<InstitutionalProposal> instProposalsToDisclose, String personId, String personName) {
        ArrayList<CoiDisclosureUndisclosedEvents> undisclosedEvents = new ArrayList<CoiDisclosureUndisclosedEvents>();
        for (InstitutionalProposal instProposal : instProposalsToDisclose) {
            String projectId = instProposal.getProposalNumber();
            String projectTitle = instProposal.getTitle();
            String disclosureEventType = DisclosureEventTypeConstants.InstituteProposal.description();
            String createDate = this.getFormattedCreateDate(instProposal.getUpdateTimestamp());
            String projectStatus = instProposal.getProposalStatus().getDescription();
            undisclosedEvents.add(this.getNewUndisclosedEvent(personId, personName, projectId, projectTitle, disclosureEventType, createDate, projectStatus));
        }
        return undisclosedEvents;
    }

    private List<CoiDisclosureUndisclosedEvents> getUndisclosedEventsForAward(List<Award> awardsToDisclose, String personId, String personName) {
        ArrayList<CoiDisclosureUndisclosedEvents> undisclosedEvents = new ArrayList<CoiDisclosureUndisclosedEvents>();
        for (Award award : awardsToDisclose) {
            String projectId = award.getAwardNumber();
            String projectTitle = award.getTitle();
            String disclosureEventType = DisclosureEventTypeConstants.Award.description();
            String createDate = this.getFormattedCreateDate(award.getUpdateTimestamp());
            String projectStatus = award.getStatusDescription();
            undisclosedEvents.add(this.getNewUndisclosedEvent(personId, personName, projectId, projectTitle, disclosureEventType, createDate, projectStatus));
        }
        return undisclosedEvents;
    }

    private List<CoiDisclosureUndisclosedEvents> getUndisclosedEventsForIrbProtocol(List<Protocol> protocolsToDisclose, String personId, String personName) {
        ArrayList<CoiDisclosureUndisclosedEvents> undisclosedEvents = new ArrayList<CoiDisclosureUndisclosedEvents>();
        for (Protocol protocol : protocolsToDisclose) {
            String projectId = protocol.getProtocolNumber();
            String projectTitle = protocol.getTitle();
            String disclosureEventType = DisclosureEventTypeConstants.IRBProtocol.description();
            String createDate = this.getFormattedCreateDate(protocol.getUpdateTimestamp());
            String projectStatus = protocol.getProtocolStatus().getDescription();
            undisclosedEvents.add(this.getNewUndisclosedEvent(personId, personName, projectId, projectTitle, disclosureEventType, createDate, projectStatus));
        }
        return undisclosedEvents;
    }

    private List<CoiDisclosureUndisclosedEvents> getUndisclosedEventsForIacucProtocol(List<IacucProtocol> protocolsToDisclose, String personId, String personName) {
        ArrayList<CoiDisclosureUndisclosedEvents> undisclosedEvents = new ArrayList<CoiDisclosureUndisclosedEvents>();
        for (IacucProtocol protocol : protocolsToDisclose) {
            String projectId = protocol.getProtocolNumber();
            String projectTitle = protocol.getTitle();
            String disclosureEventType = DisclosureEventTypeConstants.IACUCProtocol.description();
            String createDate = this.getFormattedCreateDate(protocol.getUpdateTimestamp());
            String projectStatus = protocol.getProtocolStatus().getDescription();
            undisclosedEvents.add(this.getNewUndisclosedEvent(personId, personName, projectId, projectTitle, disclosureEventType, createDate, projectStatus));
        }
        return undisclosedEvents;
    }

    private CoiDisclosureUndisclosedEvents getNewUndisclosedEvent(String personId, String personName, String projectId, String projectTitle, String disclosureEventType, String createDate, String projectStatus) {
        CoiDisclosureUndisclosedEvents event = new CoiDisclosureUndisclosedEvents();
        event.setPersonId(personId);
        event.setPersonName(personName);
        event.setProjectId(projectId);
        event.setProjectTitle(projectTitle);
        event.setDisclosureEventType(disclosureEventType);
        event.setFormattedCreateDate(createDate);
        event.setProjectStatus(projectStatus);
        return event;
    }

    private boolean isSearchByCriteriaRequired(Map<String, String> searchCriteria) {
        boolean isCriteriaQueryRequired = false;
        for (String criteriaKey : this.getAllSearchCriteriasForUndisclosedEvents()) {
            if (!StringUtils.isNotBlank((String)searchCriteria.get(criteriaKey))) continue;
            isCriteriaQueryRequired = true;
            break;
        }
        return isCriteriaQueryRequired;
    }

    private Set<String> getAllSearchCriteriasForUndisclosedEvents() {
        HashSet<String> searchCriterias = new HashSet<String>();
        searchCriterias.add("personId");
        searchCriterias.add("createDateFrom");
        searchCriterias.add("createDateTo");
        searchCriterias.add("sponsorCode");
        return searchCriterias;
    }

    private Map<String, List<ProtocolPerson>> getIrbProtocolPersonsForUndisclosedEvents(Map<String, String> searchCriteria) {
        List<Object> protocolPersons = new ArrayList();
        protocolPersons = this.isSearchByCriteriaRequired(searchCriteria) ? this.getCoiDisclosureUndisclosedEventsDao().getIrbProtocolPersons(searchCriteria) : (List)this.businessObjectService.findAll(ProtocolPerson.class);
        HashMap<String, List<ProtocolPerson>> personAndProtocols = new HashMap<String, List<ProtocolPerson>>();
        ArrayList<ProtocolPerson> personProtocols = null;
        for (ProtocolPerson protocolPerson : protocolPersons) {
            String personId = protocolPerson.getPersonId();
            personProtocols = (ArrayList<ProtocolPerson>)personAndProtocols.get(personId);
            if (personProtocols == null) {
                personProtocols = new ArrayList<ProtocolPerson>();
            }
            personProtocols.add(protocolPerson);
            personAndProtocols.put(personId, personProtocols);
        }
        return personAndProtocols;
    }

    private Map<String, List<IacucProtocolPerson>> getIacucProtocolPersonsForUndisclosedEvents(Map<String, String> searchCriteria) {
        List<Object> protocolPersons = new ArrayList();
        protocolPersons = this.isSearchByCriteriaRequired(searchCriteria) ? this.getCoiDisclosureUndisclosedEventsDao().getIacucProtocolPersons(searchCriteria) : (List)this.businessObjectService.findAll(IacucProtocolPerson.class);
        HashMap<String, List<IacucProtocolPerson>> personAndProtocols = new HashMap<String, List<IacucProtocolPerson>>();
        ArrayList<IacucProtocolPerson> personProtocols = null;
        for (IacucProtocolPerson iacucProtocolPerson : protocolPersons) {
            String personId = iacucProtocolPerson.getPersonId();
            personProtocols = (ArrayList<IacucProtocolPerson>)personAndProtocols.get(personId);
            if (personProtocols == null) {
                personProtocols = new ArrayList<IacucProtocolPerson>();
            }
            personProtocols.add(iacucProtocolPerson);
            personAndProtocols.put(personId, personProtocols);
        }
        return personAndProtocols;
    }

    private Map<String, List<ProposalPerson>> getDevelopmentProposalPersonsForUndisclosedEvents(Map<String, String> searchCriteria) {
        List<Object> proposalPersons = new ArrayList();
        proposalPersons = this.isSearchByCriteriaRequired(searchCriteria) ? this.getCoiDisclosureUndisclosedEventsDao().getDevelopmentProposalPersons(searchCriteria) : (List)this.businessObjectService.findAll(ProposalPerson.class);
        HashMap<String, List<ProposalPerson>> personAndProposals = new HashMap<String, List<ProposalPerson>>();
        ArrayList<ProposalPerson> personProposals = null;
        for (ProposalPerson proposalPerson : proposalPersons) {
            String personId = proposalPerson.getPersonId();
            personProposals = (ArrayList<ProposalPerson>)personAndProposals.get(personId);
            if (personProposals == null) {
                personProposals = new ArrayList<ProposalPerson>();
            }
            personProposals.add(proposalPerson);
            personAndProposals.put(personId, personProposals);
        }
        return personAndProposals;
    }

    private Map<String, List<InstitutionalProposalPerson>> getInstitutionalProposalPersonsForUndisclosedEvents(Map<String, String> searchCriteria) {
        List<Object> proposalPersons = new ArrayList();
        proposalPersons = this.isSearchByCriteriaRequired(searchCriteria) ? this.getCoiDisclosureUndisclosedEventsDao().getInstituteProposalPersons(searchCriteria) : (List)this.businessObjectService.findAll(InstitutionalProposalPerson.class);
        HashMap<String, List<InstitutionalProposalPerson>> personAndProposals = new HashMap<String, List<InstitutionalProposalPerson>>();
        ArrayList<InstitutionalProposalPerson> personProposals = null;
        for (InstitutionalProposalPerson institutionalProposalPerson : proposalPersons) {
            String personId = institutionalProposalPerson.getPersonId();
            personProposals = (ArrayList<InstitutionalProposalPerson>)personAndProposals.get(personId);
            if (personProposals == null) {
                personProposals = new ArrayList<InstitutionalProposalPerson>();
            }
            personProposals.add(institutionalProposalPerson);
            personAndProposals.put(personId, personProposals);
        }
        return personAndProposals;
    }

    private Map<String, List<AwardPerson>> getAwardPersonsForUndisclosedEvents(Map<String, String> searchCriteria) {
        List<Object> awardPersons = new ArrayList();
        awardPersons = this.isSearchByCriteriaRequired(searchCriteria) ? this.getCoiDisclosureUndisclosedEventsDao().getAwardPersons(searchCriteria) : (List)this.businessObjectService.findAll(AwardPerson.class);
        HashMap<String, List<AwardPerson>> personAndAwards = new HashMap<String, List<AwardPerson>>();
        ArrayList<AwardPerson> personAwards = null;
        for (AwardPerson awardPerson : awardPersons) {
            String personId = awardPerson.getPersonId();
            personAwards = (ArrayList<AwardPerson>)personAndAwards.get(personId);
            if (personAwards == null) {
                personAwards = new ArrayList<AwardPerson>();
            }
            personAwards.add(awardPerson);
            personAndAwards.put(personId, personAwards);
        }
        return personAndAwards;
    }

    private String getFormattedCreateDate(Timestamp updateTimeStamp) {
        return new SimpleDateFormat("MM/dd/yyyy").format(updateTimeStamp);
    }

    public CoiDisclosureUndisclosedEventsDao getCoiDisclosureUndisclosedEventsDao() {
        return this.coiDisclosureUndisclosedEventsDao;
    }

    public void setCoiDisclosureUndisclosedEventsDao(CoiDisclosureUndisclosedEventsDao coiDisclosureUndisclosedEventsDao) {
        this.coiDisclosureUndisclosedEventsDao = coiDisclosureUndisclosedEventsDao;
    }

    @Override
    public List<CoiDisclosure> getAllDisclosuresForUser(String personId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        List disclosures = (List)this.businessObjectService.findMatching(CoiDisclosure.class, fieldValues);
        return disclosures;
    }

    @Override
    public boolean checkScreeningQuestionnaireRule(CoiDisclosureDocument coiDisclosureDocument) {
        String krmsRuleId = this.parameterService.getParameterValueAsString(CoiDisclosureDocument.class, "SCREENING_QUESTIONNAIRE_KRMS_RULE");
        if (StringUtils.isNotBlank((String)krmsRuleId)) {
            Map<String, Boolean> krmsResults = this.getKrmsRulesExecutionService().runApplicableRules(Arrays.asList(krmsRuleId), coiDisclosureDocument, "KC1000");
            Boolean result = krmsResults.get(krmsRuleId);
            return result != null && result != false;
        }
        return true;
    }

    public KrmsRulesExecutionService getKrmsRulesExecutionService() {
        return this.krmsRulesExecutionService;
    }

    public void setKrmsRulesExecutionService(KrmsRulesExecutionService krmsRulesExecutionService) {
        this.krmsRulesExecutionService = krmsRulesExecutionService;
    }

    @Override
    public Integer calculateMaximumDispositionStatusCode(CoiDisclosure coiDisclosure) {
        Integer defaultDisposition = this.getDefaultDispositionStatus(coiDisclosure);
        Integer retval = null;
        for (CoiDisclProject project : coiDisclosure.getCoiDisclProjects()) {
            Integer projectDisposition = null;
            for (CoiDiscDetail details : project.getCoiDiscDetails()) {
                if (projectDisposition != null && (details.getEntityDispositionCode() == null || projectDisposition >= details.getEntityDispositionCode())) continue;
                projectDisposition = details.getEntityDispositionCode();
            }
            if (projectDisposition != null) {
                project.setDisclosureDispositionCode(projectDisposition);
                project.refreshReferenceObject("coiDispositionStatus");
            }
            if (retval != null && (projectDisposition == null || retval >= projectDisposition)) continue;
            retval = projectDisposition;
        }
        if (retval == null) {
            return this.getDefaultDispositionStatus(coiDisclosure);
        }
        return retval;
    }

    protected Integer getDefaultDispositionStatus(CoiDisclosure coiDisclosure) {
        Integer retval = coiDisclosure.getDisclosureStatusCode() == null || StringUtils.equals((String)coiDisclosure.getDisclosureStatusCode(), (String)"1") ? Integer.valueOf("100") : Integer.valueOf("210");
        return retval;
    }

    @Override
    public CoiDispositionStatus calculateMaximumDispositionStatus(CoiDisclosure coiDisclosure) {
        return (CoiDispositionStatus)this.businessObjectService.findBySinglePrimaryKey(CoiDispositionStatus.class, (Object)this.calculateMaximumDispositionStatusCode(coiDisclosure));
    }

    @Override
    public void updateDisclosureAndProjectDisposition(CoiDisclosure coiDisclosure) {
        CoiDispositionStatus disposition = this.calculateMaximumDispositionStatus(coiDisclosure);
        coiDisclosure.setDisclosureDispositionCode(disposition.getCoiDispositionCode());
        coiDisclosure.setCoiDispositionStatus(disposition);
    }

    static {
        eventModuleMap.put("1", "1");
        eventModuleMap.put("2", "3");
        eventModuleMap.put("3", "7");
        eventModuleMap.put("4", "9");
        eventModuleMap.put("10", "2");
        eventModuleMap.put("11", "14");
        eventModuleMap.put("12", "14");
        eventModuleMap.put("13", "14");
        eventModuleMap.put("16", "14");
        eventModuleMap.put("15", "14");
    }
}

