/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.disclosure.CoiDisclosureProjectBean;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.coi.disclosure.MasterDisclosureBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class DisclosureFinancialEntityAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String FINANCIAL_ENTITY_AUDIT_ERRORS = "financialEntityDiscAuditErrors";
    private static final String NEW_TAG = "disclosureHelper.newCoiDisclProject.finEntityStatusMissing";
    private List<AuditError> auditErrors;

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        boolean isValid = true;
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        isValid = coiDisclosureDocument.getCoiDisclosure().isManualEvent() ? this.isConflictValueSelectedForManual(coiDisclosureDocument.getCoiDisclosure()) : (coiDisclosureDocument.getCoiDisclosure().isAnnualEvent() && !coiDisclosureDocument.getCoiDisclosure().isAnnualUpdate() ? this.isConflictValueSelectedForAnnual(coiDisclosureDocument.getCoiDisclosure()) : (coiDisclosureDocument.getCoiDisclosure().isUpdateEvent() || coiDisclosureDocument.getCoiDisclosure().isAnnualEvent() && coiDisclosureDocument.getCoiDisclosure().isAnnualUpdate() ? this.isConflictValueSelectedForUpdate(coiDisclosureDocument.getCoiDisclosure()) : this.isConflictValueSelected(coiDisclosureDocument.getCoiDisclosure())));
        this.reportAndCreateAuditCluster();
        return isValid;
    }

    protected void addErrorToAuditErrors(int index, String errorKey, String anchor, String error) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("coiDisclosure");
        stringBuilder.append(".");
        stringBuilder.append(anchor);
        this.auditErrors.add(new AuditError(String.format(errorKey, index), error, stringBuilder.toString()));
    }

    protected void addErrorToAuditErrors(int index, int index1, String errorKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("coiDisclosure");
        stringBuilder.append(".");
        stringBuilder.append("Financial Entity");
        this.auditErrors.add(new AuditError(String.format(errorKey, index, index1), "error.coi.financialentity.status.required", stringBuilder.toString()));
    }

    protected void addErrorToAuditErrors(String property, int index, int index1, String errorKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("coiDisclosure");
        stringBuilder.append(".");
        stringBuilder.append("Financial Entity");
        this.auditErrors.add(new AuditError(String.format(errorKey, property, index, index1), "error.coi.financialentity.status.required", stringBuilder.toString()));
    }

    protected boolean isConflictValueSelected(CoiDisclosure coiDisclosure) {
        boolean isSelected = true;
        int i = 0;
        for (CoiDiscDetail coiDiscDetail : coiDisclosure.getCoiDisclProjects().get(0).getCoiDiscDetails()) {
            if (coiDiscDetail.getEntityDispositionCode() == null) {
                this.addErrorToAuditErrors(i, "document.coiDisclosureList[0].coiDisclProjects[0].coiDiscDetails[%s].entityStatusCode", "Financial Entity", "error.coi.financialentity.status.required");
                isSelected = false;
            }
            ++i;
        }
        return isSelected;
    }

    protected boolean isConflictValueSelectedForAnnual(CoiDisclosure coiDisclosure) {
        boolean isSelected = true;
        int i = 0;
        if (ObjectUtils.isNotNull(coiDisclosure.getCoiDisclProjects()) && !coiDisclosure.getCoiDisclProjects().isEmpty()) {
            for (CoiDisclProject disclProject : coiDisclosure.getCoiDisclProjects()) {
                if (!this.isEventExcludedFE(disclProject.getDisclosureEventType())) {
                    int j = 0;
                    for (CoiDiscDetail coiDiscDetail : disclProject.getCoiDiscDetails()) {
                        if (coiDiscDetail.getEntityDispositionCode() == null) {
                            this.addErrorToAuditErrors(i, j, "document.coiDisclosureList[0].coiDisclProjects[%s].coiDiscDetails[%s].entityStatusCode");
                            isSelected = false;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return isSelected;
    }

    protected boolean isConflictValueSelectedForManual(CoiDisclosure coiDisclosure) {
        boolean isSelected = true;
        int i = 0;
        if (coiDisclosure.getCoiDisclProjects().isEmpty()) {
            this.addErrorToAuditErrors(i, "document.coiDisclosureList[0].coiDisclProjects[0].coiDiscDetails[%s].entityStatusCode", "Financial Entity", "error.coi.project.required");
            isSelected = false;
        } else if (!coiDisclosure.getCoiDisclosureEventType().isExcludeFinancialEntities()) {
            for (CoiDiscDetail coiDiscDetail : coiDisclosure.getCoiDisclProjects().get(0).getCoiDiscDetails()) {
                if (coiDiscDetail.getEntityDispositionCode() == null) {
                    this.addErrorToAuditErrors(i, "document.coiDisclosureList[0].coiDisclProjects[0].coiDiscDetails[%s].entityStatusCode", NEW_TAG, "error.coi.financialentity.status.required");
                    isSelected = false;
                }
                ++i;
            }
        }
        return isSelected;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(FINANCIAL_ENTITY_AUDIT_ERRORS, new AuditCluster("Disclosure", this.auditErrors, "Validation Errors"));
        }
    }

    protected boolean isConflictValueSelectedForUpdate(CoiDisclosure coiDisclosure) {
        MasterDisclosureBean masterDisclosureBean = this.getCoiDisclosureService().getMasterDisclosureDetail(coiDisclosure);
        boolean isSelected = true;
        isSelected &= this.checkProject(masterDisclosureBean.getAwardProjects(), "awardProjects");
        isSelected &= this.checkProject(masterDisclosureBean.getProtocolProjects(), "protocolProjects");
        isSelected &= this.checkProject(masterDisclosureBean.getProposalProjects(), "proposalProjects");
        isSelected &= this.checkProject(masterDisclosureBean.getManualAwardProjects(), "manualAwardProjects");
        isSelected &= this.checkProject(masterDisclosureBean.getManualProtocolProjects(), "manualProtocolProjects");
        isSelected &= this.checkProject(masterDisclosureBean.getManualProposalProjects(), "manualProposalProjects");
        return isSelected &= this.checkProject(masterDisclosureBean.getManualTravelProjects(), "manualTravelProjects");
    }

    private boolean checkProject(List<CoiDisclosureProjectBean> disclProjects, String property) {
        boolean isSelected = true;
        int i = 0;
        for (CoiDisclosureProjectBean disclProjectBean : disclProjects) {
            if (!disclProjectBean.isExcludeFE()) {
                int j = 0;
                for (CoiDiscDetail coiDiscDetail : disclProjectBean.getCoiDisclProject().getCoiDiscDetails()) {
                    if (coiDiscDetail.getEntityDispositionCode() == null) {
                        this.addErrorToAuditErrors(property, i, j, "disclosureHelper.masterDisclosureBean.%s[%s].coiDisclProject.coiDiscDetails[%s].entityStatusCode");
                        isSelected = false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return isSelected;
    }

    private CoiDisclosureService getCoiDisclosureService() {
        return KraServiceLocator.getService(CoiDisclosureService.class);
    }

    private boolean isEventExcludedFE(String eventTypeCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("eventTypeCode", eventTypeCode);
        CoiDisclosureEventType CoiDisclosureEventType2 = (CoiDisclosureEventType)KraServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(CoiDisclosureEventType.class, fieldValues);
        return CoiDisclosureEventType2.isExcludeFinancialEntities();
    }
}

