/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class CoiDisclosureLookupableHelperBase
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = -1746355811792663715L;
    private TaskAuthorizationService taskAuthorizationService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List<Object> retVal = new ArrayList();
        if (this.isAuthorizedForCoiLookups()) {
            retVal = this.getLookupSpecificSearchResults(fieldValues);
        }
        return retVal;
    }

    protected boolean isAuthorizedForCoiLookups() {
        ApplicationTask task = new ApplicationTask("lookupCoiDisclosures");
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        if (this.taskAuthorizationService == null) {
            this.taskAuthorizationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        }
        return this.taskAuthorizationService;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(Document document) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("docId", document.getDocumentNumber());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("person.userName")) continue;
                field.setFieldConversions("principalName:person.userName,principalId:personId");
            }
        }
        return rows;
    }

    @Override
    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        KcPerson person;
        String userName = (String)lookupForm.getFieldsForLookup().get("person.userName");
        if (StringUtils.isNotEmpty((String)userName) && (person = this.getKcPersonService().getKcPersonByUserName(userName)) != null) {
            lookupForm.getFieldsForLookup().put("personId", person.getPersonId());
        }
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    public KcPersonService getKcPersonService() {
        return KraServiceLocator.getService(KcPersonService.class);
    }

    public List<? extends BusinessObject> getResults(Map<String, String> fieldValues) {
        List allDisclosures = (List)this.getLookupService().findCollectionBySearch(CoiDisclosure.class, fieldValues);
        return allDisclosures;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        htmlDataList.add((HtmlData)this.getOpenLink((Document)((CoiDisclosure)businessObject).getCoiDisclosureDocument()));
        return htmlDataList;
    }

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
        htmlDataList.add((HtmlData)this.getEditLink(businessObject));
    }

    protected HtmlData.AnchorHtmlData getEditLink(BusinessObject businessObject) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("edit");
        return htmlData;
    }

    @Override
    protected String getDocumentTypeName() {
        return "CoiDisclosureDocument";
    }

    @Override
    protected String getHtmlAction() {
        return "coiDisclosure.do";
    }

    @Override
    protected String getKeyFieldName() {
        return "coiDisclosureId";
    }

    public abstract List<? extends BusinessObject> getLookupSpecificSearchResults(Map<String, String> var1);
}

