/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.lookup.CoiDisclosureLookupableHelperBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiDisclosureLookupableHelperServiceImpl
extends CoiDisclosureLookupableHelperBase {
    private static final long serialVersionUID = 7142988696939655833L;
    private static final String LEAD_UNIT = "leadUnitNumber";

    protected boolean validateDate(String dateFieldName, String dateFieldValue) {
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(dateFieldValue);
            return true;
        }
        catch (ParseException e) {
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        for (String key : fieldValues.keySet()) {
            String value = fieldValues.get(key).toString();
            if (key.toUpperCase().indexOf("DATE") <= 0 || value.indexOf("..") != -1 || value.indexOf(">=") != -1 || value.indexOf("<=") != -1 || StringUtils.isEmpty((CharSequence)value)) continue;
            this.validateDate(key, value);
        }
    }

    @Override
    public List<? extends BusinessObject> getLookupSpecificSearchResults(Map<String, String> fieldValues) {
        this.validateSearchParameters(fieldValues);
        super.setBackLocationDocFormKey(fieldValues);
        List<? extends BusinessObject> results = super.getResults(fieldValues);
        return this.filterResults(results, fieldValues);
    }

    protected List<CoiDisclosure> filterResults(List<CoiDisclosure> rawResults, Map<String, String> fieldValues) {
        ArrayList<CoiDisclosure> finalResults = new ArrayList<CoiDisclosure>();
        String researcherLeadUnit = fieldValues.get(LEAD_UNIT);
        for (CoiDisclosure disclosure : rawResults) {
            if (disclosure.getCoiDisclosureDocument() == null) continue;
            CoiDisclosureTask task = new CoiDisclosureTask("viewCoiDisclosure", disclosure);
            if (!this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task) || !StringUtils.isEmpty((CharSequence)researcherLeadUnit) && !researcherLeadUnit.equals(disclosure.getLeadUnitNumber())) continue;
            if (disclosure.isSystemEvent() || disclosure.isManualEvent()) {
                List<CoiDisclProject> coiDisclProjects = disclosure.getCoiDisclProjects();
                CoiDisclosureEventType coiDisclosureEventType = disclosure.getCoiDisclosureEventType();
                String coiDisclosureModuleItemKey = disclosure.getModuleItemKey();
                int index = 0;
                for (CoiDisclProject coiDisclProject : coiDisclProjects) {
                    if (coiDisclosureEventType.getEventTypeCode().equals(coiDisclProject.getDisclosureEventType()) && coiDisclosureModuleItemKey.equals(coiDisclProject.getModuleItemKey())) {
                        disclosure.setCoiDisclProjectId(coiDisclProjects.get(index).getProjectId());
                        disclosure.setCoiDisclProjectTitle(coiDisclProjects.get(index).getCoiProjectTitle());
                        break;
                    }
                    ++index;
                }
            }
            finalResults.add(disclosure);
        }
        return finalResults;
    }

    @Override
    protected boolean isAuthorizedForCoiLookups() {
        return true;
    }
}

