/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiDisclosureUndisclosedEventsLookupableHelper
extends KraLookupableHelperServiceImpl {
    private CoiDisclosureService coiDisclosureService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List<Object> undisclosedEvents = new ArrayList();
        this.validateSearchParameters(fieldValues);
        this.addDateRangeCriteria(fieldValues);
        if (this.canViewUndisclosedEvents()) {
            undisclosedEvents = this.getCoiDisclosureService().getUndisclosedEvents(fieldValues);
        }
        return undisclosedEvents;
    }

    protected boolean validateDate(String dateFieldName, String dateFieldValue) {
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(dateFieldValue);
            return true;
        }
        catch (ParseException e) {
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        for (String key : fieldValues.keySet()) {
            String value = fieldValues.get(key).toString();
            if (key.toUpperCase().indexOf("DATE") <= 0 || value.indexOf("..") != -1 || value.indexOf(">=") != -1 || value.indexOf("<=") != -1 || StringUtils.isEmpty((String)value)) continue;
            this.validateDate(key, value);
        }
    }

    private void addDateRangeCriteria(Map<String, String> fieldValues) {
        String dateParameter = fieldValues.get("createDate");
        if (dateParameter.contains("..")) {
            String[] values = dateParameter.split("\\.\\.");
            String startDate = values[0];
            String endDate = this.getRevisedCreateToDate(values[1], 1);
            fieldValues.put("createDateFrom", startDate);
            fieldValues.put("createDateTo", endDate);
        } else if (dateParameter.contains(">=")) {
            String dateValue = dateParameter.replace(">=", "");
            fieldValues.put("createDateFrom", dateValue);
        } else if (dateParameter.contains("<=")) {
            String dateValue = dateParameter.replace("<=", "");
            String endDate = this.getRevisedCreateToDate(dateValue, 1);
            fieldValues.put("createDateTo", endDate);
        }
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("person.userName")) continue;
                field.setFieldConversions("principalName:person.userName,principalId:personId");
            }
        }
        return rows;
    }

    @Override
    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        KcPerson person;
        String userName = (String)lookupForm.getFieldsForLookup().get("person.userName");
        if (StringUtils.isNotEmpty((String)userName) && (person = this.getKcPersonService().getKcPersonByUserName(userName)) != null) {
            lookupForm.getFieldsForLookup().put("personId", person.getPersonId());
        }
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    public KcPersonService getKcPersonService() {
        return KraServiceLocator.getService(KcPersonService.class);
    }

    public CoiDisclosureService getCoiDisclosureService() {
        return this.coiDisclosureService;
    }

    public void setCoiDisclosureService(CoiDisclosureService coiDisclosureService) {
        this.coiDisclosureService = coiDisclosureService;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        return htmlDataList;
    }

    @Override
    protected String getDocumentTypeName() {
        return "";
    }

    @Override
    protected String getHtmlAction() {
        return null;
    }

    @Override
    protected String getKeyFieldName() {
        return "projectId";
    }

    private boolean canViewUndisclosedEvents() {
        ApplicationTask task = new ApplicationTask("viewCoiUndisclosedEvents");
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private String getRevisedCreateToDate(String dateInput, int addDays) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(dateInput));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        cal.add(5, addDays);
        return sdf.format(cal.getTime());
    }
}

