/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.CoiDisclosureHistory;
import org.kuali.kra.coi.lookup.dao.CoiDisclosureDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.krad.util.OjbCollectionAware;

public class CoiDisclosureDaoOjb
extends PlatformAwareDaoBaseOjb
implements OjbCollectionAware,
CoiDisclosureDao {
    @Override
    public List<CoiDisclosureHistory> getApprovedAndDisapprovedDisclosureHistory(String coiDisclosureNumber) {
        Criteria crit1 = new Criteria();
        crit1.addEqualTo("coiDisclosureNumber", (Object)coiDisclosureNumber);
        crit1.addEqualTo("disclosureStatus", (Object)"3");
        Criteria crit2 = new Criteria();
        crit2.addEqualTo("coiDisclosureNumber", (Object)coiDisclosureNumber);
        crit2.addEqualTo("disclosureStatus", (Object)"4");
        crit1.addOrCriteria(crit2);
        QueryByCriteria query = QueryFactory.newQuery(CoiDisclosureHistory.class, (Criteria)crit1);
        query.addOrderByDescending("sequenceNumber");
        Collection history = new ArrayList();
        history = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return history;
    }

    @Override
    public List<CoiDisclosure> getReviewsForReviewStatuses(Collection<String> reviewStatusCodes) {
        if (reviewStatusCodes == null || reviewStatusCodes.isEmpty()) {
            return new ArrayList<CoiDisclosure>();
        }
        Criteria crit1 = new Criteria();
        for (String reviewCode : reviewStatusCodes) {
            Criteria crit2 = new Criteria();
            crit2.addEqualTo("reviewStatusCode", (Object)reviewCode);
            crit1.addOrCriteria(crit2);
        }
        QueryByCriteria query = QueryFactory.newQuery(CoiDisclosure.class, (Criteria)crit1);
        query.addOrderByDescending("sequenceNumber");
        Collection disclosures = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        block1: for (CoiDisclosure disclosure : disclosures) {
            List<CoiDisclProject> coiDisclProjects = disclosure.getCoiDisclProjects();
            CoiDisclosureEventType coiDisclosureEventType = disclosure.getCoiDisclosureEventType();
            String coiDisclosureModuleItemKey = disclosure.getModuleItemKey();
            for (CoiDisclProject coiDisclProject : coiDisclProjects) {
                if (!coiDisclosureEventType.getEventTypeCode().equals(coiDisclProject.getDisclosureEventType()) || !coiDisclosureModuleItemKey.equals(coiDisclProject.getModuleItemKey())) continue;
                disclosure.setCoiDisclProjectId(coiDisclProject.getProjectId());
                disclosure.setCoiDisclProjectTitle(coiDisclProject.getCoiProjectTitle());
                continue block1;
            }
        }
        return new ArrayList<CoiDisclosure>(disclosures);
    }
}

