/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.disclosure.CoiDisclosureProjectBean;
import org.kuali.kra.coi.disclosure.MasterDisclosureBean;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class CoiDisclosureProjectValuesFinder
extends KeyValuesBase {
    public List getKeyValues() {
        ArrayList<KeyValue> keyLabels = new ArrayList<KeyValue>();
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)KNSGlobalVariables.getKualiForm();
        CoiDisclosureDocument coiDisclosureDocument = coiDisclosureForm.getCoiDisclosureDocument();
        CoiDisclosure coiDisclosure = coiDisclosureDocument.getCoiDisclosure();
        String event = coiDisclosure.getEventTypeCode();
        String pid = coiDisclosureForm.getDisclosureHelper().getNewProjectId();
        if (coiDisclosureDocument != null && coiDisclosure != null && !StringUtils.isEmpty((String)event)) {
            if (StringUtils.equalsIgnoreCase((String)event, (String)"6")) {
                this.addMasterProjects(keyLabels, coiDisclosureForm.getDisclosureHelper().getMasterDisclosureBean());
            } else if (!coiDisclosure.getCoiDisclProjects().isEmpty()) {
                for (CoiDisclProject project : coiDisclosure.getCoiDisclProjects()) {
                    String projectId = project.getProjectId();
                    keyLabels.add((KeyValue)new ConcreteKeyValue(projectId, project.getEventDescription() + "--" + project.getProjectName() + "--" + projectId));
                }
            }
        }
        return keyLabels;
    }

    private void addMasterProjects(List<KeyValue> keyLabels, MasterDisclosureBean masterDisclosureBean) {
        this.addManualProject(keyLabels, masterDisclosureBean.getManualProtocolProjects(), "Manual Protocol --");
        this.addManualProject(keyLabels, masterDisclosureBean.getManualTravelProjects(), "Manual Travel --");
        this.addManualProject(keyLabels, masterDisclosureBean.getManualAwardProjects(), "Manual Award --");
        this.addManualProject(keyLabels, masterDisclosureBean.getManualProposalProjects(), "Manual Proposal --");
        this.addManualProject(keyLabels, masterDisclosureBean.getOtherManualProjects(), "Manual Other --");
        this.addAutomaticProject(keyLabels, masterDisclosureBean.getAwardProjects(), "AWARD --");
        this.addAutomaticProject(keyLabels, masterDisclosureBean.getProtocolProjects(), "PROTOCOL --");
        this.addAutomaticProject(keyLabels, masterDisclosureBean.getProposalProjects(), "PROPOSAL --");
    }

    private void addManualProject(List<KeyValue> keyLabels, List<CoiDisclosureProjectBean> manualProtocolProjects, String projectLabel) {
        for (CoiDisclosureProjectBean disclProjectBean : manualProtocolProjects) {
            CoiDisclProject disclProject = disclProjectBean.getCoiDisclProject();
            keyLabels.add((KeyValue)new ConcreteKeyValue(disclProject.getProjectId(), this.formatLabel(projectLabel + disclProject.getProjectId(), disclProject.getProjectName())));
        }
    }

    private void addAutomaticProject(List<KeyValue> keyLabels, List<CoiDisclosureProjectBean> automaticProtocolProjects, String projectLabel) {
        for (CoiDisclosureProjectBean disclProjectBean : automaticProtocolProjects) {
            CoiDisclProject coiDisclProject = disclProjectBean.getCoiDisclProject();
            keyLabels.add((KeyValue)new ConcreteKeyValue(coiDisclProject.getProjectId(), this.formatLabel(projectLabel + coiDisclProject.getProjectId(), coiDisclProject.getProjectName())));
        }
    }

    protected String formatLabel(String number, String title) {
        return number + "--" + title;
    }
}

