/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.maintenance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.CoeusSubModule;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.maintenance.CoiDisclosureEventTypeToCoeusSubModuleSynchronizerService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CoiDisclosureEventTypeToCoeusSubModuleSynchronizerServiceImpl
implements CoiDisclosureEventTypeToCoeusSubModuleSynchronizerService {
    private BusinessObjectService businessObjectService;
    private String coiCoeusModuleCode;

    @Override
    public void synchronizeCoeusSubModulesWithActiveCoiDisclosureEventTypes() {
        List<CoeusSubModule> currentSubModulesForCoi = this.getCurrentCoeusSubModulesForCoiModule();
        List<CoiDisclosureEventType> currentActiveCoiDisclosureEventTypes = this.getCurrentActiveCoiDisclosureEventTypes();
        for (CoeusSubModule subModule : currentSubModulesForCoi) {
            CoiDisclosureEventType correspondingCoiEventType = this.extractCorrespondingCoiEventType(subModule.getSubModuleCode(), currentActiveCoiDisclosureEventTypes);
            if (correspondingCoiEventType != null) {
                if (StringUtils.equals((String)subModule.getDescription(), (String)correspondingCoiEventType.getDescription())) continue;
                subModule.setDescription(correspondingCoiEventType.getDescription());
                this.getBusinessObjectService().save((PersistableBusinessObject)subModule);
                continue;
            }
            this.getBusinessObjectService().delete((PersistableBusinessObject)subModule);
        }
        if (!currentActiveCoiDisclosureEventTypes.isEmpty()) {
            int nextId = this.getMaxCoeusSubModuleId() + 1;
            for (CoiDisclosureEventType remainingCoiEventType : currentActiveCoiDisclosureEventTypes) {
                CoeusSubModule correspondingSubModule = this.getCorrespondingCoeusSubModule(remainingCoiEventType);
                correspondingSubModule.setCoeusSubModuleId(nextId);
                this.getBusinessObjectService().save((PersistableBusinessObject)correspondingSubModule);
                ++nextId;
            }
        }
    }

    private int getMaxCoeusSubModuleId() {
        int retVal = 0;
        ArrayList allCoeusSubModulesSortedById = new ArrayList();
        allCoeusSubModulesSortedById.addAll(this.getBusinessObjectService().findAllOrderBy(CoeusSubModule.class, "coeusSubModuleId", false));
        if (!allCoeusSubModulesSortedById.isEmpty()) {
            retVal = ((CoeusSubModule)((Object)allCoeusSubModulesSortedById.get(0))).getCoeusSubModuleId();
        }
        return retVal;
    }

    private CoeusSubModule getCorrespondingCoeusSubModule(CoiDisclosureEventType remainingCoiEventType) {
        CoeusSubModule correspondingSubModule = new CoeusSubModule();
        correspondingSubModule.setModuleCode(this.getCoiCoeusModuleCode());
        correspondingSubModule.setSubModuleCode(remainingCoiEventType.getEventTypeCode());
        correspondingSubModule.setDescription(remainingCoiEventType.getDescription());
        return correspondingSubModule;
    }

    private CoiDisclosureEventType extractCorrespondingCoiEventType(String subModuleCode, List<CoiDisclosureEventType> currentActiveCoiDisclosureEventTypes) {
        CoiDisclosureEventType retVal = null;
        for (CoiDisclosureEventType candidateEventType : currentActiveCoiDisclosureEventTypes) {
            if (!StringUtils.equals((String)candidateEventType.getEventTypeCode(), (String)subModuleCode)) continue;
            retVal = candidateEventType;
            break;
        }
        currentActiveCoiDisclosureEventTypes.remove((Object)retVal);
        return retVal;
    }

    private List<CoiDisclosureEventType> getCurrentActiveCoiDisclosureEventTypes() {
        ArrayList<CoiDisclosureEventType> activeCoiEventTypes = new ArrayList<CoiDisclosureEventType>();
        HashMap<String, Boolean> fieldValues = new HashMap<String, Boolean>();
        fieldValues.put("active", true);
        activeCoiEventTypes.addAll(this.getBusinessObjectService().findMatchingOrderBy(CoiDisclosureEventType.class, fieldValues, "eventTypeCode", true));
        return activeCoiEventTypes;
    }

    private List<CoeusSubModule> getCurrentCoeusSubModulesForCoiModule() {
        ArrayList<CoeusSubModule> coiSubModules = new ArrayList<CoeusSubModule>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleCode", this.getCoiCoeusModuleCode());
        coiSubModules.addAll(this.getBusinessObjectService().findMatchingOrderBy(CoeusSubModule.class, fieldValues, "subModuleCode", true));
        return coiSubModules;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public String getCoiCoeusModuleCode() {
        return this.coiCoeusModuleCode;
    }

    public void setCoiCoeusModuleCode(String coiCoeusModuleCode) {
        this.coiCoeusModuleCode = coiCoeusModuleCode;
    }
}

