/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.notesandattachments;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.coi.CoiAction;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.notesandattachments.CoiNotesAndAttachmentsHelper;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.service.CoiPrintingService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class CoiNoteAndAttachmentAction
extends CoiAction {
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String ATTACHMENT_PATH = "document.coiDisclosureList[0].attachmentCoiDisclosures[";
    private static final String CONFIRM_NO_DELETE = "";

    public ActionForward replaceAttachmentCoi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        return mapping.findForward("basic");
    }

    public ActionForward addAttachmentCoi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper().addNewCoiDisclosureAttachment();
        return mapping.findForward("basic");
    }

    public ActionForward deleteCoiDisclosureAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        if (this.isValidContactData((CoiDisclosureAttachment)attachment, ATTACHMENT_PATH + selection + "]")) {
            return this.confirmDeleteAttachment(mapping, (CoiDisclosureForm)form, request, response);
        }
        return mapping.findForward("basic");
    }

    protected boolean isValidContactData(CoiDisclosureAttachment attachment, String errorPath) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(errorPath);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)attachment);
        errorMap.removeFromErrorPath(errorPath);
        return errorMap.hasNoErrors();
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }

    protected ActionForward confirmDeleteAttachment(ActionMapping mapping, CoiDisclosureForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = form.getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        String confirmMethod = helper.retrieveConfirmMethodByType();
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, confirmMethod, "document.question.deleteAttachment.text", ((CoiDisclosureAttachment)attachment).getDescription(), ((CoiDisclosureAttachment)attachment).getFile().getName());
        return this.confirm(confirm, confirmMethod, CONFIRM_NO_DELETE);
    }

    public ActionForward confirmDeleteCoiDisclosureAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteAttachment(mapping, (CoiDisclosureForm)form, request, response, ProtocolAttachmentProtocol.class);
    }

    private ActionForward deleteAttachment(ActionMapping mapping, CoiDisclosureForm form, HttpServletRequest request, HttpServletResponse response, Class<? extends ProtocolAttachmentBase> attachmentType) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = form.getCoiNotesAndAttachmentsHelper();
        if (!helper.deleteExistingAttachmentByType(selection)) {
            // empty if block
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachmentCoi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        Object attachment = helper.retrieveExistingAttachmentByType(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = ((CoiDisclosureAttachment)attachment).getFile();
        Object attachmentFile = null;
        String attachmentFileType = file.getType().replace("\"", CONFIRM_NO_DELETE);
        this.streamToResponse(file.getData(), CoiNoteAndAttachmentAction.getValidHeaderString(file.getName()), CoiNoteAndAttachmentAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private byte[] getCoiDisclosureAttachmentFile(ActionForm form, CoiDisclosureAttachment attachment) {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getCoiPrintingService().getCoiPrintArtifacts(helper.getCoiDisclosure());
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                Integer attachmentDocumentId = attachment.getDocumentId();
                List<CoiDisclosureAttachment> coiDisclosureAttachmentList = helper.getCoiDisclosure().getCoiDisclosureAttachments();
                if (coiDisclosureAttachmentList.size() > 0) {
                    for (CoiDisclosureAttachment coiDisclosureAttachment : coiDisclosureAttachmentList) {
                        if (!attachmentDocumentId.equals(coiDisclosureAttachment.getDocumentId())) continue;
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return attachmentFile;
    }

    public ActionForward updateAttachmentFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        helper.addNewCoiDisclosureAttachmentFilter();
        return mapping.findForward("basic");
    }

    @Override
    public final ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        super.save(mapping, form, request, response);
        helper.fixReloadedAttachments(request.getParameterMap());
        return mapping.findForward("basic");
    }

    @Override
    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        if (!helper.getFilesToDelete().isEmpty()) {
            this.getBusinessObjectService().delete(helper.getFilesToDelete());
            helper.getFilesToDelete().clear();
        }
        for (CoiDisclosureAttachment attachment : ((CoiDisclosureForm)form).getCoiDisclosureDocument().getCoiDisclosure().getCoiDisclosureAttachments()) {
            attachment.getCoiDisclosure().refreshReferenceObject("coiDisclosureAttachments");
        }
    }

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        helper.addNewNote();
        helper.setManageNotesOpen();
        helper.prepareView();
        return mapping.findForward("basic");
    }

    public ActionForward editNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        CoiDisclosureForm disclosureForm = (CoiDisclosureForm)form;
        CoiNotesAndAttachmentsHelper helper = disclosureForm.getCoiNotesAndAttachmentsHelper();
        helper.editNote(selection);
        return mapping.findForward("basic");
    }

    public ActionForward deleteNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiNotesAndAttachmentsHelper helper = ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper();
        return this.confirmDeleteNote(mapping, (CoiDisclosureForm)form, request, response);
    }

    protected ActionForward confirmDeleteNote(ActionMapping mapping, CoiDisclosureForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        String confirmMethod = "deleteNoteConfirmed";
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, "deleteNoteConfirmed", "document.question.deleteNote.text", new String[0]);
        return this.confirm(confirm, "deleteNoteConfirmed", CONFIRM_NO_DELETE);
    }

    public ActionForward deleteNoteConfirmed(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        if (!((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper().deleteNote(selection)) {
            // empty if block
        }
        return mapping.findForward("basic");
    }

    protected CoiPrintingService getCoiPrintingService() {
        return KraServiceLocator.getService(CoiPrintingService.class);
    }

    protected WatermarkService getWatermarkService() {
        return KraServiceLocator.getService(WatermarkService.class);
    }
}

