/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.notesandattachments;

import edu.mit.irb.irbnamespace.ProtocolDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.auth.CoiDisclosureDeleteUpdateAttachmentTask;
import org.kuali.kra.coi.auth.CoiDisclosureDeleteUpdateNoteTask;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.notesandattachments.AddCoiDisclosureAttachmentEvent;
import org.kuali.kra.coi.notesandattachments.AddCoiDisclosureAttachmentRuleImpl;
import org.kuali.kra.coi.notesandattachments.AddCoiDisclosureNotepadEvent;
import org.kuali.kra.coi.notesandattachments.AddCoiDisclosureNotepadRuleImpl;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachmentFilter;
import org.kuali.kra.coi.notesandattachments.notes.CoiDisclosureNotepad;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.util.CollectionUtil;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiNotesAndAttachmentsHelper {
    private CoiDisclosureAttachment newCoiDisclosureAttachment;
    private CoiDisclosureForm coiDisclosureForm;
    private final BusinessObjectService businessObjectService;
    private CoiDisclosureAttachmentFilter newAttachmentFilter;
    private final ParameterService parameterService;
    private List<AttachmentFile> filesToDelete;
    private CoiDisclosureNotepad newCoiDisclosureNotepad;
    private final DateTimeService dateTimeService;
    private final IdentityService identityService;
    private static final String CONFIRM_YES_DELETE_ATTACHMENT = "confirmDeleteCoiDisclosureAttachment";
    private static final String PERSON_NOT_FOUND_FORMAT_STRING = "%s (not found)";
    private static final String ATTACHMENT_TYPE_CD = "1";
    private boolean viewRestricted;
    private boolean addAttachments;
    private boolean addNotepads;
    private boolean modifyAttachments;
    private boolean modifyNotepads;
    private boolean addCoiReviewerComments;
    private Map<Integer, Boolean> canDeleteUpdateAttachment = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> canDeleteUpdateNote = new HashMap<Integer, Boolean>();

    public CoiNotesAndAttachmentsHelper(CoiDisclosureForm coiDisclosureForm) {
        this.coiDisclosureForm = coiDisclosureForm;
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        this.parameterService = KraServiceLocator.getService(ParameterService.class);
        this.dateTimeService = KraServiceLocator.getService(DateTimeService.class);
        this.identityService = KraServiceLocator.getService(IdentityService.class);
        this.filesToDelete = new ArrayList<AttachmentFile>();
    }

    public CoiDisclosureAttachment getNewCoiDisclosureAttachment() {
        if (this.newCoiDisclosureAttachment == null) {
            this.initCoiDisclosureAttachment();
        }
        return this.newCoiDisclosureAttachment;
    }

    public void prepareView() {
        this.initializePermissions();
        this.initializeNotePaseUserNames(this.getCoiDisclosure().getCoiDisclosureNotepads());
    }

    private void initializePermissions() {
        this.addAttachments = this.canAddCoiDisclosureAttachments();
        this.addNotepads = this.canAddCoiDisclosureNotes();
        this.modifyAttachments = this.canMaintainCoiDisclosureAttachments();
        this.modifyNotepads = this.canMaintainCoiDisclosureNotes();
        this.viewRestricted = this.canViewRestrictedProtocolNotepads();
        this.addCoiReviewerComments = this.canAddCoiReviewerComments();
        this.canDeleteUpdateNotes();
        this.canDeleteUpdateAttachments();
    }

    protected void initializeNotePaseUserNames(List<CoiDisclosureNotepad> notepads) {
        for (CoiDisclosureNotepad notePad : notepads) {
            Person person = this.getPersonService().getPersonByPrincipalName(notePad.getUpdateUser());
            notePad.setUpdateUserFullName(person == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, notePad.getUpdateUser()) : person.getName());
            if (StringUtils.isNotBlank((String)notePad.getCreateUser())) {
                Person creator = this.getPersonService().getPersonByPrincipalName(notePad.getCreateUser());
                notePad.setCreateUserFullName(creator == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, notePad.getCreateUser()) : creator.getName());
                continue;
            }
            notePad.setCreateUserFullName("");
        }
    }

    public boolean isCanAddAttachment() {
        return this.addAttachments;
    }

    public boolean isAddNotepads() {
        return this.addNotepads;
    }

    public boolean isModifyAttachments() {
        return this.modifyAttachments;
    }

    public boolean isModifyNotepads() {
        return this.modifyNotepads;
    }

    public void setNewCoiDisclosureAttachment(CoiDisclosureAttachment coiDisclosureAttachment) {
        this.newCoiDisclosureAttachment = coiDisclosureAttachment;
    }

    private void canDeleteUpdateNotes() {
        List<CoiDisclosureNotepad> notes = this.getCoiDisclosure().getCoiDisclosureNotepads();
        for (int i = 0; i < notes.size(); ++i) {
            CoiDisclosureDeleteUpdateNoteTask task = new CoiDisclosureDeleteUpdateNoteTask("deleteUpdateNote", this.getCoiDisclosure(), notes.get(i));
            this.canDeleteUpdateNote.put(i, this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task));
        }
    }

    public Map<Integer, Boolean> getCanDeleteUpdateNotes() {
        return this.canDeleteUpdateNote;
    }

    private void canDeleteUpdateAttachments() {
        List<CoiDisclosureAttachment> attachments = this.getCoiDisclosure().getCoiDisclosureAttachments();
        for (int i = 0; i < attachments.size(); ++i) {
            CoiDisclosureDeleteUpdateAttachmentTask task = new CoiDisclosureDeleteUpdateAttachmentTask("deleteUpdateAttachment", this.getCoiDisclosure(), attachments.get(i));
            this.canDeleteUpdateAttachment.put(i, this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task));
        }
    }

    protected boolean canDeleteAttachmentById(String id) {
        this.getCoiDisclosure().refreshReferenceObject("coiDisclosureAttachments");
        List<CoiDisclosureAttachment> attachments = this.getCoiDisclosure().getCoiDisclosureAttachments();
        for (CoiDisclosureAttachment attachment : attachments) {
            if (!StringUtils.equalsIgnoreCase((String)attachment.getAttachmentIdForPermission().toString(), (String)id)) continue;
            CoiDisclosureDeleteUpdateAttachmentTask task = new CoiDisclosureDeleteUpdateAttachmentTask("deleteUpdateAttachment", this.getCoiDisclosure(), attachment);
            return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
        }
        return false;
    }

    public Map<Integer, Boolean> getCanDeleteUpdateNote() {
        return this.canDeleteUpdateNote;
    }

    public Map<Integer, Boolean> getCanDeleteUpdateAttachment() {
        return this.canDeleteUpdateAttachment;
    }

    private void initCoiDisclosureAttachment() {
        this.setNewCoiDisclosureAttachment(new CoiDisclosureAttachment(this.getCoiDisclosure()));
        CoiDisclosure coiDisclosure = this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
        String event = coiDisclosure.getEventTypeCode();
        if (StringUtils.equalsIgnoreCase((String)event, (String)ATTACHMENT_TYPE_CD) || StringUtils.equalsIgnoreCase((String)event, (String)"2") || StringUtils.equalsIgnoreCase((String)event, (String)"10") || StringUtils.equalsIgnoreCase((String)event, (String)"3")) {
            String projectId = coiDisclosure.getCoiDisclProjects().get(0).getProjectId();
            this.newCoiDisclosureAttachment.setProjectId(projectId);
        }
    }

    public CoiDisclosureForm getCoiDisclosureForm() {
        return this.coiDisclosureForm;
    }

    public void setCoiDisclosureForm(CoiDisclosureForm coiDisclosureForm) {
        this.coiDisclosureForm = coiDisclosureForm;
    }

    public boolean isViewRestricted() {
        return this.viewRestricted;
    }

    public void setViewRestricted(boolean viewRestricted) {
        this.viewRestricted = viewRestricted;
    }

    private boolean canViewRestrictedProtocolNotepads() {
        if (StringUtils.equals((String)this.getUserIdentifier(), (String)this.getCoiDisclosure().getPersonId())) {
            return false;
        }
        CoiDisclosureTask task = new CoiDisclosureTask("viewCoiRestrictedNotes", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean canAddCoiDisclosureNotes() {
        CoiDisclosureTask task = new CoiDisclosureTask("addCoiDisclosureNotes", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean canViewCoiDisclosure() {
        CoiDisclosureTask task = new CoiDisclosureTask("viewCoiDisclosure", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public boolean isPerformCoiDisclosureActions() {
        CoiDisclosureTask task = new CoiDisclosureTask("performCoiDisclosureAction", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean canAddCoiReviewerComments() {
        boolean userIsCoiReviewer = false;
        if (this.canViewCoiDisclosure() && this.canMaintainCoiDisclosureNotes() && this.canMaintainCoiDisclosureAttachments() && this.isPerformCoiDisclosureActions()) {
            userIsCoiReviewer = true;
        }
        return userIsCoiReviewer;
    }

    protected boolean canAddCoiDisclosureAttachments() {
        CoiDisclosureTask task = new CoiDisclosureTask("addCoiDisclosureAttachments", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean canMaintainCoiDisclosureNotes() {
        CoiDisclosureTask task = new CoiDisclosureTask("maintainCoiDisclosureNotes", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean canMaintainCoiDisclosureAttachments() {
        CoiDisclosureTask task = new CoiDisclosureTask("maintainCoiDisclosureAttachments", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    public String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public String getCurrentUser() {
        return this.identityService.getPrincipal(this.getUserIdentifier()).getPrincipalName();
    }

    public void addNewCoiDisclosureAttachment() {
        this.refreshAttachmentReferences(Collections.singletonList(this.getNewCoiDisclosureAttachment()));
        this.syncNewFiles(Collections.singletonList(this.getNewCoiDisclosureAttachment()));
        AddCoiDisclosureAttachmentRuleImpl rule = new AddCoiDisclosureAttachmentRuleImpl();
        AddCoiDisclosureAttachmentEvent event = new AddCoiDisclosureAttachmentEvent(this.coiDisclosureForm.getDocument(), this.newCoiDisclosureAttachment);
        this.assignDocumentId(Collections.singletonList(this.getNewCoiDisclosureAttachment()), this.createTypeToMaxDocNumber(this.getCoiDisclosure().getCoiDisclosureAttachments()));
        if (rule.processAddCoiDisclosureAttachmentRules(event)) {
            this.newCoiDisclosureAttachment.setCoiDisclosureId(this.getCoiDisclosure().getCoiDisclosureId());
            this.newCoiDisclosureAttachment.setSequenceNumber(this.getCoiDisclosure().getSequenceNumber());
            this.newCoiDisclosureAttachment.setEventTypeCode(this.getCoiDisclosure().getEventTypeCode() + "");
            this.getCoiDisclosure().addAttachment(this.newCoiDisclosureAttachment);
            this.getBusinessObjectService().save((PersistableBusinessObject)this.newCoiDisclosureAttachment);
            this.initCoiDisclosureAttachment();
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public <T extends CoiDisclosureAttachment> String retrieveConfirmMethodByType() {
        String confirmMethod = CONFIRM_YES_DELETE_ATTACHMENT;
        return confirmMethod;
    }

    public <T extends CoiDisclosureAttachment> T retrieveExistingAttachmentByType(int attachmentNumber) {
        CoiDisclosureAttachment attachment = CoiNotesAndAttachmentsHelper.retrieveExistingAttachment(attachmentNumber, this.getCoiDisclosure().getCoiDisclosureAttachments());
        return (T)attachment;
    }

    private static <T extends CoiDisclosureAttachment> T retrieveExistingAttachment(int index, List<T> attachments) {
        return (T)((CoiDisclosureAttachment)CollectionUtil.getFromList(index, attachments));
    }

    private <T extends CoiDisclosureAttachment> Map<String, Integer> createTypeToMaxDocNumber(Collection<T> attachments) {
        assert (attachments != null) : "the attachments was null";
        HashMap<String, Integer> typeToDocNumber = new HashMap<String, Integer>();
        for (CoiDisclosureAttachment attachment : attachments) {
            Integer curMax = (Integer)typeToDocNumber.get(ATTACHMENT_TYPE_CD);
            if (curMax != null && curMax >= attachment.getDocumentId()) continue;
            typeToDocNumber.put(ATTACHMENT_TYPE_CD, attachment.getDocumentId());
        }
        return typeToDocNumber;
    }

    private static Integer createNextDocNumber(Integer docNumber) {
        return docNumber == null ? NumberUtils.INTEGER_ONE : Integer.valueOf(docNumber + 1);
    }

    private void assignDocumentId(List<CoiDisclosureAttachment> attachments, Map<String, Integer> typeToDocNumber) {
        for (CoiDisclosureAttachment attachment : attachments) {
            Integer nextDocNumber = CoiNotesAndAttachmentsHelper.createNextDocNumber(typeToDocNumber.get(ATTACHMENT_TYPE_CD));
            attachment.setDocumentId(nextDocNumber);
        }
    }

    private void initAttachmentFilter() {
        CoiDisclosureAttachmentFilter disclosureFilter = new CoiDisclosureAttachmentFilter();
        try {
            String defaultSortBy = this.parameterService.getParameterValueAsString(ProtocolDocument.class, "coiAttachmentDefaultSort");
            if (StringUtils.isNotBlank((String)defaultSortBy)) {
                disclosureFilter.setSortBy(defaultSortBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setNewAttachmentFilter(disclosureFilter);
    }

    public CoiDisclosure getCoiDisclosure() {
        if (this.coiDisclosureForm.getDocument() == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure() == null) {
            throw new IllegalArgumentException("the coiDisclosure is null");
        }
        return this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
    }

    public CoiDisclosureAttachmentFilter getNewAttachmentFilter() {
        if (this.newAttachmentFilter == null) {
            this.initAttachmentFilter();
        }
        return this.newAttachmentFilter;
    }

    public void setNewAttachmentFilter(CoiDisclosureAttachmentFilter newAttachmentFilter) {
        this.newAttachmentFilter = newAttachmentFilter;
    }

    public void addNewCoiDisclosureAttachmentFilter() {
        this.getCoiDisclosure().setCoiDisclosureAttachmentFilter(this.getNewAttachmentFilter());
    }

    public void processSave() {
        this.refreshAttachmentReferences(this.getCoiDisclosure().getCoiDisclosureAttachments());
        this.syncNewFiles(this.getCoiDisclosure().getCoiDisclosureAttachments());
    }

    protected void syncNewFiles(List<CoiDisclosureAttachment> coiDisclosureAttachments) {
        assert (coiDisclosureAttachments != null) : "the attachments was null";
        for (CoiDisclosureAttachment attachment : coiDisclosureAttachments) {
            if (!CoiNotesAndAttachmentsHelper.doesNewFileExist(attachment)) continue;
            AttachmentFile newFile = AttachmentFile.createFromFormFile(attachment.getNewFile());
            if (attachment.getFile() != null) {
                newFile.setSequenceNumber(attachment.getFile().getSequenceNumber());
            }
            attachment.setFile(newFile);
            attachment.setNewFile(null);
        }
    }

    private static boolean doesNewFileExist(CoiDisclosureAttachment attachment) {
        assert (attachment != null) : "the attachment was null";
        return attachment.getNewFile() != null && StringUtils.isNotBlank((String)attachment.getNewFile().getFileName());
    }

    private void refreshAttachmentReferences(List<CoiDisclosureAttachment> coiDisclosureAttachments) {
        assert (coiDisclosureAttachments != null) : "the attachments was null";
        for (CoiDisclosureAttachment attachment : coiDisclosureAttachments) {
            if (!(attachment instanceof CoiDisclosureAttachment)) continue;
            attachment.refreshReferenceObject("status");
            attachment.refreshReferenceObject("coiAttachmentType");
        }
    }

    public List<AttachmentFile> getFilesToDelete() {
        return this.filesToDelete;
    }

    public void setFilesToDelete(List<AttachmentFile> filesToDelete) {
        this.filesToDelete = filesToDelete;
    }

    public void fixReloadedAttachments(Map parameterMap) {
        Iterator keys = parameterMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String fieldNameStarter = "coiDisclosureRefreshButtonClicked";
            try {
                String fieldValue;
                if (key.indexOf(fieldNameStarter) <= -1 || !"T".equals(fieldValue = ((String[])parameterMap.get(key))[0])) continue;
                int numericVal = Integer.valueOf(key.substring(fieldNameStarter.length()));
                Object attachment = this.retrieveExistingAttachmentByType(numericVal);
                FormFile file = ((CoiDisclosureAttachment)attachment).getNewFile();
                if (file == null) {
                    return;
                }
                try {
                    byte[] fileData = file.getFileData();
                    if (fileData.length <= 0) continue;
                    AttachmentFile newFile = new AttachmentFile();
                    newFile.setType(file.getContentType());
                    newFile.setName(file.getFileName());
                    newFile.setData(file.getFileData());
                    ((CoiDisclosureAttachment)attachment).setFile(newFile);
                    this.getBusinessObjectService().save(attachment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setOriginalDisclosureIdsIfNecessary(CoiDisclosure disclosure) {
        for (CoiDisclosureAttachment attachment : disclosure.getCoiDisclosureAttachments()) {
            if (attachment.getOriginalCoiDisclosureId() != null) continue;
            attachment.setOriginalCoiDisclosureId(disclosure.getCoiDisclosureId());
        }
        for (CoiDisclosureNotepad note : disclosure.getCoiDisclosureNotepads()) {
            if (note.getOriginalCoiDisclosureId() != null) continue;
            note.setOriginalCoiDisclosureId(disclosure.getCoiDisclosureId());
        }
    }

    public boolean deleteExistingAttachmentByType(int attachmentNumber) {
        boolean deleted = this.deleteExistingAttachment(attachmentNumber, this.getCoiDisclosure().getCoiDisclosureAttachments());
        return deleted;
    }

    protected <T extends CoiDisclosureAttachment> boolean deleteExistingAttachment(int index, List<T> attachments) {
        if (!CollectionUtil.validIndexForList(index, attachments)) {
            return false;
        }
        CoiDisclosureAttachment attachment = (CoiDisclosureAttachment)attachments.get(index);
        attachments.remove(attachment);
        return true;
    }

    public void setNewCoiDisclosureNotepad(CoiDisclosureNotepad newCoiDisclosureNotepad) {
        this.newCoiDisclosureNotepad = newCoiDisclosureNotepad;
    }

    public CoiDisclosureNotepad getNewCoiDisclosureNotepad() {
        if (this.newCoiDisclosureNotepad == null) {
            this.initCoiDisclosureNotepad();
        }
        return this.newCoiDisclosureNotepad;
    }

    public void addNewNote() {
        AddCoiDisclosureNotepadRuleImpl rule = new AddCoiDisclosureNotepadRuleImpl();
        AddCoiDisclosureNotepadEvent event = new AddCoiDisclosureNotepadEvent((CoiDisclosureDocument)this.coiDisclosureForm.getDocument(), this.newCoiDisclosureNotepad);
        if (rule.processAddCoiDisclosureNotepadRules(event)) {
            this.newCoiDisclosureNotepad.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
            this.newCoiDisclosureNotepad.setCreateTimestamp(((DateTimeService)KraServiceLocator.getService("dateTimeService")).getCurrentTimestamp());
            this.addNewNotepad(this.newCoiDisclosureNotepad);
            this.initCoiDisclosureNotepad();
        }
    }

    private void initCoiDisclosureNotepad() {
        CoiDisclosureNotepad notepad = new CoiDisclosureNotepad(this.getCoiDisclosure());
        notepad.setEntryNumber(this.getNextEntryNumber());
        CoiDisclosure coiDisclosure = this.coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
        String event = coiDisclosure.getEventTypeCode();
        if (StringUtils.equalsIgnoreCase((String)event, (String)ATTACHMENT_TYPE_CD) || StringUtils.equalsIgnoreCase((String)event, (String)"2") || StringUtils.equalsIgnoreCase((String)event, (String)"10") || StringUtils.equalsIgnoreCase((String)event, (String)"3")) {
            String projectId = coiDisclosure.getCoiDisclProjects().get(0).getProjectId();
            notepad.setProjectId(projectId);
        }
        notepad.setEventTypeCode(event);
        if (this.canAddCoiDisclosureNotes() && coiDisclosure.isSubmitted() && this.addCoiReviewerComments) {
            notepad.setNoteTypeCode("2");
        }
        this.setNewCoiDisclosureNotepad(notepad);
    }

    private void addNewNotepad(CoiDisclosureNotepad notepad) {
        this.setUpdateFields(notepad);
        notepad.resetUpdateTimestamp();
        notepad.setEditable(false);
        notepad.setCoiDisclosureId(this.getCoiDisclosure().getCoiDisclosureId());
        notepad.setCoiDisclosureNumber(this.getCoiDisclosure().getCoiDisclosureNumber());
        notepad.setSequenceNumber(this.getCoiDisclosure().getSequenceNumber());
        notepad.setEntryNumber(this.getNextEntryNumber());
        if (notepad.getFinancialEntity() == null && notepad.getFinancialEntityId() != null) {
            notepad.refreshReferenceObject("financialEntity");
        }
        this.getBusinessObjectService().save((PersistableBusinessObject)notepad);
        this.getCoiDisclosure().getCoiDisclosureNotepads().add(notepad);
    }

    protected DocumentService getDocumentService() {
        return KraServiceLocator.getService(DocumentService.class);
    }

    protected void setUpdateFields(KraPersistableBusinessObjectBase bo) {
        bo.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        bo.setUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
    }

    private Integer getNextEntryNumber() {
        return this.getCoiDisclosure().getCoiDisclosureNotepads().size() + 1;
    }

    public void setManageNotesOpen() {
    }

    public void editNote(int noteToModify) {
        CoiDisclosureNotepad notepadObject = this.getCoiDisclosure().getCoiDisclosureNotepads().get(noteToModify);
        notepadObject.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        notepadObject.setUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
        notepadObject.setEditable(true);
    }

    public boolean deleteNote(int noteToDelete) {
        this.deleteNotepad(noteToDelete);
        return true;
    }

    private void deleteNotepad(int noteToDelete) {
        this.getCoiDisclosure().getCoiDisclosureNotepads().remove(noteToDelete);
    }

    public PersonService getPersonService() {
        return KraServiceLocator.getService(PersonService.class);
    }
}

