/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.notesandattachments.attachments;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.coi.CoiAttachmentType;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureAssociate;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;

public class CoiDisclosureAttachment
extends CoiDisclosureAssociate
implements Comparable<CoiDisclosureAttachment> {
    private static final long serialVersionUID = 8722598360752485817L;
    private Long attachmentId;
    private Long fileId;
    private Integer documentId;
    private transient AttachmentFile file;
    private transient FormFile newFile;
    @SkipVersioning
    private transient String updateUserFullName;
    private Long coiDisclosureId;
    private String description;
    private String contactName;
    private String contactEmailAddress;
    private String contactPhoneNumber;
    private String comments;
    private String documentStatusCode;
    private Timestamp createTimestamp;
    private String projectId;
    private String eventTypeCode;
    private Long originalCoiDisclosureId;
    @SkipVersioning
    private CoiDisclosure originalCoiDisclosure;
    private String projectName;
    private Long financialEntityId;
    private String typeCode;
    private CoiAttachmentType coiAttachmentType;
    private final String MESSAGE_UPDATED_BY = "message.updated.by";
    @SkipVersioning
    private PersonFinIntDisclosure financialEntity;
    private static String updatedByString;
    private transient Long attachmentIdForPermission;
    private String usageSectionId;

    public CoiDisclosureAttachment() {
    }

    public CoiDisclosureAttachment(CoiDisclosure coiDisclosure) {
        this.setCoiDisclosure(coiDisclosure);
    }

    public Long getFinancialEntityId() {
        return this.financialEntityId;
    }

    public void setFinancialEntityId(Long financialEntityId) {
        this.financialEntityId = financialEntityId;
    }

    public PersonFinIntDisclosure getFinancialEntity() {
        return this.financialEntity;
    }

    public void setFinancialEntity(PersonFinIntDisclosure financialEntity) {
        this.financialEntity = financialEntity;
    }

    public String getFinancialEntityName() {
        this.refreshReferenceObject("financialEntity");
        return ObjectUtils.isNotNull((Object)this.getFinancialEntity()) ? this.getFinancialEntity().getEntityName() : "";
    }

    public String getEventTypeCode() {
        return this.eventTypeCode;
    }

    public void setEventTypeCode(String eventTypeCode) {
        this.eventTypeCode = eventTypeCode;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getContactEmailAddress() {
        return this.contactEmailAddress;
    }

    public void setContactEmailAddress(String contactEmailAddress) {
        this.contactEmailAddress = contactEmailAddress;
    }

    public String getContactPhoneNumber() {
        return this.contactPhoneNumber;
    }

    public void setContactPhoneNumber(String contactPhoneNumber) {
        this.contactPhoneNumber = contactPhoneNumber;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
        if (attachmentId != null) {
            this.attachmentIdForPermission = attachmentId;
        }
    }

    public Long getAttachmentIdForPermission() {
        if (this.attachmentIdForPermission == null) {
            this.attachmentIdForPermission = this.getAttachmentId();
        }
        return this.attachmentIdForPermission;
    }

    public void setAttachmentIdForPermission(Long attachmentId) {
        this.attachmentIdForPermission = attachmentId;
    }

    public Long getFileId() {
        return this.fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public Integer getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Integer documentId) {
        this.documentId = documentId;
    }

    public AttachmentFile getFile() {
        return this.file;
    }

    public void setFile(AttachmentFile file) {
        this.file = file;
    }

    public FormFile getNewFile() {
        return this.newFile;
    }

    public void setNewFile(FormFile newFile) {
        this.newFile = newFile;
    }

    public String getUpdateUserFullName() {
        return this.updateUserFullName;
    }

    public void setUpdateUserFullName(String updateUserFullName) {
        this.updateUserFullName = updateUserFullName;
    }

    @Override
    public Long getCoiDisclosureId() {
        return this.coiDisclosureId;
    }

    @Override
    public void setCoiDisclosureId(Long coiDisclosureId) {
        this.coiDisclosureId = coiDisclosureId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    public String getDocumentStatusCode() {
        return this.documentStatusCode;
    }

    public CoiAttachmentType getCoiAttachmentType() {
        return this.coiAttachmentType;
    }

    public void setCoiAttachmentType(CoiAttachmentType coiAttachmentType) {
        this.coiAttachmentType = coiAttachmentType;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public static void addAttachmentToCollection(CoiDisclosureAttachment coiDisclosureAttachment, List<CoiDisclosureAttachment> coiDisclosureAttachments) {
        if (coiDisclosureAttachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        if (coiDisclosureAttachments == null) {
            throw new IllegalArgumentException("the toList is null");
        }
        coiDisclosureAttachments.add(coiDisclosureAttachment);
    }

    @Override
    public void setUpdateUser(String updateUser) {
        if (updateUser == null || this.getUpdateUser() == null) {
            super.setUpdateUser(updateUser);
        }
    }

    public String getProjectName() {
        this.refreshReferenceObject("coiDisclProjects");
        for (CoiDisclProject project : this.getCoiDisclosure().getCoiDisclProjects()) {
            if (!StringUtils.equalsIgnoreCase((String)project.getProjectId(), (String)this.getProjectId())) continue;
            return project.getCoiProjectTitle();
        }
        return "";
    }

    @Override
    public int compareTo(CoiDisclosureAttachment arg0) {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoiDisclosureAttachment other = (CoiDisclosureAttachment)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return !(this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.documentId == null ? 0 : this.documentId.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        return result;
    }

    public Long getOriginalCoiDisclosureId() {
        return this.originalCoiDisclosureId;
    }

    public void setOriginalCoiDisclosureId(Long originalCoiDisclosureId) {
        this.originalCoiDisclosureId = originalCoiDisclosureId;
    }

    public CoiDisclosure getOriginalCoiDisclosure() {
        return this.originalCoiDisclosure;
    }

    public void setOriginalCoiDisclosure(CoiDisclosure originalCoiDisclosure) {
        this.originalCoiDisclosure = originalCoiDisclosure;
    }

    public String getShortDescription() {
        String result = StringUtils.abbreviate((String)this.getDescription(), (int)20) + ": " + StringUtils.abbreviate((String)this.getFile().getName(), (int)20);
        if (!StringUtils.isEmpty((String)this.getUpdateUser())) {
            result = result + ": " + this.getUpdatedByString() + " " + this.getUpdateUser();
        }
        return result;
    }

    private String getUpdatedByString() {
        if (updatedByString == null) {
            updatedByString = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.updated.by");
        }
        return updatedByString;
    }

    protected void postRemove() {
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("fileId", this.getFileId());
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        if (boService.countMatching(CoiDisclosureAttachment.class, values) == 1) {
            boService.delete((PersistableBusinessObject)this.getFile());
        }
    }

    public String getUsageSectionId() {
        return this.usageSectionId;
    }

    public void setUsageSectionId(String usageSectionId) {
        this.usageSectionId = usageSectionId;
    }
}

