/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.notesandattachments.attachments;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.coi.PersonFinIntDisclosureAssociate;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class FinancialEntityAttachment
extends PersonFinIntDisclosureAssociate
implements Comparable<FinancialEntityAttachment> {
    private static final long serialVersionUID = 8722598360752485817L;
    private Long attachmentId;
    private Long fileId;
    private Long financialEntityId;
    private PersonFinIntDisclosure financialEntity;
    private transient AttachmentFile attachmentFile;
    private transient FormFile newFile;
    @SkipVersioning
    private transient String updateUserFullName;
    private Long personFinIntDisclosureId;
    private String description;
    private String contactName;
    private String contactEmailAddress;
    private String contactPhoneNumber;
    private String comments;
    private String statusCode;
    private Timestamp updateTimestamp;

    public FinancialEntityAttachment() {
    }

    public FinancialEntityAttachment(FinancialEntityAttachment oldAtt) {
        this.attachmentId = null;
        this.fileId = oldAtt.fileId;
        this.financialEntityId = oldAtt.financialEntityId;
        this.personFinIntDisclosureId = oldAtt.personFinIntDisclosureId;
        this.description = oldAtt.description;
        this.contactName = oldAtt.contactName;
        this.contactEmailAddress = oldAtt.contactEmailAddress;
        this.contactPhoneNumber = oldAtt.contactPhoneNumber;
        this.comments = oldAtt.comments;
        this.statusCode = oldAtt.statusCode;
        this.updateTimestamp = oldAtt.updateTimestamp;
        this.attachmentFile = (AttachmentFile)ObjectUtils.deepCopy((Serializable)oldAtt.getAttachmentFile());
    }

    public FinancialEntityAttachment(PersonFinIntDisclosure personFinIntDisclosure) {
        this.setPersonFinIntDisclosure(personFinIntDisclosure);
    }

    public Long getFinancialEntityId() {
        return this.financialEntityId;
    }

    public void setFinancialEntityId(Long financialEntityId) {
        this.financialEntityId = financialEntityId;
    }

    public PersonFinIntDisclosure getFinancialEntity() {
        return this.financialEntity;
    }

    public void setFinancialEntity(PersonFinIntDisclosure financialEntity) {
        this.financialEntity = financialEntity;
    }

    @Override
    public Timestamp getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public String getContactEmailAddress() {
        return this.contactEmailAddress;
    }

    public void setContactEmailAddress(String contactEmailAddress) {
        this.contactEmailAddress = contactEmailAddress;
    }

    public String getContactPhoneNumber() {
        return this.contactPhoneNumber;
    }

    public void setContactPhoneNumber(String contactPhoneNumber) {
        this.contactPhoneNumber = contactPhoneNumber;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public Long getFileId() {
        return this.fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public AttachmentFile getAttachmentFile() {
        return this.attachmentFile;
    }

    public String getFileName() {
        return this.attachmentFile == null ? "" : this.attachmentFile.getName();
    }

    public void setFile(AttachmentFile attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    public FormFile getNewFile() {
        return this.newFile;
    }

    public void setNewFile(FormFile newFile) {
        this.newFile = newFile;
    }

    public String getUpdateUserFullName() {
        return this.updateUserFullName;
    }

    public void setUpdateUserFullName(String updateUserFullName) {
        this.updateUserFullName = updateUserFullName;
    }

    @Override
    public Long getPersonFinIntDisclosureId() {
        return this.personFinIntDisclosureId;
    }

    @Override
    public void setPersonFinIntDisclosureId(Long personFinIntDisclosureId) {
        this.personFinIntDisclosureId = personFinIntDisclosureId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setUpdateUser(String updateUser) {
        if (updateUser == null || this.getUpdateUser() == null) {
            super.setUpdateUser(updateUser);
        }
    }

    @Override
    public int compareTo(FinancialEntityAttachment arg0) {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FinancialEntityAttachment other = (FinancialEntityAttachment)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.attachmentFile == null ? other.attachmentFile != null : !this.attachmentFile.equals(other.attachmentFile)) {
            return false;
        }
        return !(this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId));
    }

    public boolean matches(FinancialEntityAttachment other) {
        if (this == other) {
            return true;
        }
        if (!this.getFileId().equals(other.getFileId())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getUpdateUserFullName(), (String)other.getUpdateUserFullName())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getDescription(), (String)other.getDescription())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getContactName(), (String)other.getContactName())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getContactEmailAddress(), (String)other.getContactEmailAddress())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getContactPhoneNumber(), (String)other.getContactPhoneNumber())) {
            return false;
        }
        return StringUtils.equals((String)this.getComments(), (String)other.getComments());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.attachmentFile == null ? 0 : this.attachmentFile.hashCode());
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        return result;
    }

    public void updateParms() {
        this.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        this.setUpdateTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
    }

    public static List<FinancialEntityAttachment> copyAttachmentList(List<FinancialEntityAttachment> oldList) {
        ArrayList<FinancialEntityAttachment> newList = new ArrayList<FinancialEntityAttachment>();
        for (FinancialEntityAttachment att : oldList) {
            newList.add(new FinancialEntityAttachment(att));
        }
        return newList;
    }

    @Override
    public void prePersist() {
        super.prePersist();
        if (this.getAttachmentFile() != null) {
            KraServiceLocator.getService(BusinessObjectService.class).save((PersistableBusinessObject)this.getAttachmentFile());
            this.getAttachmentFile().refreshReferenceObject("id");
            this.setFileId(this.getAttachmentFile().getId());
        }
    }
}

