/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.notesandattachments.notes;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureAssociate;
import org.kuali.kra.coi.CoiNoteType;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.rice.krad.util.ObjectUtils;

public class CoiDisclosureNotepad
extends CoiDisclosureAssociate
implements Comparable<CoiDisclosureNotepad> {
    private static final long serialVersionUID = -3452466623013297158L;
    private String comments;
    private Integer entryNumber;
    private Long id;
    private String noteTopic;
    private boolean restrictedView;
    private boolean editable = false;
    private transient String updateUserFullName;
    private String projectId;
    private Long originalCoiDisclosureId;
    private String noteTypeCode;
    @SkipVersioning
    private CoiDisclosure originalCoiDisclosure;
    private Long financialEntityId;
    private String createUser;
    private Timestamp createTimestamp;
    private transient String createUserFullName;
    private CoiNoteType noteType;
    private String usageSectionId;
    @SkipVersioning
    private PersonFinIntDisclosure financialEntity;
    private String eventTypeCode;

    public CoiDisclosureNotepad() {
    }

    public CoiDisclosureNotepad(CoiDisclosure coiDisclosure) {
        super(coiDisclosure);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Long getFinancialEntityId() {
        return this.financialEntityId;
    }

    public void setFinancialEntityId(Long financialEntityId) {
        this.financialEntityId = financialEntityId;
    }

    public String getEventTypeCode() {
        return this.eventTypeCode;
    }

    public void setEventTypeCode(String eventTypeCode) {
        this.eventTypeCode = eventTypeCode;
    }

    public PersonFinIntDisclosure getFinancialEntity() {
        return this.financialEntity;
    }

    public void setFinancialEntity(PersonFinIntDisclosure financialEntity) {
        this.financialEntity = financialEntity;
    }

    public String getFinancialEntityName() {
        this.refreshReferenceObject("financialEntity");
        return ObjectUtils.isNotNull((Object)this.getFinancialEntity()) ? this.getFinancialEntity().getEntityName() : "";
    }

    public String getProjectName() {
        this.refreshReferenceObject("coiDisclProjects");
        for (CoiDisclProject project : this.getCoiDisclosure().getCoiDisclProjects()) {
            if (!StringUtils.equalsIgnoreCase((String)project.getProjectId(), (String)this.getProjectId())) continue;
            return project.getCoiProjectTitle();
        }
        return "";
    }

    public String getUpdateUserFullName() {
        return this.updateUserFullName;
    }

    public void setUpdateUserFullName(String updateUserFullName) {
        this.updateUserFullName = updateUserFullName;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getEntryNumber() {
        return this.entryNumber;
    }

    public void setEntryNumber(Integer entryNumber) {
        this.entryNumber = entryNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNoteTopic() {
        return this.noteTopic;
    }

    public void setNoteTopic(String noteTopic) {
        this.noteTopic = noteTopic;
    }

    public boolean getRestrictedView() {
        return this.restrictedView;
    }

    public void setRestrictedView(boolean restrictedView) {
        this.restrictedView = restrictedView;
    }

    public void resetUpdateTimestamp() {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        this.setUpdateTimestamp(timestamp);
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (updateTimestamp == null || this.getUpdateTimestamp() == null || this.isEditable()) {
            super.setUpdateTimestamp(updateTimestamp);
        }
    }

    @Override
    public void setUpdateUser(String updateUser) {
        if (updateUser == null || this.getUpdateUser() == null || this.isEditable()) {
            super.setUpdateUser(updateUser);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.entryNumber == null ? 0 : this.entryNumber.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.noteTopic == null ? 0 : this.noteTopic.hashCode());
        result = 31 * result + (this.restrictedView ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoiDisclosureNotepad other = (CoiDisclosureNotepad)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.entryNumber == null ? other.entryNumber != null : !this.entryNumber.equals(other.entryNumber)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.noteTopic == null ? other.noteTopic != null : !this.noteTopic.equals(other.noteTopic)) {
            return false;
        }
        return this.restrictedView == other.restrictedView;
    }

    @Override
    public int compareTo(CoiDisclosureNotepad coiDisclosureNotepad) {
        if (this.getCreateTimestamp() == null || coiDisclosureNotepad.getCreateTimestamp() == null) {
            return this.getUpdateTimestamp().compareTo(coiDisclosureNotepad.getUpdateTimestamp());
        }
        return this.getCreateTimestamp().compareTo(coiDisclosureNotepad.getCreateTimestamp());
    }

    @Override
    public void preUpdate() {
        super.preUpdate();
        this.setUpdateTimestamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    }

    public void postUpdate() {
        super.postUpdate();
        this.setEditable(false);
    }

    public Long getOriginalCoiDisclosureId() {
        return this.originalCoiDisclosureId;
    }

    public void setOriginalCoiDisclosureId(Long originalCoiDisclosureId) {
        this.originalCoiDisclosureId = originalCoiDisclosureId;
    }

    public CoiDisclosure getOriginalCoiDisclosure() {
        return this.originalCoiDisclosure;
    }

    public void setOriginalCoiDisclosure(CoiDisclosure originalCoiDisclosure) {
        this.originalCoiDisclosure = originalCoiDisclosure;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getCreateUserFullName() {
        return this.createUserFullName;
    }

    public void setCreateUserFullName(String createUserFullName) {
        this.createUserFullName = createUserFullName;
    }

    public String getUsageSectionId() {
        return this.usageSectionId;
    }

    public void setUsageSectionId(String usageSectionId) {
        this.usageSectionId = usageSectionId;
    }

    public CoiNoteType getNoteType() {
        return this.noteType;
    }

    public void setNoteType(CoiNoteType noteType) {
        this.noteType = noteType;
    }

    public String getNoteTypeCode() {
        return this.noteTypeCode;
    }

    public void setNoteTypeCode(String noteTypeCode) {
        this.noteTypeCode = noteTypeCode;
    }

    public static final class NotepadByEntryNumber
    implements Comparator<CoiDisclosureNotepad>,
    Serializable {
        public static final NotepadByEntryNumber INSTANCE = new NotepadByEntryNumber();
        private static final long serialVersionUID = -2271453419166988229L;

        private NotepadByEntryNumber() {
        }

        @Override
        public int compare(CoiDisclosureNotepad o1, CoiDisclosureNotepad o2) {
            return o1.getEntryNumber().compareTo(o2.getEntryNumber());
        }
    }
}

