/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroup;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class FinEntitiesDataGroupMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String GROUP_SORT_ID_FIELD_NAME = "dataGroupSortId";
    private static final String GROUP_NAME_FIELD_NAME = "dataGroupName";
    private transient BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    private boolean checkUniqueness(MaintenanceDocument document) {
        boolean isValid = true;
        FinEntitiesDataGroup newFinEntitiesDataGroup = (FinEntitiesDataGroup)document.getNewMaintainableObject().getDataObject();
        isValid &= this.checkSortIdUniqueness(newFinEntitiesDataGroup);
        return isValid &= this.checkGroupNameUniqueness(newFinEntitiesDataGroup);
    }

    private boolean checkSortIdUniqueness(FinEntitiesDataGroup newFinEntitiesDataGroup) {
        boolean isValid = true;
        Integer groupSortId = newFinEntitiesDataGroup.getDataGroupSortId();
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put(GROUP_SORT_ID_FIELD_NAME, groupSortId);
        Collection matchingDataGroups = this.getBusinessObjectService().findMatching(FinEntitiesDataGroup.class, fieldValues);
        for (FinEntitiesDataGroup dataGroup : matchingDataGroups) {
            if (ObjectUtils.equals((Object)dataGroup.getDataGroupId(), (Object)newFinEntitiesDataGroup.getDataGroupId())) continue;
            isValid = false;
            this.putFieldError(GROUP_SORT_ID_FIELD_NAME, "error.duplicate.property", new String[]{"Group Sort Id"});
            break;
        }
        return isValid;
    }

    private boolean checkGroupNameUniqueness(FinEntitiesDataGroup newFinEntitiesDataGroup) {
        boolean isValid = true;
        String groupName = newFinEntitiesDataGroup.getDataGroupName();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(GROUP_NAME_FIELD_NAME, groupName);
        Collection matchingDataGroups = this.getBusinessObjectService().findMatching(FinEntitiesDataGroup.class, fieldValues);
        for (FinEntitiesDataGroup dataGroup : matchingDataGroups) {
            if (ObjectUtils.equals((Object)dataGroup.getDataGroupId(), (Object)newFinEntitiesDataGroup.getDataGroupId())) continue;
            isValid = false;
            this.putFieldError(GROUP_NAME_FIELD_NAME, "error.duplicate.property", new String[]{"Group Name"});
            break;
        }
        return isValid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

