/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.HashMap;
import java.util.List;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.coi.notesandattachments.attachments.FinancialEntityAttachment;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityContactInfo;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityForm;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityHelper;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityService;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.coi.personfinancialentity.SaveFinancialEntityEvent;
import org.kuali.kra.coi.service.CoiPrintingService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.kra.service.ResearchDocumentService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public class FinancialEntityAction
extends KualiAction {
    protected static final String INACTIVATE_ENTITY = "inactive";
    protected static final String ACTIVATE_ENTITY = "active";
    protected static final String CONFIRM_YES_CANCEL_FE = "confirmCancelFinancialEntity";
    protected static final String CONFIRM_NO_CANCEL_FE = "declineCancelFinancialEntity";
    protected static final String CONFIRM_NO_DELETE = "";

    public ActionForward management(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((FinancialEntityForm)form).getFinancialEntityHelper().initiate();
        return mapping.findForward("management");
    }

    public ActionForward editNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((FinancialEntityForm)form).getFinancialEntityHelper().initiate();
        return mapping.findForward("editNew");
    }

    public ActionForward editList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((FinancialEntityForm)form).getFinancialEntityHelper().initiate();
        return mapping.findForward("editList");
    }

    protected void saveFinancialEntity(ActionForm form, PersonFinIntDisclosure personFinIntDisclosure) {
        this.getBusinessObjectService().save((PersistableBusinessObject)personFinIntDisclosure);
        ((FinancialEntityForm)form).getFinancialEntityHelper().setActiveFinancialEntities(this.getFinancialEntities(true));
        ((FinancialEntityForm)form).getFinancialEntityHelper().setInactiveFinancialEntities(this.getFinancialEntities(false));
        this.recordSubmitActionSuccess("Financial Entity save ");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_YES_CANCEL_FE, "message.cancel.fe", new String[0]);
        return this.confirm(confirm, CONFIRM_YES_CANCEL_FE, CONFIRM_NO_CANCEL_FE);
    }

    protected boolean isValidToSave(PersonFinIntDisclosure personFinIntDisclosure, String errorPath) {
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)personFinIntDisclosure);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        GlobalVariables.getMessageMap().addToErrorPath(errorPath + ".finEntityContactInfos[0]");
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)personFinIntDisclosure.getFinEntityContactInfos().get(0));
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath + ".finEntityContactInfos[0]");
        boolean isValid = GlobalVariables.getMessageMap().hasNoErrors();
        return isValid &= this.checkRule(new SaveFinancialEntityEvent(errorPath, personFinIntDisclosure));
    }

    protected boolean checkRule(KraDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }

    private DictionaryValidationService getDictionaryValidationService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected FinancialEntityService getFinancialEntityService() {
        return KraServiceLocator.getService(FinancialEntityService.class);
    }

    protected CoiDisclosureService getCoiDisclosureService() {
        return KraServiceLocator.getService(CoiDisclosureService.class);
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        return KraServiceLocator.getService(SequenceAccessorService.class);
    }

    protected List<PersonFinIntDisclosure> getFinancialEntities(boolean active) {
        return this.getFinancialEntities(GlobalVariables.getUserSession().getPrincipalId(), active);
    }

    protected List<PersonFinIntDisclosure> getFinancialEntities(String personId, boolean active) {
        return this.getFinancialEntityService().getFinancialEntities(personId, active);
    }

    protected void recordSubmitActionSuccess(String submitAction) {
        KNSGlobalVariables.getMessageList().add("message.financial.entity.action.successfully.completed", new String[]{submitAction});
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Sponsor sponsor;
        ActionForward forward = super.refresh(mapping, form, request, response);
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        String refreshCaller = request.getParameter("refreshCaller");
        String sponsorCode = request.getParameter("financialEntityHelper.newPersonFinancialEntity.sponsorCode");
        boolean isEdit = false;
        if (StringUtils.isNotBlank((String)refreshCaller) && StringUtils.isBlank((String)sponsorCode) && financialEntityHelper.getEditEntityIndex() >= 0) {
            sponsorCode = StringUtils.equals((String)ACTIVATE_ENTITY, (String)financialEntityHelper.getEditType()) ? request.getParameter("financialEntityHelper.activeFinancialEntities[" + financialEntityHelper.getEditEntityIndex() + "].sponsorCode") : request.getParameter("financialEntityHelper.inactiveFinancialEntities[" + financialEntityHelper.getEditEntityIndex() + "].sponsorCode");
            isEdit = true;
        }
        if (StringUtils.isNotBlank((String)refreshCaller) && StringUtils.isNotBlank((String)sponsorCode) && (sponsor = KraServiceLocator.getService(SponsorService.class).getSponsor(sponsorCode)) != null) {
            if (sponsor.getRolodex() == null) {
                sponsor.refreshReferenceObject("rolodex");
            }
            FinancialEntityContactInfo contactInfo = financialEntityHelper.getNewPersonFinancialEntity().getFinEntityContactInfos().get(0);
            if (isEdit) {
                if (StringUtils.equals((String)ACTIVATE_ENTITY, (String)financialEntityHelper.getEditType())) {
                    financialEntityHelper.getActiveFinancialEntities().get(financialEntityHelper.getEditEntityIndex()).setEntityName(sponsor.getSponsorName());
                    contactInfo = financialEntityHelper.getActiveFinancialEntities().get(financialEntityHelper.getEditEntityIndex()).getFinEntityContactInfos().get(0);
                } else {
                    financialEntityHelper.getInactiveFinancialEntities().get(financialEntityHelper.getEditEntityIndex()).setEntityName(sponsor.getSponsorName());
                    contactInfo = financialEntityHelper.getInactiveFinancialEntities().get(financialEntityHelper.getEditEntityIndex()).getFinEntityContactInfos().get(0);
                }
            } else {
                financialEntityHelper.getNewPersonFinancialEntity().setEntityName(sponsor.getSponsorName());
            }
            contactInfo.setAddressLine1(sponsor.getRolodex().getAddressLine1());
            contactInfo.setAddressLine2(sponsor.getRolodex().getAddressLine2());
            contactInfo.setAddressLine3(sponsor.getRolodex().getAddressLine3());
            contactInfo.setCity(sponsor.getRolodex().getCity());
            contactInfo.setState(sponsor.getRolodex().getState());
            contactInfo.setCountryCode(sponsor.getRolodex().getCountryCode());
            contactInfo.setPostalCode(sponsor.getRolodex().getPostalCode());
        }
        return forward;
    }

    protected String buildForwardUrl(String routeHeaderId) {
        ResearchDocumentService researchDocumentService = KraServiceLocator.getService(ResearchDocumentService.class);
        String forward = researchDocumentService.getDocHandlerUrl(routeHeaderId);
        forward = forward.indexOf("?") == -1 ? forward + "?" : forward + "&";
        forward = forward + "docId=" + routeHeaderId;
        forward = forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        return forward;
    }

    public ActionForward viewFinancialEntityAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialEntityForm financialEntityForm = (FinancialEntityForm)form;
        int selection = this.getSelectedLine(request);
        FinancialEntityAttachment attachment = financialEntityForm.getFinancialEntityHelper().getFinEntityAttachmentList().get(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getAttachmentFile();
        PrintingUtils.streamToResponse(file.getData(), FinancialEntityAction.getValidHeaderString(file.getName()), FinancialEntityAction.getValidHeaderString(file.getType()), response);
        return null;
    }

    public ActionForward viewFinancialEntityAttachmentFromSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String selection = request.getParameter("linkId");
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("id", selection);
        List files = (List)this.getBusinessObjectService().findMatching(AttachmentFile.class, fieldValues);
        if (files.size() == 0) {
            return mapping.findForward("basic");
        }
        AttachmentFile attachmentFile = (AttachmentFile)files.get(0);
        PrintingUtils.streamToResponse(attachmentFile.getData(), FinancialEntityAction.getValidHeaderString(attachmentFile.getName()), FinancialEntityAction.getValidHeaderString(attachmentFile.getType()), response);
        return null;
    }

    protected CoiPrintingService getCoiPrintingService() {
        return KraServiceLocator.getService(CoiPrintingService.class);
    }

    protected WatermarkService getWatermarkService() {
        return KraServiceLocator.getService(WatermarkService.class);
    }

    protected static String getValidHeaderString(String s) {
        return MimeUtility.quote((String)s, (String)"()<>@,;:\\\"\t []/?=");
    }

    protected StrutsConfirmation buildParameterizedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String configurationId, String ... params) throws Exception {
        StrutsConfirmation retval = new StrutsConfirmation();
        retval.setMapping(mapping);
        retval.setForm(form);
        retval.setRequest(request);
        retval.setResponse(response);
        retval.setQuestionId(questionId);
        retval.setQuestionType("confirmationQuestion");
        ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
        String questionText = kualiConfiguration.getPropertyValueAsString(configurationId);
        for (int i = 0; i < params.length; ++i) {
            questionText = StringUtils.replace((String)questionText, (String)("{" + i + "}"), (String)params[i]);
        }
        retval.setQuestionText(questionText);
        return retval;
    }

    public ActionForward confirm(StrutsConfirmation question, String yesMethodName, String noMethodName) throws Exception {
        question.setCaller(((KualiForm)question.getForm()).getMethodToCall());
        if (question.hasQuestionInstAttributeName()) {
            String buttonClicked = question.getRequest().getParameter("buttonClicked");
            if ("0".equals(buttonClicked) && StringUtils.isNotBlank((String)yesMethodName)) {
                return this.dispatchMethod(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), yesMethodName);
            }
            if (StringUtils.isNotBlank((String)noMethodName)) {
                return this.dispatchMethod(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), noMethodName);
            }
        } else {
            return this.performQuestionWithoutInput(question, CONFIRM_NO_DELETE);
        }
        return question.getMapping().findForward("basic");
    }

    protected ActionForward performQuestionWithoutInput(StrutsConfirmation question, String context) throws Exception {
        return this.performQuestionWithoutInput(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), question.getQuestionId(), question.getQuestionText(), question.getQuestionType(), question.getCaller(), context);
    }

    public ActionForward confirmCancelFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialEntityForm financialEntityForm = (FinancialEntityForm)form;
        FinancialEntityHelper financialEntityHelper = financialEntityForm.getFinancialEntityHelper();
        if (StringUtils.isNotBlank((String)financialEntityForm.getCoiDocId())) {
            String forward = this.buildForwardUrl(financialEntityForm.getCoiDocId());
            financialEntityForm.setCoiDocId(null);
            financialEntityForm.getFinancialEntityHelper().setReporterId(null);
            return new ActionForward(forward, true);
        }
        return this.whereToGoAfterCancel(mapping, form, request, response);
    }

    public ActionForward declineCancelFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward whereToGoAfterCancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }
}

