/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.coi.notesandattachments.attachments.FinancialEntityAttachment;
import org.kuali.kra.coi.personfinancialentity.AddFinancialEntityAttachmentEvent;
import org.kuali.kra.coi.personfinancialentity.FinEntityDataMatrixBean;
import org.kuali.kra.coi.personfinancialentity.FinIntEntityRelType;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityForm;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityReporter;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityReporterUnit;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityService;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class FinancialEntityHelper
implements Serializable {
    private static final long serialVersionUID = -5837128667442140384L;
    private FinancialEntityForm form;
    private PersonFinIntDisclosure newPersonFinancialEntity;
    private FinancialEntityReporterUnit newFinancialEntityReporterUnit;
    private FinancialEntityReporter financialEntityReporter;
    private List<PersonFinIntDisclosure> activeFinancialEntities;
    private List<PersonFinIntDisclosure> inactiveFinancialEntities;
    private List<FinancialEntityReporterUnit> deletedUnits;
    private List<FinIntEntityRelType> finEntityRelationshipTypes;
    private int editEntityIndex;
    private List<FinEntityDataMatrixBean> newRelationDetails;
    private List<FinEntityDataMatrixBean> editRelationDetails;
    private FinancialEntityAttachment newFinEntityAttachment;
    private List<FinancialEntityAttachment> finEntityAttachmentList;
    private Integer newRolodexId;
    private Integer editRolodexId;
    private String prevSponsorCode;
    private String prevNewSponsorCode;
    private String editType;
    private List<PersonFinIntDisclosure> versions;
    private String editCoiEntityId;
    private String reporterId;
    private BusinessObjectService businessObjectService;

    public String getEditType() {
        return this.editType;
    }

    public void setEditType(String editType) {
        this.editType = editType;
    }

    public FinancialEntityHelper(FinancialEntityForm form) {
        if (StringUtils.isBlank((String)this.reporterId)) {
            this.reporterId = GlobalVariables.getUserSession().getPrincipalId();
        }
        this.newPersonFinancialEntity = new PersonFinIntDisclosure();
        this.newPersonFinancialEntity.setCurrentFlag(true);
        this.financialEntityReporter = new FinancialEntityReporter();
        this.newPersonFinancialEntity.setPersonId(this.reporterId);
        this.newPersonFinancialEntity.setFinancialEntityReporterId(this.financialEntityReporter.getFinancialEntityReporterId());
        this.setNewFinancialEntityReporterUnit(new FinancialEntityReporterUnit());
        this.activeFinancialEntities = new ArrayList<PersonFinIntDisclosure>();
        this.inactiveFinancialEntities = new ArrayList<PersonFinIntDisclosure>();
        this.finEntityRelationshipTypes = this.getFinancialEntityService().getFinancialEntityRelationshipTypes();
        this.deletedUnits = new ArrayList<FinancialEntityReporterUnit>();
        this.newRelationDetails = this.getFinancialEntityService().getFinancialEntityDataMatrix();
        this.editRelationDetails = new ArrayList<FinEntityDataMatrixBean>();
        this.newFinEntityAttachment = new FinancialEntityAttachment();
        this.finEntityAttachmentList = new ArrayList<FinancialEntityAttachment>();
        this.editEntityIndex = -1;
        this.newRolodexId = -1;
        this.prevSponsorCode = "";
        this.prevNewSponsorCode = "";
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        this.form = form;
    }

    public void refreshData() {
        this.finEntityRelationshipTypes = this.getFinancialEntityService().getFinancialEntityRelationshipTypes();
        this.newRelationDetails = this.getFinancialEntityService().getFinancialEntityDataMatrix();
    }

    public FinancialEntityForm getForm() {
        return this.form;
    }

    public void setForm(FinancialEntityForm form) {
        this.form = form;
    }

    public PersonFinIntDisclosure getNewPersonFinancialEntity() {
        return this.newPersonFinancialEntity;
    }

    public void setNewPersonFinancialEntity(PersonFinIntDisclosure newPersonFinancialEntity) {
        this.newPersonFinancialEntity = newPersonFinancialEntity;
    }

    public int getEditEntityIndex() {
        return this.editEntityIndex;
    }

    public void setEditEntityIndex(int editEntityIndex) {
        this.editEntityIndex = editEntityIndex;
    }

    public List<PersonFinIntDisclosure> getActiveFinancialEntities() {
        return this.activeFinancialEntities;
    }

    public void setActiveFinancialEntities(List<PersonFinIntDisclosure> activeFinancialEntities) {
        this.activeFinancialEntities = activeFinancialEntities;
    }

    public List<PersonFinIntDisclosure> getInactiveFinancialEntities() {
        return this.inactiveFinancialEntities;
    }

    public void setInactiveFinancialEntities(List<PersonFinIntDisclosure> inactiveFinancialEntities) {
        this.inactiveFinancialEntities = inactiveFinancialEntities;
    }

    public FinancialEntityReporterUnit getNewFinancialEntityReporterUnit() {
        return this.newFinancialEntityReporterUnit;
    }

    public void setNewFinancialEntityReporterUnit(FinancialEntityReporterUnit newFinancialEntityReporterUnit) {
        this.newFinancialEntityReporterUnit = newFinancialEntityReporterUnit;
        this.newFinancialEntityReporterUnit.setFinancialEntityReporterId(this.financialEntityReporter.getFinancialEntityReporterId());
        this.newFinancialEntityReporterUnit.setFinancialEntityReporter(this.financialEntityReporter);
        this.newFinancialEntityReporterUnit.setPersonId(this.financialEntityReporter.getPersonId());
    }

    private FinancialEntityService getFinancialEntityService() {
        return KraServiceLocator.getService(FinancialEntityService.class);
    }

    public void setVersions(PersonFinIntDisclosure personFinIntDisclosure) {
        this.versions = personFinIntDisclosure.getVersions();
    }

    public List<PersonFinIntDisclosure> getVersions() {
        return this.versions;
    }

    public FinancialEntityReporter getFinancialEntityReporter() {
        return this.financialEntityReporter;
    }

    private void refreshFinancialEntityReporter() {
        if (StringUtils.isBlank((String)this.reporterId)) {
            this.reporterId = GlobalVariables.getUserSession().getPrincipalId();
        }
        this.financialEntityReporter = this.getFinancialEntityService().getFinancialEntityReporter(this.reporterId);
        this.newPersonFinancialEntity.setFinancialEntityReporterId(this.financialEntityReporter.getFinancialEntityReporterId());
    }

    public void setFinancialEntityReporter(FinancialEntityReporter financialEntityReporter) {
        this.financialEntityReporter = financialEntityReporter;
    }

    public List<FinancialEntityReporterUnit> getDeletedUnits() {
        return this.deletedUnits;
    }

    public void setDeletedUnits(List<FinancialEntityReporterUnit> deletedUnits) {
        this.deletedUnits = deletedUnits;
    }

    public List<FinIntEntityRelType> getFinEntityRelationshipTypes() {
        return this.finEntityRelationshipTypes;
    }

    public void setFinEntityRelationshipTypes(List<FinIntEntityRelType> finEntityRelationshipTypes) {
        this.finEntityRelationshipTypes = finEntityRelationshipTypes;
    }

    public List<FinEntityDataMatrixBean> getNewRelationDetails() {
        return this.newRelationDetails;
    }

    public void setNewRelationDetails(List<FinEntityDataMatrixBean> newRelationDetails) {
        this.newRelationDetails = newRelationDetails;
    }

    public List<FinEntityDataMatrixBean> getEditRelationDetails() {
        return this.editRelationDetails;
    }

    public void setEditRelationDetails(List<FinEntityDataMatrixBean> editRelationDetails) {
        this.editRelationDetails = editRelationDetails;
    }

    public FinancialEntityAttachment getNewFinEntityAttachment() {
        return this.newFinEntityAttachment;
    }

    public void setNewFinEntityAttachment(FinancialEntityAttachment newFinEntityAttachment) {
        this.newFinEntityAttachment = newFinEntityAttachment;
    }

    public void initiate() {
        if (StringUtils.isBlank((String)this.reporterId)) {
            this.reporterId = GlobalVariables.getUserSession().getPrincipalId();
        }
        this.newPersonFinancialEntity = new PersonFinIntDisclosure();
        this.newPersonFinancialEntity.setCurrentFlag(true);
        this.newPersonFinancialEntity.setPersonId(this.reporterId);
        this.newPersonFinancialEntity.setFinancialEntityReporterId(this.financialEntityReporter.getFinancialEntityReporterId());
        this.setActiveFinancialEntities(this.getFinancialEntities(true));
        this.setInactiveFinancialEntities(this.getFinancialEntities(false));
        this.refreshFinancialEntityReporter();
        this.setNewFinancialEntityReporterUnit(new FinancialEntityReporterUnit());
        this.setFinEntityAttachmentList(new ArrayList<FinancialEntityAttachment>());
        this.newRelationDetails = this.getFinancialEntityService().getFinancialEntityDataMatrix();
        this.editRelationDetails = new ArrayList<FinEntityDataMatrixBean>();
        this.editEntityIndex = -1;
        this.prevSponsorCode = "";
        this.prevNewSponsorCode = "";
        this.newRolodexId = -1;
        this.editRolodexId = -1;
    }

    private List<PersonFinIntDisclosure> getFinancialEntities(boolean active) {
        if (StringUtils.isBlank((String)this.reporterId)) {
            this.reporterId = GlobalVariables.getUserSession().getPrincipalId();
        }
        return this.getFinancialEntityService().getFinancialEntities(this.reporterId, active);
    }

    public Integer getNewRolodexId() {
        return this.newRolodexId;
    }

    public void setNewRolodexId(Integer newRolodexId) {
        this.newRolodexId = newRolodexId;
    }

    public String getPrevSponsorCode() {
        return this.prevSponsorCode;
    }

    public void setPrevSponsorCode(String prevSponsorCode) {
        this.prevSponsorCode = prevSponsorCode;
    }

    public Integer getEditRolodexId() {
        return this.editRolodexId;
    }

    public void setEditRolodexId(Integer editRolodexId) {
        this.editRolodexId = editRolodexId;
    }

    public String getPrevNewSponsorCode() {
        return this.prevNewSponsorCode;
    }

    public void setPrevNewSponsorCode(String prevNewSponsorCode) {
        this.prevNewSponsorCode = prevNewSponsorCode;
    }

    public void resetPrevSponsorCode() {
        if (StringUtils.equals((String)"active", (String)this.getEditType())) {
            this.setPrevSponsorCode(this.getActiveFinancialEntities().get(this.editEntityIndex).getSponsorCode());
        } else {
            this.setPrevSponsorCode(this.getInactiveFinancialEntities().get(this.editEntityIndex).getSponsorCode());
        }
    }

    public String getEditCoiEntityId() {
        return this.editCoiEntityId;
    }

    public void setEditCoiEntityId(String editCoiEntityId) {
        this.editCoiEntityId = editCoiEntityId;
    }

    public String getReporterId() {
        return this.reporterId;
    }

    public void setReporterId(String reporterId) {
        this.reporterId = reporterId;
    }

    public void addNewFinancialEntityAttachment() {
        this.syncNewFile(this.getNewFinEntityAttachment());
        AddFinancialEntityAttachmentEvent event = new AddFinancialEntityAttachmentEvent("financialEntityHelper.newFinEntityAttachment", this.newFinEntityAttachment);
        boolean success = event.getRule().processRules(event);
        if (success) {
            this.newFinEntityAttachment.setFinancialEntityId(this.getNewPersonFinancialEntity().getPersonFinIntDisclosureId());
            this.newFinEntityAttachment.setSequenceNumber(this.getNewPersonFinancialEntity().getSequenceNumber());
            this.newFinEntityAttachment.updateParms();
            this.getFinEntityAttachmentList().add(this.newFinEntityAttachment);
            this.newFinEntityAttachment = new FinancialEntityAttachment();
        }
    }

    public void removeNewFinancialEntityAttachment(int selectedLine) {
        FinancialEntityAttachment attachment = this.getFinEntityAttachmentList().get(selectedLine);
        this.getFinEntityAttachmentList().remove(selectedLine);
        this.getBusinessObjectService().delete((PersistableBusinessObject)attachment);
    }

    protected void syncNewFile(FinancialEntityAttachment attachment) {
        assert (attachment != null) : "the attachment is null";
        if (FinancialEntityHelper.doesNewFileExist(attachment)) {
            AttachmentFile newFile = AttachmentFile.createFromFormFile(attachment.getNewFile());
            if (attachment.getAttachmentFile() != null) {
                newFile.setSequenceNumber(new Integer(1));
            }
            attachment.setFile(newFile);
            attachment.setNewFile(null);
        }
    }

    private static boolean doesNewFileExist(FinancialEntityAttachment attachment) {
        assert (attachment != null) : "the attachment was null";
        return attachment.getNewFile() != null && StringUtils.isNotBlank((String)attachment.getNewFile().getFileName());
    }

    public List<FinancialEntityAttachment> getFinEntityAttachmentList() {
        return this.finEntityAttachmentList;
    }

    public void setFinEntityAttachmentList(List<FinancialEntityAttachment> finEntityAttachmentList) {
        this.finEntityAttachmentList = finEntityAttachmentList;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    private void refreshAttachmentReferences(List<FinancialEntityAttachment> attachments) {
        assert (attachments != null) : "the attachments were null";
        for (FinancialEntityAttachment attachment : attachments) {
            if (!(attachment instanceof FinancialEntityAttachment)) continue;
            attachment.refreshReferenceObject("attachmentFile");
        }
    }
}

