/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.coi.notesandattachments.attachments.FinancialEntityAttachment;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroup;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataMatrix;
import org.kuali.kra.coi.personfinancialentity.FinEntityDataMatrixBean;
import org.kuali.kra.coi.personfinancialentity.FinIntEntityRelType;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityContactInfo;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityReporter;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityReporterUnit;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityService;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclDet;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.coi.personfinancialentity.RelationshipTypeBean;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersioningService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FinancialEntityServiceImpl
implements FinancialEntityService {
    private BusinessObjectService businessObjectService;
    private KcPersonService kcPersonService;
    private VersioningService versioningService;
    private SequenceAccessorService sequenceAccessorService;

    @Override
    public List<PersonFinIntDisclosure> getFinancialEntities(String personId, boolean active) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        if (active) {
            fieldValues.put("statusCode", "1");
        } else {
            fieldValues.put("statusCode", "2");
        }
        fieldValues.put("currentFlag", "Y");
        List personFinDisclosures = (List)this.businessObjectService.findMatchingOrderBy(PersonFinIntDisclosure.class, fieldValues, "entityName", true);
        for (PersonFinIntDisclosure personFinIntDisclosure : personFinDisclosures) {
            personFinIntDisclosure.setVersions(this.getFinDisclosureVersions(personFinIntDisclosure.getEntityNumber()));
        }
        return personFinDisclosures;
    }

    @Override
    public List<PersonFinIntDisclosure> getFinDisclosureVersions(String entityNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("entityNumber", entityNumber);
        return (List)this.businessObjectService.findMatchingOrderBy(PersonFinIntDisclosure.class, fieldValues, "sequenceNumber", false);
    }

    @Override
    public List<FinIntEntityRelType> getFinancialEntityRelationshipTypes() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("active", "Y");
        return (List)this.businessObjectService.findMatchingOrderBy(FinIntEntityRelType.class, fieldValues, "sortId", true);
    }

    @Override
    public List<FinEntityDataMatrixBean> getFinancialEntityDataMatrix() {
        List<FinIntEntityRelType> relationshipTypes = this.getFinancialEntityRelationshipTypes();
        ArrayList<FinEntityDataMatrixBean> dataMatrixs = new ArrayList<FinEntityDataMatrixBean>();
        List dataGroups = (List)this.businessObjectService.findAll(FinEntitiesDataGroup.class);
        Collections.sort(dataGroups);
        for (FinEntitiesDataGroup dataGroup : dataGroups) {
            for (FinEntitiesDataMatrix dataMatrix : dataGroup.getFinEntitiesDataMatrixs()) {
                if (!dataMatrix.isActive()) continue;
                FinEntityDataMatrixBean dataMatrixBean = new FinEntityDataMatrixBean();
                dataMatrixBean.setDataGroupId(dataGroup.getDataGroupId());
                dataMatrixBean.setColumnLabel(dataMatrix.getColumnLabel());
                dataMatrixBean.setColumnName(dataMatrix.getColumnName());
                dataMatrixBean.setDataGroupName(dataGroup.getDataGroupName());
                dataMatrixBean.setGuiType(dataMatrix.getGuiType());
                dataMatrixBean.setLookupArgument(dataMatrix.getLookupArgument());
                dataMatrixBean.setRelationshipTypeBeans(new ArrayList<RelationshipTypeBean>());
                for (FinIntEntityRelType relationshipType : relationshipTypes) {
                    RelationshipTypeBean relationTypeBean = new RelationshipTypeBean();
                    relationTypeBean.setCode(relationshipType.getRelationshipTypeCode());
                    if (dataMatrixBean.isArgValueLookup()) {
                        relationTypeBean.setStringValue("");
                    } else {
                        relationTypeBean.setBooleanValue(false);
                    }
                    dataMatrixBean.getRelationshipTypeBeans().add(relationTypeBean);
                }
                dataMatrixs.add(dataMatrixBean);
            }
        }
        return dataMatrixs;
    }

    @Override
    public List<PersonFinIntDisclDet> getFinDisclosureDetails(List<FinEntityDataMatrixBean> dataMatrixs, String entityNumber, Integer sequenceNumber) {
        ArrayList<PersonFinIntDisclDet> disclosureDetails = new ArrayList<PersonFinIntDisclDet>();
        for (FinEntityDataMatrixBean dataRow : dataMatrixs) {
            for (RelationshipTypeBean relationshipTypeBean : dataRow.getRelationshipTypeBeans()) {
                if (!StringUtils.isNotBlank((String)dataRow.getComments()) && (!dataRow.isArgValueLookup() || !StringUtils.isNotBlank((String)relationshipTypeBean.getStringValue())) && (dataRow.isArgValueLookup() || !relationshipTypeBean.isBooleanValue())) continue;
                PersonFinIntDisclDet personFinIntDisclDet = new PersonFinIntDisclDet();
                personFinIntDisclDet.setColumnName(dataRow.getColumnName());
                if (StringUtils.isNotBlank((String)dataRow.getComments())) {
                    personFinIntDisclDet.setComments(dataRow.getComments());
                }
                personFinIntDisclDet.setColumnValue(this.getRelationshipTypeValue(dataRow, relationshipTypeBean));
                personFinIntDisclDet.setRelationshipTypeCode(relationshipTypeBean.getCode());
                personFinIntDisclDet.setEntityNumber(entityNumber);
                personFinIntDisclDet.setSequenceNumber(sequenceNumber);
                disclosureDetails.add(personFinIntDisclDet);
            }
        }
        return disclosureDetails;
    }

    @Override
    public List<FinEntityDataMatrixBean> getFinancialEntityDataMatrixForEdit(List<PersonFinIntDisclDet> disclosureDetails) {
        List<FinEntityDataMatrixBean> dataMatrixs = this.getFinancialEntityDataMatrix();
        block0: for (PersonFinIntDisclDet personFinIntDisclDet : disclosureDetails) {
            for (FinEntityDataMatrixBean dataRow : dataMatrixs) {
                if (!StringUtils.equals((String)dataRow.getColumnName(), (String)personFinIntDisclDet.getColumnName())) continue;
                for (RelationshipTypeBean relationshipTypeBean : dataRow.getRelationshipTypeBeans()) {
                    if (StringUtils.isNotBlank((String)personFinIntDisclDet.getComments())) {
                        dataRow.setComments(personFinIntDisclDet.getComments());
                    }
                    if (!StringUtils.equals((String)relationshipTypeBean.getCode(), (String)personFinIntDisclDet.getRelationshipTypeCode())) continue;
                    this.setRelationshipTypeBeanValue(dataRow, relationshipTypeBean, personFinIntDisclDet);
                    continue block0;
                }
                continue block0;
            }
        }
        return dataMatrixs;
    }

    private void setRelationshipTypeBeanValue(FinEntityDataMatrixBean dataRow, RelationshipTypeBean relationshipTypeBean, PersonFinIntDisclDet personFinIntDisclDet) {
        if (dataRow.isArgValueLookup()) {
            relationshipTypeBean.setStringValue(personFinIntDisclDet.getColumnValue());
        } else if (StringUtils.equals((String)"1", (String)personFinIntDisclDet.getColumnValue())) {
            relationshipTypeBean.setBooleanValue(true);
        }
    }

    private String getRelationshipTypeValue(FinEntityDataMatrixBean dataRow, RelationshipTypeBean relationshipTypeBean) {
        String retVal = null;
        if (dataRow.isArgValueLookup()) {
            retVal = relationshipTypeBean.getStringValue();
        } else if (relationshipTypeBean.isBooleanValue()) {
            retVal = "1";
        }
        return retVal;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public FinancialEntityReporter getFinancialEntityReporter(String personId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("personId", personId);
        fieldValues.put("reporterRoleId", "FER");
        List reporters = (List)this.businessObjectService.findMatching(FinancialEntityReporter.class, fieldValues);
        if (reporters.isEmpty()) {
            System.out.println("Save FE reporter person id " + personId);
            Object reporterSaved = GlobalVariables.getUserSession().retrieveObject("reporterSaved-" + GlobalVariables.getUserSession().getPrincipalName());
            if (reporterSaved == null) {
                GlobalVariables.getUserSession().addObject("reporterSaved-" + GlobalVariables.getUserSession().getPrincipalName(), (Object)"saved");
                System.out.println("Save FE reporter person id " + personId + " not saved ");
            }
            FinancialEntityReporter reporter = new FinancialEntityReporter();
            reporter.setFinancialEntityReporterUnits(new ArrayList<FinancialEntityReporterUnit>());
            reporter.setPersonId(personId);
            reporter.setReporterRoleId("FER");
            FinancialEntityReporterUnit leadUnit = this.createLeadUnit(personId);
            if (leadUnit != null) {
                reporter.getFinancialEntityReporterUnits().add(leadUnit);
            }
            if (reporterSaved == null) {
                System.out.println("Save FE reporter person id " + personId + " save reporter ");
                this.businessObjectService.save((PersistableBusinessObject)reporter);
            }
            return reporter;
        }
        int i = 0;
        for (FinancialEntityReporterUnit financialEntityReporterUnit : ((FinancialEntityReporter)((Object)reporters.get(0))).getFinancialEntityReporterUnits()) {
            if (financialEntityReporterUnit.isLeadUnitFlag()) {
                ((FinancialEntityReporter)((Object)reporters.get(0))).setSelectedUnit(i);
                break;
            }
            ++i;
        }
        return (FinancialEntityReporter)((Object)reporters.get(0));
    }

    private FinancialEntityReporterUnit createLeadUnit(String personId) {
        FinancialEntityReporterUnit leadUnit = null;
        KcPerson kcPerson = this.kcPersonService.getKcPersonByPersonId(personId);
        if (kcPerson != null && kcPerson.getUnit() != null) {
            leadUnit = new FinancialEntityReporterUnit();
            leadUnit.setLeadUnitFlag(true);
            leadUnit.setUnitNumber(kcPerson.getUnit().getUnitNumber());
            leadUnit.setUnitName(kcPerson.getUnit().getUnitName());
            leadUnit.setPersonId(personId);
        }
        return leadUnit;
    }

    @Override
    public List<FinancialEntityAttachment> retrieveFinancialEntityAttachmentsFor(Long entityId) {
        ArrayList attachments = null;
        if (ObjectUtils.isNotNull((Object)entityId)) {
            HashMap<String, Long> searchCriteria = new HashMap<String, Long>();
            searchCriteria.put("financialEntityId", entityId);
            attachments = new ArrayList(this.businessObjectService.findMatching(FinancialEntityAttachment.class, searchCriteria));
        }
        return attachments;
    }

    @Override
    public PersonFinIntDisclosure versionPersonFinintDisclosure(PersonFinIntDisclosure personFinIntDisclosure, List<FinEntityDataMatrixBean> newRelationDetails, List<FinancialEntityAttachment> newFinancialEntityAttachments) throws VersionException {
        this.nonCurrentOldDisclosure(personFinIntDisclosure.getPersonFinIntDisclosureId());
        PersonFinIntDisclosure newDisclosure = this.versioningService.createNewVersion(personFinIntDisclosure);
        FinancialEntityContactInfo copiedContactInfo = (FinancialEntityContactInfo)((Object)ObjectUtils.deepCopy((Serializable)((Serializable)((Object)newDisclosure.getFinEntityContactInfos().get(0)))));
        copiedContactInfo.setPersonFinIntDisclosureId(null);
        copiedContactInfo.setFinancialEntityContactInfoId(null);
        newDisclosure.setFinEntityContactInfos(new ArrayList<FinancialEntityContactInfo>());
        newDisclosure.getFinEntityContactInfos().add(copiedContactInfo);
        newDisclosure.setPerFinIntDisclDetails(this.getFinDisclosureDetails(newRelationDetails, newDisclosure.getEntityNumber(), newDisclosure.getSequenceNumber()));
        newDisclosure.setFinEntityAttachments(FinancialEntityAttachment.copyAttachmentList(newFinancialEntityAttachments));
        return newDisclosure;
    }

    private void nonCurrentOldDisclosure(Long disclosureId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("personFinIntDisclosureId", disclosureId);
        PersonFinIntDisclosure personFinIntDisclosure = (PersonFinIntDisclosure)this.businessObjectService.findByPrimaryKey(PersonFinIntDisclosure.class, fieldValues);
        personFinIntDisclosure.setCurrentFlag(false);
        this.businessObjectService.save((PersistableBusinessObject)personFinIntDisclosure);
    }

    @Override
    public PersonFinIntDisclosure getCurrentFinancialEntities(String entityNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("entityNumber", entityNumber);
        fieldValues.put("currentFlag", "Y");
        return (PersonFinIntDisclosure)((List)this.businessObjectService.findMatching(PersonFinIntDisclosure.class, fieldValues)).get(0);
    }

    @Override
    public String getNextEntityNumber() {
        return this.sequenceAccessorService.getNextAvailableSequenceNumber("SEQ_ENTITY_NUMBER_S").toString();
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

