/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.notesandattachments.attachments.FinancialEntityAttachment;
import org.kuali.kra.coi.notesandattachments.attachments.FinancialEntityAttachmentSummary;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroup;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataMatrix;
import org.kuali.kra.coi.personfinancialentity.FinIntEntityRelType;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityContactInfo;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityForm;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityService;
import org.kuali.kra.coi.personfinancialentity.FinancialEntitySummaryBean;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclDet;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.ArgValueLookupValuesFinder;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class FinancialEntitySummaryHelper
implements Serializable {
    private static final long serialVersionUID = -6990736543009439730L;
    private int currentVersionNumber;
    private FinancialEntityForm financialEntityForm;
    private PersonFinIntDisclosure currentFinancialEntity;
    private PersonFinIntDisclosure previousFinancialEntity;
    private List<PersonFinIntDisclosure> versions;
    private String[] relationshipType;
    private String[] percentages;
    private String[] remuneration;
    private String entityStatus = "";
    private static final String newLine = "<BR>";
    private static final String remunerationRange = "remuneration_range";
    private static final String ownershipInterests = "ownership_interest";
    private static final String plusString = "+";

    public FinancialEntitySummaryHelper(FinancialEntityForm financialEntityForm) {
        this.financialEntityForm = financialEntityForm;
    }

    public FinancialEntityForm getFinancialEntityForm() {
        return this.financialEntityForm;
    }

    public void setFinancialEntityForm(FinancialEntityForm financialEntityForm) {
        this.financialEntityForm = financialEntityForm;
    }

    public PersonFinIntDisclosure getCurrentFinancialEntity() {
        return this.currentFinancialEntity;
    }

    public void setCurrentFinancialEntity(PersonFinIntDisclosure currentFinancialEntity) {
        this.currentFinancialEntity = currentFinancialEntity;
    }

    public PersonFinIntDisclosure getPreviousFinancialEntity() {
        return this.previousFinancialEntity;
    }

    public void setPreviousFinancialEntity(PersonFinIntDisclosure previousFinancialEntity) {
        this.previousFinancialEntity = previousFinancialEntity;
    }

    public void setSummaryDetails(int currentVersionNumber, String entityNumber, String status) {
        this.initRanges();
        this.currentVersionNumber = currentVersionNumber;
        this.currentFinancialEntity = new PersonFinIntDisclosure();
        this.previousFinancialEntity = new PersonFinIntDisclosure();
        ArrayList<PersonFinIntDisclosure> disclosures = new ArrayList<PersonFinIntDisclosure>();
        disclosures.addAll(this.financialEntityForm.getFinancialEntityHelper().getActiveFinancialEntities());
        disclosures.addAll(this.financialEntityForm.getFinancialEntityHelper().getInactiveFinancialEntities());
        for (PersonFinIntDisclosure financialEntity : disclosures) {
            if (!StringUtils.equalsIgnoreCase((String)financialEntity.getEntityNumber(), (String)entityNumber)) continue;
            List<PersonFinIntDisclosure> currentVersions = financialEntity.getVersions();
            this.currentFinancialEntity = currentVersions.get(currentVersions.size() - currentVersionNumber);
            this.setVersions(currentVersions);
            if (currentVersionNumber <= 1) continue;
            this.previousFinancialEntity = currentVersions.get(currentVersions.size() - currentVersionNumber + 1);
        }
        this.setSummaryBeans(currentVersionNumber, this.currentFinancialEntity, this.previousFinancialEntity);
    }

    protected void setSummaryBeans(int currentVersionNumber, PersonFinIntDisclosure currentFinancialEntity, PersonFinIntDisclosure previousFinancialEntity) {
        this.setCurrentVersionNumber(currentVersionNumber);
        FinancialEntitySummaryBean currentSummary = this.financialEntityForm.getCurrentSummary();
        FinancialEntitySummaryBean previousSummary = this.financialEntityForm.getPreviousSummary();
        this.setSummaryInformation(currentFinancialEntity, currentSummary);
        this.setSummaryInformation(previousFinancialEntity, previousSummary);
        Map<String, String> currentRelationshipDetails = this.getRelationshipDetails(currentFinancialEntity);
        HashMap<String, String> previousRelationshipDetails = new HashMap();
        if (currentVersionNumber > 1) {
            previousRelationshipDetails = this.getRelationshipDetails(previousFinancialEntity);
            this.formatDetails(currentRelationshipDetails, previousRelationshipDetails);
        }
        Map<String, String> dataGroups = this.getDataGroups();
        currentSummary.setRelationshipDetails(this.cleanupDetails(currentRelationshipDetails, dataGroups));
        currentSummary.setAttachmentSummary(this.generateAttachmentSummary(currentFinancialEntity.getFinEntityAttachments(), previousFinancialEntity.getFinEntityAttachments()));
        previousSummary.setRelationshipDetails(this.cleanupDetails(previousRelationshipDetails, dataGroups));
        previousSummary.setAttachmentSummary(this.generateAttachmentSummary(previousFinancialEntity.getFinEntityAttachments(), null));
    }

    protected void formatDetails(Map<String, String> currentRelationshipDetails, Map<String, String> previousRelationshipDetails) {
        FinancialEntitySummaryBean currentSummary = this.financialEntityForm.getCurrentSummary();
        FinancialEntitySummaryBean previousSummary = this.financialEntityForm.getPreviousSummary();
        for (String group : currentRelationshipDetails.keySet()) {
            if (previousRelationshipDetails.containsKey(group)) {
                if (StringUtils.equalsIgnoreCase((String)previousRelationshipDetails.get(group), (String)currentRelationshipDetails.get(group))) continue;
                currentRelationshipDetails.put(group, this.addSpan(currentRelationshipDetails.get(group)));
                continue;
            }
            currentRelationshipDetails.put(group, this.addSpan(currentRelationshipDetails.get(group)));
        }
        Map<String, String> dataGroups = this.getDataGroups();
        currentSummary.setRelationshipDetails(this.cleanupDetails(currentRelationshipDetails, dataGroups));
        previousSummary.setRelationshipDetails(this.cleanupDetails(previousRelationshipDetails, dataGroups));
        if (!StringUtils.equalsIgnoreCase((String)currentSummary.getAddress(), (String)previousSummary.getAddress())) {
            currentSummary.setAddress(this.addSpan(currentSummary.getAddress()));
        }
        if (!StringUtils.equalsIgnoreCase((String)currentSummary.getStatusDescription(), (String)previousSummary.getStatusDescription())) {
            currentSummary.setStatusDescription(this.addSpan(currentSummary.getStatusDescription()));
        }
        if (!StringUtils.equalsIgnoreCase((String)currentSummary.getDetails(), (String)previousSummary.getDetails())) {
            currentSummary.setDetails(this.addSpan(currentSummary.getDetails()));
        }
        if (ObjectUtils.isNotNull((Object)currentSummary.getSponsorName())) {
            if (ObjectUtils.isNotNull((Object)previousSummary.getSponsorName())) {
                if (!StringUtils.equalsIgnoreCase((String)currentSummary.getSponsorName().toString(), (String)previousSummary.getSponsorName().toString())) {
                    currentSummary.setSponsorName(this.addSpan(currentSummary.getSponsorName().toString()));
                }
            } else {
                currentSummary.setSponsorName(this.addSpan(currentSummary.getSponsorName().toString()));
            }
        }
        if (!StringUtils.equalsIgnoreCase((String)currentSummary.getOwnershipType(), (String)previousSummary.getOwnershipType())) {
            currentSummary.setOwnershipType(this.addSpan(currentSummary.getOwnershipType()));
        }
        if (!StringUtils.equalsIgnoreCase((String)currentSummary.getEntitySponsorsResearch(), (String)previousSummary.getEntitySponsorsResearch())) {
            currentSummary.setEntitySponsorsResearch(this.addSpan(currentSummary.getEntitySponsorsResearch()));
        }
    }

    protected Map<String, String> cleanupDetails(Map<String, String> relationshipDetails, Map<String, String> dataGroups) {
        TreeMap<String, String> formattedRelationshipDetails = new TreeMap<String, String>();
        for (String group : relationshipDetails.keySet()) {
            String heading = group.substring(0, group.indexOf(plusString));
            String subHeading = group.substring(group.indexOf(plusString) + 1);
            if (formattedRelationshipDetails.containsKey(heading)) {
                formattedRelationshipDetails.put(heading, (String)formattedRelationshipDetails.get(heading) + subHeading + ": " + newLine + relationshipDetails.get(group) + newLine);
                continue;
            }
            formattedRelationshipDetails.put(heading, subHeading + ": " + newLine + relationshipDetails.get(group) + newLine);
        }
        for (String group : dataGroups.keySet()) {
            if (formattedRelationshipDetails.containsKey(dataGroups.get(group))) continue;
            formattedRelationshipDetails.put(dataGroups.get(group), "");
        }
        return formattedRelationshipDetails;
    }

    protected List<FinancialEntityAttachmentSummary> generateAttachmentSummary(List<FinancialEntityAttachment> attachments, List<FinancialEntityAttachment> prevAttachments) {
        ArrayList<FinancialEntityAttachmentSummary> formattedAttachments = new ArrayList<FinancialEntityAttachmentSummary>();
        for (FinancialEntityAttachment attachment : attachments) {
            String descriptionString = (!StringUtils.isEmpty((String)attachment.getContactName()) ? " Contact Name: " + attachment.getContactName() + "<br />" : "") + "Uploaded " + attachment.getUpdateTimestamp();
            boolean found = false;
            if (prevAttachments != null) {
                for (FinancialEntityAttachment oldAttachment : prevAttachments) {
                    if (!attachment.matches(oldAttachment)) continue;
                    found = true;
                }
            }
            String key = found ? attachment.getFileName() : this.addSpan1(attachment.getFileName());
            String value = found ? descriptionString : this.addSpan(descriptionString);
            String link = attachment.getFileId().toString();
            formattedAttachments.add(new FinancialEntityAttachmentSummary(key, value, link));
        }
        if (prevAttachments != null) {
            for (FinancialEntityAttachment oldAttachment : prevAttachments) {
                boolean found = false;
                for (FinancialEntityAttachment newAttachment : attachments) {
                    if (!oldAttachment.getFileId().equals(newAttachment.getFileId())) continue;
                    found = true;
                }
                if (found) continue;
                formattedAttachments.add(new FinancialEntityAttachmentSummary(this.addSpan2(oldAttachment.getFileName()), this.addSpan2("deleted"), "0"));
            }
        }
        return formattedAttachments;
    }

    protected String addSpan(String htmlString) {
        return "<span class=\"changed\">" + htmlString + "</span>";
    }

    protected String addSpan1(String htmlString) {
        return "<span class=\"change1\">" + htmlString + "</span>";
    }

    protected String addSpan2(String htmlString) {
        return "<span class=\"change2\">" + htmlString + "</span>";
    }

    public List<PersonFinIntDisclosure> getVersions() {
        return this.versions;
    }

    public void setVersions(List<PersonFinIntDisclosure> versions) {
        this.versions = versions;
    }

    public int getNumberOfVersions() {
        return this.getVersions().size();
    }

    public void setCurrentVersionNumber(int currentVersionNumber) {
        this.currentVersionNumber = currentVersionNumber;
    }

    public int getCurrentVersionNumber() {
        return this.currentVersionNumber;
    }

    protected void setSummaryInformation(PersonFinIntDisclosure financialEntity, FinancialEntitySummaryBean summary) {
        String entityAddress = "";
        String webAddress = "";
        for (FinancialEntityContactInfo address : financialEntity.getFinEntityContactInfos()) {
            entityAddress = entityAddress + (ObjectUtils.isNull((Object)address.getAddressLine1()) ? "" : address.getAddressLine1() + newLine);
            entityAddress = entityAddress + (ObjectUtils.isNull((Object)address.getAddressLine2()) ? "" : address.getAddressLine2() + newLine);
            entityAddress = entityAddress + (ObjectUtils.isNull((Object)address.getAddressLine3()) ? "" : address.getAddressLine3() + newLine);
            entityAddress = entityAddress + (ObjectUtils.isNull((Object)address.getCity()) ? "" : address.getCity() + newLine);
            entityAddress = entityAddress + (ObjectUtils.isNull((Object)address.getPostalCode()) ? "" : address.getPostalCode() + newLine);
            entityAddress = entityAddress + (ObjectUtils.isNull((Object)address.getState()) ? "" : address.getState() + newLine);
            entityAddress = entityAddress + (ObjectUtils.isNull((Object)address.getCountryCode()) ? "" : address.getCountryCode() + newLine);
            webAddress = webAddress + (ObjectUtils.isNull((Object)address.getWebAddress1()) ? "" : address.getWebAddress1() + newLine);
            webAddress = webAddress + (ObjectUtils.isNull((Object)address.getWebAddress2()) ? "" : address.getWebAddress2() + newLine);
        }
        summary.setAddress(entityAddress);
        summary.setWebAddress(webAddress);
        summary.setOwnershipType(StringUtils.equalsIgnoreCase((String)financialEntity.getEntityOwnershipType(), (String)"V") ? "Private" : "Public");
        summary.setEntitySponsorsResearch(StringUtils.equalsIgnoreCase((String)financialEntity.getEntitySponsorsResearch(), (String)"Y") ? "Yes" : "No");
        String details = "";
        if (ObjectUtils.isNotNull((Object)financialEntity.getOrgRelationDescription())) {
            details = details + "Org Relation Description: <BR>" + financialEntity.getOrgRelationDescription() + newLine + newLine;
        }
        if (ObjectUtils.isNotNull((Object)financialEntity.getPrincipalBusinessActivity())) {
            details = details + "Entity Principal Business/Activity: <BR>" + financialEntity.getPrincipalBusinessActivity() + newLine + newLine;
        }
        if (ObjectUtils.isNotNull((Object)financialEntity.getStudentInvolvement())) {
            details = details + "Entity Student Involvement: <BR>" + financialEntity.getStudentInvolvement() + newLine + newLine;
        }
        if (ObjectUtils.isNotNull((Object)financialEntity.getStaffInvolvement())) {
            details = details + "Entity Staff Involvement: <BR>" + financialEntity.getStaffInvolvement() + newLine + newLine;
        }
        if (ObjectUtils.isNotNull((Object)financialEntity.getFacilityUse())) {
            details = details + "Entity Institutional/Facilities Use: <BR>" + financialEntity.getFacilityUse() + newLine + newLine;
        }
        summary.setDetails(details);
        summary.setStatusDescription(financialEntity.getFinIntEntityStatus() != null ? financialEntity.getFinIntEntityStatus().getDescription() : "");
        summary.setSponsorName(financialEntity.getSponsor() != null ? financialEntity.getSponsor().getSponsorName() : "");
    }

    protected Map<String, String> getRelationshipDetails(PersonFinIntDisclosure financialEntity) {
        List<PersonFinIntDisclDet> details = financialEntity.getPerFinIntDisclDetails();
        Map<String, FinEntitiesDataMatrix> dataType = this.getFinancialEntityDataMatrix();
        HashMap<String, String> relationshipDetails = new HashMap<String, String>();
        Map<String, String> dataGroups = this.getDataGroups();
        String value = "";
        if (details != null) {
            for (PersonFinIntDisclDet detail : details) {
                FinEntitiesDataMatrix dm = dataType.get(detail.getColumnName());
                if (!ObjectUtils.isNotNull((Object)detail.getColumnValue())) continue;
                int columnValue = Integer.parseInt(detail.getColumnValue());
                if (ObjectUtils.isNull((Object)dm.getLookupArgument())) {
                    value = this.relationshipType[Integer.parseInt(detail.getRelationshipTypeCode()) - 1] + ", ";
                } else if (dm.getLookupArgument().equalsIgnoreCase(remunerationRange)) {
                    value = this.relationshipType[Integer.parseInt(detail.getRelationshipTypeCode()) - 1] + " : " + this.remuneration[columnValue - 1] + ", ";
                } else if (dm.getLookupArgument().equalsIgnoreCase(ownershipInterests)) {
                    value = this.relationshipType[Integer.parseInt(detail.getRelationshipTypeCode()) - 1] + " : " + this.percentages[columnValue - 1] + ", ";
                }
                String groupName = dataGroups.get(dm.getDataGroupId().toString());
                String hashKey = groupName + plusString + dm.getColumnLabel();
                if (relationshipDetails.containsKey(hashKey)) {
                    relationshipDetails.put(hashKey, (String)relationshipDetails.get(hashKey) + value);
                    continue;
                }
                if (ObjectUtils.isNotNull((Object)detail.getComments())) {
                    value = "Comments: " + detail.getComments() + newLine + value;
                }
                relationshipDetails.put(hashKey, value);
            }
        }
        return relationshipDetails;
    }

    protected Map<String, FinEntitiesDataMatrix> getFinancialEntityDataMatrix() {
        HashMap<String, FinEntitiesDataMatrix> dataType = new HashMap<String, FinEntitiesDataMatrix>();
        List matrix = (List)this.getBusinessObjectService().findAll(FinEntitiesDataMatrix.class);
        for (FinEntitiesDataMatrix row : matrix) {
            dataType.put(row.getColumnName(), row);
        }
        return dataType;
    }

    protected Map<String, String> getDataGroups() {
        HashMap<String, String> dataGroups = new HashMap<String, String>();
        List groups = (List)this.getBusinessObjectService().findAll(FinEntitiesDataGroup.class);
        for (FinEntitiesDataGroup row : groups) {
            dataGroups.put(row.getDataGroupId().toString(), row.getDataGroupName());
        }
        return dataGroups;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected FinancialEntityService getFinancialEntityService() {
        return KraServiceLocator.getService(FinancialEntityService.class);
    }

    protected void initRanges() {
        ArgValueLookupValuesFinder finder = new ArgValueLookupValuesFinder();
        finder.setArgName(remunerationRange);
        List<KeyValue> kv = finder.getKeyValues();
        int index = 0;
        String[] temp = new String[kv.size()];
        for (KeyValue pair : kv) {
            if (pair.getValue().equalsIgnoreCase("select")) continue;
            temp[index] = pair.getValue();
            ++index;
        }
        this.setRemuneration(temp);
        finder.setArgName(ownershipInterests);
        kv = finder.getKeyValues();
        index = 0;
        String[] tempPercentage = new String[kv.size()];
        for (KeyValue pair : kv) {
            if (pair.getValue().equalsIgnoreCase("select")) continue;
            tempPercentage[index] = pair.getValue();
            ++index;
        }
        this.setPercentages(tempPercentage);
        List relTypes = (List)this.getBusinessObjectService().findAll(FinIntEntityRelType.class);
        String[] types = new String[relTypes.size()];
        index = 0;
        for (FinIntEntityRelType type : relTypes) {
            types[index] = type.getDescription();
            ++index;
        }
        this.setRelationshipType(types);
    }

    public String[] getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String[] relationshipType) {
        this.relationshipType = relationshipType;
    }

    public String[] getPercentages() {
        return this.percentages;
    }

    public void setPercentages(String[] percentages) {
        this.percentages = percentages;
    }

    public String[] getRemuneration() {
        return this.remuneration;
    }

    public void setRemuneration(String[] remuneration) {
        this.remuneration = remuneration;
    }

    public String getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(String entityStatus) {
        this.entityStatus = entityStatus;
    }
}

