/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.ApprovedDisclosureDocument;
import noNamespace.CoiDisclosureDetailsDocument;
import noNamespace.DisclosureDocumentsDocument;
import noNamespace.DisclosureNotesDocument;
import noNamespace.DisclosureProjectsDocument;
import noNamespace.PersonDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.notesandattachments.notes.CoiDisclosureNotepad;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.kra.questionnaire.print.QuestionnaireXmlStream;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class CoiCertificationXmlStream
implements XmlStream {
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private static final Log LOG = LogFactory.getLog(QuestionnaireXmlStream.class);

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        CoiDisclosure disclosure = (CoiDisclosure)printableBusinessObject;
        ApprovedDisclosureDocument approvedDisclosureDoc = ApprovedDisclosureDocument.Factory.newInstance();
        try {
            approvedDisclosureDoc.setApprovedDisclosure(this.getDisclosureData(disclosure, reportParameters));
        }
        catch (PrintingException e) {
            e.printStackTrace();
        }
        LinkedHashMap xmlObjectList = new LinkedHashMap();
        HashMap<String, XmlObject> map = new HashMap<String, XmlObject>();
        map.put("DisclosureSummary", (XmlObject)approvedDisclosureDoc);
        return map;
    }

    public ApprovedDisclosureDocument.ApprovedDisclosure getDisclosureData(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> htData) throws PrintingException {
        CoiDisclosure disclosure = (CoiDisclosure)printableBusinessObject;
        ApprovedDisclosureDocument.ApprovedDisclosure approvedDisclosure = ApprovedDisclosureDocument.ApprovedDisclosure.Factory.newInstance();
        approvedDisclosure.setDisclosureNumber(disclosure.getCoiDisclosureNumber());
        approvedDisclosure.setSequenceNumber(disclosure.getSequenceNumber().toString());
        approvedDisclosure.setPersonID(disclosure.getPersonId());
        String certText = disclosure.getCertificationText();
        certText = certText.substring(3);
        approvedDisclosure.setCertificationText(certText);
        approvedDisclosure.setCertifiedBy(disclosure.getCertifiedBy());
        approvedDisclosure.setCertificationTimestamp(disclosure.getCertificationTimestampString());
        approvedDisclosure.setDisclosureDipositionStatus(disclosure.getDisclosureDispositionCode());
        approvedDisclosure.setDisclosureStatus(disclosure.getDisclosureStatusCode());
        approvedDisclosure.setExpirationDate(disclosure.getExpirationDate().toString());
        this.setPersonDetails(approvedDisclosure, disclosure);
        this.setDisclosureProjects(approvedDisclosure, disclosure);
        this.setCoiDisclosureDetails(approvedDisclosure, disclosure);
        this.setCertificationQuestionnaires(approvedDisclosure, disclosure);
        this.setDisclosureNotes(approvedDisclosure, disclosure);
        this.setDisclosureAttachments(approvedDisclosure, disclosure);
        return approvedDisclosure;
    }

    private void setPersonDetails(ApprovedDisclosureDocument.ApprovedDisclosure approvedDisclosure, CoiDisclosure disclosure) {
        ArrayList<PersonDocument.Person> personDocList = new ArrayList<PersonDocument.Person>();
        PersonDocument.Person person = PersonDocument.Person.Factory.newInstance();
        KcPerson reporter = KraServiceLocator.getService(KcPersonService.class).getKcPersonByPersonId(disclosure.getPersonId());
        person.setFullName(reporter.getFullName());
        person.setAddress1(reporter.getAddressLine1() + "" + reporter.getAddressLine2() + "" + reporter.getAddressLine3());
        person.setDirDept(reporter.getDirectoryDepartment());
        person.setSchool(reporter.getSchool());
        person.setOffPhone(reporter.getOfficePhone());
        person.setEmail(reporter.getEmailAddress());
        personDocList.add(person);
        approvedDisclosure.setPersonArray(personDocList.toArray(new PersonDocument.Person[0]));
    }

    private void setCertificationQuestionnaires(ApprovedDisclosureDocument.ApprovedDisclosure approvedDisclosure, CoiDisclosure disclosure) {
    }

    private void setCoiDisclosureDetails(ApprovedDisclosureDocument.ApprovedDisclosure approvedDisclosure, CoiDisclosure disclosure) {
        ArrayList<CoiDisclosureDetailsDocument.CoiDisclosureDetails> coiDisclosurProjectsList = new ArrayList<CoiDisclosureDetailsDocument.CoiDisclosureDetails>();
        List<CoiDisclProject> coiDisclProjectList = disclosure.getCoiDisclProjects();
        for (CoiDisclProject coiDisclProject : coiDisclProjectList) {
            for (CoiDiscDetail coiDiscDetail : coiDisclProject.getCoiDiscDetails()) {
                if (coiDiscDetail.getPersonFinIntDisclosure() == null) continue;
                CoiDisclosureDetailsDocument.CoiDisclosureDetails coiDisclosureDetails = CoiDisclosureDetailsDocument.CoiDisclosureDetails.Factory.newInstance();
                coiDisclosureDetails.setEntityName(coiDiscDetail.getPersonFinIntDisclosure().getEntityName());
                if (coiDiscDetail.getCoiEntityDispositionStatus() != null) {
                    coiDisclosureDetails.setConflictStatus(coiDiscDetail.getCoiEntityDispositionStatus().getDescription());
                }
                coiDisclosurProjectsList.add(coiDisclosureDetails);
            }
        }
        if (coiDisclosurProjectsList.size() > 0) {
            approvedDisclosure.setCoiDisclosureDetailsArray(coiDisclosurProjectsList.toArray(new CoiDisclosureDetailsDocument.CoiDisclosureDetails[0]));
        }
    }

    private void setDisclosureProjects(ApprovedDisclosureDocument.ApprovedDisclosure approvedDisclosure, CoiDisclosure disclosure) {
        ArrayList<DisclosureProjectsDocument.DisclosureProjects> discProjectsList = new ArrayList<DisclosureProjectsDocument.DisclosureProjects>();
        List<CoiDisclProject> disclosureProjectList = disclosure.getCoiDisclProjects();
        for (CoiDisclProject coiDisclProject : disclosureProjectList) {
            DisclosureProjectsDocument.DisclosureProjects disclosureProjects = DisclosureProjectsDocument.DisclosureProjects.Factory.newInstance();
            if (coiDisclProject.getProjectId() != null) {
                disclosureProjects.setProjectID(coiDisclProject.getProjectId());
            }
            if (coiDisclProject.getCoiProjectTitle() != null) {
                disclosureProjects.setProjectTitle(coiDisclProject.getCoiProjectTitle());
            }
            if (coiDisclProject.getLongTextField1() != null) {
                disclosureProjects.setProjectSponsor(coiDisclProject.getLongTextField1());
            }
            if (coiDisclProject.getDateField1() != null) {
                disclosureProjects.setProjectStartDate(coiDisclProject.getDateField1().toString());
            }
            if (coiDisclProject.getDateField2() != null) {
                disclosureProjects.setProjectEndDate(coiDisclProject.getDateField2().toString());
            }
            if (coiDisclProject.getProjectTypeLabel() != null) {
                disclosureProjects.setProjectType(coiDisclProject.getProjectTypeLabel());
            }
            discProjectsList.add(disclosureProjects);
        }
        if (discProjectsList.size() > 0) {
            approvedDisclosure.setDisclosureProjectsArray(discProjectsList.toArray(new DisclosureProjectsDocument.DisclosureProjects[0]));
        }
    }

    private void setDisclosureNotes(ApprovedDisclosureDocument.ApprovedDisclosure approvedDisclosure, CoiDisclosure disclosure) {
        ArrayList<DisclosureNotesDocument.DisclosureNotes> disclosureNoteslist = new ArrayList<DisclosureNotesDocument.DisclosureNotes>();
        List<CoiDisclosureNotepad> coiDisclosureNotepadList = disclosure.getCoiDisclosureNotepads();
        for (CoiDisclosureNotepad coiDisclosureNotepad : coiDisclosureNotepadList) {
            if (!coiDisclosureNotepad.getRestrictedView()) {
                DisclosureNotesDocument.DisclosureNotes disclosureNotes = DisclosureNotesDocument.DisclosureNotes.Factory.newInstance();
                disclosureNotes.setComments(coiDisclosureNotepad.getComments());
                disclosureNotes.setNoteEntry(coiDisclosureNotepad.getNoteTopic());
                disclosureNotes.setUpdateTimestamp(coiDisclosureNotepad.getUpdateTimestamp().toString());
                disclosureNotes.setUpdateUser(coiDisclosureNotepad.getUpdateUser());
                disclosureNoteslist.add(disclosureNotes);
            }
            if (disclosureNoteslist.size() <= 0) continue;
            approvedDisclosure.setDisclosureNotesArray(disclosureNoteslist.toArray(new DisclosureNotesDocument.DisclosureNotes[0]));
        }
    }

    private void setDisclosureAttachments(ApprovedDisclosureDocument.ApprovedDisclosure approvedDisclosure, CoiDisclosure disclosure) {
        ArrayList<DisclosureDocumentsDocument.DisclosureDocuments> disclosureDocumentList = new ArrayList<DisclosureDocumentsDocument.DisclosureDocuments>();
        List<CoiDisclosureAttachment> coiDisclAttachmentList = disclosure.getCoiDisclosureAttachments();
        for (CoiDisclosureAttachment coiDiscAttachments : coiDisclAttachmentList) {
            DisclosureDocumentsDocument.DisclosureDocuments disclDocuments = DisclosureDocumentsDocument.DisclosureDocuments.Factory.newInstance();
            disclDocuments.setComments(coiDiscAttachments.getComments());
            disclDocuments.setDescription(coiDiscAttachments.getDescription());
            disclDocuments.setUpdateTimestamp(coiDiscAttachments.getUpdateTimestamp().toString());
            disclDocuments.setUpdateUser(coiDiscAttachments.getUpdateUser());
            disclosureDocumentList.add(disclDocuments);
        }
        approvedDisclosure.setDisclosureDocumentsArray(disclosureDocumentList.toArray(new DisclosureDocumentsDocument.DisclosureDocuments[0]));
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    @Override
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

