/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.disclosure.CoiDisclosureProjectBean;
import org.kuali.kra.coi.disclosure.MasterDisclosureBean;
import org.kuali.kra.coi.questionnaire.DisclosureModuleQuestionnaireBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.BaseQuestionnaireAuditRule;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class DisclosureQuestionnaireAuditRule
extends BaseQuestionnaireAuditRule<CoiDisclosureDocument>
implements DocumentAuditRule {
    private static final String DISCLOSURE_QUESTIONNAIRE_KEY = "disclosureQuestionnaireHelper.answerHeaders";
    private static final String SCREENING_QUESTIONNAIRE_KEY = "screeningQuestionnaireHelper.answerHeaders";
    private static final String DISCLOSURE_QUESTIONNAIRE_PANEL_KEY = "coiQuestionnaireKey";
    protected static final String MASTER_DISCLOSURE_PROJECT_QUESTIONNAIRE_KEY = "disclosureHelper.masterDisclosureBean.%s[%s].projectQuestionnaireHelper.answerHeaders";
    protected static final String AUDIT_ERROR_LABEL;
    private boolean requestSubmission;

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        CoiDisclosure coiDisclosure = ((CoiDisclosureDocument)document).getCoiDisclosure();
        boolean isValid = true;
        DisclosureModuleQuestionnaireBean disclosureModuleQuestionnaireBean = new DisclosureModuleQuestionnaireBean(coiDisclosure);
        List<AnswerHeader> headers = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(disclosureModuleQuestionnaireBean);
        if (headers != null) {
            isValid &= this.checkAnswerHeaders(headers, DISCLOSURE_QUESTIONNAIRE_KEY);
        }
        if ((headers = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(new DisclosureModuleQuestionnaireBean(coiDisclosure, "8"))) != null) {
            isValid &= this.checkAnswerHeaders(headers, SCREENING_QUESTIONNAIRE_KEY);
        }
        MasterDisclosureBean masterBean = new MasterDisclosureBean();
        for (CoiDisclProject project : coiDisclosure.getCoiDisclProjects()) {
            if (project.getOriginalCoiDisclosureId() == null || ObjectUtils.equals((Object)project.getOriginalCoiDisclosureId(), (Object)coiDisclosure.getCoiDisclosureId())) continue;
            CoiDisclosureProjectBean projectBean = new CoiDisclosureProjectBean();
            projectBean.setCoiDisclProject(project);
            projectBean.populateAnswers(coiDisclosure);
            masterBean.addProject(projectBean, projectBean.getCoiDisclProject().getDisclosureEventType());
        }
        isValid &= this.checkProjects(masterBean.getManualAwardProjects(), "manualAwardProjects");
        isValid &= this.checkProjects(masterBean.getManualIacucProtocolProjects(), "manualIacucProtocolProjects");
        isValid &= this.checkProjects(masterBean.getManualProposalProjects(), "manualProposalProjects");
        isValid &= this.checkProjects(masterBean.getManualProtocolProjects(), "manualProtocolProjects");
        isValid &= this.checkProjects(masterBean.getManualTravelProjects(), "manualTravelProjects");
        isValid &= this.checkProjects(masterBean.getOtherManualProjects(), "otherManualProjects");
        isValid &= this.checkProjects(masterBean.getAwardProjects(), "awardProjects");
        isValid &= this.checkProjects(masterBean.getProposalProjects(), "proposalProjects");
        return isValid &= this.checkProjects(masterBean.getProtocolProjects(), "protocolProjects");
    }

    protected boolean checkProjects(List<CoiDisclosureProjectBean> projects, String listName) {
        boolean result = true;
        for (int i = 0; i < projects.size(); ++i) {
            CoiDisclosureProjectBean projectBean = projects.get(i);
            result &= this.checkAnswerHeaders(projectBean.getProjectQuestionnaireHelper().getAnswerHeaders(), String.format(MASTER_DISCLOSURE_PROJECT_QUESTIONNAIRE_KEY, listName, i));
        }
        return result;
    }

    protected boolean checkAnswerHeaders(List<AnswerHeader> answerHeaders, String messageKey) {
        boolean isValid = true;
        for (int i = 0; i < answerHeaders.size(); ++i) {
            AnswerHeader header = answerHeaders.get(i);
            QuestionnaireUsage usage = header.getQuestionnaire().getHighestVersionUsageFor(header.getModuleItemCode(), header.getModuleSubItemCode());
            if (usage != null && usage.isMandatory() && !header.getCompleted() && header.isActiveQuestionnaire()) {
                isValid = false;
                this.addAuditError(messageKey + "[" + i + "]", "error.coi.questionnaire.mandatory", usage.getQuestionnaireLabel());
            }
            if (!header.isNewerVersionPublished() || !header.isActiveQuestionnaire()) continue;
            isValid = false;
            this.addAuditError(messageKey + "[" + i + "]", "error.coi.questionnaire.notupdated", usage.getQuestionnaireLabel());
        }
        return isValid;
    }

    @Override
    protected List<Integer> getIncompleteMandatoryQuestionnaire(CoiDisclosureDocument coiDisclosureDocument) {
        CoiDisclosure coiDisclosure = coiDisclosureDocument.getCoiDisclosure();
        DisclosureModuleQuestionnaireBean moduleQuestionnaireBean = new DisclosureModuleQuestionnaireBean(coiDisclosure);
        if (this.isRequestSubmission()) {
            moduleQuestionnaireBean.setModuleSubItemCode("1");
        }
        return super.getIncompleteMandatoryQuestionnaire("8", moduleQuestionnaireBean);
    }

    protected void addAuditError(String errorKey, String messageKey, String label) {
        this.getCoiDisclosureAuditErrors().add(new AuditError(errorKey, messageKey, AUDIT_ERROR_LABEL, new String[]{label}));
    }

    private List<AuditError> getCoiDisclosureAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String key = DISCLOSURE_QUESTIONNAIRE_PANEL_KEY;
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(key)) {
            KNSGlobalVariables.getAuditErrorMap().put(key, new AuditCluster("Questionnaire", auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }

    public boolean isMandatorySubmissionQuestionnaireComplete(List<AnswerHeader> answerHeaders) {
        boolean isValid = true;
        for (AnswerHeader answerHeader : answerHeaders) {
            if (!this.getQuestionnaireUsage("8", "1", answerHeader.getQuestionnaire().getQuestionnaireUsages()).isMandatory() || this.getQuestionnaireAnswerService().isQuestionnaireAnswerComplete(answerHeader.getAnswers())) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    @Override
    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    @Override
    protected String getAuditErrorLink() {
        return AUDIT_ERROR_LABEL;
    }

    @Override
    protected String getAuditErrorsLabel() {
        return null;
    }

    public boolean isRequestSubmission() {
        return this.requestSubmission;
    }

    public void setRequestSubmittion(boolean requestSubmission) {
        this.requestSubmission = requestSubmission;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("coiDisclosure");
        stringBuilder.append(".");
        stringBuilder.append("Disclosure");
        AUDIT_ERROR_LABEL = stringBuilder.toString();
    }
}

