/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.questionnaire;

import java.util.ArrayList;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.questionnaire.DisclosureModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.QuestionnaireHelperBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.springframework.util.CollectionUtils;

public class DisclosureQuestionnaireHelper
extends QuestionnaireHelperBase {
    private static final long serialVersionUID = -8685872555239368202L;
    private CoiDisclosure coiDisclosure;
    private boolean questionnairesLoaded;

    public DisclosureQuestionnaireHelper(CoiDisclosure coiDisclosure) {
        this.setAnswerHeaders(new ArrayList<AnswerHeader>());
        this.coiDisclosure = coiDisclosure;
    }

    @Override
    public String getModuleCode() {
        return "8";
    }

    @Override
    public ModuleQuestionnaireBean getModuleQnBean() {
        return new DisclosureModuleQuestionnaireBean(this.getCoiDisclosure());
    }

    public void prepareView(boolean reload) {
        this.initializePermissions(this.getCoiDisclosure());
        this.populateQuestionnaires(reload);
    }

    protected void initializePermissions(CoiDisclosure CoiDisclosure2) {
        CoiDisclosureTask task = new CoiDisclosureTask("answerCoiDisclosureQuestionnaire", CoiDisclosure2);
        this.setAnswerQuestionnaire(this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task));
    }

    protected void populateQuestionnaires(boolean reload) {
        boolean refreshed = false;
        if (!this.questionnairesLoaded || reload) {
            this.populateAnswers();
            refreshed = true;
        }
        if (!refreshed && !CollectionUtils.isEmpty(this.getAnswerHeaders())) {
            for (AnswerHeader answerHeader : this.getAnswerHeaders()) {
                this.getQuestionnaireAnswerService().setupChildAnswerIndicator(answerHeader);
            }
        }
    }

    @Override
    public void populateAnswers() {
        super.populateAnswers();
        this.questionnairesLoaded = true;
    }

    public CoiDisclosure getCoiDisclosure() {
        return this.coiDisclosure;
    }

    public void setCoiDisclosure(CoiDisclosure coiDisclosure) {
        this.coiDisclosure = coiDisclosure;
    }

    @Override
    public void preSave() {
        for (AnswerHeader answerHeader : this.getAnswerHeaders()) {
            answerHeader.setModuleItemKey(this.getCoiDisclosure().getCoiDisclosureId().toString());
        }
        super.preSave();
    }
}

