/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiUserRole;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class CoiDisclosureReviewerDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static final Logger LOG = Logger.getLogger(CoiDisclosureReviewerDerivedRoleTypeServiceImpl.class);
    private static final String DISCLOSURE = "coiDisclosureId";
    private KcPersonService kcPersonService;
    protected List<String> requiredAttributes = new ArrayList<String>();

    public CoiDisclosureReviewerDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add(DISCLOSURE);
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        List<CoiUserRole> userRoles;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String disclosureId = qualification.get(DISCLOSURE);
        CoiDisclosure disclosure = this.getCoiDisclosureById(disclosureId);
        if (disclosure != null && CollectionUtils.isNotEmpty(userRoles = disclosure.getCoiUserRoles())) {
            for (CoiUserRole userRole : userRoles) {
                if (!StringUtils.equalsIgnoreCase((String)userRole.getRoleName(), (String)"COI Reviewer")) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)this.getPersonId(userRole.getUserId()), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        List<CoiUserRole> userRoles;
        this.validateRequiredAttributesAgainstReceived(qualification);
        boolean hasRole = false;
        String disclosureId = qualification.get(DISCLOSURE);
        CoiDisclosure disclosure = this.getCoiDisclosureById(disclosureId);
        if (disclosure != null && CollectionUtils.isNotEmpty(userRoles = disclosure.getCoiUserRoles())) {
            String personId = null;
            for (CoiUserRole userRole : userRoles) {
                if (!StringUtils.equals((String)"COI Reviewer", (String)userRole.getRoleName()) || !StringUtils.equals((String)(personId = this.getPersonId(userRole.getUserId())), (String)principalId)) continue;
                hasRole = true;
                break;
            }
        }
        return hasRole;
    }

    private CoiDisclosure getCoiDisclosureById(String disclosureId) {
        CoiDisclosure disclosure = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DISCLOSURE, disclosureId);
        List disclosures = (List)this.getBusinessObjectService().findMatching(CoiDisclosure.class, params);
        if (CollectionUtils.isNotEmpty((Collection)disclosures)) {
            disclosure = (CoiDisclosure)disclosures.get(0);
        }
        return disclosure;
    }

    private String getPersonId(String userName) {
        String personId = null;
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(userName);
        if (person != null) {
            personId = person.getPersonId();
        }
        return personId;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

