/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.service.CoiMessagesService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiMessagesServiceImpl
implements CoiMessagesService {
    private transient BusinessObjectService businessObjectService;
    private transient ParameterService parameterService;
    private transient ConfigurationService configurationService;

    @Override
    public List<String> getMessages() {
        ArrayList<String> results = new ArrayList<String>();
        UserSession session = GlobalVariables.getUserSession();
        if (session != null && StringUtils.isNotEmpty((String)GlobalVariables.getUserSession().getPrincipalId())) {
            String personId = GlobalVariables.getUserSession().getPrincipalId();
            String renewalDateString = this.getParameterService().getParameterValueAsString("KC-COIDISCLOSURE", "Document", "ANNUAL_DISCLOSURE_RENEWAL_DATE");
            if (StringUtils.isNotEmpty((String)renewalDateString)) {
                String msg;
                Calendar dueCalendarDate;
                Date renewalDue = null;
                try {
                    renewalDue = new Date(new SimpleDateFormat("MM/dd").parse(renewalDateString).getTime());
                }
                catch (Exception e) {
                    System.err.println("***** no valid Annual Disclosure Certification renewal date found.  Defaulting to anniversary of last Annual");
                }
                String advanceNoticeString = this.getParameterService().getParameterValueAsString("KC-COIDISCLOSURE", "Document", "ANNUAL_DISCLOSURE_ADVANCE_NOTICE");
                int advanceDays = -1;
                try {
                    advanceDays = Integer.parseInt(advanceNoticeString);
                }
                catch (Exception e) {
                    System.err.println("***** no valid Annual Disclosure Certification advance notice parameter found.  Defaulting to 30 days.");
                    advanceDays = 30;
                }
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", personId);
                fieldValues.put("eventTypeCode", "14");
                List annualDisclosures = (List)this.businessObjectService.findMatching(CoiDisclosure.class, fieldValues);
                Timestamp lastAnnualDate = null;
                for (CoiDisclosure disclosure : annualDisclosures) {
                    if (lastAnnualDate != null && !lastAnnualDate.before(disclosure.getCertificationTimestamp())) continue;
                    lastAnnualDate = disclosure.getCertificationTimestamp();
                }
                Calendar lastAnnualCalendar = null;
                if (lastAnnualDate != null) {
                    lastAnnualCalendar = Calendar.getInstance();
                    lastAnnualCalendar.setTimeInMillis(lastAnnualDate.getTime());
                }
                Calendar currentTime = Calendar.getInstance();
                boolean sendErrorWithDate = false;
                boolean sendError = false;
                if (renewalDue != null) {
                    dueCalendarDate = Calendar.getInstance();
                    dueCalendarDate.setTimeInMillis(renewalDue.getTime());
                    dueCalendarDate.set(1, currentTime.get(1));
                    renewalDue = new Date(dueCalendarDate.getTimeInMillis());
                    Calendar reminderDate = Calendar.getInstance();
                    reminderDate.setTimeInMillis(renewalDue.getTime());
                    reminderDate.add(5, -advanceDays);
                    if (currentTime.after(reminderDate) && (lastAnnualCalendar == null || currentTime.after(lastAnnualCalendar))) {
                        sendErrorWithDate = true;
                    }
                } else {
                    dueCalendarDate = Calendar.getInstance();
                    if (lastAnnualDate == null) {
                        sendError = true;
                    } else {
                        dueCalendarDate.setTimeInMillis(lastAnnualDate.getTime());
                        dueCalendarDate.add(1, 1);
                        dueCalendarDate.add(5, -1);
                        renewalDue = new Date(dueCalendarDate.getTimeInMillis());
                        Calendar reminderDate = Calendar.getInstance();
                        reminderDate.setTimeInMillis(renewalDue.getTime());
                        reminderDate.add(5, -advanceDays);
                        if (currentTime.after(reminderDate)) {
                            sendErrorWithDate = true;
                        }
                    }
                }
                if (sendError && !StringUtils.isEmpty((String)(msg = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("annual.disclosure.due.message")))) {
                    results.add(msg);
                }
                if (sendErrorWithDate && !StringUtils.isEmpty((String)(msg = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("annual.disclosure.due.message.with.date")))) {
                    results.add(msg.replace("{0}", new SimpleDateFormat("MM/dd/yyyy").format(renewalDue)));
                }
            }
        }
        return results;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

