/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.print.CoiCertificationPrint;
import org.kuali.kra.coi.print.CoiReportType;
import org.kuali.kra.coi.service.CoiPrintingService;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class CoiPrintingServiceImpl
implements CoiPrintingService {
    private PrintingService printingService;
    private CoiCertificationPrint coiCertificationPrint;
    private BusinessObjectService businessObjectService;
    private ConfigurationService configurationService;

    @Override
    public AttachmentDataSource printDisclosureCertification(KraPersistableBusinessObjectBase printableBusinessObject, String reportName, Map<String, Object> reportParameters) throws PrintingException {
        System.out.println("\nNew printDisclosureCertification event occurred.... ");
        AttachmentDataSource source = null;
        CoiCertificationPrint printable = null;
        printable = this.getCoiCertificationPrint();
        printable.setPrintableBusinessObject(printableBusinessObject);
        printable.setReportParameters(reportParameters);
        source = this.getPrintingService().print(printable);
        return source;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public CoiCertificationPrint getCoiCertificationPrint() {
        return this.coiCertificationPrint;
    }

    public void setCoiCertificationPrint(CoiCertificationPrint coiCertificationPrint) {
        this.coiCertificationPrint = coiCertificationPrint;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public Printable getCoiPrintArtifacts(CoiDisclosure coiDisclosure) {
        CoiReportType reportType = CoiReportType.COI_BATCH_CORRESPONDENCE;
        AbstractPrint printable = this.getCoiPrintable(reportType);
        printable.setPrintableBusinessObject(coiDisclosure);
        return printable;
    }

    @Override
    public AttachmentDataSource print(List<Printable> printableArtifactList) throws PrintingException {
        String fileName = "";
        AttachmentDataSource attachmentDataSource = this.getPrintingService().print(printableArtifactList);
        CoiCertificationPrint certificationPrint = (CoiCertificationPrint)printableArtifactList.get(0);
        CoiDisclosure coiDisclosure = (CoiDisclosure)certificationPrint.getPrintableBusinessObject();
        fileName = "PendingDisclosure.pdf";
        try {
            attachmentDataSource.setFileName(URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setFileName(fileName);
        }
        attachmentDataSource.setContentType("application/pdf");
        return attachmentDataSource;
    }

    @Override
    public AbstractPrint getCoiPrintable(CoiReportType reportType) {
        CoiCertificationPrint printable = null;
        switch (reportType) {
            case COI_APPROVED_DISCLOSURE: {
                printable = this.getCoiCertificationPrint();
            }
        }
        return printable;
    }

    public ConfigurationService getKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

