/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueComparator;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeIdByUnitValuesFinder
extends KeyValuesBase {
    private String protocolLeadUnit;
    private String docRouteStatus;
    private String currentCommitteeId;
    public static final String FINAL_STATUS_CD = "F";
    private Set<String> unitIds = new HashSet<String>();

    public List getKeyValues() {
        Collection<Committee> committees = this.getValidCommittees();
        ArrayList<ConcreteKeyValue> keyValues = new ArrayList<ConcreteKeyValue>();
        if (CollectionUtils.isNotEmpty(committees)) {
            if (this.isSaved()) {
                this.getProtocolUnitIds();
                for (Committee committee : committees) {
                    if (!StringUtils.equalsIgnoreCase((String)((CommitteeDocument)((Object)committee.getCommitteeDocument())).getDocStatusCode(), (String)FINAL_STATUS_CD) || !this.unitIds.contains(committee.getHomeUnit().getUnitNumber())) continue;
                    keyValues.add(new ConcreteKeyValue(committee.getCommitteeId(), committee.getCommitteeName()));
                }
            } else {
                this.getIRBAdminUnitIds();
                for (Committee committee : committees) {
                    if (!this.unitIds.contains(committee.getHomeUnit().getUnitNumber()) && !committee.getCommitteeId().equals(this.getCurrentCommitteeId())) continue;
                    keyValues.add(new ConcreteKeyValue(committee.getCommitteeId(), committee.getCommitteeName()));
                }
            }
            Collections.sort(keyValues, new KeyValueComparator());
        }
        keyValues.add(0, new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        return keyValues;
    }

    protected abstract String getCommitteeTypeCodeHook();

    private boolean isSaved() {
        return this.getDocRouteStatus().equals("S");
    }

    protected abstract String getRoleNameHook();

    private void getIRBAdminUnitIds() {
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        Role roleInfo = this.getRoleService().getRoleByNamespaceCodeAndName("KC-UNT", this.getRoleNameHook());
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleInfo.getId());
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", "*");
        HashMap qualifications = new HashMap(qualifiedRoleAttributes);
        boolean valid = this.getRoleService().principalHasRole(principalId, roleIds, qualifications);
        if (valid) {
            List principalQualifications = this.getRoleService().getNestedRoleQualifiersForPrincipalByRoleIds(principalId, roleIds, qualifications);
            for (Map attrSet : principalQualifications) {
                Unit unit = this.getUnitService().getUnit((String)attrSet.get("unitNumber"));
                if (unit == null) continue;
                this.unitIds.add(unit.getUnitNumber());
                if (!attrSet.containsKey("subunits") || !StringUtils.equalsIgnoreCase((String)"Y", (String)((String)attrSet.get("subunits")))) continue;
                List<Unit> subUnits = this.getUnitService().getAllSubUnits((String)attrSet.get("unitNumber"));
                for (Unit u : subUnits) {
                    this.unitIds.add(u.getUnitNumber());
                }
            }
        }
    }

    private Collection<Committee> getValidCommittees() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("committeeTypeCode", this.getCommitteeTypeCodeHook());
        Collection allCommittees = KraServiceLocator.getService(BusinessObjectService.class).findMatching(Committee.class, criteria);
        HashMap<String, Committee> committeeMap = new HashMap<String, Committee>();
        Committee tmpComm = null;
        for (Committee comm : allCommittees) {
            if (!FINAL_STATUS_CD.equalsIgnoreCase(((CommitteeDocument)((Object)comm.getCommitteeDocument())).getDocStatusCode())) continue;
            if (committeeMap.containsKey(comm.getCommitteeId())) {
                tmpComm = (Committee)committeeMap.get(comm.getCommitteeId());
                if (comm.getSequenceNumber() <= tmpComm.getSequenceNumber()) continue;
                committeeMap.put(comm.getCommitteeId(), comm);
                continue;
            }
            committeeMap.put(comm.getCommitteeId(), comm);
        }
        return committeeMap.values();
    }

    private void getProtocolUnitIds() {
        if (StringUtils.isNotBlank((String)this.protocolLeadUnit)) {
            this.unitIds.add(this.protocolLeadUnit);
            List<Unit> subUnits = this.getUnitService().getAllSubUnits(this.protocolLeadUnit);
            for (Unit unit : subUnits) {
                this.unitIds.add(unit.getUnitNumber());
            }
            String topUnitNumber = this.getUnitService().getTopUnit().getUnitNumber();
            this.getParentUnitIds(this.protocolLeadUnit, topUnitNumber);
        }
    }

    private void getParentUnitIds(String currentUnitNumber, String topUnitNumber) {
        if (currentUnitNumber.equals(topUnitNumber)) {
            return;
        }
        String parentUnitNumber = this.getUnitService().getUnit(currentUnitNumber).getParentUnitNumber();
        Unit parentUnit = this.getUnitService().getUnit(parentUnitNumber);
        this.unitIds.add(parentUnit.getUnitNumber());
        this.getParentUnitIds(parentUnit.getUnitNumber(), topUnitNumber);
    }

    private UnitService getUnitService() {
        return KraServiceLocator.getService(UnitService.class);
    }

    private RoleService getRoleService() {
        return KraServiceLocator.getService(RoleService.class);
    }

    public String getProtocolLeadUnit() {
        return this.protocolLeadUnit;
    }

    public void setProtocolLeadUnit(String protocolLeadUnit) {
        this.protocolLeadUnit = protocolLeadUnit;
    }

    public String getDocRouteStatus() {
        return this.docRouteStatus;
    }

    public void setDocRouteStatus(String docRouteStatus) {
        this.docRouteStatus = docRouteStatus;
    }

    public String getCurrentCommitteeId() {
        return this.currentCommitteeId;
    }

    public void setCurrentCommitteeId(String currentCommitteeId) {
        this.currentCommitteeId = currentCommitteeId;
    }
}

